from typing import Any as _py_Any
from typing import List as _py_List
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.io
import java.lang
import java.nio
import java.util


class CharacterCodingException(java.io.IOException):
    def __init__(self): ...

class Charset(java.lang.Comparable['Charset']):
    def aliases(self) -> java.util.Set[str]: ...
    @classmethod
    def availableCharsets(cls) -> java.util.SortedMap[str, 'Charset']: ...
    def canEncode(self) -> bool: ...
    @overload
    def compareTo(self, charset: 'Charset') -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    def contains(self, charset: 'Charset') -> bool: ...
    def decode(self, byteBuffer: java.nio.ByteBuffer) -> java.nio.CharBuffer: ...
    @classmethod
    def defaultCharset(cls) -> 'Charset': ...
    @overload
    def displayName(self) -> str: ...
    @overload
    def displayName(self, locale: java.util.Locale) -> str: ...
    @overload
    def encode(self, string: str) -> java.nio.ByteBuffer: ...
    @overload
    def encode(self, charBuffer: java.nio.CharBuffer) -> java.nio.ByteBuffer: ...
    def equals(self, object: _py_Any) -> bool: ...
    @classmethod
    def forName(cls, string: str) -> 'Charset': ...
    def hashCode(self) -> int: ...
    def isRegistered(self) -> bool: ...
    @classmethod
    def isSupported(cls, string: str) -> bool: ...
    def name(self) -> str: ...
    def newDecoder(self) -> 'CharsetDecoder': ...
    def newEncoder(self) -> 'CharsetEncoder': ...
    def toString(self) -> str: ...

class CharsetDecoder:
    def averageCharsPerByte(self) -> float: ...
    def charset(self) -> Charset: ...
    @overload
    def decode(self, byteBuffer: java.nio.ByteBuffer) -> java.nio.CharBuffer: ...
    @overload
    def decode(self, byteBuffer: java.nio.ByteBuffer, charBuffer: java.nio.CharBuffer, boolean: bool) -> 'CoderResult': ...
    def detectedCharset(self) -> Charset: ...
    def flush(self, charBuffer: java.nio.CharBuffer) -> 'CoderResult': ...
    def isAutoDetecting(self) -> bool: ...
    def isCharsetDetected(self) -> bool: ...
    def malformedInputAction(self) -> 'CodingErrorAction': ...
    def maxCharsPerByte(self) -> float: ...
    def onMalformedInput(self, codingErrorAction: 'CodingErrorAction') -> 'CharsetDecoder': ...
    def onUnmappableCharacter(self, codingErrorAction: 'CodingErrorAction') -> 'CharsetDecoder': ...
    def replaceWith(self, string: str) -> 'CharsetDecoder': ...
    def replacement(self) -> str: ...
    def reset(self) -> 'CharsetDecoder': ...
    def unmappableCharacterAction(self) -> 'CodingErrorAction': ...

class CharsetEncoder:
    def averageBytesPerChar(self) -> float: ...
    @overload
    def canEncode(self, char: str) -> bool: ...
    @overload
    def canEncode(self, charSequence: java.lang.CharSequence) -> bool: ...
    def charset(self) -> Charset: ...
    @overload
    def encode(self, charBuffer: java.nio.CharBuffer) -> java.nio.ByteBuffer: ...
    @overload
    def encode(self, charBuffer: java.nio.CharBuffer, byteBuffer: java.nio.ByteBuffer, boolean: bool) -> 'CoderResult': ...
    def flush(self, byteBuffer: java.nio.ByteBuffer) -> 'CoderResult': ...
    def isLegalReplacement(self, byteArray: _py_List[int]) -> bool: ...
    def malformedInputAction(self) -> 'CodingErrorAction': ...
    def maxBytesPerChar(self) -> float: ...
    def onMalformedInput(self, codingErrorAction: 'CodingErrorAction') -> 'CharsetEncoder': ...
    def onUnmappableCharacter(self, codingErrorAction: 'CodingErrorAction') -> 'CharsetEncoder': ...
    def replaceWith(self, byteArray: _py_List[int]) -> 'CharsetEncoder': ...
    def replacement(self) -> _py_List[int]: ...
    def reset(self) -> 'CharsetEncoder': ...
    def unmappableCharacterAction(self) -> 'CodingErrorAction': ...

class CoderMalfunctionError(java.lang.Error):
    def __init__(self, exception: java.lang.Exception): ...

class CoderResult:
    UNDERFLOW: _py_ClassVar['CoderResult'] = ...
    OVERFLOW: _py_ClassVar['CoderResult'] = ...
    def isError(self) -> bool: ...
    def isMalformed(self) -> bool: ...
    def isOverflow(self) -> bool: ...
    def isUnderflow(self) -> bool: ...
    def isUnmappable(self) -> bool: ...
    def length(self) -> int: ...
    @classmethod
    def malformedForLength(cls, int: int) -> 'CoderResult': ...
    def throwException(self) -> None: ...
    def toString(self) -> str: ...
    @classmethod
    def unmappableForLength(cls, int: int) -> 'CoderResult': ...

class CodingErrorAction:
    IGNORE: _py_ClassVar['CodingErrorAction'] = ...
    REPLACE: _py_ClassVar['CodingErrorAction'] = ...
    REPORT: _py_ClassVar['CodingErrorAction'] = ...
    def toString(self) -> str: ...

class IllegalCharsetNameException(java.lang.IllegalArgumentException):
    def __init__(self, string: str): ...
    def getCharsetName(self) -> str: ...

class StandardCharsets:
    US_ASCII: _py_ClassVar[Charset] = ...
    ISO_8859_1: _py_ClassVar[Charset] = ...
    UTF_8: _py_ClassVar[Charset] = ...
    UTF_16BE: _py_ClassVar[Charset] = ...
    UTF_16LE: _py_ClassVar[Charset] = ...
    UTF_16: _py_ClassVar[Charset] = ...

class UnsupportedCharsetException(java.lang.IllegalArgumentException):
    def __init__(self, string: str): ...
    def getCharsetName(self) -> str: ...

class MalformedInputException(CharacterCodingException):
    def __init__(self, int: int): ...
    def getInputLength(self) -> int: ...
    def getMessage(self) -> str: ...

class UnmappableCharacterException(CharacterCodingException):
    def __init__(self, int: int): ...
    def getInputLength(self) -> int: ...
    def getMessage(self) -> str: ...
