from typing import Any as _py_Any
from typing import List as _py_List
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.awt
import java.beans
import java.io
import java.net
import java.util


class BeanContextChild:
    def addPropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def addVetoableChangeListener(self, string: str, vetoableChangeListener: java.beans.VetoableChangeListener) -> None: ...
    def getBeanContext(self) -> 'BeanContext': ...
    def removePropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def removeVetoableChangeListener(self, string: str, vetoableChangeListener: java.beans.VetoableChangeListener) -> None: ...
    def setBeanContext(self, beanContext: 'BeanContext') -> None: ...

class BeanContextChildComponentProxy:
    def getComponent(self) -> java.awt.Component: ...

class BeanContextContainerProxy:
    def getContainer(self) -> java.awt.Container: ...

class BeanContextEvent(java.util.EventObject):
    def getBeanContext(self) -> 'BeanContext': ...
    def getPropagatedFrom(self) -> 'BeanContext': ...
    def isPropagated(self) -> bool: ...
    def setPropagatedFrom(self, beanContext: 'BeanContext') -> None: ...

class BeanContextMembershipListener(java.util.EventListener):
    def childrenAdded(self, beanContextMembershipEvent: 'BeanContextMembershipEvent') -> None: ...
    def childrenRemoved(self, beanContextMembershipEvent: 'BeanContextMembershipEvent') -> None: ...

class BeanContextProxy:
    def getBeanContextProxy(self) -> BeanContextChild: ...

class BeanContextServiceProvider:
    def getCurrentServiceSelectors(self, beanContextServices: 'BeanContextServices', class_: _py_Type) -> java.util.Iterator: ...
    def getService(self, beanContextServices: 'BeanContextServices', object: _py_Any, class_: _py_Type, object2: _py_Any) -> _py_Any: ...
    def releaseService(self, beanContextServices: 'BeanContextServices', object: _py_Any, object2: _py_Any) -> None: ...

class BeanContextServiceProviderBeanInfo(java.beans.BeanInfo):
    def getServicesBeanInfo(self) -> _py_List[java.beans.BeanInfo]: ...

class BeanContextServiceRevokedListener(java.util.EventListener):
    def serviceRevoked(self, beanContextServiceRevokedEvent: 'BeanContextServiceRevokedEvent') -> None: ...

class BeanContext(BeanContextChild, java.util.Collection, java.beans.DesignMode, java.beans.Visibility):
    globalHierarchyLock: _py_ClassVar[_py_Any] = ...
    def addBeanContextMembershipListener(self, beanContextMembershipListener: BeanContextMembershipListener) -> None: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getResource(self, string: str, beanContextChild: BeanContextChild) -> java.net.URL: ...
    def getResourceAsStream(self, string: str, beanContextChild: BeanContextChild) -> java.io.InputStream: ...
    def hashCode(self) -> int: ...
    def instantiateChild(self, string: str) -> _py_Any: ...
    def removeBeanContextMembershipListener(self, beanContextMembershipListener: BeanContextMembershipListener) -> None: ...

class BeanContextMembershipEvent(BeanContextEvent):
    @overload
    def __init__(self, beanContext: BeanContext, objectArray: _py_List[_py_Any]): ...
    @overload
    def __init__(self, beanContext: BeanContext, collection: java.util.Collection): ...
    def contains(self, object: _py_Any) -> bool: ...
    def iterator(self) -> java.util.Iterator: ...
    def size(self) -> int: ...
    def toArray(self) -> _py_List[_py_Any]: ...

class BeanContextServiceAvailableEvent(BeanContextEvent):
    def __init__(self, beanContextServices: 'BeanContextServices', class_: _py_Type): ...
    def getCurrentServiceSelectors(self) -> java.util.Iterator: ...
    def getServiceClass(self) -> _py_Type: ...
    def getSourceAsBeanContextServices(self) -> 'BeanContextServices': ...

class BeanContextServiceRevokedEvent(BeanContextEvent):
    def __init__(self, beanContextServices: 'BeanContextServices', class_: _py_Type, boolean: bool): ...
    def getServiceClass(self) -> _py_Type: ...
    def getSourceAsBeanContextServices(self) -> 'BeanContextServices': ...
    def isCurrentServiceInvalidNow(self) -> bool: ...
    def isServiceClass(self, class_: _py_Type) -> bool: ...

class BeanContextServicesListener(BeanContextServiceRevokedListener):
    def serviceAvailable(self, beanContextServiceAvailableEvent: BeanContextServiceAvailableEvent) -> None: ...

class BeanContextChildSupport(BeanContextChild, BeanContextServicesListener, java.io.Serializable):
    beanContextChildPeer: BeanContextChild = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, beanContextChild: BeanContextChild): ...
    def addPropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def addVetoableChangeListener(self, string: str, vetoableChangeListener: java.beans.VetoableChangeListener) -> None: ...
    def firePropertyChange(self, string: str, object: _py_Any, object2: _py_Any) -> None: ...
    def fireVetoableChange(self, string: str, object: _py_Any, object2: _py_Any) -> None: ...
    def getBeanContext(self) -> BeanContext: ...
    def getBeanContextChildPeer(self) -> BeanContextChild: ...
    def isDelegated(self) -> bool: ...
    def removePropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def removeVetoableChangeListener(self, string: str, vetoableChangeListener: java.beans.VetoableChangeListener) -> None: ...
    def serviceAvailable(self, beanContextServiceAvailableEvent: BeanContextServiceAvailableEvent) -> None: ...
    def serviceRevoked(self, beanContextServiceRevokedEvent: BeanContextServiceRevokedEvent) -> None: ...
    def setBeanContext(self, beanContext: BeanContext) -> None: ...
    def validatePendingSetBeanContext(self, beanContext: BeanContext) -> bool: ...

class BeanContextServices(BeanContext, BeanContextServicesListener):
    def addBeanContextServicesListener(self, beanContextServicesListener: BeanContextServicesListener) -> None: ...
    def addService(self, class_: _py_Type, beanContextServiceProvider: BeanContextServiceProvider) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getCurrentServiceClasses(self) -> java.util.Iterator: ...
    def getCurrentServiceSelectors(self, class_: _py_Type) -> java.util.Iterator: ...
    def getService(self, beanContextChild: BeanContextChild, object: _py_Any, class_: _py_Type, object2: _py_Any, beanContextServiceRevokedListener: BeanContextServiceRevokedListener) -> _py_Any: ...
    def hasService(self, class_: _py_Type) -> bool: ...
    def hashCode(self) -> int: ...
    def releaseService(self, beanContextChild: BeanContextChild, object: _py_Any, object2: _py_Any) -> None: ...
    def removeBeanContextServicesListener(self, beanContextServicesListener: BeanContextServicesListener) -> None: ...
    def revokeService(self, class_: _py_Type, beanContextServiceProvider: BeanContextServiceProvider, boolean: bool) -> None: ...

class BeanContextSupport(BeanContextChildSupport, BeanContext, java.io.Serializable, java.beans.PropertyChangeListener, java.beans.VetoableChangeListener):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, beanContext: BeanContext): ...
    @overload
    def __init__(self, beanContext: BeanContext, locale: java.util.Locale): ...
    @overload
    def __init__(self, beanContext: BeanContext, locale: java.util.Locale, boolean: bool): ...
    @overload
    def __init__(self, beanContext: BeanContext, locale: java.util.Locale, boolean: bool, boolean2: bool): ...
    def add(self, object: _py_Any) -> bool: ...
    def addAll(self, collection: java.util.Collection) -> bool: ...
    def addBeanContextMembershipListener(self, beanContextMembershipListener: BeanContextMembershipListener) -> None: ...
    def avoidingGui(self) -> bool: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def containsAll(self, collection: java.util.Collection) -> bool: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def dontUseGui(self) -> None: ...
    def getBeanContextPeer(self) -> BeanContext: ...
    def getLocale(self) -> java.util.Locale: ...
    def getResource(self, string: str, beanContextChild: BeanContextChild) -> java.net.URL: ...
    def getResourceAsStream(self, string: str, beanContextChild: BeanContextChild) -> java.io.InputStream: ...
    def instantiateChild(self, string: str) -> _py_Any: ...
    def isDesignTime(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isSerializing(self) -> bool: ...
    def iterator(self) -> java.util.Iterator: ...
    def needsGui(self) -> bool: ...
    def okToUseGui(self) -> None: ...
    def propertyChange(self, propertyChangeEvent: java.beans.PropertyChangeEvent) -> None: ...
    def readChildren(self, objectInputStream: java.io.ObjectInputStream) -> None: ...
    def remove(self, object: _py_Any) -> bool: ...
    def removeAll(self, collection: java.util.Collection) -> bool: ...
    def removeBeanContextMembershipListener(self, beanContextMembershipListener: BeanContextMembershipListener) -> None: ...
    def retainAll(self, collection: java.util.Collection) -> bool: ...
    def setDesignTime(self, boolean: bool) -> None: ...
    def setLocale(self, locale: java.util.Locale) -> None: ...
    def size(self) -> int: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    @overload
    def toArray(self, objectArray: _py_List[_py_Any]) -> _py_List[_py_Any]: ...
    def vetoableChange(self, propertyChangeEvent: java.beans.PropertyChangeEvent) -> None: ...
    def writeChildren(self, objectOutputStream: java.io.ObjectOutputStream) -> None: ...

class BeanContextServicesSupport(BeanContextSupport, BeanContextServices):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, beanContextServices: BeanContextServices): ...
    @overload
    def __init__(self, beanContextServices: BeanContextServices, locale: java.util.Locale): ...
    @overload
    def __init__(self, beanContextServices: BeanContextServices, locale: java.util.Locale, boolean: bool): ...
    @overload
    def __init__(self, beanContextServices: BeanContextServices, locale: java.util.Locale, boolean: bool, boolean2: bool): ...
    def addBeanContextServicesListener(self, beanContextServicesListener: BeanContextServicesListener) -> None: ...
    def addService(self, class_: _py_Type, beanContextServiceProvider: BeanContextServiceProvider) -> bool: ...
    def getBeanContextServicesPeer(self) -> BeanContextServices: ...
    def getCurrentServiceClasses(self) -> java.util.Iterator: ...
    def getCurrentServiceSelectors(self, class_: _py_Type) -> java.util.Iterator: ...
    def getService(self, beanContextChild: BeanContextChild, object: _py_Any, class_: _py_Type, object2: _py_Any, beanContextServiceRevokedListener: BeanContextServiceRevokedListener) -> _py_Any: ...
    def hasService(self, class_: _py_Type) -> bool: ...
    def initialize(self) -> None: ...
    def releaseService(self, beanContextChild: BeanContextChild, object: _py_Any, object2: _py_Any) -> None: ...
    def removeBeanContextServicesListener(self, beanContextServicesListener: BeanContextServicesListener) -> None: ...
    def revokeService(self, class_: _py_Type, beanContextServiceProvider: BeanContextServiceProvider, boolean: bool) -> None: ...
    def serviceAvailable(self, beanContextServiceAvailableEvent: BeanContextServiceAvailableEvent) -> None: ...
    def serviceRevoked(self, beanContextServiceRevokedEvent: BeanContextServiceRevokedEvent) -> None: ...
