from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import java.lang
import java.util


class AbstractResponse(java.lang.Cloneable):
    def __init__(self): ...
    def clone(self) -> _py_Any: ...
    def getException(self) -> str: ...
    def getExceptionTrace(self) -> str: ...
    def getLog(self) -> str: ...
    def getParameters(self) -> java.util.Map['ResponseParameterType', _py_Any]: ...
    def getProcessTime(self) -> int: ...
    def getResponseStatus(self) -> 'ResponseStatus': ...
    def toString(self) -> str: ...

class FaultResponse:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, exception: java.lang.Exception): ...
    @overload
    def __init__(self, string: str): ...
    def getMessage(self) -> str: ...
    def getStacktrace(self) -> str: ...

_ResponseBuilder__Response = _py_TypeVar('_ResponseBuilder__Response', bound=AbstractResponse)  # <Response>
class ResponseBuilder(_py_Generic[_ResponseBuilder__Response]):
    def __init__(self, response: _ResponseBuilder__Response): ...
    def addParameters(self, map: java.util.Map['ResponseParameterType', _py_Any]) -> None: ...
    def buildResponse(self) -> _ResponseBuilder__Response: ...
    @overload
    def setException(self, exception: java.lang.Exception, responseStatus: 'ResponseStatus') -> None: ...
    @overload
    def setException(self, string: str) -> None: ...
    def setExceptionTrace(self, string: str) -> None: ...
    def setLog(self, string: str) -> None: ...
    def setProcessTime(self, int: int) -> None: ...
    def setResponseStatus(self, responseStatus: 'ResponseStatus') -> None: ...

class ResponseParameterType(java.lang.Enum['ResponseParameterType']):
    STATUS: _py_ClassVar['ResponseParameterType'] = ...
    EXCEPTION: _py_ClassVar['ResponseParameterType'] = ...
    EXCEPTION_TRACE: _py_ClassVar['ResponseParameterType'] = ...
    PROCESS_TIME: _py_ClassVar['ResponseParameterType'] = ...
    LOG: _py_ClassVar['ResponseParameterType'] = ...
    @classmethod
    def fromString(cls, string: str) -> 'ResponseParameterType': ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'ResponseParameterType': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['ResponseParameterType']: ...

class ResponseStatus(java.lang.Enum['ResponseStatus']):
    OK: _py_ClassVar['ResponseStatus'] = ...
    BAD_REQUEST: _py_ClassVar['ResponseStatus'] = ...
    AUTHENTICATION_FAILED: _py_ClassVar['ResponseStatus'] = ...
    PROCESSING_ERROR: _py_ClassVar['ResponseStatus'] = ...
    @classmethod
    def fromString(cls, string: str) -> 'ResponseStatus': ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'ResponseStatus': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['ResponseStatus']: ...

class AccessMapResponse(AbstractResponse):
    def __init__(self): ...

class AccessMapResponseBuilder(ResponseBuilder[AccessMapResponse]):
    @classmethod
    def newInstance(cls) -> 'AccessMapResponseBuilder': ...
