from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import cern
import cern.accsoft.commons.domain
import cern.accsoft.commons.domain.particletransfers
import cern.accsoft.commons.domain.zones
import cern.accsoft.commons.util
import cern.accsoft.commons.util.value
import cern.accsoft.commons.value
import cern.lsa.domain.commons
import cern.lsa.domain.commons.spi
import cern.lsa.domain.devices
import cern.lsa.domain.devices.type
import cern.lsa.domain.exploitation
import cern.lsa.domain.settings
import cern.lsa.domain.settings.type
import java.io
import java.lang
import java.time
import java.util


class AbstractContextIntersectionsImpl(cern.lsa.domain.settings.ContextIntersections, java.io.Serializable):
    def addIntersection(self, cycleBeamProcessIntersection: cern.lsa.domain.settings.CycleBeamProcessIntersection) -> None: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getCycleBeamProcessIntersections(self) -> java.util.SortedSet[cern.lsa.domain.settings.CycleBeamProcessIntersection]: ...
    def getFollowingBeamProcess(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> cern.lsa.domain.settings.BeamProcess: ...
    def getParticleTransfers(self) -> java.util.SortedSet[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def getPrecedingBeamProcess(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> cern.lsa.domain.settings.BeamProcess: ...
    def hashCode(self) -> int: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    class BeamProcessIntersectionImpl(cern.lsa.domain.settings.BeamProcessIntersection):
        def __init__(self, beamProcess: cern.lsa.domain.settings.BeamProcess, double: float): ...
        def getBeamProcess(self) -> cern.lsa.domain.settings.BeamProcess: ...
        def getIntersectionCoordinate(self) -> float: ...

class AbstractSetting(cern.lsa.domain.commons.spi.AbstractIdentifiedEntity[cern.lsa.domain.settings.Setting], cern.lsa.domain.settings.Setting, java.lang.Cloneable):
    @classmethod
    def checkReadSettingPart(cls, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> None: ...
    @overload
    def clone(self) -> cern.lsa.domain.settings.Setting: ...
    @overload
    def clone(self) -> 'AbstractSetting': ...
    @overload
    def clone(self) -> _py_Any: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getArray2DValue(self) -> cern.accsoft.commons.value.ImmutableScalarArray2D: ...
    def getArrayValue(self) -> cern.accsoft.commons.value.ImmutableScalarArray: ...
    def getBeamProcess(self) -> cern.lsa.domain.settings.BeamProcess: ...
    def getCorrectionFunctionValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getCorrectionFunctionsArrayValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray: ...
    def getCorrectionScalarValue(self) -> cern.accsoft.commons.value.ImmutableScalar: ...
    def getCorrectionValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getFunctionValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getFunctionsArrayValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray: ...
    def getParameter(self) -> cern.lsa.domain.settings.Parameter: ...
    def getScalarValue(self) -> cern.accsoft.commons.value.ImmutableScalar: ...
    def getTargetFunctionValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getTargetFunctionsArrayValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray: ...
    def getTargetScalarValue(self) -> cern.accsoft.commons.value.ImmutableScalar: ...
    def getTargetValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getTrimId(self) -> int: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
    def hashCode(self) -> int: ...
    def setBeamProcess(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> None: ...
    def setCreationDate(self, date: java.util.Date) -> None: ...
    def setParameter(self, parameter: cern.lsa.domain.settings.Parameter) -> None: ...
    def setTrimId(self, long: int) -> None: ...
    def toString(self) -> str: ...
    @overload
    def updateValue(self, immutableValue: cern.accsoft.commons.value.ImmutableValue, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> None: ...
    @overload
    def updateValue(self, setting: cern.lsa.domain.settings.Setting) -> None: ...

class ActualBeamProcessInfoImpl(cern.lsa.domain.settings.ActualBeamProcessInfo, java.io.Serializable):
    def __init__(self, beamProcess: cern.lsa.domain.settings.BeamProcess, int: int): ...
    def getSourceBeamProcess(self) -> cern.lsa.domain.settings.BeamProcess: ...
    def getSourcePoint(self) -> int: ...
    def setSourceBeamProcess(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> None: ...

class ArchiveImpl(cern.lsa.domain.commons.spi.AbstractIdentifiedNamedEntity[cern.lsa.domain.settings.Archive], cern.lsa.domain.settings.Archive):
    def __init__(self, long: int, string: str, standAloneContext: cern.lsa.domain.settings.StandAloneContext): ...
    def addArchiveVersion(self, archiveVersion: cern.lsa.domain.settings.ArchiveVersion) -> None: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getLatestVersion(self) -> cern.lsa.domain.settings.ArchiveVersion: ...
    def getStandAloneContext(self) -> cern.lsa.domain.settings.StandAloneContext: ...
    def getVersion(self, double: float) -> cern.lsa.domain.settings.ArchiveVersion: ...
    def getVersions(self) -> java.util.SortedSet[cern.lsa.domain.settings.ArchiveVersion]: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class ArchiveVersionImpl(cern.lsa.domain.settings.ArchiveVersion, java.io.Serializable):
    def __init__(self, archive: cern.lsa.domain.settings.Archive, double: float, date: java.util.Date, string: str, int: int): ...
    @overload
    def compareTo(self, archiveVersion: cern.lsa.domain.settings.ArchiveVersion) -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getArchive(self) -> cern.lsa.domain.settings.Archive: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getDescription(self) -> str: ...
    def getSettingCount(self) -> int: ...
    def getVersion(self) -> float: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class BeamProcessIncorporationRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.settings.BeamProcessIncorporationRequest):
    SOURCE_BEAM_PROCESS: _py_ClassVar[str] = ...
    SETTINGS_SOURCE: _py_ClassVar[str] = ...
    DEST_BEAM_PROCESS: _py_ClassVar[str] = ...
    SOURCE_POINT_IN_TIME: _py_ClassVar[str] = ...
    DEST_POINT_IN_TIME: _py_ClassVar[str] = ...
    SHOULD_INCORPORATE_ALL_PARAMETERS: _py_ClassVar[str] = ...
    PARAMETERS: _py_ClassVar[str] = ...
    SETTING_PART: _py_ClassVar[str] = ...
    DRIVE: _py_ClassVar[str] = ...
    DESCRIPTION: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any]): ...
    def getDescription(self) -> str: ...
    def getDestBeamProcess(self) -> cern.lsa.domain.settings.BeamProcess: ...
    def getDestPointInTime(self) -> float: ...
    def getParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getSettingPart(self) -> cern.lsa.domain.settings.SettingPartEnum: ...
    def getSettingsSource(self) -> cern.lsa.domain.settings.SettingsSource: ...
    def getSourceBeamProcess(self) -> cern.lsa.domain.settings.BeamProcess: ...
    def getSourcePointInTime(self) -> float: ...
    def shouldDrive(self) -> bool: ...
    def shouldIncorporateAllParameters(self) -> bool: ...

class CompositeContextSettingsImpl(cern.lsa.domain.settings.CompositeContextSettings, java.io.Serializable):
    def __init__(self, contextSettings: cern.lsa.domain.settings.ContextSettings, contextSettings2: cern.lsa.domain.settings.ContextSettings): ...
    def getContextSettings(self) -> cern.lsa.domain.settings.ContextSettings: ...
    def getNonMultiplexedSettings(self) -> cern.lsa.domain.settings.ContextSettings: ...
    def getParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getValue(self, drivableContext: cern.lsa.domain.settings.DrivableContext, string: str) -> cern.accsoft.commons.value.ImmutableValue: ...
    def toString(self) -> str: ...

_ContextBase__C = _py_TypeVar('_ContextBase__C', bound=cern.accsoft.commons.util.Named)  # <C>
class ContextBase(cern.lsa.domain.commons.spi.AbstractIdentifiedNamedEntity[_ContextBase__C], _py_Generic[_ContextBase__C]):
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getContextCategory(self) -> cern.lsa.domain.settings.ContextCategory: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getCreatorName(self) -> str: ...
    def getDescription(self) -> str: ...
    def getLength(self) -> int: ...
    def getModificationDate(self) -> java.util.Date: ...
    def getModifierName(self) -> str: ...
    def setAccelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> None: ...
    def setContextCategory(self, contextCategory: cern.lsa.domain.settings.ContextCategory) -> None: ...
    def setCreationDate(self, date: java.util.Date) -> None: ...
    def setCreatorName(self, string: str) -> None: ...
    def setDescription(self, string: str) -> None: ...
    @overload
    def setLength(self, int: int) -> None: ...
    @overload
    def setLength(self, string: str) -> None: ...
    def setModificationDate(self, date: java.util.Date) -> None: ...
    def setModifierName(self, string: str) -> None: ...
    def toString(self) -> str: ...

class ContextSettingsImpl(cern.lsa.domain.settings.ContextSettings, java.io.Serializable):
    @overload
    def __init__(self, contextSettings: cern.lsa.domain.settings.ContextSettings): ...
    @overload
    def __init__(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext): ...
    @overload
    def __init__(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext, map: java.util.Map[str, 'ParameterSettingsImpl']): ...
    def addAll(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> None: ...
    def addCurrentSetting(self, setting: cern.lsa.domain.settings.Setting) -> None: ...
    def addParameterSettings(self, parameterSettings: cern.lsa.domain.settings.ParameterSettings) -> None: ...
    def addUpdatedSetting(self, setting: cern.lsa.domain.settings.Setting) -> None: ...
    def getContext(self) -> cern.lsa.domain.settings.StandAloneContext: ...
    def getCurrentBeamProcesses(self) -> java.util.Set[cern.lsa.domain.settings.BeamProcess]: ...
    @overload
    def getCurrentSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess, parameter: cern.lsa.domain.settings.Parameter) -> cern.lsa.domain.settings.Setting: ...
    @overload
    def getCurrentSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess, string: str) -> cern.lsa.domain.settings.Setting: ...
    def getCurrentSettings(self) -> java.util.Set[cern.lsa.domain.settings.Setting]: ...
    def getParameterSettingMap(self) -> java.util.Map[str, 'ParameterSettingsImpl']: ...
    @overload
    def getParameterSettings(self, parameter: cern.lsa.domain.settings.Parameter) -> cern.lsa.domain.settings.ParameterSettings: ...
    @overload
    def getParameterSettings(self, string: str) -> cern.lsa.domain.settings.ParameterSettings: ...
    def getParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    @overload
    def getSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess, parameter: cern.lsa.domain.settings.Parameter) -> cern.lsa.domain.settings.Setting: ...
    @overload
    def getSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess, string: str) -> cern.lsa.domain.settings.Setting: ...
    def getSettings(self) -> java.util.Set[cern.lsa.domain.settings.Setting]: ...
    def getUpdatedBeamProcesses(self) -> java.util.Set[cern.lsa.domain.settings.BeamProcess]: ...
    def getUpdatedParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    @overload
    def getUpdatedSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess, parameter: cern.lsa.domain.settings.Parameter) -> cern.lsa.domain.settings.Setting: ...
    @overload
    def getUpdatedSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess, string: str) -> cern.lsa.domain.settings.Setting: ...
    def getUpdatedSettings(self) -> java.util.Set[cern.lsa.domain.settings.Setting]: ...
    def isEmpty(self) -> bool: ...
    @overload
    def isUpdated(self, beamProcess: cern.lsa.domain.settings.BeamProcess, parameter: cern.lsa.domain.settings.Parameter) -> bool: ...
    @overload
    def isUpdated(self, beamProcess: cern.lsa.domain.settings.BeamProcess, string: str) -> bool: ...
    @overload
    def isUpdated(self, parameter: cern.lsa.domain.settings.Parameter) -> bool: ...
    @overload
    def isUpdated(self, string: str) -> bool: ...
    def round(self) -> None: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def updateSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess, parameter: cern.lsa.domain.settings.Parameter, immutableValue: cern.accsoft.commons.value.ImmutableValue, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> None: ...
    @overload
    def updateSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess, string: str, immutableValue: cern.accsoft.commons.value.ImmutableValue, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> None: ...

class CycleBeamProcessIntersectionImpl(cern.lsa.domain.settings.CycleBeamProcessIntersection, java.io.Serializable):
    def __init__(self): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getBeamProcess(self) -> cern.lsa.domain.settings.BeamProcess: ...
    def getCycle(self) -> cern.lsa.domain.settings.Cycle: ...
    def getEndInBeamProcess(self) -> int: ...
    def getEndInCycle(self) -> int: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...
    def getStartInBeamProcess(self) -> int: ...
    def getStartInCycle(self) -> int: ...
    def hashCode(self) -> int: ...
    def setBeamProcess(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> None: ...
    def setCycle(self, cycle: cern.lsa.domain.settings.Cycle) -> None: ...
    def setIntersectionEndInBeamProcess(self, int: int) -> None: ...
    def setIntersectionEndInCycle(self, int: int) -> None: ...
    def setIntersectionStartInBeamProcess(self, int: int) -> None: ...
    def setIntersectionStartInCycle(self, int: int) -> None: ...
    def setParticleTransfer(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> None: ...
    def toString(self) -> str: ...

class DevicePropertyParametersImpl(cern.lsa.domain.settings.DevicePropertyParameters, java.io.Serializable):
    def __init__(self, set: java.util.Set[cern.lsa.domain.settings.Parameter]): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDeviceClassName(self) -> str: ...
    def getDeviceName(self) -> str: ...
    def getDevicePropertyName(self) -> str: ...
    @overload
    def getFieldNames(self) -> java.util.SortedSet[str]: ...
    @overload
    def getFieldNames(self, boolean: bool) -> java.util.SortedSet[str]: ...
    @overload
    def getParameters(self) -> java.util.SortedSet[cern.lsa.domain.settings.Parameter]: ...
    @overload
    def getParameters(self, boolean: bool) -> java.util.SortedSet[cern.lsa.domain.settings.Parameter]: ...
    def getPropertyName(self) -> str: ...
    def getSignature(self) -> cern.lsa.domain.settings.Parameter: ...
    def hashCode(self) -> int: ...
    def isCritical(self) -> bool: ...
    def toString(self) -> str: ...

class FailedParametersStatusImpl(cern.lsa.domain.settings.FailedParametersStatus, java.io.Serializable):
    def __init__(self): ...
    def addFailedParameters(self, context: cern.lsa.domain.settings.Context, map: java.util.Map[str, java.lang.Exception]) -> None: ...
    def containsFailedParameters(self) -> bool: ...
    def getFailedContexts(self) -> java.util.Set[cern.lsa.domain.settings.Context]: ...
    def getFailedParameters(self, context: cern.lsa.domain.settings.Context) -> java.util.Map[str, java.lang.Exception]: ...
    def toString(self) -> str: ...

class HyperCycleImpl(cern.lsa.domain.commons.spi.AbstractIdentifiedNamedEntity[cern.lsa.domain.settings.HyperCycle], cern.lsa.domain.settings.HyperCycle, java.lang.Cloneable):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, long: int, string: str): ...
    @overload
    def add(self, acceleratorUser: cern.lsa.domain.settings.AcceleratorUser, standAloneBeamProcess: cern.lsa.domain.settings.StandAloneBeamProcess) -> None: ...
    @overload
    def add(self, acceleratorUser: cern.lsa.domain.settings.AcceleratorUser, standAloneBeamProcess: cern.lsa.domain.settings.StandAloneBeamProcess, int: int) -> None: ...
    def clone(self) -> _py_Any: ...
    def contains(self, standAloneBeamProcess: cern.lsa.domain.settings.StandAloneBeamProcess) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getBeamProcessByUser(self, string: str) -> cern.lsa.domain.settings.StandAloneBeamProcess: ...
    def getBeamProcessPosition(self, string: str, standAloneBeamProcess: cern.lsa.domain.settings.StandAloneBeamProcess) -> int: ...
    def getDescription(self) -> str: ...
    def getFirstBeamProcess(self, string: str) -> cern.lsa.domain.settings.StandAloneBeamProcess: ...
    def getLastBeamProcess(self, string: str) -> cern.lsa.domain.settings.StandAloneBeamProcess: ...
    def getNextBeamProcess(self, string: str) -> cern.lsa.domain.settings.StandAloneBeamProcess: ...
    def getPreviousBeamProcess(self, string: str) -> cern.lsa.domain.settings.StandAloneBeamProcess: ...
    def getResidentBeamProcess(self, string: str) -> cern.lsa.domain.settings.StandAloneBeamProcess: ...
    def getResidentBeamProcesses(self) -> java.util.Set[cern.lsa.domain.settings.StandAloneBeamProcess]: ...
    @overload
    def getScheduledBeamProcesses(self) -> java.util.List[cern.lsa.domain.settings.StandAloneBeamProcess]: ...
    @overload
    def getScheduledBeamProcesses(self, string: str) -> java.util.List[cern.lsa.domain.settings.StandAloneBeamProcess]: ...
    def getUserCategories(self) -> java.util.SortedSet[str]: ...
    def getUserCategory(self, standAloneBeamProcess: cern.lsa.domain.settings.StandAloneBeamProcess) -> str: ...
    def getUserForBeamProcess(self, standAloneBeamProcess: cern.lsa.domain.settings.StandAloneBeamProcess) -> str: ...
    @overload
    def getUsers(self, string: str) -> java.util.List[str]: ...
    @overload
    def getUsers(self) -> java.util.Set[str]: ...
    def hashCode(self) -> int: ...
    def isActive(self) -> bool: ...
    def remove(self, standAloneBeamProcess: cern.lsa.domain.settings.StandAloneBeamProcess) -> None: ...
    def setActive(self, boolean: bool) -> None: ...
    def setDescription(self, string: str) -> None: ...
    def swap(self, string: str, int: int, int2: int) -> None: ...

class KnobFactorsBuilder:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, knobFactors: cern.lsa.domain.settings.KnobFactors): ...
    @overload
    def addFactor(self, knobFactor: cern.lsa.domain.settings.KnobFactor) -> 'KnobFactorsBuilder': ...
    @overload
    def addFactor(self, string: str, string2: str, double: float) -> 'KnobFactorsBuilder': ...
    @overload
    def addOrUpdateFactor(self, knobFactor: cern.lsa.domain.settings.KnobFactor) -> 'KnobFactorsBuilder': ...
    @overload
    def addOrUpdateFactor(self, string: str, string2: str, double: float) -> 'KnobFactorsBuilder': ...
    def build(self) -> cern.lsa.domain.settings.KnobFactors: ...
    def clear(self) -> 'KnobFactorsBuilder': ...
    def removeFactor(self, string: str, string2: str) -> 'KnobFactorsBuilder': ...
    @overload
    def updateFactor(self, knobFactor: cern.lsa.domain.settings.KnobFactor) -> 'KnobFactorsBuilder': ...
    @overload
    def updateFactor(self, string: str, string2: str, double: float) -> 'KnobFactorsBuilder': ...

class KnobFactorsImpl(cern.lsa.domain.settings.KnobFactors, java.io.Serializable):
    def __init__(self, set: java.util.Set[cern.lsa.domain.settings.KnobFactor]): ...
    @classmethod
    def buildFactorsMap(cls, set: java.util.Set[cern.lsa.domain.settings.KnobFactor]) -> java.util.Map[cern.accsoft.commons.util.value.Pair[str, str], cern.lsa.domain.settings.KnobFactor]: ...
    def containsFactor(self, string: str, string2: str) -> bool: ...
    @classmethod
    def extractComponents(cls, collection: java.util.Collection[cern.lsa.domain.settings.KnobFactor]) -> java.util.Set[str]: ...
    @classmethod
    def extractOptics(cls, collection: java.util.Collection[cern.lsa.domain.settings.KnobFactor]) -> java.util.Set[str]: ...
    def getComponentNames(self) -> java.util.Set[str]: ...
    def getFactor(self, string: str, string2: str) -> float: ...
    def getFactors(self) -> java.util.Set[cern.lsa.domain.settings.KnobFactor]: ...
    def getFactorsForComponent(self, string: str) -> java.util.Set[cern.lsa.domain.settings.KnobFactor]: ...
    def getFactorsForOptic(self, string: str) -> java.util.Set[cern.lsa.domain.settings.KnobFactor]: ...
    def getOpticNames(self) -> java.util.Set[str]: ...

class NotIncorporatedParametersImpl(cern.lsa.domain.settings.NotIncorporatedParameters, java.io.Serializable):
    def __init__(self, set: java.util.Set[str], set2: java.util.Set[str]): ...
    def getNonCountinueParameters(self) -> java.util.Set[str]: ...
    def getParametersWithSettingsOnlyInFirstContext(self) -> java.util.Set[str]: ...

class ParameterAttributesImpl(cern.lsa.domain.settings.ParameterAttributes):
    @overload
    def __init__(self, parameterAttributes: cern.lsa.domain.settings.ParameterAttributes): ...
    @overload
    def __init__(self, long: int, string: str, device: cern.lsa.domain.devices.Device, parameterType: cern.lsa.domain.settings.ParameterType, propertyField: cern.lsa.domain.devices.type.PropertyField, double: float, double2: float, integer: int, integer2: int, double3: float, double4: float, boolean: bool, string2: str, boolean2: bool, boolean3: bool): ...
    @overload
    def __init__(self, string: str, device: cern.lsa.domain.devices.Device, parameterType: cern.lsa.domain.settings.ParameterType, propertyField: cern.lsa.domain.devices.type.PropertyField): ...
    @classmethod
    def asNew(cls, parameterAttributes: cern.lsa.domain.settings.ParameterAttributes) -> cern.lsa.domain.settings.ParameterAttributes: ...
    @classmethod
    def baseFromParameter(cls, parameter: cern.lsa.domain.settings.Parameter) -> cern.lsa.domain.settings.ParameterAttributes: ...
    def getAbsoluteTolerance(self) -> float: ...
    def getDefaultHierarchy(self) -> str: ...
    def getDevice(self) -> cern.lsa.domain.devices.Device: ...
    def getMaxValue(self) -> float: ...
    def getMinValue(self) -> float: ...
    def getName(self) -> str: ...
    def getParameterId(self) -> int: ...
    def getParameterName(self) -> str: ...
    def getParameterType(self) -> cern.lsa.domain.settings.ParameterType: ...
    def getPropertyField(self) -> cern.lsa.domain.devices.type.PropertyField: ...
    def getRelativeTolerance(self) -> float: ...
    def getXPrecision(self) -> int: ...
    def getYPrecision(self) -> int: ...
    def isBelongsToFunctionBProc(self) -> bool: ...
    def isReservedForOpExperts(self) -> bool: ...
    def isTrimable(self) -> bool: ...
    def setAbsoluteTolerance(self, double: float) -> None: ...
    def setBelongsToFunctionBProc(self, boolean: bool) -> None: ...
    def setDefaultHierarchy(self, string: str) -> None: ...
    def setMaxValue(self, double: float) -> None: ...
    def setMinValue(self, double: float) -> None: ...
    def setParameterId(self, long: int) -> None: ...
    def setParameterName(self, string: str) -> None: ...
    def setRelativeTolerance(self, double: float) -> None: ...
    def setReservedForOpExperts(self, boolean: bool) -> None: ...
    def setTrimable(self, boolean: bool) -> None: ...
    def setXPrecision(self, integer: int) -> None: ...
    def setYPrecision(self, integer: int) -> None: ...

class ParameterDecorator(cern.lsa.domain.settings.Parameter, java.io.Serializable):
    def belongsToFunctionBeamProcess(self) -> bool: ...
    @overload
    def compareTo(self, parameter: cern.lsa.domain.settings.Parameter) -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getDefaultHierarchy(self) -> str: ...
    def getDevice(self) -> cern.lsa.domain.devices.Device: ...
    def getId(self) -> int: ...
    def getName(self) -> str: ...
    def getParameterGroups(self) -> java.util.Set[str]: ...
    def getParameterType(self) -> cern.lsa.domain.settings.ParameterType: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def getPropertyField(self) -> cern.lsa.domain.devices.type.PropertyField: ...
    def getValueDescriptor(self) -> cern.accsoft.commons.value.ValueDescriptor: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
    def hashCode(self) -> int: ...
    def isCritical(self) -> bool: ...
    def isCycleBound(self) -> bool: ...
    def isMonitorable(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isPropertySupportingPartialSet(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isReservedForOpExperts(self) -> bool: ...
    def isTrimable(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def toString(self) -> str: ...

class ParameterImpl(cern.lsa.domain.commons.spi.AbstractIdentifiedNamedEntity[cern.lsa.domain.settings.Parameter], cern.lsa.domain.settings.Parameter, java.lang.Cloneable):
    def belongsToFunctionBeamProcess(self) -> bool: ...
    @overload
    def clone(self) -> 'ParameterImpl': ...
    @overload
    def clone(self) -> _py_Any: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getDefaultHierarchy(self) -> str: ...
    def getDevice(self) -> cern.lsa.domain.devices.Device: ...
    def getParameterGroups(self) -> java.util.Set[str]: ...
    def getParameterType(self) -> cern.lsa.domain.settings.ParameterType: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def getPropertyField(self) -> cern.lsa.domain.devices.type.PropertyField: ...
    def getValueDescriptor(self) -> cern.accsoft.commons.value.ValueDescriptor: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
    def hashCode(self) -> int: ...
    def isCritical(self) -> bool: ...
    def isCycleBound(self) -> bool: ...
    def isMonitorable(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isPropertySupportingPartialSet(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isReservedForOpExperts(self) -> bool: ...
    def isTrimable(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def isWritable(self) -> bool: ...

class ParameterSettingsImpl(cern.lsa.domain.settings.ParameterSettings, java.io.Serializable, java.lang.Cloneable):
    @overload
    def __init__(self, parameter: cern.lsa.domain.settings.Parameter): ...
    @overload
    def __init__(self, parameter: cern.lsa.domain.settings.Parameter, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer): ...
    @overload
    def __init__(self, parameter: cern.lsa.domain.settings.Parameter, collection: java.util.Collection[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]): ...
    @overload
    def __init__(self, parameterSettings: cern.lsa.domain.settings.ParameterSettings): ...
    def addCurrentSetting(self, setting: cern.lsa.domain.settings.Setting) -> None: ...
    def addUpdatedSetting(self, setting: cern.lsa.domain.settings.Setting) -> None: ...
    def getCurrentBeamProcesses(self) -> java.util.Set[cern.lsa.domain.settings.BeamProcess]: ...
    def getCurrentSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> cern.lsa.domain.settings.Setting: ...
    def getCurrentSettings(self) -> java.util.Set[cern.lsa.domain.settings.Setting]: ...
    def getParameter(self) -> cern.lsa.domain.settings.Parameter: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def getSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> cern.lsa.domain.settings.Setting: ...
    def getSettings(self) -> java.util.Set[cern.lsa.domain.settings.Setting]: ...
    def getUpdatedBeamProcesses(self) -> java.util.Set[cern.lsa.domain.settings.BeamProcess]: ...
    def getUpdatedSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> cern.lsa.domain.settings.Setting: ...
    def getUpdatedSettings(self) -> java.util.Set[cern.lsa.domain.settings.Setting]: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
    def isEmpty(self) -> bool: ...
    @overload
    def isUpdated(self) -> bool: ...
    @overload
    def isUpdated(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> bool: ...
    def round(self) -> None: ...
    def size(self) -> int: ...
    @overload
    def updateSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess, immutableValue: cern.accsoft.commons.value.ImmutableValue, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> None: ...
    @overload
    def updateSetting(self, beamProcess: cern.lsa.domain.settings.BeamProcess, setting: cern.lsa.domain.settings.Setting) -> None: ...

class ParameterTreeNodeImpl(cern.lsa.domain.settings.ParameterTreeNode, java.lang.Comparable[cern.lsa.domain.settings.ParameterTreeNode], java.io.Serializable):
    def __init__(self, parameter: cern.lsa.domain.settings.Parameter, boolean: bool): ...
    def addChild(self, parameterTreeNodeImpl: 'ParameterTreeNodeImpl') -> None: ...
    @overload
    def compareTo(self, parameterTreeNode: cern.lsa.domain.settings.ParameterTreeNode) -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def findNode(self, string: str) -> cern.lsa.domain.settings.ParameterTreeNode: ...
    def getAllChildren(self) -> java.util.List[cern.lsa.domain.settings.ParameterTreeNode]: ...
    def getAllParents(self) -> java.util.List[cern.lsa.domain.settings.ParameterTreeNode]: ...
    def getChildren(self) -> java.util.List[cern.lsa.domain.settings.ParameterTreeNode]: ...
    def getName(self) -> str: ...
    @overload
    def getNodes(self) -> java.util.List[cern.lsa.domain.settings.ParameterTreeNode]: ...
    @overload
    def getNodes(self, boolean: bool) -> java.util.List[cern.lsa.domain.settings.ParameterTreeNode]: ...
    def getParameter(self) -> cern.lsa.domain.settings.Parameter: ...
    def getParameters(self) -> java.util.List[cern.lsa.domain.settings.Parameter]: ...
    def getParametersFromThisNodeAndAllChildren(self) -> java.util.List[cern.lsa.domain.settings.Parameter]: ...
    def getParametersFromThisNodeAndAllParents(self) -> java.util.List[cern.lsa.domain.settings.Parameter]: ...
    def getParents(self) -> java.util.List[cern.lsa.domain.settings.ParameterTreeNode]: ...
    def getThisNodeAndAllChildren(self) -> java.util.List[cern.lsa.domain.settings.ParameterTreeNode]: ...
    def getThisNodeAndAllParents(self) -> java.util.List[cern.lsa.domain.settings.ParameterTreeNode]: ...
    def hashCode(self) -> int: ...
    def isLeaf(self) -> bool: ...
    def isRoot(self) -> bool: ...
    def isSource(self) -> bool: ...
    def setIsSource(self, boolean: bool) -> None: ...
    def toString(self) -> str: ...

class ParameterTreesRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.settings.ParameterTreesRequest):
    PARAMETER_NAMES: _py_ClassVar[str] = ...
    PARAMETERS: _py_ClassVar[str] = ...
    HIERARCHY: _py_ClassVar[str] = ...
    TREE_DIRECTION: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any]): ...
    def getHierarchy(self) -> str: ...
    def getParameterNames(self) -> java.util.Set[str]: ...
    def getParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getTreeDirection(self) -> cern.lsa.domain.settings.ParameterTreesRequest.TreeDirection: ...

class ParameterTypeGroupImpl(cern.accsoft.commons.util.AbstractNamed[cern.lsa.domain.settings.ParameterTypeGroup], cern.lsa.domain.settings.ParameterTypeGroup, java.io.Serializable):
    def __init__(self, string: str, parameterTypeCategory: cern.lsa.domain.settings.ParameterTypeCategory): ...
    def addParameterType(self, parameterType: cern.lsa.domain.settings.ParameterType) -> None: ...
    @overload
    def compareTo(self, named: cern.accsoft.commons.util.Named) -> int: ...
    @overload
    def compareTo(self, parameterTypeGroup: cern.lsa.domain.settings.ParameterTypeGroup) -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getParameterTypes(self) -> java.util.Set[cern.lsa.domain.settings.ParameterType]: ...
    def hashCode(self) -> int: ...

class ParameterTypeImpl(cern.lsa.domain.commons.spi.AbstractIdentifiedNamedEntity[cern.lsa.domain.settings.ParameterType], cern.lsa.domain.settings.ParameterType, java.lang.Cloneable):
    @overload
    def clone(self) -> 'ParameterTypeImpl': ...
    @overload
    def clone(self) -> _py_Any: ...
    @overload
    def compareTo(self, named: cern.accsoft.commons.util.Named) -> int: ...
    @overload
    def compareTo(self, parameterType: cern.lsa.domain.settings.ParameterType) -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getCategory(self) -> cern.lsa.domain.settings.ParameterTypeCategory: ...
    def hashCode(self) -> int: ...
    def isLinkRuleApplicable(self) -> bool: ...

class ParameterTypesRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.settings.ParameterTypesRequest):
    PARAMETER_TYPE_NAMES: _py_ClassVar[str] = ...
    ALL_PARAMETER_TYPES_REQUESTED: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any]): ...
    def getParameterTypeNames(self) -> java.util.Set[str]: ...
    def isAllParameterTypesRequested(self) -> bool: ...

class ParametersRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.settings.ParametersRequest):
    ACCELERATOR: _py_ClassVar[str] = ...
    ACCELERATOR_ZONES: _py_ClassVar[str] = ...
    PARTICLE_TRANSFERS: _py_ClassVar[str] = ...
    PARAMETER_GROUPS: _py_ClassVar[str] = ...
    PARAMETER_TYPE_NAMES: _py_ClassVar[str] = ...
    PROPERTY_FIELDS: _py_ClassVar[str] = ...
    PROPERTY_NAMES: _py_ClassVar[str] = ...
    PARAMETER_NAMES: _py_ClassVar[str] = ...
    DEVICE_NAMES: _py_ClassVar[str] = ...
    DEVICES: _py_ClassVar[str] = ...
    DEVICE_TYPE_VERSION: _py_ClassVar[str] = ...
    MULTIPLEXED: _py_ClassVar[str] = ...
    VIRTUAL: _py_ClassVar[str] = ...
    WRITABLE: _py_ClassVar[str] = ...
    READABLE: _py_ClassVar[str] = ...
    PARAMETER_NAME_PATTERN: _py_ClassVar[str] = ...
    CRITICAL: _py_ClassVar[str] = ...
    VALUE_TYPES: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any]): ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getAcceleratorZones(self) -> java.util.Set[cern.accsoft.commons.domain.zones.AcceleratorZone]: ...
    def getDeviceNames(self) -> java.util.Set[str]: ...
    def getDevices(self) -> java.util.Set[cern.lsa.domain.devices.Device]: ...
    def getParameterGroups(self) -> java.util.Set[str]: ...
    def getParameterNamePattern(self) -> str: ...
    def getParameterNames(self) -> java.util.Set[str]: ...
    def getParameterTypeNames(self) -> java.util.Set[str]: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def getPropertyFields(self) -> java.util.Set[cern.lsa.domain.devices.type.PropertyField]: ...
    def getPropertyNames(self) -> java.util.Set[str]: ...
    def getValueTypes(self) -> java.util.Set[cern.accsoft.commons.value.Type]: ...
    def isCritical(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def isWritable(self) -> bool: ...

class SettingComparisonParameterResultImpl(cern.lsa.domain.settings.SettingComparisonParameterResult, java.io.Serializable):
    def __init__(self, parameter: cern.lsa.domain.settings.Parameter, list: java.util.List[cern.lsa.domain.settings.BeamProcess], list2: java.util.List[cern.lsa.domain.settings.BeamProcess]): ...
    def addDetailedResultType(self, beamProcess: cern.lsa.domain.settings.BeamProcess, beamProcess2: cern.lsa.domain.settings.BeamProcess, settingComparisonResultType: cern.lsa.domain.settings.SettingComparisonResultType) -> None: ...
    def getDestinationBeamProcesses(self) -> java.util.List[cern.lsa.domain.settings.BeamProcess]: ...
    def getDestinationDetailedException(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> java.lang.Exception: ...
    def getDestinationException(self) -> java.lang.Exception: ...
    def getDestinationSettings(self) -> cern.lsa.domain.settings.ParameterSettings: ...
    def getDetailedResultType(self, beamProcess: cern.lsa.domain.settings.BeamProcess, beamProcess2: cern.lsa.domain.settings.BeamProcess) -> cern.lsa.domain.settings.SettingComparisonResultType: ...
    def getDetailedResultTypes(self) -> java.util.Map[cern.accsoft.commons.util.value.Pair[cern.lsa.domain.settings.BeamProcess, cern.lsa.domain.settings.BeamProcess], cern.lsa.domain.settings.SettingComparisonResultType]: ...
    def getParameter(self) -> cern.lsa.domain.settings.Parameter: ...
    def getResultType(self) -> cern.lsa.domain.settings.SettingComparisonResultType: ...
    def getSourceBeamProcesses(self) -> java.util.List[cern.lsa.domain.settings.BeamProcess]: ...
    def getSourceDetailedException(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> java.lang.Exception: ...
    def getSourceException(self) -> java.lang.Exception: ...
    def getSourceSettings(self) -> cern.lsa.domain.settings.ParameterSettings: ...
    def setDestinationDetailedException(self, beamProcess: cern.lsa.domain.settings.BeamProcess, exception: java.lang.Exception) -> None: ...
    def setDestinationException(self, exception: java.lang.Exception) -> None: ...
    def setDestinationSettings(self, parameterSettings: cern.lsa.domain.settings.ParameterSettings) -> None: ...
    def setDetailedResultTypes(self, map: java.util.Map[cern.accsoft.commons.util.value.Pair[cern.lsa.domain.settings.BeamProcess, cern.lsa.domain.settings.BeamProcess], cern.lsa.domain.settings.SettingComparisonResultType]) -> None: ...
    def setResultType(self, settingComparisonResultType: cern.lsa.domain.settings.SettingComparisonResultType) -> None: ...
    def setSourceDetailedException(self, beamProcess: cern.lsa.domain.settings.BeamProcess, exception: java.lang.Exception) -> None: ...
    def setSourceException(self, exception: java.lang.Exception) -> None: ...
    def setSourceSettings(self, parameterSettings: cern.lsa.domain.settings.ParameterSettings) -> None: ...
    def toString(self) -> str: ...

class SettingComparisonRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.settings.SettingComparisonRequest):
    POINT_IN_SRC_FUNCTION: _py_ClassVar[str] = ...
    POINT_IN_DEST_FUNCTION: _py_ClassVar[str] = ...
    SRC_SETTINGS_SOURCE: _py_ClassVar[str] = ...
    DEST_SETTINGS_SOURCE: _py_ClassVar[str] = ...
    PARAMETERS: _py_ClassVar[str] = ...
    COMPARE_ALL_PARAMETERS: _py_ClassVar[str] = ...
    SRC_BEAMPROCESSES: _py_ClassVar[str] = ...
    DEST_BEAMPROCESSES: _py_ClassVar[str] = ...
    IGNORE_FLAT_FUNCTION_LENGTH: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any]): ...
    def compareAllParameters(self) -> bool: ...
    def getDestinationBeamProcesses(self) -> java.util.List[cern.lsa.domain.settings.BeamProcess]: ...
    def getDestinationSettingsSource(self) -> cern.lsa.domain.settings.SettingsSource: ...
    def getParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getPointInDestFunction(self) -> int: ...
    def getPointInSourceFunction(self) -> int: ...
    def getSourceBeamProcesses(self) -> java.util.List[cern.lsa.domain.settings.BeamProcess]: ...
    def getSourceSettingsSource(self) -> cern.lsa.domain.settings.SettingsSource: ...
    def ignoreFlatFunctionsLength(self) -> bool: ...

class SettingComparisonResponseImpl(cern.lsa.domain.settings.SettingComparisonResponse, java.io.Serializable):
    def __init__(self, settingComparisonRequest: cern.lsa.domain.settings.SettingComparisonRequest, settingComparisonResult: cern.lsa.domain.settings.SettingComparisonResult): ...
    def getSettingComparisonRequest(self) -> cern.lsa.domain.settings.SettingComparisonRequest: ...
    def getSettingComparisonResult(self) -> cern.lsa.domain.settings.SettingComparisonResult: ...

class SettingComparisonResultImpl(cern.lsa.domain.settings.SettingComparisonResult, java.io.Serializable):
    def __init__(self, map: java.util.Map[cern.lsa.domain.settings.Parameter, cern.lsa.domain.settings.SettingComparisonParameterResult]): ...
    def getComparedParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getSettingComparisonParameterResult(self, parameter: cern.lsa.domain.settings.Parameter) -> cern.lsa.domain.settings.SettingComparisonParameterResult: ...
    def getSettingComparisonParameterResults(self) -> java.util.Map[cern.lsa.domain.settings.Parameter, cern.lsa.domain.settings.SettingComparisonParameterResult]: ...

class StandAloneContextCloneRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.settings.StandAloneContextCloneRequest):
    CLONE_NAME: _py_ClassVar[str] = ...
    DESCRIPTION: _py_ClassVar[str] = ...
    ATTRIBUTES: _py_ClassVar[str] = ...
    SOURCE: _py_ClassVar[str] = ...
    WITH_HISTORY: _py_ClassVar[str] = ...
    HISTORY_CUT_OFF_DATE: _py_ClassVar[str] = ...
    CONTEXT_CATEGORY: _py_ClassVar[str] = ...
    CLONE_TYPE: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any]): ...
    def getAttributes(self) -> java.util.Set[cern.lsa.domain.commons.Attribute]: ...
    def getCloneName(self) -> str: ...
    def getContextCategory(self) -> cern.lsa.domain.settings.ContextCategory: ...
    def getDescription(self) -> str: ...
    def getHistoryCutOff(self) -> java.time.Instant: ...
    def getSource(self) -> cern.lsa.domain.settings.StandAloneContext: ...
    def shouldCloneType(self) -> bool: ...
    def withHistory(self) -> bool: ...

class StandAloneContextCreationRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.settings.StandAloneContextCreationRequest):
    NAME: _py_ClassVar[str] = ...
    DESCRIPTION: _py_ClassVar[str] = ...
    CONTEXT_TYPE: _py_ClassVar[str] = ...
    CONTEXT_CATEGORY: _py_ClassVar[str] = ...
    ATTRIBUTES: _py_ClassVar[str] = ...
    LENGTH: _py_ClassVar[str] = ...
    MULTIPLEXITY: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any]): ...
    def getAttributes(self) -> java.util.Set[cern.lsa.domain.commons.Attribute]: ...
    def getContextCategory(self) -> cern.lsa.domain.settings.ContextCategory: ...
    def getContextType(self) -> cern.lsa.domain.settings.type.ContextType: ...
    def getDescription(self) -> str: ...
    def getLength(self) -> int: ...
    def getName(self) -> str: ...
    def isMultiplexed(self) -> bool: ...

class TrimHeaderImpl(cern.lsa.domain.commons.spi.AbstractIdentifiedEntity[cern.lsa.domain.settings.TrimHeader], cern.lsa.domain.settings.TrimHeader, java.io.Serializable):
    def __init__(self): ...
    def getBeamProcesses(self) -> java.util.List[cern.lsa.domain.settings.BeamProcess]: ...
    def getClientInfo(self) -> str: ...
    def getCreatedDate(self) -> java.util.Date: ...
    def getDescription(self) -> str: ...
    def setBeamProcesses(self, collection: java.util.Collection[cern.lsa.domain.settings.BeamProcess]) -> None: ...
    def setClientInfo(self, string: str) -> None: ...
    def setCreatedDate(self, date: java.util.Date) -> None: ...
    def setDescription(self, string: str) -> None: ...
    def toString(self) -> str: ...

class TrimRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.settings.TrimRequest):
    IS_GENERATION: _py_ClassVar[str] = ...
    SETTING_PART: _py_ClassVar[str] = ...
    CHILD_SETTING_PART: _py_ClassVar[str] = ...
    CUSTOM_SETTING_PART_MAP: _py_ClassVar[str] = ...
    CONTEXT_SETTINGS: _py_ClassVar[str] = ...
    PARAMETERS: _py_ClassVar[str] = ...
    IGNORE_ERRORS: _py_ClassVar[str] = ...
    LENIENT_DRIVE: _py_ClassVar[str] = ...
    PROPAGATE_TO_CHILDREN: _py_ClassVar[str] = ...
    RELATIVE: _py_ClassVar[str] = ...
    PERSIST_SETTINGS: _py_ClassVar[str] = ...
    RETURN_SETTINGS: _py_ClassVar[str] = ...
    DRIVE: _py_ClassVar[str] = ...
    DESCRIPTION: _py_ClassVar[str] = ...
    FORCE_DRIVE: _py_ClassVar[str] = ...
    SKIP_PROCESSING: _py_ClassVar[str] = ...
    FORCE_PROCESSING: _py_ClassVar[str] = ...
    SKIP_DRIVING_SOURCE_PARAMETERS: _py_ClassVar[str] = ...
    COMMIT: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any], map2: java.util.Map[str, _py_Any]): ...
    def getAttribute(self, string: str) -> _py_Any: ...
    def getAttributes(self) -> java.util.Map[str, _py_Any]: ...
    def getChildSettingPart(self) -> cern.lsa.domain.settings.SettingPartEnum: ...
    def getContext(self) -> cern.lsa.domain.settings.StandAloneContext: ...
    def getContextSettings(self) -> cern.lsa.domain.settings.ContextSettings: ...
    def getCustomSettingPart(self, parameter: cern.lsa.domain.settings.Parameter) -> cern.lsa.domain.settings.SettingPartEnum: ...
    def getCustomSettingPartMap(self) -> java.util.Map[cern.lsa.domain.settings.Parameter, cern.lsa.domain.settings.SettingPartEnum]: ...
    def getDescription(self) -> str: ...
    def getParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getSettingPart(self) -> cern.lsa.domain.settings.SettingPartEnum: ...
    def isCommit(self) -> bool: ...
    def isDrive(self) -> bool: ...
    def isForceDrive(self) -> bool: ...
    def isForceProcessing(self) -> bool: ...
    def isIgnoreErrors(self) -> bool: ...
    def isLenientDrive(self) -> bool: ...
    def isPersistSettings(self) -> bool: ...
    def isPropagateToChildren(self) -> bool: ...
    def isRelative(self) -> bool: ...
    def isReturnSettings(self) -> bool: ...
    def isSkipProcessing(self) -> bool: ...
    def setAttribute(self, string: str, object: _py_Any) -> None: ...
    def setSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> None: ...
    def toString(self) -> str: ...

class TrimResponseImpl(cern.lsa.domain.settings.TrimResponse, java.io.Serializable):
    def __init__(self, trimResult: cern.lsa.domain.settings.TrimResult, driveResult: cern.lsa.domain.exploitation.DriveResult): ...
    def getDriveResult(self) -> cern.lsa.domain.exploitation.DriveResult: ...
    def getTrimResult(self) -> cern.lsa.domain.settings.TrimResult: ...
    def isDrivePerformed(self) -> bool: ...

class TrimResultImpl(cern.lsa.domain.settings.TrimResult, java.io.Serializable):
    @overload
    def __init__(self, trimRequest: cern.lsa.domain.settings.TrimRequest, contextSettings: cern.lsa.domain.settings.ContextSettings): ...
    @overload
    def __init__(self, trimRequest: cern.lsa.domain.settings.TrimRequest, trimHeader: cern.lsa.domain.settings.TrimHeader, contextSettings: cern.lsa.domain.settings.ContextSettings, list: java.util.List[cern.accsoft.commons.util.value.Pair[str, java.lang.Throwable]]): ...
    def getAttribute(self, string: str) -> java.io.Serializable: ...
    def getContext(self) -> cern.lsa.domain.settings.StandAloneContext: ...
    def getContextSettings(self) -> cern.lsa.domain.settings.ContextSettings: ...
    def getTrimHeader(self) -> cern.lsa.domain.settings.TrimHeader: ...
    def getTrimRequest(self) -> cern.lsa.domain.settings.TrimRequest: ...
    def getWarnings(self) -> java.util.List[cern.accsoft.commons.util.value.Pair[str, java.lang.Throwable]]: ...
    def putAttributes(self, map: java.util.Map[str, java.io.Serializable]) -> None: ...
    def setAttribute(self, string: str, serializable: java.io.Serializable) -> None: ...

class UserContextMappingImpl(cern.lsa.domain.settings.UserContextMapping, java.io.Serializable):
    def __init__(self, string: str, string2: str, long: int, operationType: cern.lsa.domain.settings.UserContextMapping.OperationType, string3: str, boolean: bool): ...
    def equalByName(self, userContextMapping: cern.lsa.domain.settings.UserContextMapping) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getContextName(self) -> str: ...
    def getContextParent(self) -> str: ...
    def getMappingTimestamp(self) -> int: ...
    def getOperationType(self) -> cern.lsa.domain.settings.UserContextMapping.OperationType: ...
    def getUser(self) -> str: ...
    def hashCode(self) -> int: ...
    def isResident(self) -> bool: ...
    def toString(self) -> str: ...

class BoundedPolynomialSequenceSetting(AbstractSetting):
    def __init__(self): ...
    def getCorrectionValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    @overload
    def getTargetValue(self) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    @overload
    def getTargetValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    @overload
    def getValue(self) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    @overload
    def getValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    @overload
    def setValue(self, boundedPolynomialSequence: cern.accsoft.commons.value.BoundedPolynomialSequence) -> None: ...
    @overload
    def setValue(self, scalarArray2D: cern.accsoft.commons.value.ScalarArray2D) -> None: ...

class ContextImpl(ContextBase[cern.lsa.domain.settings.Context], cern.lsa.domain.settings.Context):
    def getDescription(self) -> str: ...
    def getParent(self) -> cern.lsa.domain.settings.Context: ...
    def getTypeName(self) -> str: ...
    def isMultiplexed(self) -> bool: ...
    def isStandAlone(self) -> bool: ...
    def setMultiplexed(self, boolean: bool) -> None: ...
    def setParent(self, context: cern.lsa.domain.settings.Context) -> None: ...
    def setTypeName(self, string: str) -> None: ...

class CopySettingsRequestImpl(TrimRequestImpl, cern.lsa.domain.settings.CopySettingsRequest):
    SETTINGS_SOURCE: _py_ClassVar[str] = ...
    SOURCE_CONTEXTS: _py_ClassVar[str] = ...
    DESTINATION_CONTEXTS: _py_ClassVar[str] = ...
    DESTINATION_PARAMETERS: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any], map2: java.util.Map[str, _py_Any]): ...
    def getDestinationContexts(self) -> java.util.List[cern.lsa.domain.settings.Context]: ...
    def getDestinationParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getSettingsSource(self) -> cern.lsa.domain.settings.SettingsSource: ...
    def getSourceContexts(self) -> java.util.List[cern.lsa.domain.settings.Context]: ...
    def toString(self) -> str: ...

class CycleIntersectionsImpl(AbstractContextIntersectionsImpl, cern.lsa.domain.settings.CycleIntersections, java.io.Serializable):
    def __init__(self, string: str): ...
    def addIntersection(self, cycleBeamProcessIntersection: cern.lsa.domain.settings.CycleBeamProcessIntersection) -> None: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getBeamProcesses(self) -> java.util.Set[cern.lsa.domain.settings.BeamProcess]: ...
    def getCycleBeamProcessIntersections(self) -> java.util.SortedSet: ...
    def getCycleName(self) -> str: ...
    def getFollowingBeamProcess(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> cern.lsa.domain.settings.BeamProcess: ...
    def getIntersectedBeamProcesses(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> java.util.Set[cern.lsa.domain.settings.BeamProcess]: ...
    def getIntersectedFunctionBeamProcess(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer, double: float) -> cern.lsa.domain.settings.BeamProcessIntersection: ...
    def getIntersectedFunctionBeamProcesses(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer, double: float) -> java.util.List[cern.lsa.domain.settings.BeamProcessIntersection]: ...
    @overload
    def getParticleTransfers(self) -> java.util.Set: ...
    @overload
    def getParticleTransfers(self) -> java.util.SortedSet: ...
    def getPrecedingBeamProcess(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> cern.lsa.domain.settings.BeamProcess: ...
    def hashCode(self) -> int: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...

class FunctionSetting(AbstractSetting, java.io.Serializable, java.lang.Cloneable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, type: cern.accsoft.commons.value.Type): ...
    @overload
    def clone(self) -> cern.lsa.domain.settings.Setting: ...
    @overload
    def clone(self) -> AbstractSetting: ...
    @overload
    def clone(self) -> 'FunctionSetting': ...
    @overload
    def clone(self) -> _py_Any: ...
    def getCorrectionValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getTargetValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def setCorrectionValue(self, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> None: ...
    def setTargetValue(self, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> None: ...

class FunctionsArraySetting(AbstractSetting, java.io.Serializable, java.lang.Cloneable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, type: cern.accsoft.commons.value.Type): ...
    @overload
    def clone(self) -> cern.lsa.domain.settings.Setting: ...
    @overload
    def clone(self) -> AbstractSetting: ...
    @overload
    def clone(self) -> 'FunctionsArraySetting': ...
    @overload
    def clone(self) -> _py_Any: ...
    def getCorrectionValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getTargetValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def setCorrectionValue(self, immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> None: ...
    def setTargetValue(self, immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> None: ...

class IncorporationRequestImpl(TrimRequestImpl, cern.lsa.domain.settings.IncorporationRequest):
    INCORPORATION_SETTINGS: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any], map2: java.util.Map[str, _py_Any]): ...
    def getIncorporationSettings(self) -> java.util.Set[cern.lsa.domain.settings.IncorporationSetting]: ...
    def shouldIncorporate(self, parameter: cern.lsa.domain.settings.Parameter) -> bool: ...
    def toString(self) -> str: ...

class KnobImpl(ParameterDecorator, cern.lsa.domain.settings.Knob):
    def __init__(self, parameter: cern.lsa.domain.settings.Parameter, knobFactors: cern.lsa.domain.settings.KnobFactors): ...
    def belongsToFunctionBeamProcess(self) -> bool: ...
    @overload
    def compareTo(self, parameter: cern.lsa.domain.settings.Parameter) -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getComponentNames(self) -> java.util.Set[str]: ...
    def getDefaultHierarchy(self) -> str: ...
    def getDevice(self) -> cern.lsa.domain.devices.Device: ...
    def getId(self) -> int: ...
    def getKnobFactors(self) -> cern.lsa.domain.settings.KnobFactors: ...
    def getName(self) -> str: ...
    def getOpticNames(self) -> java.util.Set[str]: ...
    def getParameterGroups(self) -> java.util.Set: ...
    def getParameterType(self) -> cern.lsa.domain.settings.ParameterType: ...
    def getParticleTransfers(self) -> java.util.Set: ...
    def getPropertyField(self) -> cern.lsa.domain.devices.type.PropertyField: ...
    def getValueDescriptor(self) -> cern.accsoft.commons.value.ValueDescriptor: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
    def hashCode(self) -> int: ...
    def isCritical(self) -> bool: ...
    def isCycleBound(self) -> bool: ...
    def isMonitorable(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isPropertySupportingPartialSet(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isReservedForOpExperts(self) -> bool: ...
    def isTrimable(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def toString(self) -> str: ...

class RevertTrimRequestImpl(TrimRequestImpl, cern.lsa.domain.settings.RevertTrimRequest):
    TRIM_HEADER: _py_ClassVar[str] = ...
    BEAM_PROCESSES: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any], map2: java.util.Map[str, _py_Any]): ...
    def getBeamProcesses(self) -> java.util.Set[cern.lsa.domain.settings.BeamProcess]: ...
    def getTrimHeader(self) -> cern.lsa.domain.settings.TrimHeader: ...
    def toString(self) -> str: ...

class ScalarSetting(AbstractSetting, java.io.Serializable, java.lang.Cloneable):
    def __init__(self, type: cern.accsoft.commons.value.Type): ...
    @overload
    def clone(self) -> cern.lsa.domain.settings.Setting: ...
    @overload
    def clone(self) -> AbstractSetting: ...
    @overload
    def clone(self) -> 'ScalarSetting': ...
    @overload
    def clone(self) -> _py_Any: ...
    def getCorrectionValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getTargetValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def setCorrectionValue(self, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> None: ...
    def setTargetValue(self, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> None: ...

class SettingsGenerationRequestImpl(TrimRequestImpl, cern.lsa.domain.settings.SettingsGenerationRequest):
    SUBCONTEXTS: _py_ClassVar[str] = ...
    GENERATE_ZERO_SETTINGS: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any], map2: java.util.Map[str, _py_Any]): ...
    def getSubContexts(self) -> java.util.Set[cern.lsa.domain.settings.SubContext]: ...
    def isGenerateZeroSettings(self) -> bool: ...
    def toString(self) -> str: ...

class SettingsRestoreStatusImpl(FailedParametersStatusImpl, cern.lsa.domain.settings.SettingsRestoreStatus, java.io.Serializable):
    def __init__(self, compositeContextSettings: cern.lsa.domain.settings.CompositeContextSettings): ...
    def getSettings(self) -> cern.lsa.domain.settings.CompositeContextSettings: ...

class CorrectionMissingSetting(ScalarSetting):
    def getCorrectionValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def setCorrectionValue(self, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> None: ...
    def setValue(self, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> None: ...

class IncorporationFunctionsArraySetting(FunctionsArraySetting):
    def __init__(self, doubleArray: _py_List[float], doubleArray2: _py_List[float]): ...
    @overload
    def getCorrectionValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray: ...
    @overload
    def getCorrectionValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    @overload
    def getTargetValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray: ...
    @overload
    def getTargetValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    @overload
    def getValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray: ...
    @overload
    def getValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def setCorrectionValue(self, immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> None: ...
    def setTargetValue(self, immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> None: ...

class PatternImpl(ContextImpl, cern.lsa.domain.settings.Pattern):
    def __init__(self): ...
    def getAttribute(self, string: str) -> cern.lsa.domain.commons.Attribute: ...
    def getAttributes(self) -> java.util.Set[cern.lsa.domain.commons.Attribute]: ...
    def getBeamProcesses(self) -> java.util.List[cern.lsa.domain.settings.BeamProcess]: ...
    def getContextFamily(self) -> cern.lsa.domain.settings.ContextFamily: ...
    def getDrivableBeamProcesses(self) -> java.util.List[cern.lsa.domain.settings.DrivableBeamProcess]: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def isMultiplexed(self) -> bool: ...
    def isResident(self) -> bool: ...
    def setMultiplexed(self, boolean: bool) -> None: ...
    def setResident(self, boolean: bool) -> None: ...
    def setSubContexts(self, collection: java.util.Collection[cern.lsa.domain.settings.SubContext]) -> None: ...

class SubContextImpl(ContextImpl, cern.lsa.domain.settings.SubContext):
    def getStartTime(self) -> int: ...
    def getUser(self) -> str: ...
    def setStartTime(self, int: int) -> None: ...
    def setUser(self, string: str) -> None: ...

class Array2DSetting(CorrectionMissingSetting):
    def __init__(self, type: cern.accsoft.commons.value.Type): ...
    def setValue(self, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> None: ...

class ArraySetting(CorrectionMissingSetting):
    def __init__(self, type: cern.accsoft.commons.value.Type): ...
    def setValue(self, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> None: ...

class BeamProcessImpl(SubContextImpl, cern.lsa.domain.settings.BeamProcess):
    @overload
    def __init__(self, beamProcessImpl: 'BeamProcessImpl'): ...
    @overload
    def __init__(self, string: str): ...
    def getCategory(self) -> cern.lsa.domain.settings.type.BeamProcessTypeCategory: ...
    def getContextFamily(self) -> cern.lsa.domain.settings.ContextFamily: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...
    def getPurpose(self) -> cern.lsa.domain.settings.type.BeamProcessPurpose: ...
    def setCategory(self, beamProcessTypeCategory: cern.lsa.domain.settings.type.BeamProcessTypeCategory) -> None: ...
    def setParticleTransfer(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> None: ...
    def setPurpose(self, beamProcessPurpose: cern.lsa.domain.settings.type.BeamProcessPurpose) -> None: ...

class BeamProductionChainImpl(SubContextImpl, cern.lsa.domain.settings.BeamProductionChain):
    @overload
    def __init__(self, beamProductionChainImpl: 'BeamProductionChainImpl'): ...
    @overload
    def __init__(self, string: str): ...
    def getBeamProcesses(self) -> java.util.List[cern.lsa.domain.settings.DrivableBeamProcess]: ...
    def getContextFamily(self) -> cern.lsa.domain.settings.ContextFamily: ...
    def setBeamProcesses(self, collection: java.util.Collection[cern.lsa.domain.settings.DrivableBeamProcess]) -> None: ...

class BooleanSetting(CorrectionMissingSetting):
    def __init__(self): ...
    def setValue(self, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> None: ...

class CycleImpl(SubContextImpl, cern.lsa.domain.settings.Cycle):
    @overload
    def __init__(self, cycleImpl: 'CycleImpl'): ...
    @overload
    def __init__(self, string: str): ...
    def getContextFamily(self) -> cern.lsa.domain.settings.ContextFamily: ...

class StringSetting(CorrectionMissingSetting):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, type: cern.accsoft.commons.value.Type): ...
    def setValue(self, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> None: ...

class StandAloneBeamProcessImpl(BeamProcessImpl, cern.lsa.domain.settings.StandAloneBeamProcess, cern.lsa.domain.commons.AttributeWritableAware):
    @overload
    def __init__(self, standAloneBeamProcessImpl: 'StandAloneBeamProcessImpl'): ...
    @overload
    def __init__(self, string: str): ...
    def addAttribute(self, attribute: cern.lsa.domain.commons.Attribute) -> None: ...
    def getActualBeamProcessInfo(self) -> cern.lsa.domain.settings.ActualBeamProcessInfo: ...
    def getAttribute(self, string: str) -> cern.lsa.domain.commons.Attribute: ...
    def getAttributes(self) -> java.util.Set[cern.lsa.domain.commons.Attribute]: ...
    def getBeamProcesses(self) -> java.util.List[cern.lsa.domain.settings.BeamProcess]: ...
    def getContextFamily(self) -> cern.lsa.domain.settings.ContextFamily: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def isActual(self) -> bool: ...
    def isResident(self) -> bool: ...
    def setActualBeamProcessInfo(self, actualBeamProcessInfo: cern.lsa.domain.settings.ActualBeamProcessInfo) -> None: ...
    def setAttributes(self, collection: java.util.Collection[cern.lsa.domain.commons.Attribute]) -> None: ...
    def setResident(self, boolean: bool) -> None: ...

class StandAloneCycleImpl(CycleImpl, cern.lsa.domain.settings.StandAloneCycle, cern.lsa.domain.commons.AttributeWritableAware):
    @overload
    def __init__(self, standAloneCycleImpl: 'StandAloneCycleImpl'): ...
    @overload
    def __init__(self, string: str): ...
    def addAttribute(self, attribute: cern.lsa.domain.commons.Attribute) -> None: ...
    def clearIntersections(self) -> None: ...
    def getAttribute(self, string: str) -> cern.lsa.domain.commons.Attribute: ...
    def getAttributes(self) -> java.util.Set[cern.lsa.domain.commons.Attribute]: ...
    def getBeamProcesses(self) -> java.util.List[cern.lsa.domain.settings.BeamProcess]: ...
    def getContextFamily(self) -> cern.lsa.domain.settings.ContextFamily: ...
    def getIntersections(self) -> cern.lsa.domain.settings.CycleIntersections: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def isResident(self) -> bool: ...
    def setAttributes(self, collection: java.util.Collection[cern.lsa.domain.commons.Attribute]) -> None: ...
    def setBeamProcesses(self, collection: java.util.Collection[BeamProcessImpl]) -> None: ...
    def setResident(self, boolean: bool) -> None: ...
    def setStartTime(self, int: int) -> None: ...

class ParameterBuilder:
    def __init__(self): ...
    @classmethod
    @overload
    def newBuilder(cls, parameter: cern.lsa.domain.settings.Parameter) -> 'ParameterBuilder.ParameterBuilderSteps': ...
    @classmethod
    @overload
    def newBuilder(cls) -> 'ParameterBuilder.SetIdParameterBuilder': ...
    class BuildParameterBuilder:
        def build(self) -> cern.lsa.domain.settings.Parameter: ...
    class ParameterBuilderSteps(cern.lsa.domain.settings.spi.ParameterBuilder.SetIdParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetDeviceParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetParameterTypeParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetPropertyFieldParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetValueDescriptorParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetMultiplexedParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetTrimableParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetCriticalParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetDefaultHierarchyParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetBelongsToFunctionBeamProcessParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetReservedForOpExpertsParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetParameterGroupsParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetPropertySupportingPartialSetParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetVirtualParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetMonitorableParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetWritableParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetReadableParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetValueTypeParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.BuildParameterBuilder, cern.lsa.domain.settings.spi.ParameterBuilder.SetCycleBoundParameterBuilder):
        def addParameterGroup(self, string: str) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        def addParameterGroups(self, collection: java.util.Collection[str]) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        def build(self) -> cern.lsa.domain.settings.Parameter: ...
        @overload
        def setBelongsToFunctionBeamProcess(self, boolean: bool) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setBelongsToFunctionBeamProcess(self, boolean: bool) -> 'ParameterBuilder.SetReadableParameterBuilder': ...
        @overload
        def setCritical(self, boolean: bool) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setCritical(self, boolean: bool) -> 'ParameterBuilder.SetReservedForOpExpertsParameterBuilder': ...
        @overload
        def setCycleBound(self, boolean: bool) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setCycleBound(self, boolean: bool) -> 'ParameterBuilder.SetTrimableParameterBuilder': ...
        @overload
        def setDefaultHierarchy(self) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setDefaultHierarchy(self, string: str) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setDefaultHierarchy(self) -> 'ParameterBuilder.SetPropertySupportingPartialSetParameterBuilder': ...
        @overload
        def setDefaultHierarchy(self, string: str) -> 'ParameterBuilder.SetPropertySupportingPartialSetParameterBuilder': ...
        @overload
        def setDevice(self, device: cern.lsa.domain.devices.Device) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setDevice(self, device: cern.lsa.domain.devices.Device) -> 'ParameterBuilder.SetParameterTypeParameterBuilder': ...
        @overload
        def setMonitorable(self, boolean: bool) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setMonitorable(self, boolean: bool) -> 'ParameterBuilder.SetVirtualParameterBuilder': ...
        @overload
        def setMultiplexed(self, boolean: bool) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setMultiplexed(self, boolean: bool) -> 'ParameterBuilder.SetCycleBoundParameterBuilder': ...
        @overload
        def setParameterGroups(self, collection: java.util.Collection) -> 'ParameterBuilder.BuildParameterBuilder': ...
        @overload
        def setParameterGroups(self, collection: java.util.Collection[str]) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setParameterName(self, string: str) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setParameterName(self, string: str) -> 'ParameterBuilder.SetDeviceParameterBuilder': ...
        @overload
        def setParameterNameAndId(self, long: int, string: str) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setParameterNameAndId(self, long: int, string: str) -> 'ParameterBuilder.SetDeviceParameterBuilder': ...
        @overload
        def setParameterType(self, parameterType: cern.lsa.domain.settings.ParameterType) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setParameterType(self, parameterType: cern.lsa.domain.settings.ParameterType) -> 'ParameterBuilder.SetPropertyFieldParameterBuilder': ...
        @overload
        def setPropertyField(self, propertyField: cern.lsa.domain.devices.type.PropertyField) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setPropertyField(self, propertyField: cern.lsa.domain.devices.type.PropertyField) -> 'ParameterBuilder.SetValueTypeParameterBuilder': ...
        @overload
        def setReadable(self, boolean: bool) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setReadable(self, boolean: bool) -> 'ParameterBuilder.SetWritableParameterBuilder': ...
        @overload
        def setReservedForOpExperts(self, boolean: bool) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setReservedForOpExperts(self, boolean: bool) -> 'ParameterBuilder.SetDefaultHierarchyParameterBuilder': ...
        @overload
        def setSupportingPartialSet(self, boolean: bool) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setSupportingPartialSet(self, boolean: bool) -> 'ParameterBuilder.SetParameterGroupsParameterBuilder': ...
        @overload
        def setTrimable(self, boolean: bool) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setTrimable(self, boolean: bool) -> 'ParameterBuilder.SetBelongsToFunctionBeamProcessParameterBuilder': ...
        @overload
        def setValueDescriptor(self, valueDescriptor: cern.accsoft.commons.value.ValueDescriptor) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setValueDescriptor(self, valueDescriptor: cern.accsoft.commons.value.ValueDescriptor) -> 'ParameterBuilder.SetMultiplexedParameterBuilder': ...
        @overload
        def setValueType(self, type: cern.accsoft.commons.value.Type) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setValueType(self, type: cern.accsoft.commons.value.Type) -> 'ParameterBuilder.SetValueDescriptorParameterBuilder': ...
        @overload
        def setVirtual(self, boolean: bool) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setVirtual(self, boolean: bool) -> 'ParameterBuilder.SetCriticalParameterBuilder': ...
        @overload
        def setWritable(self, boolean: bool) -> 'ParameterBuilder.ParameterBuilderSteps': ...
        @overload
        def setWritable(self, boolean: bool) -> 'ParameterBuilder.SetMonitorableParameterBuilder': ...
        @overload
        def withNoGroups(self) -> 'ParameterBuilder.BuildParameterBuilder': ...
        @overload
        def withNoGroups(self) -> 'ParameterBuilder.ParameterBuilderSteps': ...
    class SetBelongsToFunctionBeamProcessParameterBuilder:
        def setBelongsToFunctionBeamProcess(self, boolean: bool) -> 'ParameterBuilder.SetReadableParameterBuilder': ...
    class SetCriticalParameterBuilder:
        def setCritical(self, boolean: bool) -> 'ParameterBuilder.SetReservedForOpExpertsParameterBuilder': ...
    class SetCycleBoundParameterBuilder:
        def setCycleBound(self, boolean: bool) -> 'ParameterBuilder.SetTrimableParameterBuilder': ...
    class SetDefaultHierarchyParameterBuilder:
        @overload
        def setDefaultHierarchy(self) -> 'ParameterBuilder.SetPropertySupportingPartialSetParameterBuilder': ...
        @overload
        def setDefaultHierarchy(self, string: str) -> 'ParameterBuilder.SetPropertySupportingPartialSetParameterBuilder': ...
    class SetDeviceParameterBuilder:
        def setDevice(self, device: cern.lsa.domain.devices.Device) -> 'ParameterBuilder.SetParameterTypeParameterBuilder': ...
    class SetIdParameterBuilder:
        def setParameterName(self, string: str) -> 'ParameterBuilder.SetDeviceParameterBuilder': ...
        def setParameterNameAndId(self, long: int, string: str) -> 'ParameterBuilder.SetDeviceParameterBuilder': ...
    class SetMonitorableParameterBuilder:
        def setMonitorable(self, boolean: bool) -> 'ParameterBuilder.SetVirtualParameterBuilder': ...
    class SetMultiplexedParameterBuilder:
        def setMultiplexed(self, boolean: bool) -> 'ParameterBuilder.SetCycleBoundParameterBuilder': ...
    class SetParameterGroupsParameterBuilder:
        def setParameterGroups(self, collection: java.util.Collection[str]) -> 'ParameterBuilder.BuildParameterBuilder': ...
        def withNoGroups(self) -> 'ParameterBuilder.BuildParameterBuilder': ...
    class SetParameterTypeParameterBuilder:
        def setParameterType(self, parameterType: cern.lsa.domain.settings.ParameterType) -> 'ParameterBuilder.SetPropertyFieldParameterBuilder': ...
    class SetPropertyFieldParameterBuilder:
        def setPropertyField(self, propertyField: cern.lsa.domain.devices.type.PropertyField) -> 'ParameterBuilder.SetValueTypeParameterBuilder': ...
    class SetPropertySupportingPartialSetParameterBuilder:
        def setSupportingPartialSet(self, boolean: bool) -> 'ParameterBuilder.SetParameterGroupsParameterBuilder': ...
    class SetReadableParameterBuilder:
        def setReadable(self, boolean: bool) -> 'ParameterBuilder.SetWritableParameterBuilder': ...
    class SetReservedForOpExpertsParameterBuilder:
        def setReservedForOpExperts(self, boolean: bool) -> 'ParameterBuilder.SetDefaultHierarchyParameterBuilder': ...
    class SetTrimableParameterBuilder:
        def setTrimable(self, boolean: bool) -> 'ParameterBuilder.SetBelongsToFunctionBeamProcessParameterBuilder': ...
    class SetValueDescriptorParameterBuilder:
        def setValueDescriptor(self, valueDescriptor: cern.accsoft.commons.value.ValueDescriptor) -> 'ParameterBuilder.SetMultiplexedParameterBuilder': ...
    class SetValueTypeParameterBuilder:
        def setValueType(self, type: cern.accsoft.commons.value.Type) -> 'ParameterBuilder.SetValueDescriptorParameterBuilder': ...
    class SetVirtualParameterBuilder:
        def setVirtual(self, boolean: bool) -> 'ParameterBuilder.SetCriticalParameterBuilder': ...
    class SetWritableParameterBuilder:
        def setWritable(self, boolean: bool) -> 'ParameterBuilder.SetMonitorableParameterBuilder': ...

class ParameterTypeBuilder:
    def __init__(self): ...
    @classmethod
    @overload
    def newBuilder(cls, parameterType: cern.lsa.domain.settings.ParameterType) -> 'ParameterTypeBuilder.ParameterTypeStepBuilder': ...
    @classmethod
    @overload
    def newBuilder(cls) -> 'ParameterTypeBuilder.SetNameAndIdParameterTypeBuilder': ...
    class BuildParameterType:
        def build(self) -> cern.lsa.domain.settings.ParameterType: ...
    class ParameterTypeStepBuilder(cern.lsa.domain.settings.spi.ParameterTypeBuilder.SetNameAndIdParameterTypeBuilder, cern.lsa.domain.settings.spi.ParameterTypeBuilder.SetLinkRuleApplicableParameterTypeBuilder, cern.lsa.domain.settings.spi.ParameterTypeBuilder.SetParameterTypeCategoryBuilder, cern.lsa.domain.settings.spi.ParameterTypeBuilder.BuildParameterType):
        def build(self) -> cern.lsa.domain.settings.ParameterType: ...
        @overload
        def setCategoryType(self, parameterTypeCategory: cern.lsa.domain.settings.ParameterTypeCategory) -> 'ParameterTypeBuilder.BuildParameterType': ...
        @overload
        def setCategoryType(self, parameterTypeCategory: cern.lsa.domain.settings.ParameterTypeCategory) -> 'ParameterTypeBuilder.ParameterTypeStepBuilder': ...
        @overload
        def setDefaultCategoryType(self) -> 'ParameterTypeBuilder.BuildParameterType': ...
        @overload
        def setDefaultCategoryType(self) -> 'ParameterTypeBuilder.ParameterTypeStepBuilder': ...
        @overload
        def setIdAndName(self, long: int, string: str) -> 'ParameterTypeBuilder.ParameterTypeStepBuilder': ...
        @overload
        def setIdAndName(self, long: int, string: str) -> 'ParameterTypeBuilder.SetLinkRuleApplicableParameterTypeBuilder': ...
        @overload
        def setLinkRuleApplicable(self, boolean: bool) -> 'ParameterTypeBuilder.ParameterTypeStepBuilder': ...
        @overload
        def setLinkRuleApplicable(self, boolean: bool) -> 'ParameterTypeBuilder.SetParameterTypeCategoryBuilder': ...
        @overload
        def setName(self, string: str) -> 'ParameterTypeBuilder.ParameterTypeStepBuilder': ...
        @overload
        def setName(self, string: str) -> 'ParameterTypeBuilder.SetLinkRuleApplicableParameterTypeBuilder': ...
    class SetLinkRuleApplicableParameterTypeBuilder:
        def setLinkRuleApplicable(self, boolean: bool) -> 'ParameterTypeBuilder.SetParameterTypeCategoryBuilder': ...
    class SetNameAndIdParameterTypeBuilder:
        def setIdAndName(self, long: int, string: str) -> 'ParameterTypeBuilder.SetLinkRuleApplicableParameterTypeBuilder': ...
        def setName(self, string: str) -> 'ParameterTypeBuilder.SetLinkRuleApplicableParameterTypeBuilder': ...
    class SetParameterTypeCategoryBuilder:
        def setCategoryType(self, parameterTypeCategory: cern.lsa.domain.settings.ParameterTypeCategory) -> 'ParameterTypeBuilder.BuildParameterType': ...
        def setDefaultCategoryType(self) -> 'ParameterTypeBuilder.BuildParameterType': ...
