from typing import Any as _py_Any
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.domain
import cern.accsoft.commons.domain.beams
import cern.accsoft.commons.domain.particletransfers
import cern.accsoft.commons.domain.zones
import cern.accsoft.commons.util
import cern.accsoft.commons.value
import cern.lsa.domain.commons.spi
import cern.lsa.domain.devices
import cern.lsa.domain.devices.spi
import cern.lsa.domain.optics
import cern.lsa.domain.settings.type
import com.google.common.collect
import java.io
import java.lang
import java.util


class CalibrationImpl(cern.accsoft.commons.util.AbstractNamedSerializable[cern.lsa.domain.optics.Calibration], cern.lsa.domain.optics.Calibration, java.io.Serializable):
    def __init__(self): ...
    def addCalibrationFunctionForType(self, calibrationFunctionTypes: cern.lsa.domain.optics.CalibrationFunctionTypes, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> None: ...
    def getCalibrationFunctionByType(self, calibrationFunctionTypes: cern.lsa.domain.optics.CalibrationFunctionTypes) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getCalibrationFunctionMap(self) -> java.util.Map[cern.lsa.domain.optics.CalibrationFunctionTypes, cern.accsoft.commons.value.ImmutableDiscreteFunction]: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getFidelModelId(self) -> int: ...
    def setCreationDate(self, date: java.util.Date) -> None: ...
    def setFidelModelId(self, long: int) -> None: ...

class ChromaticModelImpl(cern.accsoft.commons.util.AbstractNamedSerializable[cern.lsa.domain.optics.ChromaticModel], cern.lsa.domain.optics.ChromaticModel):
    def __init__(self): ...
    def getAlphaH(self) -> float: ...
    def getAlphaV(self) -> float: ...
    def getBetaH(self) -> float: ...
    def getBetaV(self) -> float: ...
    def getBsedd(self) -> float: ...
    def getBsrem(self) -> float: ...
    def getChcon(self) -> float: ...
    def getChedd(self) -> float: ...
    def getChrem(self) -> float: ...
    def getCvcon(self) -> float: ...
    def getCvedd(self) -> float: ...
    def getCvrem(self) -> float: ...
    def getGammaH(self) -> float: ...
    def getGammaV(self) -> float: ...
    def getLatticeChromaH(self) -> float: ...
    def getLatticeChromaV(self) -> float: ...
    def setAlphaH(self, double: float) -> None: ...
    def setAlphaV(self, double: float) -> None: ...
    def setBetaH(self, double: float) -> None: ...
    def setBetaV(self, double: float) -> None: ...
    def setBsedd(self, double: float) -> None: ...
    def setBsrem(self, double: float) -> None: ...
    def setChcon(self, double: float) -> None: ...
    def setChedd(self, double: float) -> None: ...
    def setChrem(self, double: float) -> None: ...
    def setCvcon(self, double: float) -> None: ...
    def setCvedd(self, double: float) -> None: ...
    def setCvrem(self, double: float) -> None: ...
    def setGammaH(self, double: float) -> None: ...
    def setGammaV(self, double: float) -> None: ...
    def setLatticeChromaH(self, double: float) -> None: ...
    def setLatticeChromaV(self, double: float) -> None: ...

class ElementImpl(cern.lsa.domain.commons.spi.AbstractIdentifiedNamedEntity[cern.lsa.domain.optics.Element], cern.lsa.domain.optics.Element):
    def __init__(self): ...
    def addLogicalHwName(self, string: str) -> None: ...
    def getAcceleratorZone(self) -> cern.accsoft.commons.domain.zones.AcceleratorZone: ...
    def getAffectedRings(self) -> java.util.Set[cern.lsa.domain.optics.BeamEnum]: ...
    def getLength(self) -> float: ...
    def getLogicalHwName(self) -> str: ...
    def getLogicalHwNames(self) -> java.util.Set[str]: ...
    def getMadParent(self) -> str: ...
    def getPlane(self) -> cern.lsa.domain.optics.ElementPlane: ...
    def getPosition(self) -> float: ...
    def getSteeringPlane(self) -> cern.lsa.domain.optics.ElementPlane: ...
    def getType(self) -> cern.lsa.domain.optics.ElementType: ...
    def isObsolete(self) -> bool: ...
    def setAcceleratorZone(self, acceleratorZone: cern.accsoft.commons.domain.zones.AcceleratorZone) -> None: ...
    def setAffectedRings(self, set: java.util.Set[cern.lsa.domain.optics.BeamEnum]) -> None: ...
    def setLength(self, double: float) -> None: ...
    def setMadParent(self, string: str) -> None: ...
    def setObsolete(self, boolean: bool) -> None: ...
    def setPlane(self, elementPlane: cern.lsa.domain.optics.ElementPlane) -> None: ...
    def setPosition(self, double: float) -> None: ...
    def setSteeringPlane(self, elementPlane: cern.lsa.domain.optics.ElementPlane) -> None: ...
    def setType(self, elementType: cern.lsa.domain.optics.ElementType) -> None: ...
    def toString(self) -> str: ...

class ElementsRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.optics.ElementsRequest):
    ACCELERATOR_ZONE: _py_ClassVar[str] = ...
    PARTICLE_TRANSFER: _py_ClassVar[str] = ...
    ELEMENT_NAMES: _py_ClassVar[str] = ...
    LOGICAL_HW_NAMES: _py_ClassVar[str] = ...
    TYPES: _py_ClassVar[str] = ...
    STEERING: _py_ClassVar[str] = ...
    EXCLUDE_OBSOLETE: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any]): ...
    def excludeObsolete(self) -> bool: ...
    def getAcceleratorZone(self) -> cern.accsoft.commons.domain.zones.AcceleratorZone: ...
    def getElementNames(self) -> java.util.Set[str]: ...
    def getLogicalHwNames(self) -> java.util.Set[str]: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...
    def getSteering(self) -> bool: ...
    def getTypes(self) -> java.util.Set[cern.lsa.domain.optics.ElementType]: ...

class LogicalHardwareImpl(cern.lsa.domain.devices.spi.DeviceImpl, cern.lsa.domain.optics.LogicalHardware):
    @overload
    def __init__(self, device: cern.lsa.domain.devices.Device): ...
    @overload
    def __init__(self, logicalHardware: cern.lsa.domain.optics.LogicalHardware): ...
    @overload
    def __init__(self, long: int, string: str): ...
    def getCalibrationName(self) -> str: ...
    def getCalibrationSign(self) -> int: ...
    def getLinkRuleName(self) -> str: ...
    def getLtot(self) -> float: ...
    def getMadStrengthName(self) -> str: ...
    def getMadStrengthType(self) -> str: ...
    def getMagnetType(self) -> str: ...
    def getMagneticLength(self) -> float: ...
    def getOpTemp(self) -> float: ...
    def getPlane(self) -> cern.lsa.domain.optics.ElementPlane: ...
    def getRtot(self) -> float: ...
    def getRtotMeasured(self) -> float: ...
    def getTau(self) -> float: ...
    def setCalibrationName(self, string: str) -> None: ...
    def setCalibrationSign(self, int: int) -> None: ...
    def setLinkRuleName(self, string: str) -> None: ...
    def setLtot(self, double: float) -> None: ...
    def setMadStrengthName(self, string: str) -> None: ...
    def setMadStrengthType(self, string: str) -> None: ...
    def setMagnetType(self, string: str) -> None: ...
    def setMagneticLength(self, double: float) -> None: ...
    def setOpTemp(self, double: float) -> None: ...
    def setPlane(self, elementPlane: cern.lsa.domain.optics.ElementPlane) -> None: ...
    def setRtot(self, double: float) -> None: ...
    def setRtotMeasured(self, double: float) -> None: ...
    def setTau(self, double: float) -> None: ...

class MeasuredTwissImpl(cern.lsa.domain.optics.MeasuredTwiss, java.io.Serializable):
    def __init__(self, twiss: cern.lsa.domain.optics.Twiss, double: float, date: java.util.Date, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float, double8: float, double9: float, double10: float, double11: float, double12: float, double13: float, double14: float, double15: float, double16: float, double17: float): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAlfxError(self) -> float: ...
    def getAlfxMeas(self) -> float: ...
    def getAlfyError(self) -> float: ...
    def getAlfyMeas(self) -> float: ...
    def getBetxError(self) -> float: ...
    def getBetxMeas(self) -> float: ...
    def getBetyError(self) -> float: ...
    def getBetyMeas(self) -> float: ...
    def getDxError(self) -> float: ...
    def getDxMeas(self) -> float: ...
    def getDyError(self) -> float: ...
    def getDyMeas(self) -> float: ...
    def getEnergy(self) -> float: ...
    def getMuxError(self) -> float: ...
    def getMuxMeas(self) -> float: ...
    def getMuyError(self) -> float: ...
    def getMuyMeas(self) -> float: ...
    def getTimestamp(self) -> java.util.Date: ...
    def getTwiss(self) -> cern.lsa.domain.optics.Twiss: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class OpticImpl(cern.lsa.domain.commons.spi.AbstractIdentifiedNamedEntity[cern.lsa.domain.optics.Optic], cern.lsa.domain.optics.Optic):
    def __init__(self): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getBaseStrengthFile(self) -> str: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getDescription(self) -> str: ...
    def getGeometry(self) -> str: ...
    def getOpticParameters(self) -> java.util.Map[str, float]: ...
    def getOpticStrengths(self) -> java.util.List[cern.lsa.domain.optics.OpticStrength]: ...
    def getOverrideStrengthFile(self) -> str: ...
    def getParameterNames(self) -> java.util.Set[str]: ...
    def getParameterValue(self, string: str) -> float: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...
    def getProgramVersion(self) -> str: ...
    def getTitle(self) -> str: ...
    def hashCode(self) -> int: ...
    def setBaseStrengthFile(self, string: str) -> None: ...
    def setCreationDate(self, date: java.util.Date) -> None: ...
    def setDescription(self, string: str) -> None: ...
    def setGeometry(self, string: str) -> None: ...
    def setOpticParameters(self, map: java.util.Map[str, float]) -> None: ...
    def setOpticStrengths(self, list: java.util.List[cern.lsa.domain.optics.OpticStrength]) -> None: ...
    def setOverrideStrengthFile(self, string: str) -> None: ...
    def setParticleTransfer(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> None: ...
    def setProgramVersion(self, string: str) -> None: ...
    def setTitle(self, string: str) -> None: ...

class OpticStrengthImpl(cern.lsa.domain.optics.OpticStrength, java.io.Serializable):
    def __init__(self): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getBeam(self) -> str: ...
    def getLogicalHardwareName(self) -> str: ...
    def getStrength(self) -> float: ...
    def getStrengthL(self) -> float: ...
    def hashCode(self) -> int: ...
    def setBeam(self, string: str) -> None: ...
    def setLogicalHWName(self, string: str) -> None: ...
    def setStrength(self, double: float) -> None: ...
    def setStrengthL(self, double: float) -> None: ...

class OpticsRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.optics.OpticsRequest):
    ACCELERATOR: _py_ClassVar[str] = ...
    PARTICLE_TRANSFER: _py_ClassVar[str] = ...
    BEAM_RPOCESS_TYPE_NAMES: _py_ClassVar[str] = ...
    OPTIC_IDS: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any]): ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getBeamProcessTypeNames(self) -> java.util.Set[str]: ...
    def getOpticIds(self) -> java.util.Set[int]: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...

class OpticsTableImpl(cern.lsa.domain.optics.OpticsTable, java.io.Serializable):
    @overload
    def __init__(self, opticsTable: cern.lsa.domain.optics.OpticsTable, list: java.util.List[cern.lsa.domain.optics.OpticsTableItem]): ...
    @overload
    def __init__(self, beamProcessType: cern.lsa.domain.settings.type.BeamProcessType, list: java.util.List[cern.lsa.domain.optics.OpticsTableItem]): ...
    @overload
    def __init__(self, string: str, int: int, list: java.util.List[cern.lsa.domain.optics.OpticsTableItem]): ...
    def getBeamProcessTypeName(self) -> str: ...
    def getErrorMessages(self) -> java.util.Set[str]: ...
    def getLength(self) -> int: ...
    def getOpticNames(self) -> java.util.List[str]: ...
    def getOpticsTableItemByIndex(self, int: int) -> cern.lsa.domain.optics.OpticsTableItem: ...
    def getOpticsTableItemByTime(self, double: float) -> cern.lsa.domain.optics.OpticsTableItem: ...
    def getOpticsTableItems(self) -> java.util.List[cern.lsa.domain.optics.OpticsTableItem]: ...
    def getSize(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def isValid(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[cern.lsa.domain.optics.OpticsTableItem]: ...

class OpticsTableItemImpl(cern.lsa.domain.optics.OpticsTableItem, java.io.Serializable, java.lang.Cloneable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str, int: int, double: float, string2: str): ...
    @overload
    def __init__(self, string: str, int: int, double: float, long: int, string2: str): ...
    @overload
    def clone(self) -> cern.lsa.domain.optics.OpticsTableItem: ...
    @overload
    def clone(self) -> _py_Any: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getBeamProcessTypeName(self) -> str: ...
    def getEnergy(self) -> float: ...
    def getOpticId(self) -> int: ...
    def getOpticName(self) -> str: ...
    def getTime(self) -> int: ...
    def hashCode(self) -> int: ...
    def setBeamProcessTypeName(self, string: str) -> None: ...
    def setEnergy(self, double: float) -> None: ...
    def setOpticId(self, long: int) -> None: ...
    def setOpticName(self, string: str) -> None: ...
    def setTime(self, int: int) -> None: ...
    def toString(self) -> str: ...

class PowerConverterInfoImpl(cern.lsa.domain.commons.spi.AbstractIdentifiedNamedEntity[cern.lsa.domain.optics.PowerConverterInfo], cern.lsa.domain.optics.PowerConverterInfo):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, powerConverterInfo: cern.lsa.domain.optics.PowerConverterInfo): ...
    @overload
    def __init__(self, long: int, string: str): ...
    def getAccelerationLimit(self) -> float: ...
    def getAdvance(self) -> float: ...
    def getBeam(self) -> str: ...
    def getDecelerationLimit(self) -> float: ...
    def getDidtMax(self) -> float: ...
    def getDidtMin(self) -> float: ...
    def getIMinOp(self) -> float: ...
    def getINom(self) -> float: ...
    def getIPNo(self) -> float: ...
    def getIUlt(self) -> float: ...
    def getLastRefDatabaseUpdate(self) -> java.util.Date: ...
    def getPoweringSubsector(self) -> str: ...
    def isPolaritySwitch(self) -> bool: ...
    def setAccelerationLimit(self, double: float) -> None: ...
    def setAdvance(self, double: float) -> None: ...
    def setBeam(self, string: str) -> None: ...
    def setDecelerationLimit(self, double: float) -> None: ...
    def setDidtMax(self, double: float) -> None: ...
    def setDidtMin(self, double: float) -> None: ...
    def setIMinOp(self, double: float) -> None: ...
    def setINom(self, double: float) -> None: ...
    def setIPNo(self, double: float) -> None: ...
    def setIUlt(self, double: float) -> None: ...
    def setLastRefDatabaseUpdate(self, date: java.util.Date) -> None: ...
    def setPolaritySwitch(self, boolean: bool) -> None: ...
    def setPoweringSubsector(self, string: str) -> None: ...
    def toString(self) -> str: ...

class PreCyclingPrescriptionImpl(cern.lsa.domain.optics.PreCyclingPrescription):
    def __init__(self, string: str): ...
    def addAttribute(self, string: str, double: float) -> None: ...
    def getAttributeValue(self, string: str) -> float: ...
    def getMagnetType(self) -> str: ...
    def getPrecyclingPrescriptionMode(self) -> str: ...
    def getPrecyclingPrescriptionName(self) -> str: ...
    def getPrecyclingPrescriptionType(self) -> str: ...
    def setMagnetType(self, string: str) -> None: ...
    def setPrecyclingPrescriptionMode(self, string: str) -> None: ...
    def setPrecyclingPrescriptionName(self, string: str) -> None: ...
    def setPrecyclingPrescriptionType(self, string: str) -> None: ...

class RFCalibrationImpl(cern.accsoft.commons.util.AbstractNamedSerializable[cern.lsa.domain.optics.RFCalibration], cern.lsa.domain.optics.RFCalibration):
    def __init__(self): ...
    def getCavityQ(self, double: float) -> float: ...
    def getCavityQ2CouplerPosFunction(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getCouplerPos(self, double: float) -> float: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getDeviceName(self) -> str: ...
    def setCreationDate(self, date: java.util.Date) -> None: ...
    def setDeviceName(self, string: str) -> None: ...
    def setRFCalibrationFunction(self, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> None: ...

class TwissImpl(cern.lsa.domain.optics.Twiss, java.io.Serializable):
    def __init__(self): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAlfx(self) -> float: ...
    def getAlfy(self) -> float: ...
    def getBeam(self) -> cern.accsoft.commons.domain.beams.Beam: ...
    def getBetx(self) -> float: ...
    def getBety(self) -> float: ...
    def getDpx(self) -> float: ...
    def getDpy(self) -> float: ...
    def getDx(self) -> float: ...
    def getDy(self) -> float: ...
    def getElement(self) -> cern.lsa.domain.optics.ElementBase: ...
    def getK0l(self) -> float: ...
    def getK1Sl(self) -> float: ...
    def getK1l(self) -> float: ...
    def getK2Sl(self) -> float: ...
    def getK2l(self) -> float: ...
    def getK3Sl(self) -> float: ...
    def getK3l(self) -> float: ...
    def getK4l(self) -> float: ...
    def getK5l(self) -> float: ...
    def getMux(self) -> float: ...
    def getMuy(self) -> float: ...
    def getOpticName(self) -> str: ...
    def getPx(self) -> float: ...
    def getPy(self) -> float: ...
    def getX(self) -> float: ...
    def getY(self) -> float: ...
    def hashCode(self) -> int: ...
    def setAlfx(self, double: float) -> None: ...
    def setAlfy(self, double: float) -> None: ...
    def setBeam(self, beam: cern.accsoft.commons.domain.beams.Beam) -> None: ...
    def setBetx(self, double: float) -> None: ...
    def setBety(self, double: float) -> None: ...
    def setDpx(self, double: float) -> None: ...
    def setDpy(self, double: float) -> None: ...
    def setDx(self, double: float) -> None: ...
    def setDy(self, double: float) -> None: ...
    def setElement(self, elementBase: cern.lsa.domain.optics.ElementBase) -> None: ...
    def setK0l(self, double: float) -> None: ...
    def setK1l(self, double: float) -> None: ...
    def setK1sl(self, double: float) -> None: ...
    def setK2l(self, double: float) -> None: ...
    def setK2sl(self, double: float) -> None: ...
    def setK3l(self, double: float) -> None: ...
    def setK3sl(self, double: float) -> None: ...
    def setK4l(self, double: float) -> None: ...
    def setK5l(self, double: float) -> None: ...
    def setMux(self, double: float) -> None: ...
    def setMuy(self, double: float) -> None: ...
    def setOpticName(self, string: str) -> None: ...
    def setPx(self, double: float) -> None: ...
    def setPy(self, double: float) -> None: ...
    def setX(self, double: float) -> None: ...
    def setY(self, double: float) -> None: ...
    def toString(self) -> str: ...
    def updateOpticName(self, string: str) -> None: ...

class TwissesRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.optics.TwissesRequest):
    OPTIC_NAME: _py_ClassVar[str] = ...
    BEAM: _py_ClassVar[str] = ...
    ELEMENT_NAMES: _py_ClassVar[str] = ...
    ELEMENT_TYPES: _py_ClassVar[str] = ...
    ELEMENT_POSITION_RANGE: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any]): ...
    def getBeam(self) -> cern.accsoft.commons.domain.beams.Beam: ...
    def getElementNames(self) -> java.util.Set[str]: ...
    def getElementPositionRange(self) -> com.google.common.collect.Range[float]: ...
    def getElementTypes(self) -> java.util.Set[cern.lsa.domain.optics.ElementType]: ...
    def getOpticName(self) -> str: ...
