from typing import ClassVar as _py_ClassVar
import cern.accsoft.commons.domain
import cern.accsoft.commons.domain.particletransfers
import cern.accsoft.commons.domain.zones
import cern.lsa.domain.devices
import java.util


class DeviceGroupsRequestBuilder:
    def __init__(self): ...
    def build(self) -> cern.lsa.domain.devices.DeviceGroupsRequest: ...
    @classmethod
    def byAccelerator(cls, accelerator: cern.accsoft.commons.domain.Accelerator) -> cern.lsa.domain.devices.DeviceGroupsRequest: ...
    @classmethod
    def byDeviceGroupNamePattern(cls, string: str) -> cern.lsa.domain.devices.DeviceGroupsRequest: ...
    @classmethod
    def byDeviceGroupNames(cls, collection: java.util.Collection[str]) -> cern.lsa.domain.devices.DeviceGroupsRequest: ...
    @classmethod
    def byDeviceGroupType(cls, deviceGroupType: cern.lsa.domain.devices.DeviceGroupType) -> cern.lsa.domain.devices.DeviceGroupsRequest: ...
    @classmethod
    def byDeviceGroupTypes(cls, collection: java.util.Collection[cern.lsa.domain.devices.DeviceGroupType]) -> cern.lsa.domain.devices.DeviceGroupsRequest: ...
    def setAccelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DeviceGroupsRequestBuilder': ...
    def setDeviceGroupName(self, string: str) -> 'DeviceGroupsRequestBuilder': ...
    def setDeviceGroupNamePattern(self, string: str) -> 'DeviceGroupsRequestBuilder': ...
    def setDeviceGroupNames(self, collection: java.util.Collection[str]) -> 'DeviceGroupsRequestBuilder': ...
    def setDeviceGroupType(self, deviceGroupType: cern.lsa.domain.devices.DeviceGroupType) -> 'DeviceGroupsRequestBuilder': ...
    def setDeviceGroupTypes(self, collection: java.util.Collection[cern.lsa.domain.devices.DeviceGroupType]) -> 'DeviceGroupsRequestBuilder': ...

class DeviceTypesRequestBuilder:
    ALL_DEVICE_TYPES: _py_ClassVar[cern.lsa.domain.devices.DeviceTypesRequest] = ...
    def __init__(self): ...
    def build(self) -> cern.lsa.domain.devices.DeviceTypesRequest: ...
    @classmethod
    def byAccelerator(cls, accelerator: cern.accsoft.commons.domain.Accelerator) -> cern.lsa.domain.devices.DeviceTypesRequest: ...
    @classmethod
    def byDeviceTypeNameImplementation(cls, collection: java.util.Collection[cern.lsa.domain.devices.DeviceTypeImplementation]) -> cern.lsa.domain.devices.DeviceTypesRequest: ...
    @classmethod
    def byDeviceTypeNamePattern(cls, string: str) -> cern.lsa.domain.devices.DeviceTypesRequest: ...
    @classmethod
    def byDeviceTypeNames(cls, collection: java.util.Collection[str]) -> cern.lsa.domain.devices.DeviceTypesRequest: ...
    def setAccelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DeviceTypesRequestBuilder': ...
    def setDeviceTypeImplementation(self, collection: java.util.Collection[cern.lsa.domain.devices.DeviceTypeImplementation]) -> 'DeviceTypesRequestBuilder': ...
    def setDeviceTypeNamePattern(self, string: str) -> 'DeviceTypesRequestBuilder': ...
    def setDeviceTypeNames(self, collection: java.util.Collection[str]) -> 'DeviceTypesRequestBuilder': ...
    def setDeviceTypeVersionNumber(self, deviceTypeVersionNumber: cern.lsa.domain.devices.DeviceTypeVersionNumber) -> 'DeviceTypesRequestBuilder': ...

class DevicesRequestBuilder:
    def __init__(self): ...
    def build(self) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byAccelerator(cls, accelerator: cern.accsoft.commons.domain.Accelerator) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byAcceleratorZone(cls, acceleratorZone: cern.accsoft.commons.domain.zones.AcceleratorZone) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byAcceleratorZones(cls, collection: java.util.Collection[cern.accsoft.commons.domain.zones.AcceleratorZone]) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byDeviceAliases(cls, collection: java.util.Collection[str]) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byDeviceGroup(cls, deviceGroup: cern.lsa.domain.devices.DeviceGroup) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byDeviceGroupName(cls, string: str) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byDeviceGroupNames(cls, collection: java.util.Collection[str]) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byDeviceGroups(cls, collection: java.util.Collection[cern.lsa.domain.devices.DeviceGroup]) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byDeviceName(cls, string: str) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byDeviceNamePattern(cls, string: str) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byDeviceNames(cls, collection: java.util.Collection[str]) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byDeviceTypeName(cls, string: str) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byDeviceTypeNames(cls, collection: java.util.Collection[str]) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byDeviceTypeVersion(cls, deviceTypeVersion: cern.lsa.domain.devices.DeviceTypeVersion) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byDeviceTypeVersions(cls, collection: java.util.Collection[cern.lsa.domain.devices.DeviceTypeVersion]) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byElementName(cls, string: str) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byFecName(cls, string: str) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byFecNames(cls, collection: java.util.Collection[str]) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byParticleTransfer(cls, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> cern.lsa.domain.devices.DevicesRequest: ...
    @classmethod
    def byParticleTransfers(cls, collection: java.util.Collection[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]) -> cern.lsa.domain.devices.DevicesRequest: ...
    def setAccelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DevicesRequestBuilder': ...
    def setAcceleratorZone(self, acceleratorZone: cern.accsoft.commons.domain.zones.AcceleratorZone) -> 'DevicesRequestBuilder': ...
    def setAcceleratorZones(self, collection: java.util.Collection[cern.accsoft.commons.domain.zones.AcceleratorZone]) -> 'DevicesRequestBuilder': ...
    def setDeviceAliases(self, collection: java.util.Collection[str]) -> 'DevicesRequestBuilder': ...
    def setDeviceGroup(self, deviceGroup: cern.lsa.domain.devices.DeviceGroup) -> 'DevicesRequestBuilder': ...
    def setDeviceGroupName(self, string: str) -> 'DevicesRequestBuilder': ...
    def setDeviceGroupNames(self, collection: java.util.Collection[str]) -> 'DevicesRequestBuilder': ...
    def setDeviceGroups(self, collection: java.util.Collection[cern.lsa.domain.devices.DeviceGroup]) -> 'DevicesRequestBuilder': ...
    def setDeviceName(self, string: str) -> 'DevicesRequestBuilder': ...
    def setDeviceNamePattern(self, string: str) -> 'DevicesRequestBuilder': ...
    def setDeviceNames(self, collection: java.util.Collection[str]) -> 'DevicesRequestBuilder': ...
    def setDeviceTypeName(self, string: str) -> 'DevicesRequestBuilder': ...
    def setDeviceTypeNamePattern(self, string: str) -> 'DevicesRequestBuilder': ...
    def setDeviceTypeNames(self, collection: java.util.Collection[str]) -> 'DevicesRequestBuilder': ...
    def setDeviceTypeVersion(self, deviceTypeVersion: cern.lsa.domain.devices.DeviceTypeVersion) -> 'DevicesRequestBuilder': ...
    def setDeviceTypeVersions(self, collection: java.util.Collection[cern.lsa.domain.devices.DeviceTypeVersion]) -> 'DevicesRequestBuilder': ...
    def setElementName(self, string: str) -> 'DevicesRequestBuilder': ...
    def setExistInLsaOnly(self, boolean: bool) -> 'DevicesRequestBuilder': ...
    def setFecName(self, string: str) -> 'DevicesRequestBuilder': ...
    def setFecNames(self, collection: java.util.Collection[str]) -> 'DevicesRequestBuilder': ...
    def setMetaType(self, deviceMetaTypeEnum: cern.lsa.domain.devices.DeviceMetaTypeEnum) -> 'DevicesRequestBuilder': ...
    def setMultiplexed(self, boolean: bool) -> 'DevicesRequestBuilder': ...
    def setParticleTransfer(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> 'DevicesRequestBuilder': ...
    def setParticleTransfers(self, collection: java.util.Collection[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]) -> 'DevicesRequestBuilder': ...
