from typing import Any as _py_Any
from typing import TypeVar as _py_TypeVar
from typing import Generic as _py_Generic
from typing import overload
import cern.accsoft.commons.util
import cern.accsoft.commons.value
import cern.lsa.domain.commons
import java.io
import java.lang
import java.util


_AbstractIdentifiedEntity__I = _py_TypeVar('_AbstractIdentifiedEntity__I', bound=cern.lsa.domain.commons.IdentifiedEntity)  # <I>
class AbstractIdentifiedEntity(cern.lsa.domain.commons.IdentifiedEntity, java.io.Serializable, java.lang.Comparable[_AbstractIdentifiedEntity__I], _py_Generic[_AbstractIdentifiedEntity__I]):
    @overload
    def compareTo(self, i: _AbstractIdentifiedEntity__I) -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getId(self) -> int: ...
    def hashCode(self) -> int: ...
    def setId(self, long: int) -> None: ...

_AbstractIdentifiedNamedEntity__E = _py_TypeVar('_AbstractIdentifiedNamedEntity__E', bound=cern.accsoft.commons.util.Named)  # <E>
class AbstractIdentifiedNamedEntity(cern.accsoft.commons.util.AbstractNamedSerializable[_AbstractIdentifiedNamedEntity__E], cern.lsa.domain.commons.IdentifiedEntity, _py_Generic[_AbstractIdentifiedNamedEntity__E]):
    def equals(self, object: _py_Any) -> bool: ...
    def getId(self) -> int: ...
    def hashCode(self) -> int: ...
    def setId(self, long: int) -> None: ...

_AbstractImmutableIdentifiedEntity__I = _py_TypeVar('_AbstractImmutableIdentifiedEntity__I', bound=cern.lsa.domain.commons.IdentifiedEntity)  # <I>
class AbstractImmutableIdentifiedEntity(cern.lsa.domain.commons.IdentifiedEntity, java.io.Serializable, java.lang.Comparable[_AbstractImmutableIdentifiedEntity__I], _py_Generic[_AbstractImmutableIdentifiedEntity__I]):
    @overload
    def compareTo(self, i: _AbstractImmutableIdentifiedEntity__I) -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getId(self) -> int: ...
    def hashCode(self) -> int: ...

_AbstractImmutableIdentifiedNamedEntity__E = _py_TypeVar('_AbstractImmutableIdentifiedNamedEntity__E', bound=cern.accsoft.commons.util.Named)  # <E>
class AbstractImmutableIdentifiedNamedEntity(cern.accsoft.commons.util.AbstractImmutableNamedSerializable[_AbstractImmutableIdentifiedNamedEntity__E], cern.lsa.domain.commons.IdentifiedEntity, _py_Generic[_AbstractImmutableIdentifiedNamedEntity__E]):
    def equals(self, object: _py_Any) -> bool: ...
    def getId(self) -> int: ...
    def hashCode(self) -> int: ...

class AbstractPropertiesHolder(java.io.Serializable):
    def equals(self, object: _py_Any) -> bool: ...
    def getProperties(self) -> java.util.Map[str, _py_Any]: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class AttributeImpl(cern.accsoft.commons.util.AbstractNamedSerializable[cern.lsa.domain.commons.Attribute], cern.lsa.domain.commons.Attribute):
    @overload
    def __init__(self, attribute: cern.lsa.domain.commons.Attribute): ...
    @overload
    def __init__(self, attributeDefinition: cern.lsa.domain.commons.AttributeDefinition, string: str): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAttributeDefinition(self) -> cern.lsa.domain.commons.AttributeDefinition: ...
    def getBoolean(self) -> bool: ...
    def getDouble(self) -> float: ...
    def getInt(self) -> int: ...
    def getLong(self) -> int: ...
    def getName(self) -> str: ...
    def getValue(self) -> str: ...
    def hashCode(self) -> int: ...
    @overload
    def setValue(self, boolean: bool) -> None: ...
    @overload
    def setValue(self, double: float) -> None: ...
    @overload
    def setValue(self, int: int) -> None: ...
    @overload
    def setValue(self, string: str) -> None: ...
    @overload
    def setValue(self, long: int) -> None: ...
    def toString(self) -> str: ...

class AttributeDefinitionImpl(AbstractIdentifiedNamedEntity[cern.lsa.domain.commons.AttributeDefinition], cern.lsa.domain.commons.AttributeDefinition):
    @overload
    def __init__(self, attributeDefinition: cern.lsa.domain.commons.AttributeDefinition): ...
    @overload
    def __init__(self, long: int, string: str, string2: str, string3: str, type: cern.accsoft.commons.value.Type, set: java.util.Set[str], string4: str): ...
    def getDefaultValue(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEnumValues(self) -> java.util.Set[str]: ...
    def getUnits(self) -> str: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
    def toString(self) -> str: ...
