from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.lsa.domain.cern.settings.ad
import cern.lsa.domain.cern.timing
import cern.lsa.domain.commons.spi
import java.io
import java.lang
import java.util


class ADCycleSerializer:
    def __init__(self): ...
    def marshal(self, adCycleStructure: cern.lsa.domain.cern.settings.ad.AdCycleStructure) -> str: ...
    def unmarshal(self, string: str) -> 'AdCycleStructureImpl': ...

class AbstractAdCycleSegment(cern.lsa.domain.cern.settings.ad.AdCycleSegment, java.io.Serializable):
    def addTimingProcess(self, timingProcess: cern.lsa.domain.cern.timing.TimingProcess, int: int, timingProcessAnchor: cern.lsa.domain.cern.timing.TimingProcessAnchor) -> None: ...
    def getAttribute(self, string: str) -> str: ...
    def getAttributeNames(self) -> java.util.Set[str]: ...
    def getAttributes(self) -> java.util.Set['AbstractAdCycleSegment.Attribute']: ...
    def getInitialMomentum(self) -> int: ...
    def getLength(self) -> int: ...
    def getName(self) -> str: ...
    def getScheduledTimingProcesses(self) -> java.util.Set[cern.lsa.domain.cern.timing.TimingProcessScheduling]: ...
    def getStartTime(self) -> int: ...
    def getType(self) -> cern.lsa.domain.cern.settings.ad.SegmentType: ...
    def isFirstSegmentInCycle(self) -> bool: ...
    def nextSegment(self) -> cern.lsa.domain.cern.settings.ad.AdCycleSegment: ...
    def previousSegment(self) -> cern.lsa.domain.cern.settings.ad.AdCycleSegment: ...
    def removeAttribute(self, string: str) -> None: ...
    def removeTimingProcess(self, timingProcess: cern.lsa.domain.cern.timing.TimingProcess) -> None: ...
    def setAttribute(self, string: str, string2: str) -> None: ...
    def setAttributes(self, set: java.util.Set['AbstractAdCycleSegment.Attribute']) -> None: ...
    def setLength(self, int: int) -> None: ...
    def setName(self, string: str) -> None: ...
    class Attribute: ...

class AdCycleStructureImpl(cern.lsa.domain.commons.spi.AbstractIdentifiedEntity['AdCycleStructureImpl'], cern.lsa.domain.cern.settings.ad.AdCycleStructure, java.io.Serializable):
    PARAMETER_CYCLE: _py_ClassVar[str] = ...
    PARAMETER_CYCLE_TEST: _py_ClassVar[str] = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, list: java.util.List[cern.lsa.domain.cern.settings.ad.AdCycleSegment]): ...
    @classmethod
    def getCycleParameterName(cls, boolean: bool) -> str: ...
    def getId(self) -> int: ...
    def getLength(self) -> int: ...
    def getSegment(self, int: int) -> cern.lsa.domain.cern.settings.ad.AdCycleSegment: ...
    def getSegments(self) -> java.util.List[cern.lsa.domain.cern.settings.ad.AdCycleSegment]: ...
    def getSegmentsCount(self) -> int: ...
    def getVersion(self) -> int: ...
    def insertFlatSegment(self, rampSegment: cern.lsa.domain.cern.settings.ad.RampSegment, int: int) -> cern.lsa.domain.cern.settings.ad.FlatSegment: ...
    def isTestCycle(self) -> bool: ...
    def removeFlatSegment(self, flatSegment: cern.lsa.domain.cern.settings.ad.FlatSegment) -> None: ...
    def setSegments(self, list: java.util.List[cern.lsa.domain.cern.settings.ad.AdCycleSegment]) -> None: ...
    def setTestCycle(self, boolean: bool) -> None: ...
    def setVersion(self, int: int) -> None: ...

class SettingsUpdateState(java.lang.Enum['SettingsUpdateState']):
    CURRENT_SETTINGS: _py_ClassVar['SettingsUpdateState'] = ...
    UPDATED_SETTINGS: _py_ClassVar['SettingsUpdateState'] = ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'SettingsUpdateState': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['SettingsUpdateState']: ...

class FlatSegmentImpl(AbstractAdCycleSegment, cern.lsa.domain.cern.settings.ad.FlatSegment):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str, int: int): ...
    def getEndMomentum(self) -> int: ...
    def getNumberOfExtractions(self) -> int: ...
    def getNumberOfInjections(self) -> int: ...
    def getPauseLocation(self) -> cern.lsa.domain.cern.settings.ad.PauseLocation: ...
    def getStartTime(self) -> int: ...
    def setNumberOfExtractions(self, int: int) -> None: ...
    def setNumberOfInjections(self, int: int) -> None: ...
    def setPauseLocation(self, pauseLocation: cern.lsa.domain.cern.settings.ad.PauseLocation) -> None: ...
    def toString(self) -> str: ...

class RampSegmentImpl(AbstractAdCycleSegment, cern.lsa.domain.cern.settings.ad.RampSegment):
    def __init__(self, int: int): ...
    def getEndMomentum(self) -> int: ...
    def getFlatPartLength(self) -> int: ...
    def getRoundPartLength(self) -> int: ...
    def setEndMomentum(self, int: int) -> None: ...
    def setFlatPartLength(self, int: int) -> None: ...
    def setRoundPartLength(self, int: int) -> None: ...
    def toString(self) -> str: ...
