from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.util
import cern.lsa.domain.commons
import cern.lsa.domain.optics
import java.lang
import java.util


class OfbMonitorReading:
    def getHorizontal(self) -> float: ...
    def getMonitorName(self) -> str: ...
    def getPosition(self) -> float: ...
    def getVertical(self) -> float: ...
    def isHorizontalValid(self) -> bool: ...
    def isVerticalValid(self) -> bool: ...
    def setHorizontal(self, double: float) -> None: ...
    def setHorizontalValid(self, boolean: bool) -> None: ...
    def setVertical(self, double: float) -> None: ...
    def setVerticalValid(self, boolean: bool) -> None: ...

class OfbOpticsTableItem(cern.lsa.domain.optics.OpticsTableItem):
    def getOfbOrbit(self) -> 'OfbOrbit': ...
    def isUsedByOfb(self) -> bool: ...

class OfbOrbit(cern.accsoft.commons.util.Named, cern.lsa.domain.commons.IdentifiedEntity):
    def addKnobOverlay(self, ofbKnobOverlay: 'OfbKnobOverlay') -> None: ...
    def addStaticOverlay(self, ofbStaticOverlay: 'OfbStaticOverlay') -> None: ...
    def getBaseReadingSet(self) -> 'OfbReadingSet': ...
    def getCreateTime(self) -> java.util.Date: ...
    def getKnobOverlays(self) -> java.util.Set['OfbKnobOverlay']: ...
    def getStaticOverlay(self, ofbReadingSet: 'OfbReadingSet') -> 'OfbStaticOverlay': ...
    def getStaticOverlays(self) -> java.util.Set['OfbStaticOverlay']: ...
    def removeKnobOverlay(self, ofbKnobOverlay: 'OfbKnobOverlay') -> None: ...
    def removeStaticOverlay(self, ofbStaticOverlay: 'OfbStaticOverlay') -> None: ...
    def setBaseReadingSet(self, ofbReadingSet: 'OfbReadingSet') -> None: ...
    def setName(self, string: str) -> None: ...

class OfbOverlay: ...

class OfbReadingSet(cern.accsoft.commons.util.Named, cern.lsa.domain.commons.IdentifiedEntity):
    def addReading(self, ofbMonitorReading: OfbMonitorReading) -> None: ...
    def getAllReadings(self) -> java.util.SortedSet[OfbMonitorReading]: ...
    def getReading(self, string: str) -> OfbMonitorReading: ...
    def getType(self) -> 'OfbReadingSetType': ...
    def setName(self, string: str) -> None: ...
    def setType(self, ofbReadingSetType: 'OfbReadingSetType') -> None: ...

class OfbReadingSetType(java.lang.Enum['OfbReadingSetType']):
    BASE_ORBIT: _py_ClassVar['OfbReadingSetType'] = ...
    SEPARATION_BUMP_IR1: _py_ClassVar['OfbReadingSetType'] = ...
    SEPARATION_BUMP_IR2: _py_ClassVar['OfbReadingSetType'] = ...
    SEPARATION_BUMP_IR5: _py_ClassVar['OfbReadingSetType'] = ...
    SEPARATION_BUMP_IR8: _py_ClassVar['OfbReadingSetType'] = ...
    CROSSING_ANGLE_IR1: _py_ClassVar['OfbReadingSetType'] = ...
    CROSSING_ANGLE_IR2: _py_ClassVar['OfbReadingSetType'] = ...
    CROSSING_ANGLE_IR5: _py_ClassVar['OfbReadingSetType'] = ...
    CROSSING_ANGLE_IR8: _py_ClassVar['OfbReadingSetType'] = ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'OfbReadingSetType': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['OfbReadingSetType']: ...

class OfbKnobOverlay(OfbOverlay):
    def getKnobId(self) -> int: ...
    def getKnobName(self) -> str: ...

class OfbStaticOverlay(OfbOverlay):
    def getReadingSet(self) -> OfbReadingSet: ...
    def getScaling(self) -> float: ...
