from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.util
import cern.accsoft.commons.value
import cern.lsa.domain.settings
import com.google.common.collect
import java.io
import java.lang
import java.time
import java.util


class BctMarker(cern.accsoft.commons.util.AbstractNamedSerializable['BctMarker']):
    def __init__(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext, string: str, double: float, boolean: bool): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getContext(self) -> cern.lsa.domain.settings.StandAloneContext: ...
    def getName(self) -> str: ...
    def getTime(self) -> float: ...
    def hashCode(self) -> int: ...
    def isEditable(self) -> bool: ...
    def setEditable(self, boolean: bool) -> None: ...
    def setTime(self, double: float) -> None: ...
    def toString(self) -> str: ...

class BctMarkerExistsException(java.lang.RuntimeException):
    def __init__(self, string: str): ...

class FunctionsToReachNewValues:
    @classmethod
    def builder(cls) -> 'DefaultFunctionsToReachNewValues.Builder': ...
    def getFunction(self, parameter: cern.lsa.domain.settings.Parameter) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getFunctions(self) -> java.util.Map[cern.lsa.domain.settings.Parameter, cern.accsoft.commons.value.ImmutableDiscreteFunction]: ...

class SpsRunType(java.lang.Enum['SpsRunType']):
    LHC_PROTONS: _py_ClassVar['SpsRunType'] = ...
    LHC_IONS: _py_ClassVar['SpsRunType'] = ...
    SFT_PROTONS: _py_ClassVar['SpsRunType'] = ...
    SFT_IONS: _py_ClassVar['SpsRunType'] = ...
    MD_PROTONS: _py_ClassVar['SpsRunType'] = ...
    MD_IONS: _py_ClassVar['SpsRunType'] = ...
    UNDEFINED: _py_ClassVar['SpsRunType'] = ...
    ATTRIBUTE_NAME: _py_ClassVar[str] = ...
    def getAttributeValue(self) -> str: ...
    @classmethod
    def getSpsRunTypeForAttributeValue(cls, string: str) -> 'SpsRunType': ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'SpsRunType': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['SpsRunType']: ...

class TimeToReachNewValues:
    def areAllParametersTakenIntoAccount(self) -> bool: ...
    @classmethod
    def builder(cls) -> 'DefaultTimeToReachNewValues.Builder': ...
    def getDuration(self) -> java.util.Optional[java.time.Duration]: ...
    def getIgnoredParameters(self) -> java.util.Map[cern.lsa.domain.settings.Parameter, 'TimeToReachNewValues.NotCalculatedReason']: ...
    class NotCalculatedReason:
        def getMessage(self) -> str: ...

class DefaultFunctionsToReachNewValues(FunctionsToReachNewValues, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultFunctionsToReachNewValues.Builder': ...
    @classmethod
    def copyOf(cls, functionsToReachNewValues: FunctionsToReachNewValues) -> 'DefaultFunctionsToReachNewValues': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getFunctions(self) -> com.google.common.collect.ImmutableMap[cern.lsa.domain.settings.Parameter, cern.accsoft.commons.value.ImmutableDiscreteFunction]: ...
    @overload
    def getFunctions(self) -> java.util.Map: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withFunctions(self, map: java.util.Map[cern.lsa.domain.settings.Parameter, cern.accsoft.commons.value.ImmutableDiscreteFunction]) -> 'DefaultFunctionsToReachNewValues': ...
    class Builder:
        def build(self) -> 'DefaultFunctionsToReachNewValues': ...
        def functions(self, map: java.util.Map[cern.lsa.domain.settings.Parameter, cern.accsoft.commons.value.ImmutableDiscreteFunction]) -> 'DefaultFunctionsToReachNewValues.Builder': ...
        def putAllFunctions(self, map: java.util.Map[cern.lsa.domain.settings.Parameter, cern.accsoft.commons.value.ImmutableDiscreteFunction]) -> 'DefaultFunctionsToReachNewValues.Builder': ...
        @overload
        def putFunction(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> 'DefaultFunctionsToReachNewValues.Builder': ...
        @overload
        def putFunction(self, entry: java.util.Map.Entry[cern.lsa.domain.settings.Parameter, cern.accsoft.commons.value.ImmutableDiscreteFunction]) -> 'DefaultFunctionsToReachNewValues.Builder': ...

class DefaultTimeToReachNewValues(TimeToReachNewValues, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultTimeToReachNewValues.Builder': ...
    @classmethod
    def copyOf(cls, timeToReachNewValues: TimeToReachNewValues) -> 'DefaultTimeToReachNewValues': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDuration(self) -> java.util.Optional[java.time.Duration]: ...
    @overload
    def getIgnoredParameters(self) -> com.google.common.collect.ImmutableMap[cern.lsa.domain.settings.Parameter, TimeToReachNewValues.NotCalculatedReason]: ...
    @overload
    def getIgnoredParameters(self) -> java.util.Map: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def withDuration(self, duration: java.time.Duration) -> 'DefaultTimeToReachNewValues': ...
    @overload
    def withDuration(self, optional: java.util.Optional[java.time.Duration]) -> 'DefaultTimeToReachNewValues': ...
    def withIgnoredParameters(self, map: java.util.Map[cern.lsa.domain.settings.Parameter, TimeToReachNewValues.NotCalculatedReason]) -> 'DefaultTimeToReachNewValues': ...
    class Builder:
        def build(self) -> 'DefaultTimeToReachNewValues': ...
        @overload
        def duration(self, duration: java.time.Duration) -> 'DefaultTimeToReachNewValues.Builder': ...
        @overload
        def duration(self, optional: java.util.Optional[java.time.Duration]) -> 'DefaultTimeToReachNewValues.Builder': ...
        def ignoredParameters(self, map: java.util.Map[cern.lsa.domain.settings.Parameter, TimeToReachNewValues.NotCalculatedReason]) -> 'DefaultTimeToReachNewValues.Builder': ...
        def putAllIgnoredParameters(self, map: java.util.Map[cern.lsa.domain.settings.Parameter, TimeToReachNewValues.NotCalculatedReason]) -> 'DefaultTimeToReachNewValues.Builder': ...
        @overload
        def putIgnoredParameter(self, parameter: cern.lsa.domain.settings.Parameter, notCalculatedReason: TimeToReachNewValues.NotCalculatedReason) -> 'DefaultTimeToReachNewValues.Builder': ...
        @overload
        def putIgnoredParameter(self, entry: java.util.Map.Entry[cern.lsa.domain.settings.Parameter, TimeToReachNewValues.NotCalculatedReason]) -> 'DefaultTimeToReachNewValues.Builder': ...

class DefaultNotCalculatedReason(TimeToReachNewValues.NotCalculatedReason, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultNotCalculatedReason.Builder': ...
    @classmethod
    def copyOf(cls, notCalculatedReason: TimeToReachNewValues.NotCalculatedReason) -> 'DefaultNotCalculatedReason': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getMessage(self) -> str: ...
    def hashCode(self) -> int: ...
    @classmethod
    def of(cls, string: str) -> 'DefaultNotCalculatedReason': ...
    def toString(self) -> str: ...
    def withMessage(self, string: str) -> 'DefaultNotCalculatedReason': ...
    class Builder:
        def build(self) -> 'DefaultNotCalculatedReason': ...
        def message(self, string: str) -> 'DefaultNotCalculatedReason.Builder': ...
