from typing import TypeVar as _py_TypeVar
from typing import Generic as _py_Generic
from typing import overload
import cern.accsoft.commons.domain
import cern.accsoft.commons.util.value
import cern.japc.core
import cern.japc.core.factory
import cern.japc.core.spi.provider
import cern.japc.value
import cern.lsa.client
import cern.lsa.client.reference
import cern.lsa.domain.settings
import java.util


_AbstractMonitor__L = _py_TypeVar('_AbstractMonitor__L')  # <L>
class AbstractMonitor(_py_Generic[_AbstractMonitor__L]): ...

class ContextResolver:
    def __init__(self, parameterService: cern.lsa.client.ParameterService, contextService: cern.lsa.client.ContextService): ...
    def getDrivableContextByUser(self, string: str) -> cern.lsa.domain.settings.DrivableContext: ...
    def getNonMuxDrivableContext(self, set: java.util.Set[str]) -> cern.lsa.domain.settings.DrivableContext: ...
    def getNonMuxDrivableContextForDeviceProperty(self, string: str) -> cern.lsa.domain.settings.DrivableContext: ...

class InternalReferenceController:
    def getReference(self, string: str, drivableContext: cern.lsa.domain.settings.DrivableContext) -> cern.japc.value.SimpleParameterValue: ...
    def getReferences(self, set: java.util.Set[str], drivableContext: cern.lsa.domain.settings.DrivableContext) -> java.util.Map[str, cern.accsoft.commons.util.value.FailSafeValue[cern.japc.value.SimpleParameterValue]]: ...

class LsaMappingChangeDetector: ...

class LsaMappingUpdate:
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...

class LsaMappingUpdateListener:
    def onLsaMappingChanged(self, lsaMappingUpdate: LsaMappingUpdate) -> None: ...

class LsaReferenceUpdate: ...

class LsaReferenceUpdateListener:
    def onReferenceChanged(self, lsaReferenceUpdate: LsaReferenceUpdate) -> None: ...

class ReferenceSubscriptionRegistry: ...

class ReferenceUtils: ...

class LsaMappingMonitor(AbstractMonitor[LsaMappingUpdateListener]): ...

class LsaReferenceMonitor(AbstractMonitor[LsaReferenceUpdateListener], cern.japc.core.ParameterValueListener):
    def exceptionOccured(self, string: str, string2: str, parameterException: cern.japc.core.ParameterException) -> None: ...
    def valueReceived(self, string: str, acquiredParameterValue: cern.japc.core.AcquiredParameterValue) -> None: ...

class ReferenceControllerImpl(cern.lsa.client.reference.ReferenceController, InternalReferenceController):
    def __init__(self): ...
    def addReferenceListener(self, string: str, selector: cern.japc.core.Selector, referenceListener: cern.lsa.client.reference.ReferenceListener) -> None: ...
    @overload
    def getReference(self, string: str, selector: cern.japc.core.Selector) -> cern.japc.value.SimpleParameterValue: ...
    @overload
    def getReference(self, string: str, drivableContext: cern.lsa.domain.settings.DrivableContext) -> cern.japc.value.SimpleParameterValue: ...
    @overload
    def getReferences(self, string: str, collection: java.util.Collection[cern.japc.core.Selector]) -> cern.lsa.client.reference.ParameterReferences: ...
    @overload
    def getReferences(self, collection: java.util.Collection[str], selector: cern.japc.core.Selector) -> java.util.Map[str, cern.accsoft.commons.util.value.FailSafeValue[cern.japc.value.SimpleParameterValue]]: ...
    @overload
    def getReferences(self, set: java.util.Set[str], drivableContext: cern.lsa.domain.settings.DrivableContext) -> java.util.Map[str, cern.accsoft.commons.util.value.FailSafeValue[cern.japc.value.SimpleParameterValue]]: ...
    def initialize(self) -> None: ...
    def removeReferenceListener(self, string: str, selector: cern.japc.core.Selector) -> None: ...
    def setAccelerator(self, cernAccelerator: cern.accsoft.commons.domain.CernAccelerator) -> None: ...
    def setArchiveReferenceService(self, archiveReferenceService: cern.lsa.client.ArchiveReferenceService) -> None: ...
    def setContextService(self, contextService: cern.lsa.client.ContextService) -> None: ...
    def setDescriptorProvider(self, descriptorProvider: cern.japc.core.spi.provider.DescriptorProvider) -> None: ...
    def setParameterFactory(self, parameterFactory: cern.japc.core.factory.ParameterFactory) -> None: ...
    def setParameterService(self, parameterService: cern.lsa.client.ParameterService) -> None: ...

class ReferenceWatcher(LsaReferenceUpdateListener, LsaMappingUpdateListener):
    @overload
    def __init__(self, internalReferenceController: InternalReferenceController, parameterFactory: cern.japc.core.factory.ParameterFactory, contextService: cern.lsa.client.ContextService): ...
    @overload
    def __init__(self, internalReferenceController: InternalReferenceController, parameterFactory: cern.japc.core.factory.ParameterFactory, contextService: cern.lsa.client.ContextService, set: java.util.Set[cern.accsoft.commons.domain.Accelerator]): ...
    def onLsaMappingChanged(self, lsaMappingUpdate: LsaMappingUpdate) -> None: ...
    def onReferenceChanged(self, lsaReferenceUpdate: LsaReferenceUpdate) -> None: ...
