from typing import Any as _py_Any
from typing import List as _py_List
from typing import overload
import cern.japc.value
import cern.japc.value.spi.value.simple
import java.io
import java.lang
import java.util


class BooleanItemData:
    def __init__(self, boolean: bool, simpleValueStandardMeaning: cern.japc.value.SimpleValueStandardMeaning): ...
    def getStandardMeaning(self) -> cern.japc.value.SimpleValueStandardMeaning: ...
    def getValue(self) -> bool: ...
    def toString(self) -> str: ...

class BooleanTypeImpl(cern.japc.value.BooleanType, java.io.Serializable):
    def equals(self, object: _py_Any) -> bool: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def valueOf(self, boolean: bool) -> cern.japc.value.BooleanItem: ...
    def values(self) -> java.util.Set[cern.japc.value.BooleanItem]: ...

class BooleanTypeRegistry:
    @classmethod
    def clearAll(cls) -> None: ...
    @classmethod
    @overload
    def createBooleanTypeName(cls, string: str, string2: str) -> str: ...
    @classmethod
    @overload
    def createBooleanTypeName(cls, string: str, string2: str, string3: str) -> str: ...
    @classmethod
    def getBooleanType(cls, string: str) -> cern.japc.value.BooleanType: ...
    @classmethod
    def getBooleanTypeNotNull(cls, string: str) -> cern.japc.value.BooleanType: ...
    @classmethod
    def isRegistered(cls, string: str) -> bool: ...
    @classmethod
    def registerBooleanType(cls, string: str, booleanItemData: BooleanItemData, booleanItemData2: BooleanItemData) -> cern.japc.value.BooleanType: ...
    @classmethod
    def registerBooleanTypeIfUnknown(cls, string: str, booleanItemData: BooleanItemData, booleanItemData2: BooleanItemData) -> cern.japc.value.BooleanType: ...

class EnumItemData:
    @overload
    def __init__(self, long: int, string: str): ...
    @overload
    def __init__(self, long: int, string: str, simpleValueStandardMeaning: cern.japc.value.SimpleValueStandardMeaning, boolean: bool): ...
    def getCode(self) -> int: ...
    def getStandardMeaning(self) -> cern.japc.value.SimpleValueStandardMeaning: ...
    def getSymbol(self) -> str: ...
    def isSettable(self) -> bool: ...
    def toString(self) -> str: ...

class EnumItemSetImpl(java.util.AbstractSet[cern.japc.value.EnumItem], cern.japc.value.EnumItemSet, java.io.Serializable):
    @overload
    def __init__(self, enumItem: cern.japc.value.EnumItem, enumItemArray: _py_List[cern.japc.value.EnumItem]): ...
    @overload
    def __init__(self, enumType: cern.japc.value.EnumType, enumItemArray: _py_List[cern.japc.value.EnumItem]): ...
    @overload
    def __init__(self, enumType: cern.japc.value.EnumType, long: int): ...
    @overload
    def add(self, enumItem: cern.japc.value.EnumItem) -> bool: ...
    @overload
    def add(self, object: _py_Any) -> bool: ...
    @overload
    def addAll(self, enumItemArray: _py_List[cern.japc.value.EnumItem]) -> bool: ...
    @overload
    def addAll(self, collection: java.util.Collection[cern.japc.value.EnumItem]) -> bool: ...
    def asLong(self) -> int: ...
    def clear(self) -> None: ...
    @overload
    def clone(self) -> cern.japc.value.EnumItemSet: ...
    @overload
    def clone(self) -> _py_Any: ...
    def contains(self, object: _py_Any) -> bool: ...
    @overload
    def containsAll(self, enumItemArray: _py_List[cern.japc.value.EnumItem]) -> bool: ...
    @overload
    def containsAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def getEnumType(self) -> cern.japc.value.EnumType: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[cern.japc.value.EnumItem]: ...
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def removeAll(self, enumItemArray: _py_List[cern.japc.value.EnumItem]) -> bool: ...
    @overload
    def removeAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    @overload
    def retainAll(self, enumItemArray: _py_List[cern.japc.value.EnumItem]) -> bool: ...
    @overload
    def retainAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...

class EnumTypeImpl(cern.japc.value.EnumType, java.io.Serializable):
    def equals(self, object: _py_Any) -> bool: ...
    def getBitSize(self) -> cern.japc.value.EnumTypeBitSize: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def isApplicableToEnumItemSet(self) -> bool: ...
    def symbols(self) -> java.util.Collection[str]: ...
    def toString(self) -> str: ...
    @overload
    def valueOf(self, string: str) -> cern.japc.value.EnumItem: ...
    @overload
    def valueOf(self, long: int) -> cern.japc.value.EnumItem: ...
    def valueStrings(self) -> java.util.Collection[str]: ...
    def values(self) -> java.util.Set[cern.japc.value.EnumItem]: ...

class EnumerationRegistry:
    @classmethod
    def clearAll(cls) -> None: ...
    @classmethod
    @overload
    def createEnumTypeName(cls, string: str, string2: str) -> str: ...
    @classmethod
    @overload
    def createEnumTypeName(cls, string: str, string2: str, string3: str) -> str: ...
    @classmethod
    def getEnumType(cls, string: str) -> cern.japc.value.EnumType: ...
    @classmethod
    def getEnumTypeNotNull(cls, string: str) -> cern.japc.value.EnumType: ...
    @classmethod
    def isRegistered(cls, string: str) -> bool: ...
    @classmethod
    def registerEnumType(cls, string: str, enumTypeBitSize: cern.japc.value.EnumTypeBitSize, set: java.util.Set[EnumItemData]) -> cern.japc.value.EnumType: ...
    @classmethod
    def registerEnumTypeIfUnknown(cls, string: str, enumTypeBitSize: cern.japc.value.EnumTypeBitSize, set: java.util.Set[EnumItemData]) -> cern.japc.value.EnumType: ...

class InternalDiscreteFunction(cern.japc.value.DiscreteFunction):
    @overload
    def clone(self) -> 'InternalDiscreteFunction': ...
    @overload
    def clone(self) -> cern.japc.value.DiscreteFunction: ...
    def getXArray(self) -> _py_List[float]: ...
    def getYArray(self) -> _py_List[float]: ...
    def setArrays(self, doubleArray: _py_List[float], doubleArray2: _py_List[float]) -> None: ...

class InternalDiscreteFunctionFactory:
    def __init__(self): ...
    @classmethod
    def newDiscreteFunction(cls, doubleArray: _py_List[float], doubleArray2: _py_List[float]) -> cern.japc.value.DiscreteFunction: ...
    @classmethod
    def newDiscreteFunctionList(cls, discreteFunctionArray: _py_List[cern.japc.value.DiscreteFunction]) -> cern.japc.value.DiscreteFunctionList: ...

class InternalDiscreteFunctionList(cern.japc.value.DiscreteFunctionList):
    @overload
    def clone(self) -> 'InternalDiscreteFunctionList': ...
    @overload
    def clone(self) -> cern.japc.value.DiscreteFunctionList: ...
    def getFunctions(self) -> java.util.List[InternalDiscreteFunction]: ...
    def setFunctions(self, list: java.util.List[InternalDiscreteFunction]) -> None: ...

class SimpleParameterValueImpl(cern.japc.value.spi.value.simple.AbstractMapSimpleValue, java.lang.Cloneable, java.io.Serializable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, simpleParameterValue: cern.japc.value.SimpleParameterValue): ...
    def clone(self) -> _py_Any: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getArray2D(self) -> cern.japc.value.Array2D: ...
    @overload
    def getArray2D(self, string: str) -> cern.japc.value.Array2D: ...
    @overload
    def getBoolean(self) -> bool: ...
    @overload
    def getBoolean(self, int: int) -> bool: ...
    @overload
    def getBoolean(self, string: str) -> bool: ...
    @overload
    def getBoolean(self, string: str, int: int) -> bool: ...
    @overload
    def getBooleans(self) -> _py_List[bool]: ...
    @overload
    def getBooleans(self, int: int, int2: int) -> _py_List[bool]: ...
    @overload
    def getBooleans(self, string: str) -> _py_List[bool]: ...
    @overload
    def getBooleans(self, string: str, int: int, int2: int) -> _py_List[bool]: ...
    @overload
    def getByte(self) -> int: ...
    @overload
    def getByte(self, int: int) -> int: ...
    @overload
    def getByte(self, string: str) -> int: ...
    @overload
    def getByte(self, string: str, int: int) -> int: ...
    @overload
    def getBytes(self) -> _py_List[int]: ...
    @overload
    def getBytes(self, int: int, int2: int) -> _py_List[int]: ...
    @overload
    def getBytes(self, string: str) -> _py_List[int]: ...
    @overload
    def getBytes(self, string: str, int: int, int2: int) -> _py_List[int]: ...
    @overload
    def getColumnCount(self) -> int: ...
    @overload
    def getColumnCount(self, string: str) -> int: ...
    @overload
    def getDiscreteFunction(self) -> cern.japc.value.DiscreteFunction: ...
    @overload
    def getDiscreteFunction(self, string: str) -> cern.japc.value.DiscreteFunction: ...
    @overload
    def getDiscreteFunctionList(self) -> cern.japc.value.DiscreteFunctionList: ...
    @overload
    def getDiscreteFunctionList(self, string: str) -> cern.japc.value.DiscreteFunctionList: ...
    @overload
    def getDouble(self) -> float: ...
    @overload
    def getDouble(self, int: int) -> float: ...
    @overload
    def getDouble(self, string: str) -> float: ...
    @overload
    def getDouble(self, string: str, int: int) -> float: ...
    @overload
    def getDoubles(self) -> _py_List[float]: ...
    @overload
    def getDoubles(self, int: int, int2: int) -> _py_List[float]: ...
    @overload
    def getDoubles(self, string: str) -> _py_List[float]: ...
    @overload
    def getDoubles(self, string: str, int: int, int2: int) -> _py_List[float]: ...
    @overload
    def getEnumItem(self) -> cern.japc.value.EnumItem: ...
    @overload
    def getEnumItem(self, int: int) -> cern.japc.value.EnumItem: ...
    @overload
    def getEnumItem(self, string: str) -> cern.japc.value.EnumItem: ...
    @overload
    def getEnumItemSet(self) -> cern.japc.value.EnumItemSet: ...
    @overload
    def getEnumItemSet(self, int: int) -> cern.japc.value.EnumItemSet: ...
    @overload
    def getEnumItemSet(self, string: str) -> cern.japc.value.EnumItemSet: ...
    @overload
    def getEnumItemSets(self) -> _py_List[cern.japc.value.EnumItemSet]: ...
    @overload
    def getEnumItemSets(self, int: int, int2: int) -> _py_List[cern.japc.value.EnumItemSet]: ...
    @overload
    def getEnumItemSets(self, string: str) -> _py_List[cern.japc.value.EnumItemSet]: ...
    @overload
    def getEnumItems(self) -> _py_List[cern.japc.value.EnumItem]: ...
    @overload
    def getEnumItems(self, int: int, int2: int) -> _py_List[cern.japc.value.EnumItem]: ...
    @overload
    def getEnumItems(self, string: str) -> _py_List[cern.japc.value.EnumItem]: ...
    @overload
    def getFloat(self) -> float: ...
    @overload
    def getFloat(self, int: int) -> float: ...
    @overload
    def getFloat(self, string: str) -> float: ...
    @overload
    def getFloat(self, string: str, int: int) -> float: ...
    @overload
    def getFloats(self) -> _py_List[float]: ...
    @overload
    def getFloats(self, int: int, int2: int) -> _py_List[float]: ...
    @overload
    def getFloats(self, string: str) -> _py_List[float]: ...
    @overload
    def getFloats(self, string: str, int: int, int2: int) -> _py_List[float]: ...
    @overload
    def getInt(self) -> int: ...
    @overload
    def getInt(self, int: int) -> int: ...
    @overload
    def getInt(self, string: str) -> int: ...
    @overload
    def getInt(self, string: str, int: int) -> int: ...
    @overload
    def getInts(self) -> _py_List[int]: ...
    @overload
    def getInts(self, int: int, int2: int) -> _py_List[int]: ...
    @overload
    def getInts(self, string: str) -> _py_List[int]: ...
    @overload
    def getInts(self, string: str, int: int, int2: int) -> _py_List[int]: ...
    @overload
    def getLength(self) -> int: ...
    @overload
    def getLength(self, string: str) -> int: ...
    @overload
    def getLong(self) -> int: ...
    @overload
    def getLong(self, int: int) -> int: ...
    @overload
    def getLong(self, string: str) -> int: ...
    @overload
    def getLong(self, string: str, int: int) -> int: ...
    @overload
    def getLongs(self) -> _py_List[int]: ...
    @overload
    def getLongs(self, int: int, int2: int) -> _py_List[int]: ...
    @overload
    def getLongs(self, string: str) -> _py_List[int]: ...
    @overload
    def getLongs(self, string: str, int: int, int2: int) -> _py_List[int]: ...
    @overload
    def getMaxValue(self) -> float: ...
    @overload
    def getMaxValue(self, string: str) -> float: ...
    @overload
    def getMinValue(self) -> float: ...
    @overload
    def getMinValue(self, string: str) -> float: ...
    @overload
    def getObject(self) -> _py_Any: ...
    @overload
    def getObject(self, int: int) -> _py_Any: ...
    @overload
    def getObject(self, string: str) -> _py_Any: ...
    @overload
    def getObject(self, string: str, int: int) -> _py_Any: ...
    @overload
    def getRowCount(self) -> int: ...
    @overload
    def getRowCount(self, string: str) -> int: ...
    @overload
    def getShort(self) -> int: ...
    @overload
    def getShort(self, int: int) -> int: ...
    @overload
    def getShort(self, string: str) -> int: ...
    @overload
    def getShort(self, string: str, int: int) -> int: ...
    @overload
    def getShorts(self) -> _py_List[int]: ...
    @overload
    def getShorts(self, int: int, int2: int) -> _py_List[int]: ...
    @overload
    def getShorts(self, string: str) -> _py_List[int]: ...
    @overload
    def getShorts(self, string: str, int: int, int2: int) -> _py_List[int]: ...
    @overload
    def getString(self) -> str: ...
    @overload
    def getString(self, int: int) -> str: ...
    @overload
    def getString(self, string: str) -> str: ...
    @overload
    def getString(self, string: str, int: int) -> str: ...
    @overload
    def getStrings(self) -> _py_List[str]: ...
    @overload
    def getStrings(self, int: int, int2: int) -> _py_List[str]: ...
    @overload
    def getStrings(self, string: str) -> _py_List[str]: ...
    @overload
    def getStrings(self, string: str, int: int, int2: int) -> _py_List[str]: ...
    @overload
    def getUnit(self) -> str: ...
    @overload
    def getUnit(self, string: str) -> str: ...
    def getValueStatus(self) -> cern.japc.value.SimpleValueStatus: ...
    @overload
    def getValueType(self) -> cern.japc.value.ValueType: ...
    @overload
    def getValueType(self, string: str) -> cern.japc.value.ValueType: ...
    @overload
    def getXMaxValue(self) -> float: ...
    @overload
    def getXMaxValue(self, string: str) -> float: ...
    @overload
    def getXMinValue(self) -> float: ...
    @overload
    def getXMinValue(self, string: str) -> float: ...
    @overload
    def getXUnit(self) -> str: ...
    @overload
    def getXUnit(self, string: str) -> str: ...
    @overload
    def getYMaxValue(self) -> float: ...
    @overload
    def getYMaxValue(self, string: str) -> float: ...
    @overload
    def getYMinValue(self) -> float: ...
    @overload
    def getYMinValue(self, string: str) -> float: ...
    @overload
    def getYUnit(self) -> str: ...
    @overload
    def getYUnit(self, string: str) -> str: ...
    def hashCode(self) -> int: ...
    @overload
    def setBoolean(self, boolean: bool) -> None: ...
    @overload
    def setBoolean(self, int: int, boolean: bool) -> None: ...
    @overload
    def setBoolean(self, string: str, boolean: bool) -> None: ...
    @overload
    def setBoolean(self, string: str, int: int, boolean: bool) -> None: ...
    @overload
    def setBooleans(self, booleanArray: _py_List[bool]) -> None: ...
    @overload
    def setBooleans(self, string: str, booleanArray: _py_List[bool]) -> None: ...
    @overload
    def setBooleans2D(self, booleanArray: _py_List[bool], intArray: _py_List[int]) -> None: ...
    @overload
    def setBooleans2D(self, string: str, booleanArray: _py_List[bool], intArray: _py_List[int]) -> None: ...
    @overload
    def setByte(self, byte: int) -> None: ...
    @overload
    def setByte(self, int: int, byte: int) -> None: ...
    @overload
    def setByte(self, string: str, byte: int) -> None: ...
    @overload
    def setByte(self, string: str, int: int, byte: int) -> None: ...
    @overload
    def setBytes(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def setBytes(self, string: str, byteArray: _py_List[int]) -> None: ...
    @overload
    def setBytes2D(self, byteArray: _py_List[int], intArray: _py_List[int]) -> None: ...
    @overload
    def setBytes2D(self, string: str, byteArray: _py_List[int], intArray: _py_List[int]) -> None: ...
    @overload
    def setDiscreteFunction(self, discreteFunction: cern.japc.value.DiscreteFunction) -> None: ...
    @overload
    def setDiscreteFunction(self, string: str, discreteFunction: cern.japc.value.DiscreteFunction) -> None: ...
    @overload
    def setDiscreteFunctionList(self, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> None: ...
    @overload
    def setDiscreteFunctionList(self, string: str, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> None: ...
    @overload
    def setDouble(self, double: float) -> None: ...
    @overload
    def setDouble(self, int: int, double: float) -> None: ...
    @overload
    def setDouble(self, string: str, double: float) -> None: ...
    @overload
    def setDouble(self, string: str, int: int, double: float) -> None: ...
    @overload
    def setDoubles(self, doubleArray: _py_List[float]) -> None: ...
    @overload
    def setDoubles(self, string: str, doubleArray: _py_List[float]) -> None: ...
    @overload
    def setDoubles2D(self, doubleArray: _py_List[float], intArray: _py_List[int]) -> None: ...
    @overload
    def setDoubles2D(self, string: str, doubleArray: _py_List[float], intArray: _py_List[int]) -> None: ...
    @overload
    def setEnumItem(self, enumItem: cern.japc.value.EnumItem) -> None: ...
    @overload
    def setEnumItem(self, int: int, enumItem: cern.japc.value.EnumItem) -> None: ...
    @overload
    def setEnumItem(self, string: str, enumItem: cern.japc.value.EnumItem) -> None: ...
    @overload
    def setEnumItemSet(self, enumItemSet: cern.japc.value.EnumItemSet) -> None: ...
    @overload
    def setEnumItemSet(self, int: int, enumItemSet: cern.japc.value.EnumItemSet) -> None: ...
    @overload
    def setEnumItemSet(self, string: str, enumItemSet: cern.japc.value.EnumItemSet) -> None: ...
    @overload
    def setEnumItemSets(self, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet]) -> None: ...
    @overload
    def setEnumItemSets(self, string: str, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet]) -> None: ...
    @overload
    def setEnumItemSets2D(self, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet], intArray: _py_List[int]) -> None: ...
    @overload
    def setEnumItemSets2D(self, string: str, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet], intArray: _py_List[int]) -> None: ...
    @overload
    def setEnumItems(self, enumItemArray: _py_List[cern.japc.value.EnumItem]) -> None: ...
    @overload
    def setEnumItems(self, string: str, enumItemArray: _py_List[cern.japc.value.EnumItem]) -> None: ...
    @overload
    def setEnumItems2D(self, enumItemArray: _py_List[cern.japc.value.EnumItem], intArray: _py_List[int]) -> None: ...
    @overload
    def setEnumItems2D(self, string: str, enumItemArray: _py_List[cern.japc.value.EnumItem], intArray: _py_List[int]) -> None: ...
    @overload
    def setFloat(self, float: float) -> None: ...
    @overload
    def setFloat(self, int: int, float: float) -> None: ...
    @overload
    def setFloat(self, string: str, float: float) -> None: ...
    @overload
    def setFloat(self, string: str, int: int, float: float) -> None: ...
    @overload
    def setFloats(self, floatArray: _py_List[float]) -> None: ...
    @overload
    def setFloats(self, string: str, floatArray: _py_List[float]) -> None: ...
    @overload
    def setFloats2D(self, floatArray: _py_List[float], intArray: _py_List[int]) -> None: ...
    @overload
    def setFloats2D(self, string: str, floatArray: _py_List[float], intArray: _py_List[int]) -> None: ...
    @overload
    def setInt(self, int: int) -> None: ...
    @overload
    def setInt(self, int: int, int2: int) -> None: ...
    @overload
    def setInt(self, string: str, int: int) -> None: ...
    @overload
    def setInt(self, string: str, int: int, int2: int) -> None: ...
    @overload
    def setInts(self, intArray: _py_List[int]) -> None: ...
    @overload
    def setInts(self, string: str, intArray: _py_List[int]) -> None: ...
    @overload
    def setInts2D(self, intArray: _py_List[int], intArray2: _py_List[int]) -> None: ...
    @overload
    def setInts2D(self, string: str, intArray: _py_List[int], intArray2: _py_List[int]) -> None: ...
    @overload
    def setLong(self, int: int, long: int) -> None: ...
    @overload
    def setLong(self, long: int) -> None: ...
    @overload
    def setLong(self, string: str, int: int, long: int) -> None: ...
    @overload
    def setLong(self, string: str, long: int) -> None: ...
    @overload
    def setLongs(self, longArray: _py_List[int]) -> None: ...
    @overload
    def setLongs(self, string: str, longArray: _py_List[int]) -> None: ...
    @overload
    def setLongs2D(self, longArray: _py_List[int], intArray: _py_List[int]) -> None: ...
    @overload
    def setLongs2D(self, string: str, longArray: _py_List[int], intArray: _py_List[int]) -> None: ...
    @overload
    def setObject(self, object: _py_Any) -> None: ...
    @overload
    def setObject(self, string: str, object: _py_Any) -> None: ...
    @overload
    def setObjects2D(self, object: _py_Any, intArray: _py_List[int]) -> None: ...
    @overload
    def setObjects2D(self, string: str, object: _py_Any, intArray: _py_List[int]) -> None: ...
    @overload
    def setShort(self, int: int, short: int) -> None: ...
    @overload
    def setShort(self, short: int) -> None: ...
    @overload
    def setShort(self, string: str, int: int, short: int) -> None: ...
    @overload
    def setShort(self, string: str, short: int) -> None: ...
    @overload
    def setShorts(self, shortArray: _py_List[int]) -> None: ...
    @overload
    def setShorts(self, string: str, shortArray: _py_List[int]) -> None: ...
    @overload
    def setShorts2D(self, shortArray: _py_List[int], intArray: _py_List[int]) -> None: ...
    @overload
    def setShorts2D(self, string: str, shortArray: _py_List[int], intArray: _py_List[int]) -> None: ...
    @overload
    def setString(self, int: int, string: str) -> None: ...
    @overload
    def setString(self, string: str) -> None: ...
    @overload
    def setString(self, string: str, int: int, string2: str) -> None: ...
    @overload
    def setString(self, string: str, string2: str) -> None: ...
    @overload
    def setStrings(self, stringArray: _py_List[str]) -> None: ...
    @overload
    def setStrings(self, string: str, stringArray: _py_List[str]) -> None: ...
    @overload
    def setStrings2D(self, stringArray: _py_List[str], intArray: _py_List[int]) -> None: ...
    @overload
    def setStrings2D(self, string: str, stringArray: _py_List[str], intArray: _py_List[int]) -> None: ...
    def setValueStatus(self, simpleValueStatus: cern.japc.value.SimpleValueStatus) -> None: ...
    def toString(self) -> str: ...

class DiscreteFunctionImpl(InternalDiscreteFunction, java.io.Serializable):
    @overload
    def clone(self) -> cern.japc.value.DiscreteFunction: ...
    @overload
    def clone(self) -> InternalDiscreteFunction: ...
    @overload
    def clone(self) -> _py_Any: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getX(self, int: int) -> float: ...
    def getXArray(self) -> _py_List[float]: ...
    def getY(self, int: int) -> float: ...
    def getYArray(self) -> _py_List[float]: ...
    def hashCode(self) -> int: ...
    def setArrays(self, doubleArray: _py_List[float], doubleArray2: _py_List[float]) -> None: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    def toXArray(self) -> _py_List[float]: ...
    def toYArray(self) -> _py_List[float]: ...

class DiscreteFunctionListImpl(InternalDiscreteFunctionList, java.io.Serializable):
    @overload
    def clone(self) -> cern.japc.value.DiscreteFunctionList: ...
    @overload
    def clone(self) -> InternalDiscreteFunctionList: ...
    @overload
    def clone(self) -> _py_Any: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getFunction(self, int: int) -> cern.japc.value.DiscreteFunction: ...
    def getFunctions(self) -> java.util.List[InternalDiscreteFunction]: ...
    def hashCode(self) -> int: ...
    def iterator(self) -> java.util.Iterator[cern.japc.value.DiscreteFunction]: ...
    def setFunctions(self, list: java.util.List[InternalDiscreteFunction]) -> None: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
