from typing import Any as _py_Any
from typing import List as _py_List
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.japc.core
import cern.japc.core.spi
import cern.japc.core.spi.provider
import cern.japc.core.transaction
import cern.japc.value
import java.io
import java.lang
import java.util


class AcquiredParameterValueFactory:
    @classmethod
    @overload
    def newAcquiredParameterValue(cls, acquiredParameterValue: cern.japc.core.AcquiredParameterValue, valueHeader: cern.japc.core.ValueHeader) -> cern.japc.core.AcquiredParameterValue: ...
    @classmethod
    @overload
    def newAcquiredParameterValue(cls, string: str, valueHeader: cern.japc.core.ValueHeader, parameterValue: cern.japc.value.ParameterValue) -> cern.japc.core.AcquiredParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, acquiredParameterValue: cern.japc.core.AcquiredParameterValue, valueHeader: cern.japc.core.ValueHeader) -> cern.japc.core.AcquiredParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, string: str, valueHeader: cern.japc.core.ValueHeader, parameterValue: cern.japc.value.ParameterValue) -> cern.japc.core.AcquiredParameterValue: ...

class FactoryConfigurationError(java.lang.Error):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, exception: java.lang.Exception): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class FailSafeParameterValueFactory:
    @classmethod
    @overload
    def newFailSafeParameterValue(cls, acquiredParameterValue: cern.japc.core.AcquiredParameterValue) -> cern.japc.core.FailSafeParameterValue: ...
    @classmethod
    @overload
    def newFailSafeParameterValue(cls, string: str, parameterException: cern.japc.core.ParameterException) -> cern.japc.core.FailSafeParameterValue: ...
    @classmethod
    @overload
    def newFailSafeParameterValue(cls, string: str, valueHeader: cern.japc.core.ValueHeader, parameterValue: cern.japc.value.ParameterValue) -> cern.japc.core.FailSafeParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, string: str, parameterException: cern.japc.core.ParameterException) -> cern.japc.core.FailSafeParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, string: str, valueHeader: cern.japc.core.ValueHeader, parameterValue: cern.japc.value.ParameterValue) -> cern.japc.core.FailSafeParameterValue: ...

class IParameterFactory:
    @overload
    def newParameter(self, parameterUrl: cern.japc.core.spi.ParameterUrl) -> cern.japc.core.transaction.TransactionalParameter: ...
    @overload
    def newParameter(self, parameterUrl: cern.japc.core.spi.ParameterUrl, parameterCharacteristics: cern.japc.core.ParameterCharacteristics) -> cern.japc.core.transaction.TransactionalParameter: ...
    @overload
    def newParameter(self, string: str) -> cern.japc.core.transaction.TransactionalParameter: ...
    @overload
    def newParameter(self, string: str, parameterCharacteristics: cern.japc.core.ParameterCharacteristics) -> cern.japc.core.transaction.TransactionalParameter: ...
    @overload
    def newParameter(self, string: str, string2: str) -> cern.japc.core.transaction.TransactionalParameter: ...

class MapParameterValueFactory:
    @classmethod
    @overload
    def newMapParameterValue(cls) -> cern.japc.value.MapParameterValue: ...
    @classmethod
    @overload
    def newMapParameterValue(cls, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.MapParameterValue: ...
    @classmethod
    @overload
    def newMapParameterValue(cls, mapDescriptor: cern.japc.value.MapDescriptor) -> cern.japc.value.MapParameterValue: ...
    @classmethod
    @overload
    def newMapParameterValue(cls, stringArray: _py_List[str], simpleParameterValueArray: _py_List[cern.japc.value.SimpleParameterValue]) -> cern.japc.value.MapParameterValue: ...
    @classmethod
    @overload
    def newMapParameterValue(cls, map: java.util.Map[str, cern.japc.value.SimpleParameterValue]) -> cern.japc.value.MapParameterValue: ...
    @classmethod
    @overload
    def newValue(cls) -> cern.japc.value.MapParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.MapParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, mapDescriptor: cern.japc.value.MapDescriptor) -> cern.japc.value.MapParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, stringArray: _py_List[str], simpleParameterValueArray: _py_List[cern.japc.value.SimpleParameterValue]) -> cern.japc.value.MapParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, map: java.util.Map[str, cern.japc.value.SimpleParameterValue]) -> cern.japc.value.MapParameterValue: ...

class ObjectParameterValueFactory:
    @classmethod
    def newObjectParameterValue(cls, object: _py_Any) -> cern.japc.core.ObjectParameterValue: ...
    @classmethod
    def newValue(cls, object: _py_Any) -> cern.japc.core.ObjectParameterValue: ...

class ParameterCharacteristicsFactory:
    def __init__(self): ...
    @classmethod
    def getNormalCharacteristics(cls) -> cern.japc.core.ParameterCharacteristics: ...
    @classmethod
    def getParameterCharacteristics(cls, boolean: bool, map: java.util.Map[str, _py_Any]) -> cern.japc.core.ParameterCharacteristics: ...
    @classmethod
    def getWildcardCharacteristics(cls) -> cern.japc.core.ParameterCharacteristics: ...

class ParameterCharacteristicsImpl(cern.japc.core.ParameterCharacteristics, java.io.Serializable):
    CHARACHTERISTICS_N: _py_ClassVar[cern.japc.core.ParameterCharacteristics] = ...
    CHARACHTERISTICS_W: _py_ClassVar[cern.japc.core.ParameterCharacteristics] = ...
    def getAdditionalInformation(self) -> java.util.Map[str, _py_Any]: ...
    def isWildcardSubscriptionParameter(self) -> bool: ...
    def toString(self) -> str: ...

class ParameterDecorations: ...

class ParameterExceptionFactory:
    def __init__(self): ...
    @classmethod
    @overload
    def newException(cls, exception: java.lang.Exception, acquiredParameterValue: cern.japc.core.AcquiredParameterValue) -> cern.japc.core.ParameterException: ...
    @classmethod
    @overload
    def newException(cls, string: str, exception: java.lang.Exception, acquiredParameterValue: cern.japc.core.AcquiredParameterValue) -> cern.japc.core.ParameterException: ...

class ParameterMetaFactoryConstants:
    RDA_SERVICE_NAME: _py_ClassVar[str] = ...
    RDA3_SERVICE_NAME: _py_ClassVar[str] = ...
    TGM_SERVICE_NAME: _py_ClassVar[str] = ...
    SNMP_SERVICE_NAME: _py_ClassVar[str] = ...
    RMI_SERVICE_NAME: _py_ClassVar[str] = ...
    RDA_PROTOCOL: _py_ClassVar[str] = ...
    RDA3_PROTOCOL: _py_ClassVar[str] = ...
    TGM_PROTOCOL: _py_ClassVar[str] = ...
    SYSPROP_DEFAULT_SERVICE_NAME: _py_ClassVar[str] = ...
    SYSPROP_DEFAULT_PROTOCOL_NAME: _py_ClassVar[str] = ...
    DEFAULT_SERVICE_NAME: _py_ClassVar[str] = ...
    DEFAULT_PROTOCOL_NAME: _py_ClassVar[str] = ...
    SYSPROP_SERVICE_NAME_RESOLVERS: _py_ClassVar[str] = ...
    SYSPROP_SERVICE_CONFIG_LOOKUPS: _py_ClassVar[str] = ...
    SYSPROP_WILDCARD_SELECTOR_RESOLVER: _py_ClassVar[str] = ...
    SYSPROP_DEFAULT_WILDCARD_SUBSCRIPTION_ON: _py_ClassVar[str] = ...

class SelectorFactory:
    @classmethod
    @overload
    def newSelector(cls, parameterValue: cern.japc.value.ParameterValue) -> cern.japc.core.Selector: ...
    @classmethod
    @overload
    def newSelector(cls, string: str) -> cern.japc.core.Selector: ...
    @classmethod
    @overload
    def newSelector(cls, string: str, parameterValue: cern.japc.value.ParameterValue) -> cern.japc.core.Selector: ...

class ServiceNameResolver:
    def getServiceName(self, string: str, parameterDescriptor: cern.japc.core.ParameterDescriptor) -> str: ...

class SimpleParameterValueFactory:
    @classmethod
    @overload
    def newSimpleParameterValue(cls) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, boolean: bool) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, boolean: bool, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, booleanArray: _py_List[bool]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, booleanArray: _py_List[bool], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, booleanArray: _py_List[bool], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, booleanArray: _py_List[bool], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, byte: int) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, byte: int, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, byteArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, byteArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, byteArray: _py_List[int], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, byteArray: _py_List[int], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, discreteFunction: cern.japc.value.DiscreteFunction) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, discreteFunction: cern.japc.value.DiscreteFunction, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, enumItem: cern.japc.value.EnumItem) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, enumItem: cern.japc.value.EnumItem, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, enumItemSet: cern.japc.value.EnumItemSet) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, enumItemSet: cern.japc.value.EnumItemSet, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, enumItemArray: _py_List[cern.japc.value.EnumItem]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, enumItemArray: _py_List[cern.japc.value.EnumItem], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, enumItemArray: _py_List[cern.japc.value.EnumItem], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, enumItemArray: _py_List[cern.japc.value.EnumItem], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, simpleDescriptor: cern.japc.value.SimpleDescriptor) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, valueType: cern.japc.value.ValueType) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, valueType: cern.japc.value.ValueType, enumType: cern.japc.value.EnumType) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, double: float) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, double: float, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, doubleArray: _py_List[float]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, doubleArray: _py_List[float], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, doubleArray: _py_List[float], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, doubleArray: _py_List[float], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, float: float) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, float: float, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, floatArray: _py_List[float]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, floatArray: _py_List[float], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, floatArray: _py_List[float], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, floatArray: _py_List[float], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, int: int) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, int: int, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, intArray: _py_List[int], intArray2: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, intArray: _py_List[int], intArray2: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, object: _py_Any) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, object: _py_Any, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, object: _py_Any, intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, object: _py_Any, intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, string: str) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, string: str, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, stringArray: _py_List[str]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, stringArray: _py_List[str], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, stringArray: _py_List[str], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, stringArray: _py_List[str], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, long: int) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, long: int, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, longArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, longArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, longArray: _py_List[int], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, longArray: _py_List[int], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, short: int) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, short: int, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, shortArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, shortArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, shortArray: _py_List[int], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newSimpleParameterValue(cls, shortArray: _py_List[int], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, boolean: bool) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, boolean: bool, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, booleanArray: _py_List[bool]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, booleanArray: _py_List[bool], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, booleanArray: _py_List[bool], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, booleanArray: _py_List[bool], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, byte: int) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, byte: int, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, byteArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, byteArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, byteArray: _py_List[int], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, byteArray: _py_List[int], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, discreteFunction: cern.japc.value.DiscreteFunction) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, discreteFunction: cern.japc.value.DiscreteFunction, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, enumItem: cern.japc.value.EnumItem) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, enumItem: cern.japc.value.EnumItem, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, enumItemSet: cern.japc.value.EnumItemSet) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, enumItemSet: cern.japc.value.EnumItemSet, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, enumItemArray: _py_List[cern.japc.value.EnumItem]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, enumItemArray: _py_List[cern.japc.value.EnumItem], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, enumItemArray: _py_List[cern.japc.value.EnumItem], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, enumItemArray: _py_List[cern.japc.value.EnumItem], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, simpleDescriptor: cern.japc.value.SimpleDescriptor) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, valueType: cern.japc.value.ValueType) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, valueType: cern.japc.value.ValueType, enumType: cern.japc.value.EnumType) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, double: float) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, double: float, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, doubleArray: _py_List[float]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, doubleArray: _py_List[float], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, doubleArray: _py_List[float], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, doubleArray: _py_List[float], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, float: float) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, float: float, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, floatArray: _py_List[float]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, floatArray: _py_List[float], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, floatArray: _py_List[float], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, floatArray: _py_List[float], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, int: int) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, int: int, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, intArray: _py_List[int], intArray2: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, intArray: _py_List[int], intArray2: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, object: _py_Any) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, object: _py_Any, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, object: _py_Any, intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, object: _py_Any, intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, string: str) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, string: str, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, stringArray: _py_List[str]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, stringArray: _py_List[str], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, stringArray: _py_List[str], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, stringArray: _py_List[str], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, long: int) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, long: int, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, longArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, longArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, longArray: _py_List[int], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, longArray: _py_List[int], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, short: int) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, short: int, immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, shortArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, shortArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, shortArray: _py_List[int], intArray: _py_List[int]) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    @overload
    def newValue(cls, shortArray: _py_List[int], intArray: _py_List[int], immutableParameter: cern.japc.core.ImmutableParameter) -> cern.japc.value.SimpleParameterValue: ...

class TransactionFactory:
    @classmethod
    def newCompositeTransaction(cls) -> cern.japc.core.transaction.CompositeTransaction: ...

class ValueHeaderFactory:
    NO_CYCLE_STAMP: _py_ClassVar[int] = ...
    NO_SET_STAMP: _py_ClassVar[int] = ...
    @classmethod
    @overload
    def newAcquisitionFirstUpdateHeader(cls, long: int, long2: int, selector: cern.japc.core.Selector) -> cern.japc.core.ValueHeader: ...
    @classmethod
    @overload
    def newAcquisitionFirstUpdateHeader(cls, long: int, long2: int, string: str) -> cern.japc.core.ValueHeader: ...
    @classmethod
    @overload
    def newAcquisitionRegularUpdateHeader(cls, long: int, long2: int, selector: cern.japc.core.Selector) -> cern.japc.core.ValueHeader: ...
    @classmethod
    @overload
    def newAcquisitionRegularUpdateHeader(cls, long: int, long2: int, string: str) -> cern.japc.core.ValueHeader: ...
    @classmethod
    @overload
    def newSettingFirstUpdateHeader(cls, long: int, long2: int, selector: cern.japc.core.Selector) -> cern.japc.core.ValueHeader: ...
    @classmethod
    @overload
    def newSettingFirstUpdateHeader(cls, long: int, long2: int, string: str) -> cern.japc.core.ValueHeader: ...
    @classmethod
    @overload
    def newSettingImmediateUpdateHeader(cls, selector: cern.japc.core.Selector) -> cern.japc.core.ValueHeader: ...
    @classmethod
    @overload
    def newSettingImmediateUpdateHeader(cls, string: str) -> cern.japc.core.ValueHeader: ...
    @classmethod
    @overload
    def newSettingImmediateUpdateHeader(cls, long: int, long2: int, selector: cern.japc.core.Selector) -> cern.japc.core.ValueHeader: ...
    @classmethod
    @overload
    def newSettingImmediateUpdateHeader(cls, long: int, long2: int, string: str) -> cern.japc.core.ValueHeader: ...
    @classmethod
    @overload
    def newSettingRegularUpdateHeader(cls, long: int, long2: int, selector: cern.japc.core.Selector) -> cern.japc.core.ValueHeader: ...
    @classmethod
    @overload
    def newSettingRegularUpdateHeader(cls, long: int, long2: int, string: str) -> cern.japc.core.ValueHeader: ...
    @classmethod
    def toFirstUpdateHeader(cls, valueHeader: cern.japc.core.ValueHeader) -> cern.japc.core.ValueHeader: ...
    @classmethod
    def toImmediateUpdateHeader(cls, valueHeader: cern.japc.core.ValueHeader) -> cern.japc.core.ValueHeader: ...
    @classmethod
    def toRegularUpdateHeader(cls, valueHeader: cern.japc.core.ValueHeader) -> cern.japc.core.ValueHeader: ...

class ParameterFactory(IParameterFactory):
    FACTORY_ID: _py_ClassVar[str] = ...
    DESCRIPTOR_PROVIDER_ID: _py_ClassVar[str] = ...
    SYSPROP_JAPC_DIRSERVICE_PROVIDER_ENABLED: _py_ClassVar[str] = ...
    SYSPROP_JAPC_CCS_DESCRIPTORS_ENABLED: _py_ClassVar[str] = ...
    SYSPROP_JAPC_IGNORE_SET: _py_ClassVar[str] = ...
    @classmethod
    def addAllDescriptors(cls, string: str, deviceDescriptor: cern.japc.core.DeviceDescriptor, parameterDescriptor: cern.japc.core.ParameterDescriptor, valueDescriptor: cern.japc.value.ValueDescriptor) -> None: ...
    @classmethod
    def addDeviceDescriptor(cls, string: str, deviceDescriptor: cern.japc.core.DeviceDescriptor) -> None: ...
    @classmethod
    def addParameterAndValueDescriptor(cls, string: str, parameterDescriptor: cern.japc.core.ParameterDescriptor, valueDescriptor: cern.japc.value.ValueDescriptor) -> None: ...
    @classmethod
    def addParameterDescriptor(cls, string: str, parameterDescriptor: cern.japc.core.ParameterDescriptor) -> None: ...
    @classmethod
    def addValueDescriptor(cls, string: str, valueDescriptor: cern.japc.value.ValueDescriptor) -> None: ...
    def getDescriptorProvider(self) -> cern.japc.core.spi.provider.DescriptorProvider: ...
    def getDeviceDescriptor(self, string: str) -> cern.japc.core.DeviceDescriptor: ...
    def getDeviceDescriptors(self, collection: java.util.Collection[str]) -> java.util.Map[str, cern.japc.core.DeviceDescriptor]: ...
    @overload
    def getParameterDescriptor(self, parameterUrl: cern.japc.core.spi.ParameterUrl) -> cern.japc.core.ParameterDescriptor: ...
    @overload
    def getParameterDescriptor(self, string: str) -> cern.japc.core.ParameterDescriptor: ...
    def getParameterDescriptors(self, collection: java.util.Collection[str]) -> java.util.Map[str, cern.japc.core.ParameterDescriptor]: ...
    def getParameterDescriptorsFromUrls(self, collection: java.util.Collection[cern.japc.core.spi.ParameterUrl]) -> java.util.Map[cern.japc.core.spi.ParameterUrl, cern.japc.core.ParameterDescriptor]: ...
    @overload
    def getValueDescriptor(self, parameterUrl: cern.japc.core.spi.ParameterUrl) -> cern.japc.value.ValueDescriptor: ...
    @overload
    def getValueDescriptor(self, string: str) -> cern.japc.value.ValueDescriptor: ...
    def getValueDescriptors(self, collection: java.util.Collection[str]) -> java.util.Map[str, cern.japc.value.ValueDescriptor]: ...
    def getValueDescriptorsFromUrls(self, collection: java.util.Collection[cern.japc.core.spi.ParameterUrl]) -> java.util.Map[cern.japc.core.spi.ParameterUrl, cern.japc.value.ValueDescriptor]: ...
    def isUnknownParameterSupported(self) -> bool: ...
    @classmethod
    @overload
    def newInstance(cls) -> 'ParameterFactory': ...
    @classmethod
    @overload
    def newInstance(cls, string: str) -> 'ParameterFactory': ...
    @overload
    def newParameter(self, parameterUrl: cern.japc.core.spi.ParameterUrl) -> cern.japc.core.transaction.TransactionalParameter: ...
    @overload
    def newParameter(self, parameterUrl: cern.japc.core.spi.ParameterUrl, parameterCharacteristics: cern.japc.core.ParameterCharacteristics) -> cern.japc.core.transaction.TransactionalParameter: ...
    @overload
    def newParameter(self, string: str) -> cern.japc.core.transaction.TransactionalParameter: ...
    @overload
    def newParameter(self, string: str, parameterCharacteristics: cern.japc.core.ParameterCharacteristics) -> cern.japc.core.transaction.TransactionalParameter: ...
    @overload
    def newParameter(self, string: str, string2: str) -> cern.japc.core.transaction.TransactionalParameter: ...
    def newParameterExplorer(self) -> cern.japc.core.ParameterExplorer: ...
    def setUnknownParameterSupported(self, boolean: bool) -> None: ...
