"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Architecture = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Architectures supported by AWS Lambda.
 *
 * @stability stable
 */
class Architecture {
    constructor(archName, dockerPlatform) {
        this.name = archName;
        this.dockerPlatform = dockerPlatform;
    }
    /**
     * Used to specify a custom architecture name.
     *
     * Use this if the architecture name is not yet supported by the CDK.
     *
     * @param name the architecture name as recognized by AWS Lambda.
     * @param dockerPlatform the platform to use for this architecture when building with Docker.
     * @stability stable
     */
    static custom(name, dockerPlatform) {
        return new Architecture(name, dockerPlatform !== null && dockerPlatform !== void 0 ? dockerPlatform : 'linux/amd64');
    }
}
exports.Architecture = Architecture;
_a = JSII_RTTI_SYMBOL_1;
Architecture[_a] = { fqn: "@aws-cdk/aws-lambda.Architecture", version: "1.129.0" };
/**
 * 64 bit architecture with x86 instruction set.
 *
 * @stability stable
 */
Architecture.X86_64 = new Architecture('x86_64', 'linux/amd64');
/**
 * 64 bit architecture with the ARM instruction set.
 *
 * @stability stable
 */
Architecture.ARM_64 = new Architecture('arm64', 'linux/arm64');
//# sourceMappingURL=data:application/json;base64,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