"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .assistantmessage import AssistantMessage, AssistantMessageTypedDict
from .systemmessage import SystemMessage, SystemMessageTypedDict
from .toolmessage import ToolMessage, ToolMessageTypedDict
from .usermessage import UserMessage, UserMessageTypedDict
from mistralai.types import BaseModel, Nullable, UNSET_SENTINEL
from mistralai.utils import get_discriminator
import pydantic
from pydantic import Discriminator, Tag, model_serializer
from typing import List, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


TwoTypedDict = TypeAliasType(
    "TwoTypedDict",
    Union[
        SystemMessageTypedDict,
        UserMessageTypedDict,
        AssistantMessageTypedDict,
        ToolMessageTypedDict,
    ],
)


Two = Annotated[
    Union[
        Annotated[AssistantMessage, Tag("assistant")],
        Annotated[SystemMessage, Tag("system")],
        Annotated[ToolMessage, Tag("tool")],
        Annotated[UserMessage, Tag("user")],
    ],
    Discriminator(lambda m: get_discriminator(m, "role", "role")),
]


OneTypedDict = TypeAliasType(
    "OneTypedDict",
    Union[
        SystemMessageTypedDict,
        UserMessageTypedDict,
        AssistantMessageTypedDict,
        ToolMessageTypedDict,
    ],
)


One = Annotated[
    Union[
        Annotated[AssistantMessage, Tag("assistant")],
        Annotated[SystemMessage, Tag("system")],
        Annotated[ToolMessage, Tag("tool")],
        Annotated[UserMessage, Tag("user")],
    ],
    Discriminator(lambda m: get_discriminator(m, "role", "role")),
]


ChatClassificationRequestInputsTypedDict = TypeAliasType(
    "ChatClassificationRequestInputsTypedDict",
    Union[List[OneTypedDict], List[List[TwoTypedDict]]],
)
r"""Chat to classify"""


ChatClassificationRequestInputs = TypeAliasType(
    "ChatClassificationRequestInputs", Union[List[One], List[List[Two]]]
)
r"""Chat to classify"""


class ChatClassificationRequestTypedDict(TypedDict):
    inputs: ChatClassificationRequestInputsTypedDict
    r"""Chat to classify"""
    model: Nullable[str]


class ChatClassificationRequest(BaseModel):
    inputs: Annotated[ChatClassificationRequestInputs, pydantic.Field(alias="input")]
    r"""Chat to classify"""

    model: Nullable[str]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["model"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
