/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * The version provider parses a JSON file containing references to ECRs that serve Thinkbox's Deadline Docker images.
 * It can be downloaded or loaded from local file and returns the ECR ARN prefix.
 */
export declare class ThinkboxEcrProvider {
    private readonly indexPath?;
    /**
     * The URL to obtain the ECR index from.
     */
    private static readonly ECR_INDEX_URL;
    private indexJsonPromise?;
    constructor(indexPath?: string | undefined);
    private get indexJson();
    private verifyThinkboxDockerImageIndex;
    /**
     * Gets the global ECR base URI for Thinkbox published Deadline Docker images.
     */
    getGlobalEcrBaseURI(): Promise<string>;
    /**
     * Downloads and parses the ECR index.
     *
     * Returns a promise that is resolved with a JSON-parsed object containing the index.
     */
    private getEcrIndex;
    /**
     * This method reads the ECR index from a file and returns a parsed JSON object.
     *
     * @param indexFilePath The path to the ECR index file
     */
    private readEcrIndex;
}
