/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { LambdaContext } from '../aws-lambda';
import { CfnRequestEvent } from './types';
export declare enum CfnResponseStatus {
    SUCCESS = "SUCCESS",
    FAILED = "FAILED"
}
export declare function sendCfnResponse(args: {
    readonly event: CfnRequestEvent;
    readonly context: LambdaContext;
    readonly status: CfnResponseStatus;
    readonly reason?: string;
    readonly physicalId?: string;
    readonly data?: object;
}): Promise<void>;
