/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { SecretsManager } from 'aws-sdk';
import { LambdaContext } from '../lib/aws-lambda';
import { CfnRequestEvent, SimpleCustomResource } from '../lib/custom-resource';
import { SEPConfiguratorResourceProps } from './types';
/**
 * A custom resource used to save Spot Event Plugin server data and configurations.
 */
export declare class SEPConfiguratorResource extends SimpleCustomResource {
    protected readonly secretsManagerClient: SecretsManager;
    constructor(secretsManagerClient: SecretsManager);
    /**
     * @inheritdoc
     */
    validateInput(data: object): boolean;
    /**
     * @inheritdoc
     */
    doCreate(_physicalId: string, resourceProperties: SEPConfiguratorResourceProps): Promise<object | undefined>;
    /**
     * @inheritdoc
     */
    doDelete(_physicalId: string, _resourceProperties: SEPConfiguratorResourceProps): Promise<void>;
    private implementsSEPConfiguratorResourceProps;
    private implementsConnectionOptions;
    private isSecretArnOrUndefined;
    private spotEventPluginClient;
    private toKeyValueArray;
    private securitySettings;
}
/**
 * The lambda handler that is used to log in to MongoDB and perform some configuration actions.
 */
export declare function configureSEP(event: CfnRequestEvent, context: LambdaContext): Promise<string>;
