"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lib_1 = require("../lib");
const mount_permissions_helper_1 = require("../lib/mount-permissions-helper");
test.each([
    [lib_1.MountPermissions.READONLY, 'ro'],
    [lib_1.MountPermissions.READWRITE, 'rw'],
    [undefined, 'rw'],
])('toLinuxMountOption test: %p', (permission, expected) => {
    expect(mount_permissions_helper_1.MountPermissionsHelper.toLinuxMountOption(permission)).toBe(expected);
});
test.each([
    [
        lib_1.MountPermissions.READONLY,
        [
            'elasticfilesystem:ClientMount',
        ],
    ],
    [
        lib_1.MountPermissions.READWRITE,
        [
            'elasticfilesystem:ClientMount',
            'elasticfilesystem:ClientWrite',
        ],
    ],
    [
        undefined,
        [
            'elasticfilesystem:ClientMount',
            'elasticfilesystem:ClientWrite',
        ],
    ],
])('toEfsIAMActions test: %p', (permission, expected) => {
    expect(mount_permissions_helper_1.MountPermissionsHelper.toEfsIAMActions(permission)).toEqual(expected);
});
//# sourceMappingURL=data:application/json;base64,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