import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OraclepaasProviderConfig {
    /**
    * The HTTP endpoint for the Oracle Application operations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas#application_endpoint OraclepaasProvider#application_endpoint}
    */
    readonly applicationEndpoint?: string;
    /**
    * The HTTP endpoint for Oracle Database operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas#database_endpoint OraclepaasProvider#database_endpoint}
    */
    readonly databaseEndpoint?: string;
    /**
    * The OPAAS identity domain for API operations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas#identity_domain OraclepaasProvider#identity_domain}
    */
    readonly identityDomain: string;
    /**
    * Skip TLS Verification for self-signed certificates. Should only be used if absolutely required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas#insecure OraclepaasProvider#insecure}
    */
    readonly insecure?: boolean | cdktf.IResolvable;
    /**
    * The HTTP endpoint for Oracle Java operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas#java_endpoint OraclepaasProvider#java_endpoint}
    */
    readonly javaEndpoint?: string;
    /**
    * Maximum number retries to wait for a successful response when operating on resources within OPAAS (defaults to 1)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas#max_retries OraclepaasProvider#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * The HTTP endpoint for Oracle MySQL operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas#mysql_endpoint OraclepaasProvider#mysql_endpoint}
    */
    readonly mysqlEndpoint?: string;
    /**
    * The user password for OPAAS API operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas#password OraclepaasProvider#password}
    */
    readonly password: string;
    /**
    * The user name for OPAAS API operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas#user OraclepaasProvider#user}
    */
    readonly user: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas#alias OraclepaasProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/oraclepaas oraclepaas}
*/
export declare class OraclepaasProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "oraclepaas";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/oraclepaas oraclepaas} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OraclepaasProviderConfig
    */
    constructor(scope: Construct, id: string, config: OraclepaasProviderConfig);
    private _applicationEndpoint?;
    get applicationEndpoint(): string | undefined;
    set applicationEndpoint(value: string | undefined);
    resetApplicationEndpoint(): void;
    get applicationEndpointInput(): string | undefined;
    private _databaseEndpoint?;
    get databaseEndpoint(): string | undefined;
    set databaseEndpoint(value: string | undefined);
    resetDatabaseEndpoint(): void;
    get databaseEndpointInput(): string | undefined;
    private _identityDomain?;
    get identityDomain(): string | undefined;
    set identityDomain(value: string | undefined);
    get identityDomainInput(): string | undefined;
    private _insecure?;
    get insecure(): boolean | cdktf.IResolvable | undefined;
    set insecure(value: boolean | cdktf.IResolvable | undefined);
    resetInsecure(): void;
    get insecureInput(): boolean | cdktf.IResolvable | undefined;
    private _javaEndpoint?;
    get javaEndpoint(): string | undefined;
    set javaEndpoint(value: string | undefined);
    resetJavaEndpoint(): void;
    get javaEndpointInput(): string | undefined;
    private _maxRetries?;
    get maxRetries(): number | undefined;
    set maxRetries(value: number | undefined);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _mysqlEndpoint?;
    get mysqlEndpoint(): string | undefined;
    set mysqlEndpoint(value: string | undefined);
    resetMysqlEndpoint(): void;
    get mysqlEndpointInput(): string | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    get passwordInput(): string | undefined;
    private _user?;
    get user(): string | undefined;
    set user(value: string | undefined);
    get userInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
