"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretKey = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const key_type_1 = require("./key-type");
class SecretKey {
    constructor(secretKeyType) {
        this.secretKeyType = secretKeyType;
    }
    static fromPlainText(value) {
        return new PlainTextSecretKey(value);
    }
    static fromSSMParameter(secretKeyParameter) {
        return new SSMParameterSecretKey(secretKeyParameter);
    }
    static fromSecretsManager(secretKeySecret, fieldName) {
        return new SecretsManagerSecretKey(secretKeySecret, fieldName);
    }
}
exports.SecretKey = SecretKey;
_a = JSII_RTTI_SYMBOL_1;
SecretKey[_a] = { fqn: "@cloudcomponents/cdk-secret-key.SecretKey", version: "1.14.0" };
class PlainTextSecretKey extends SecretKey {
    constructor(value) {
        super(key_type_1.KeyType.PLAIN_TEXT);
        this.value = value;
    }
    serialize() {
        return JSON.stringify({
            secretKeyType: this.secretKeyType,
            value: this.value,
        });
    }
}
class SecretsManagerSecretKey extends SecretKey {
    constructor(secretKeySecret, fieldName) {
        super(key_type_1.KeyType.SECRETS_MANAGER);
        this.secretKeySecret = secretKeySecret;
        this.fieldName = fieldName;
    }
    grantRead(grantee) {
        return this.secretKeySecret.grantRead(grantee);
    }
    serialize() {
        return JSON.stringify({
            secretKeyType: this.secretKeyType,
            secretId: this.secretKeySecret.secretArn,
            fieldName: this.fieldName,
        });
    }
}
class SSMParameterSecretKey extends SecretKey {
    constructor(secretKeyParameter) {
        super(key_type_1.KeyType.SSM_PARAMETER);
        this.secretKeyParameter = secretKeyParameter;
    }
    grantRead(grantee) {
        return this.secretKeyParameter.grantRead(grantee);
    }
    serialize() {
        return JSON.stringify({
            secretKeyType: this.secretKeyType,
            parameterName: this.secretKeyParameter.parameterName,
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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