from functools import partial
from subprocess import (
    PIPE,
    CalledProcessError,
    run,
)

from pybrary.ascii import rm_ansi_codes


def shell(script, shell, color=False):
    try:
        proc = run(
            script,
            stdout = PIPE,
            stderr = PIPE,
            check  = True,
            shell  = True,
            executable = shell,
        )
    except CalledProcessError as exc:
        ret = exc.returncode
        out = exc.stdout.decode('utf-8')
        err = exc.stderr.decode('utf-8')
    else:
        ret = proc.returncode
        out = proc.stdout.decode('utf-8').strip()
        err = proc.stderr.decode('utf-8').strip()

    if not color:
        out = rm_ansi_codes(out)
        err = rm_ansi_codes(err)

    return ret, out, err


bash = partial(shell, shell='/bin/bash')
