from __future__ import annotations
import enum

class FontCollection:
    def __len__(self) -> int: ...
    def __getitem__(self, key: int | str) -> FontFamily: ...

class FontFamily:
    name: str
    def __len__(self) -> int: ...
    def __getitem__(self, idx: int) -> FontVariant: ...
    def get_matching_variants(
        self,
        *,
        weight: float | Weight | None = None,
        style: Style | None = None,
        width: float | None = None,
        slant: float | None = None,
        optical_size: float | None = None,
        italic: bool | None = None,
    ) -> list[FontVariant]: ...
    def get_best_variant(
        self,
        *,
        weight: float | Weight | None = None,
        style: Style | None = None,
        width: float | None = None,
        slant: float | None = None,
        optical_size: float | None = None,
        italic: bool | None = None,
    ) -> FontVariant: ...

class FontVariant:
    style: Style
    weight: Weight
    filename: str
    def files(self) -> list[str]: ...

class Style(enum.Enum):
    NORMAL = ...
    ITALIIC = ...
    OBLIQUE = ...

class Weight(enum.Enum):
    ULTRA_LIGHT = ...
    LIGHT = ...
    SEMI_LIGHT = ...
    REGULAR = ...
    MEDIUM = ...
    SEMI_BOLD = ...
    BOLD = ...
    EXTRA_BOLD = ...
    BLACK = ...
    EXTRA_BLACK = ...

def get_matching_variants(
    win32_family_names: str | None = None,
    typographic_family_names: str | None = None,
    full_name: str | None = None,
    postscript_name: str | None = None,
    weight_stretch_style_family_name: str | None = None,
    design_script_language_tag: str | None = None,
    supported_script_language_tag: str | None = None,
    preferred_family_names: str | None = None,
    preferred_subfamily_names: str | None = None,
) -> list[FontVariant]: ...
