![Tests](https://github.com/SyntropyNet/syntropy-python-sdk/workflows/Tests/badge.svg)
![PyPi](https://github.com/SyntropyNet/syntropy-python-sdk/workflows/PyPi/badge.svg)

# Syntropy SDK
Syntropy SDK for Python allows you to manage Syntropy Networks using simple Python interface.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.1.0
- Package version: 0.3.0

## Requirements.

Python 3.6+

## Installation & Usage
### pip install

Install the SDK simply using pip:

```sh
pip install syntropy_sdk
```

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/SyntropyNet/syntropy-python-sdk.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/SyntropyNet/syntropy-python-sdk.git`)

Then import the package:
```python
import syntropy_sdk 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import syntropy_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then use the following as a reference:

```python
import syntropy_sdk as sdk
from syntropy_sdk.exceptions import ApiException
from syntropy_sdk.utils import WithRetry
from pprint import pprint

# Configure API
config = sdk.Configuration()
config.host = "url to the Syntropy Stack"
config.api_key["Authorization"] = "your api authorizaton token"
api = sdk.ApiClient(config)
platform_api = sdk.NetworkApi(api)

try:
    api_response = WithRetry(platform_api.platform_network_info)()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling NetworkApi->platform_network_info: %s\n" % e)


# Create connections
connections_api = sdk.ConectionsApi(api)
try:
    body = {
        "agent_ids": [
            0, 1,  # Valid agent IDs
            1, 2,
            2, 4,
        ],
    }
    connections = connections_api.platform_connection_create_p2p(body=body)["data"]
except ApiException as e:
    print("Exception when creating a network: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to */*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIAuthApi* | [**v1_auth_acess_token_login**](docs/APIAuthApi.md#v1_auth_acess_token_login) | **POST** /api/auth/v1/access-token/login | Access Token Login
*APIKeysApi* | [**create_api_key**](docs/APIKeysApi.md#create_api_key) | **POST** /auth/api-key | Create API key
*APIKeysApi* | [**delete_api_key**](docs/APIKeysApi.md#delete_api_key) | **DELETE** /auth/api-key/{api_key_id} | Delete API keys
*APIKeysApi* | [**get_api_key**](docs/APIKeysApi.md#get_api_key) | **GET** /auth/api-key | Get API keys
*AuthApi* | [**add_contact**](docs/AuthApi.md#add_contact) | **POST** /auth/authorization/contact | Update user contacts
*AuthApi* | [**auth_access_token_list**](docs/AuthApi.md#auth_access_token_list) | **GET** /auth/authorization/access-token | Get access tokens
*AuthApi* | [**auth_access_token_login**](docs/AuthApi.md#auth_access_token_login) | **POST** /auth/authorization/access-token/login | Login (access token)
*AuthApi* | [**auth_access_token_permissions_list**](docs/AuthApi.md#auth_access_token_permissions_list) | **GET** /auth/authorization/permissions/access-token | Get access token permissions
*AuthApi* | [**auth_access_token_user_create**](docs/AuthApi.md#auth_access_token_user_create) | **POST** /auth/authorization/access-token | Create access token
*AuthApi* | [**auth_access_token_user_delete**](docs/AuthApi.md#auth_access_token_user_delete) | **DELETE** /auth/authorization/access-token/{id} | Delete access token
*AuthApi* | [**auth_logout**](docs/AuthApi.md#auth_logout) | **POST** /auth/authorization/logout | Logout
*AuthApi* | [**auth_show_user**](docs/AuthApi.md#auth_show_user) | **GET** /auth/authorization/user | Get user info
*AuthApi* | [**auth_verify_email**](docs/AuthApi.md#auth_verify_email) | **GET** /auth/authorization/verify-email/{code} | Verify email
*AuthApi* | [**update_settings**](docs/AuthApi.md#update_settings) | **PUT** /auth/authorization/settings | Update user settings
*MFAApi* | [**confirm_mfa_secret**](docs/MFAApi.md#confirm_mfa_secret) | **POST** /auth/mfa/confirm | Confirm MFA
*MFAApi* | [**disable_mfa**](docs/MFAApi.md#disable_mfa) | **POST** /auth/mfa/disable | Disable MFA
*MFAApi* | [**disable_mfa_using_backup**](docs/MFAApi.md#disable_mfa_using_backup) | **POST** /auth/mfa/disable-using-backup | Disable MFA (backup)
*MFAApi* | [**generate_mfa_secret**](docs/MFAApi.md#generate_mfa_secret) | **GET** /auth/mfa/generate | Generate MFA
*AgentsApi* | [**platform_agent_config**](docs/AgentsApi.md#platform_agent_config) | **GET** /api/platform/agent/{agent_id}/config | Get agent config
*AgentsApi* | [**platform_agent_coordinates**](docs/AgentsApi.md#platform_agent_coordinates) | **POST** /api/platform/agents/coordinates | Get coordinates
*AgentsApi* | [**platform_agent_create**](docs/AgentsApi.md#platform_agent_create) | **POST** /api/platform/agents | Create agent
*AgentsApi* | [**platform_agent_id_name_pairs**](docs/AgentsApi.md#platform_agent_id_name_pairs) | **GET** /api/platform/agents/filters | Get agents (id,name)
*AgentsApi* | [**platform_agent_index**](docs/AgentsApi.md#platform_agent_index) | **GET** /api/platform/agents | Get agents
*AgentsApi* | [**platform_agent_provider_index**](docs/AgentsApi.md#platform_agent_provider_index) | **GET** /api/platform/agent-providers | Get agent providers
*AgentsApi* | [**platform_agent_provider_show**](docs/AgentsApi.md#platform_agent_provider_show) | **GET** /api/platform/agent-providers/{id} | Get agent provider
*AgentsApi* | [**platform_agent_tag_index**](docs/AgentsApi.md#platform_agent_tag_index) | **GET** /api/platform/agent-tags | Get agent tags
*AgentsApi* | [**platform_agent_update**](docs/AgentsApi.md#platform_agent_update) | **PATCH** /api/platform/agents/{agent_id} | Update agent
*AgentsApi* | [**platform_agents_destroy**](docs/AgentsApi.md#platform_agents_destroy) | **POST** /api/platform/agents/remove | Delete agent
*AgentsApi* | [**platform_config**](docs/AgentsApi.md#platform_config) | **GET** /api/platform/agent/{agent_id}/wg-config | Get agent wg config
*AgentsApi* | [**platform_logs_read_timestamp**](docs/AgentsApi.md#platform_logs_read_timestamp) | **POST** /api/platform/logs-reads-timestamp | Get logs reads timestamps
*AgentsApi* | [**v1_platform_delete_agents**](docs/AgentsApi.md#v1_platform_delete_agents) | **POST** /api/platform/v1/agents/delete | Delete Agents
*AgentsApi* | [**v1_platform_get_agents**](docs/AgentsApi.md#v1_platform_get_agents) | **POST** /api/platform/v1/agents | Get Agents
*AgentsLogsApi* | [**search_platform_agent**](docs/AgentsLogsApi.md#search_platform_agent) | **POST** /api/search/platform-agents | Get agents log
*AgentsLogsApi* | [**search_platform_agent_error**](docs/AgentsLogsApi.md#search_platform_agent_error) | **POST** /api/search/platform-agents-errors | Get agents errors log
*ConnectionsApi* | [**platform_connection_agents_destroy**](docs/ConnectionsApi.md#platform_connection_agents_destroy) | **POST** /api/platform/connections/agents/remove | Delete connections
*ConnectionsApi* | [**platform_connection_create_mesh**](docs/ConnectionsApi.md#platform_connection_create_mesh) | **POST** /api/platform/connections/mesh | Create connections (mesh)
*ConnectionsApi* | [**platform_connection_create_p2p**](docs/ConnectionsApi.md#platform_connection_create_p2p) | **POST** /api/platform/connections/point-to-point | Create connections (p2p)
*ConnectionsApi* | [**platform_connection_groups_destroy**](docs/ConnectionsApi.md#platform_connection_groups_destroy) | **POST** /api/platform/connections/groups/remove | Delete connections (groups)
*ConnectionsApi* | [**platform_connection_groups_index**](docs/ConnectionsApi.md#platform_connection_groups_index) | **GET** /api/platform/connections/groups | Get connections (groups)
*ConnectionsApi* | [**platform_connection_groups_sdn_toggle**](docs/ConnectionsApi.md#platform_connection_groups_sdn_toggle) | **PATCH** /api/platform/connections/groups | Toggles SDN for specific connection
*ConnectionsApi* | [**platform_connection_index**](docs/ConnectionsApi.md#platform_connection_index) | **GET** /api/platform/connections | Get connections
*ConnectionsApi* | [**v1_platform_create_connections_mesh**](docs/ConnectionsApi.md#v1_platform_create_connections_mesh) | **POST** /api/platform/v1/connections/mesh | Create Connections Mesh
*ConnectionsApi* | [**v1_platform_create_p2p_connections**](docs/ConnectionsApi.md#v1_platform_create_p2p_connections) | **POST** /api/platform/v1/connections/point-to-point | Create P2P Connections
*ConnectionsApi* | [**v1_platform_delete_connections_groups**](docs/ConnectionsApi.md#v1_platform_delete_connections_groups) | **POST** /api/platform/v1/connections/groups/delete | Delete Connections
*ConnectionsApi* | [**v1_platform_get_connections_groups**](docs/ConnectionsApi.md#v1_platform_get_connections_groups) | **POST** /api/platform/v1/connections/groups | Get Connections
*NetworkApi* | [**platform_network_info**](docs/NetworkApi.md#platform_network_info) | **GET** /api/platform/network/info | Get network
*PublicApi* | [**public_health**](docs/PublicApi.md#public_health) | **GET** /api/public/health | Get health
*PublicApi* | [**public_info**](docs/PublicApi.md#public_info) | **GET** /api/public/info | Get info
*ServicesApi* | [**platform_agent_service_destroy**](docs/ServicesApi.md#platform_agent_service_destroy) | **POST** /api/platform/agent-services-delete | Delete services
*ServicesApi* | [**platform_agent_service_index**](docs/ServicesApi.md#platform_agent_service_index) | **GET** /api/platform/agent-services | Get services
*ServicesApi* | [**platform_agent_service_subnet_update**](docs/ServicesApi.md#platform_agent_service_subnet_update) | **POST** /api/platform/agent-services-subnets | Update service status
*ServicesApi* | [**platform_connection_service_show**](docs/ServicesApi.md#platform_connection_service_show) | **GET** /api/platform/connections/services | Get services
*ServicesApi* | [**platform_connection_service_update**](docs/ServicesApi.md#platform_connection_service_update) | **POST** /api/platform/connections/services | Create services
*ServicesApi* | [**platform_connection_subnet_destroy**](docs/ServicesApi.md#platform_connection_subnet_destroy) | **POST** /api/platform/connections/services/remove | Delete services
*UserApi* | [**setting_create**](docs/UserApi.md#setting_create) | **POST** /api/settings | Update user settings
*UserApi* | [**setting_index**](docs/UserApi.md#setting_index) | **GET** /api/settings | Get user settings
*RulesApi* | [**rules_connection_point_to_tag_create**](docs/RulesApi.md#rules_connection_point_to_tag_create) | **POST** /api/rules/connections/point-to-tag | Create point-to-tag
*RulesApi* | [**rules_connection_point_to_tag_remove**](docs/RulesApi.md#rules_connection_point_to_tag_remove) | **POST** /api/rules/connections/point-to-tag/remove | Remove point-to-tag
*RulesApi* | [**rules_connection_point_to_tag_search**](docs/RulesApi.md#rules_connection_point_to_tag_search) | **POST** /api/rules/connections/point-to-tag/search | Search point-to-tag
*RulesApi* | [**rules_connection_point_to_tag_show_by_id**](docs/RulesApi.md#rules_connection_point_to_tag_show_by_id) | **GET** /api/rules/connections/point-to-tag/{agent_id} | Get point-to-tag
*RulesApi* | [**rules_connection_point_to_tag_update**](docs/RulesApi.md#rules_connection_point_to_tag_update) | **PATCH** /api/rules/connections/point-to-tag | Patch point-to-tag
*RulesApi* | [**rules_search**](docs/RulesApi.md#rules_search) | **POST** /api/rules/search | Search rules

## Documentation For Models

 - [AccessTokenData](docs/AccessTokenData.md)
 - [AccessTokenLoginRequestV1](docs/AccessTokenLoginRequestV1.md)
 - [AccessTokenOrder](docs/AccessTokenOrder.md)
 - [AccessTokenReadData](docs/AccessTokenReadData.md)
 - [AccessTokenWriteData](docs/AccessTokenWriteData.md)
 - [AnyOfApiKeyCreateRequestApiKeyValidUntil](docs/AnyOfApiKeyCreateRequestApiKeyValidUntil.md)
 - [AnyOfApiKeyDtoApiKeyCreatedAt](docs/AnyOfApiKeyDtoApiKeyCreatedAt.md)
 - [AnyOfApiKeyDtoApiKeyUpdatedAt](docs/AnyOfApiKeyDtoApiKeyUpdatedAt.md)
 - [AnyOfApiKeyDtoApiKeyValidUntil](docs/AnyOfApiKeyDtoApiKeyValidUntil.md)
 - [AnyOfApiKeyObjectApiKeyCreatedAt](docs/AnyOfApiKeyObjectApiKeyCreatedAt.md)
 - [AnyOfApiKeyObjectApiKeyUpdatedAt](docs/AnyOfApiKeyObjectApiKeyUpdatedAt.md)
 - [AnyOfApiKeyObjectApiKeyValidUntil](docs/AnyOfApiKeyObjectApiKeyValidUntil.md)
 - [AnyOfAuthResponseV1AzureUserTokenDto_](docs/AnyOfAuthResponseV1AzureUserTokenDto_.md)
 - [AnyOfVerifyMFARequestCode](docs/AnyOfVerifyMFARequestCode.md)
 - [ApiKeyCreateRequest](docs/ApiKeyCreateRequest.md)
 - [ApiKeyDto](docs/ApiKeyDto.md)
 - [ApiKeyId](docs/ApiKeyId.md)
 - [ApiKeyObject](docs/ApiKeyObject.md)
 - [ApiResponseApiKeyDtoArray_](docs/ApiResponseApiKeyDtoArray_.md)
 - [ApiResponseApiKeyObject_](docs/ApiResponseApiKeyObject_.md)
 - [AuthErrorResponseV1](docs/AuthErrorResponseV1.md)
 - [AuthErrorResponseV1Errors](docs/AuthErrorResponseV1Errors.md)
 - [AuthResponseV1AzureUserTokenDto_](docs/AuthResponseV1AzureUserTokenDto_.md)
 - [AuthSource](docs/AuthSource.md)
 - [AuthSuccessResponseV1AzureUserTokenDto_](docs/AuthSuccessResponseV1AzureUserTokenDto_.md)
 - [AzureUserTokenDto](docs/AzureUserTokenDto.md)
 - [CheckMFAForNewSocialAccountRequest](docs/CheckMFAForNewSocialAccountRequest.md)
 - [CheckMFAForNewSocialAccountResponse](docs/CheckMFAForNewSocialAccountResponse.md)
 - [CodeGenerationResponse](docs/CodeGenerationResponse.md)
 - [ConfirmMFARequest](docs/ConfirmMFARequest.md)
 - [ContactRequest](docs/ContactRequest.md)
 - [DisableMFARequest](docs/DisableMFARequest.md)
 - [DisableMFAUsingBackupRequest](docs/DisableMFAUsingBackupRequest.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [MFABackupCode](docs/MFABackupCode.md)
 - [MFACode](docs/MFACode.md)
 - [MfaCodeType](docs/MfaCodeType.md)
 - [PermissionObject](docs/PermissionObject.md)
 - [UserDataResponse](docs/UserDataResponse.md)
 - [UserSettingsObject](docs/UserSettingsObject.md)
 - [VerifyMFARequest](docs/VerifyMFARequest.md)
 - [AdminAgentConfig](docs/AdminAgentConfig.md)
 - [AgentConnGroupAgentObject](docs/AgentConnGroupAgentObject.md)
 - [AgentConnGroupFindAndCountObject](docs/AgentConnGroupFindAndCountObject.md)
 - [AgentConnGroupWithServicesObject](docs/AgentConnGroupWithServicesObject.md)
 - [AgentConnectionAgentAgentTagObject](docs/AgentConnectionAgentAgentTagObject.md)
 - [AgentConnectionAgentObject](docs/AgentConnectionAgentObject.md)
 - [AgentConnectionFindAndCountObject](docs/AgentConnectionFindAndCountObject.md)
 - [AgentConnectionGroupIdObject](docs/AgentConnectionGroupIdObject.md)
 - [AgentConnectionObject](docs/AgentConnectionObject.md)
 - [AgentConnectionStatus](docs/AgentConnectionStatus.md)
 - [AgentConnectionSubnetStatuses](docs/AgentConnectionSubnetStatuses.md)
 - [AgentConnectionSubnetsDeletionObject](docs/AgentConnectionSubnetsDeletionObject.md)
 - [AgentConnectionWithServicesAgent](docs/AgentConnectionWithServicesAgent.md)
 - [AgentConnectionWithServicesAgentAgentServiceSubnets](docs/AgentConnectionWithServicesAgentAgentServiceSubnets.md)
 - [AgentConnectionWithServicesAgentAgentServices](docs/AgentConnectionWithServicesAgentAgentServices.md)
 - [AgentCoordinatesObject](docs/AgentCoordinatesObject.md)
 - [AgentCreateAgentObject](docs/AgentCreateAgentObject.md)
 - [AgentFiltersObject](docs/AgentFiltersObject.md)
 - [AgentFoundAndCountObject](docs/AgentFoundAndCountObject.md)
 - [AgentInterfaceBwObject](docs/AgentInterfaceBwObject.md)
 - [AgentInterfaceMetadata](docs/AgentInterfaceMetadata.md)
 - [AgentInterfaceModelObject](docs/AgentInterfaceModelObject.md)
 - [AgentInterfaceObject](docs/AgentInterfaceObject.md)
 - [AgentInterfacesMetadata](docs/AgentInterfacesMetadata.md)
 - [AgentLockedFields](docs/AgentLockedFields.md)
 - [AgentMessagePayload](docs/AgentMessagePayload.md)
 - [AgentMessageType](docs/AgentMessageType.md)
 - [AgentNetworkObject](docs/AgentNetworkObject.md)
 - [AgentObject](docs/AgentObject.md)
 - [AgentPathObject](docs/AgentPathObject.md)
 - [AgentProvider](docs/AgentProvider.md)
 - [AgentProviderObject](docs/AgentProviderObject.md)
 - [AgentProviderOrderString](docs/AgentProviderOrderString.md)
 - [AgentServiceGetServicesByAgentIdUserIdObject](docs/AgentServiceGetServicesByAgentIdUserIdObject.md)
 - [AgentServiceTypes](docs/AgentServiceTypes.md)
 - [AgentServicesDeletionObject](docs/AgentServicesDeletionObject.md)
 - [AgentServicesUpdateChangesObject](docs/AgentServicesUpdateChangesObject.md)
 - [AgentSuccessResponse](docs/AgentSuccessResponse.md)
 - [AgentTagModelObject](docs/AgentTagModelObject.md)
 - [AgentVersion](docs/AgentVersion.md)
 - [AgentWgConfig](docs/AgentWgConfig.md)
 - [AgentsCoordinatesBody](docs/AgentsCoordinatesBody.md)
 - [AgentsObject](docs/AgentsObject.md)
 - [AgentsPairObject](docs/AgentsPairObject.md)
 - [AllOfUserAgentPatchObjectAgentLocationCity](docs/AllOfUserAgentPatchObjectAgentLocationCity.md)
 - [AllOfUserAgentPatchObjectAgentLocationCountry](docs/AllOfUserAgentPatchObjectAgentLocationCountry.md)
 - [AllOfUserAgentPatchObjectAgentLocationLat](docs/AllOfUserAgentPatchObjectAgentLocationLat.md)
 - [AllOfUserAgentPatchObjectAgentLocationLon](docs/AllOfUserAgentPatchObjectAgentLocationLon.md)
 - [AllOfUserAgentPatchObjectAgentProviderId](docs/AllOfUserAgentPatchObjectAgentProviderId.md)
 - [AnyOfAgentMessagePayload](docs/AnyOfAgentMessagePayload.md)
 - [AnyOfConnectionCreationBodyAgentIds](docs/AnyOfConnectionCreationBodyAgentIds.md)
 - [AnyOfGetAgentsRequestOrderV1](docs/AnyOfGetAgentsRequestOrderV1.md)
 - [AnyOfGetConnectionsGroupsRequestOrderV1](docs/AnyOfGetConnectionsGroupsRequestOrderV1.md)
 - [AnyOfPlatformResponseErrorItemValue](docs/AnyOfPlatformResponseErrorItemValue.md)
 - [AnyOfPlatformResponseV1GetAgentsResponseV1_](docs/AnyOfPlatformResponseV1GetAgentsResponseV1_.md)
 - [AnyOfPlatformResponseV1GetConnectionsGroupsResponseV1_](docs/AnyOfPlatformResponseV1GetConnectionsGroupsResponseV1_.md)
 - [AnyOfVppCallableObject](docs/AnyOfVppCallableObject.md)
 - [AnyOfWgCallableObject](docs/AnyOfWgCallableObject.md)
 - [ApiKeyObject](docs/ApiKeyObject.md)
 - [AutoPingPayload](docs/AutoPingPayload.md)
 - [BaseRequestOrderV1](docs/BaseRequestOrderV1.md)
 - [BehaviorType](docs/BehaviorType.md)
 - [BiStatistics](docs/BiStatistics.md)
 - [BiStatisticsEdgesPost](docs/BiStatisticsEdgesPost.md)
 - [ChangePathObject](docs/ChangePathObject.md)
 - [ChangePathObjectData](docs/ChangePathObjectData.md)
 - [ChangePathObjectDataCosts](docs/ChangePathObjectDataCosts.md)
 - [ColorObject](docs/ColorObject.md)
 - [ConnGroupSdnChangeObject](docs/ConnGroupSdnChangeObject.md)
 - [ConnGroupSdnToggleObject](docs/ConnGroupSdnToggleObject.md)
 - [ConnectionCreationBody](docs/ConnectionCreationBody.md)
 - [ConnectionCreationBodyMesh](docs/ConnectionCreationBodyMesh.md)
 - [ConnectionCreationBodyP2p](docs/ConnectionCreationBodyP2p.md)
 - [ConnectionGroupServicesUpdateObject](docs/ConnectionGroupServicesUpdateObject.md)
 - [ConstraintEnum](docs/ConstraintEnum.md)
 - [ContentObject](docs/ContentObject.md)
 - [ContextType](docs/ContextType.md)
 - [CreateConnectionsMeshRequestV1](docs/CreateConnectionsMeshRequestV1.md)
 - [CreateP2pConnectionsRequestV1](docs/CreateP2pConnectionsRequestV1.md)
 - [CreateP2pConnectionsRequestV1AgentPairs](docs/CreateP2pConnectionsRequestV1AgentPairs.md)
 - [DefaultString](docs/DefaultString.md)
 - [DeleteAgentsRequestV1](docs/DeleteAgentsRequestV1.md)
 - [DeleteAgentsRequestV1Inner](docs/DeleteAgentsRequestV1Inner.md)
 - [DeleteConnectionsGroupsRequestV1](docs/DeleteConnectionsGroupsRequestV1.md)
 - [DeleteConnectionsGroupsRequestV1Inner](docs/DeleteConnectionsGroupsRequestV1Inner.md)
 - [GetAgentsRequestFilterAgentStatusV1](docs/GetAgentsRequestFilterAgentStatusV1.md)
 - [GetAgentsRequestFilterAgentTypeV1](docs/GetAgentsRequestFilterAgentTypeV1.md)
 - [GetAgentsRequestFilterV1](docs/GetAgentsRequestFilterV1.md)
 - [GetAgentsRequestOrderV1](docs/GetAgentsRequestOrderV1.md)
 - [GetAgentsRequestV1](docs/GetAgentsRequestV1.md)
 - [GetAgentsResponseV1](docs/GetAgentsResponseV1.md)
 - [GetAgentsResponseV1Inner](docs/GetAgentsResponseV1Inner.md)
 - [GetConnectionsGroupsAgentResponseV1](docs/GetConnectionsGroupsAgentResponseV1.md)
 - [GetConnectionsGroupsRequestFilterV1](docs/GetConnectionsGroupsRequestFilterV1.md)
 - [GetConnectionsGroupsRequestOrderV1](docs/GetConnectionsGroupsRequestOrderV1.md)
 - [GetConnectionsGroupsRequestV1](docs/GetConnectionsGroupsRequestV1.md)
 - [GetConnectionsGroupsResponseV1](docs/GetConnectionsGroupsResponseV1.md)
 - [GetConnectionsGroupsResponseV1Inner](docs/GetConnectionsGroupsResponseV1Inner.md)
 - [IdNumber](docs/IdNumber.md)
 - [InterfaceObject](docs/InterfaceObject.md)
 - [InterfaceType](docs/InterfaceType.md)
 - [Ipv4](docs/Ipv4.md)
 - [LanguageObject](docs/LanguageObject.md)
 - [Latitude](docs/Latitude.md)
 - [LinkObject](docs/LinkObject.md)
 - [LinkTag](docs/LinkTag.md)
 - [LogsReadTimestampEntityTypes](docs/LogsReadTimestampEntityTypes.md)
 - [LogsReadTimestampObject](docs/LogsReadTimestampObject.md)
 - [Longitude](docs/Longitude.md)
 - [NetworkInfoAgent](docs/NetworkInfoAgent.md)
 - [NetworkInfoAgentConnectionGroupsObject](docs/NetworkInfoAgentConnectionGroupsObject.md)
 - [NetworkInfoObject](docs/NetworkInfoObject.md)
 - [OrderString](docs/OrderString.md)
 - [PlatformAgentStatus](docs/PlatformAgentStatus.md)
 - [PlatformAgentTypeLocal](docs/PlatformAgentTypeLocal.md)
 - [PlatformAgentsBodyObject](docs/PlatformAgentsBodyObject.md)
 - [PlatformAgentsErrorBody](docs/PlatformAgentsErrorBody.md)
 - [PlatformAgentsErrorResponse](docs/PlatformAgentsErrorResponse.md)
 - [PlatformAgentsErrorResponseHits](docs/PlatformAgentsErrorResponseHits.md)
 - [PlatformAgentsHitObject](docs/PlatformAgentsHitObject.md)
 - [PlatformAgentsHitObjectSource](docs/PlatformAgentsHitObjectSource.md)
 - [PlatformErrorResponseV1](docs/PlatformErrorResponseV1.md)
 - [PlatformErrorResponseV1Errors](docs/PlatformErrorResponseV1Errors.md)
 - [PlatformResponseAdminAgentConfig_](docs/PlatformResponseAdminAgentConfig_.md)
 - [PlatformResponseAgentConnGroupFindAndCountObjectArray_](docs/PlatformResponseAgentConnGroupFindAndCountObjectArray_.md)
 - [PlatformResponseAgentConnGroupWithServicesObjectArray_](docs/PlatformResponseAgentConnGroupWithServicesObjectArray_.md)
 - [PlatformResponseAgentConnectionFindAndCountObjectArray_](docs/PlatformResponseAgentConnectionFindAndCountObjectArray_.md)
 - [PlatformResponseAgentCoordinatesObjectArray_](docs/PlatformResponseAgentCoordinatesObjectArray_.md)
 - [PlatformResponseAgentCreateAgentObject_](docs/PlatformResponseAgentCreateAgentObject_.md)
 - [PlatformResponseAgentFiltersObject_](docs/PlatformResponseAgentFiltersObject_.md)
 - [PlatformResponseAgentFoundAndCountObjectArray_](docs/PlatformResponseAgentFoundAndCountObjectArray_.md)
 - [PlatformResponseAgentProviderArray_](docs/PlatformResponseAgentProviderArray_.md)
 - [PlatformResponseAgentProvider_](docs/PlatformResponseAgentProvider_.md)
 - [PlatformResponseAgentServiceGetServicesByAgentIdUserIdObjectArray_](docs/PlatformResponseAgentServiceGetServicesByAgentIdUserIdObjectArray_.md)
 - [PlatformResponseAgentSuccessResponse_](docs/PlatformResponseAgentSuccessResponse_.md)
 - [PlatformResponseAgentTagModelObjectArray_](docs/PlatformResponseAgentTagModelObjectArray_.md)
 - [PlatformResponseAgentWgConfig_](docs/PlatformResponseAgentWgConfig_.md)
 - [PlatformResponseApiKeyObjectArray_](docs/PlatformResponseApiKeyObjectArray_.md)
 - [PlatformResponseApiKeyObject_](docs/PlatformResponseApiKeyObject_.md)
 - [PlatformResponseErrorItem](docs/PlatformResponseErrorItem.md)
 - [PlatformResponseNetworkInfoObject_](docs/PlatformResponseNetworkInfoObject_.md)
 - [PlatformResponseSuccessBoolean_](docs/PlatformResponseSuccessBoolean_.md)
 - [PlatformResponseSuccessbooleanData](docs/PlatformResponseSuccessbooleanData.md)
 - [PlatformResponseV1GetAgentsResponseV1_](docs/PlatformResponseV1GetAgentsResponseV1_.md)
 - [PlatformResponseV1GetConnectionsGroupsResponseV1_](docs/PlatformResponseV1GetConnectionsGroupsResponseV1_.md)
 - [PlatformSuccessResponseV1GetAgentsResponseV1_](docs/PlatformSuccessResponseV1GetAgentsResponseV1_.md)
 - [PlatformSuccessResponseV1GetConnectionsGroupsResponseV1_](docs/PlatformSuccessResponseV1GetConnectionsGroupsResponseV1_.md)
 - [Port](docs/Port.md)
 - [ProviderObject](docs/ProviderObject.md)
 - [PublicAppInfoObject](docs/PublicAppInfoObject.md)
 - [PublicLanguageObject](docs/PublicLanguageObject.md)
 - [PublicLanguagesObject](docs/PublicLanguagesObject.md)
 - [PublicLinkObject](docs/PublicLinkObject.md)
 - [PublicLinksLangCodeObject](docs/PublicLinksLangCodeObject.md)
 - [PublicLinksObject](docs/PublicLinksObject.md)
 - [PublicTranslationObject](docs/PublicTranslationObject.md)
 - [PublicTranslationsLangCodeObject](docs/PublicTranslationsLangCodeObject.md)
 - [PublicTranslationsObject](docs/PublicTranslationsObject.md)
 - [PublicVersionsObject](docs/PublicVersionsObject.md)
 - [RegionObject](docs/RegionObject.md)
 - [ResetServerObject](docs/ResetServerObject.md)
 - [RestartAgentObject](docs/RestartAgentObject.md)
 - [RouteObject](docs/RouteObject.md)
 - [S3ObjectListItem](docs/S3ObjectListItem.md)
 - [S3ObjectListItemOwner](docs/S3ObjectListItemOwner.md)
 - [S3SendData](docs/S3SendData.md)
 - [SdnPathsV1](docs/SdnPathsV1.md)
 - [ServerAgentStatus](docs/ServerAgentStatus.md)
 - [ServerObject](docs/ServerObject.md)
 - [ServerSrSoftware](docs/ServerSrSoftware.md)
 - [SettingReadObject](docs/SettingReadObject.md)
 - [SettingWriteObject](docs/SettingWriteObject.md)
 - [SettingsTypes](docs/SettingsTypes.md)
 - [ShowSdnConnections](docs/ShowSdnConnections.md)
 - [SkipNumber](docs/SkipNumber.md)
 - [SkipNumberV1](docs/SkipNumberV1.md)
 - [SrPathObject](docs/SrPathObject.md)
 - [SrPolicyObject](docs/SrPolicyObject.md)
 - [Status](docs/Status.md)
 - [TakeNumber](docs/TakeNumber.md)
 - [TakeNumberV1](docs/TakeNumberV1.md)
 - [TopologyObject](docs/TopologyObject.md)
 - [TranslationObject](docs/TranslationObject.md)
 - [TsoaAgentConfigInfoNetwork](docs/TsoaAgentConfigInfoNetwork.md)
 - [TsoaAgentConfigInfoNetworkPUBLIC](docs/TsoaAgentConfigInfoNetworkPUBLIC.md)
 - [TsoaOmitAgentInterfaceAgent_](docs/TsoaOmitAgentInterfaceAgent_.md)
 - [TsoaOmitAgentServiceModelAgentOrAgentServiceSubnets_](docs/TsoaOmitAgentServiceModelAgentOrAgentServiceSubnets_.md)
 - [TsoaOmitAgentServiceSubnetAgentServiceOrAgentNetworkOrAgentOrAgentConnectionSubnets_](docs/TsoaOmitAgentServiceSubnetAgentServiceOrAgentNetworkOrAgentOrAgentConnectionSubnets_.md)
 - [TsoaPartialAgentConnectionObject_](docs/TsoaPartialAgentConnectionObject_.md)
 - [TsoaPartialAgentInterfaceBwObject_](docs/TsoaPartialAgentInterfaceBwObject_.md)
 - [TsoaPartialAgentInterfaceObject_](docs/TsoaPartialAgentInterfaceObject_.md)
 - [TsoaPartialAgentNetworkObject_](docs/TsoaPartialAgentNetworkObject_.md)
 - [TsoaPartialAgentObject_](docs/TsoaPartialAgentObject_.md)
 - [TsoaPartialAgentPathObject_](docs/TsoaPartialAgentPathObject_.md)
 - [TsoaPartialAgentProviderObject_](docs/TsoaPartialAgentProviderObject_.md)
 - [TsoaPartialApiKeyObject_](docs/TsoaPartialApiKeyObject_.md)
 - [TsoaPartialColorObject_](docs/TsoaPartialColorObject_.md)
 - [TsoaPartialContentObject_](docs/TsoaPartialContentObject_.md)
 - [TsoaPartialInterfaceObject_](docs/TsoaPartialInterfaceObject_.md)
 - [TsoaPartialLanguageObject_](docs/TsoaPartialLanguageObject_.md)
 - [TsoaPartialLinkObject_](docs/TsoaPartialLinkObject_.md)
 - [TsoaPartialProviderObject_](docs/TsoaPartialProviderObject_.md)
 - [TsoaPartialRegionObject_](docs/TsoaPartialRegionObject_.md)
 - [TsoaPartialRouteObject_](docs/TsoaPartialRouteObject_.md)
 - [TsoaPartialServerObject_](docs/TsoaPartialServerObject_.md)
 - [TsoaPartialTopologyObject_](docs/TsoaPartialTopologyObject_.md)
 - [TsoaPartialTranslationObject_](docs/TsoaPartialTranslationObject_.md)
 - [TsoaPartialTunnelObject_](docs/TsoaPartialTunnelObject_.md)
 - [TsoaPartialUserSrObject_](docs/TsoaPartialUserSrObject_.md)
 - [TsoaPartialVersionObject_](docs/TsoaPartialVersionObject_.md)
 - [TsoaPartialVpnObject_](docs/TsoaPartialVpnObject_.md)
 - [TsoaPickAgentAgentIdOrAgentLocationLatOrAgentLocationLon_](docs/TsoaPickAgentAgentIdOrAgentLocationLatOrAgentLocationLon_.md)
 - [TsoaPickAgentAgentLocationCountry_](docs/TsoaPickAgentAgentLocationCountry_.md)
 - [TsoaPickAgentAgentNameOrAgentId_](docs/TsoaPickAgentAgentNameOrAgentId_.md)
 - [TsoaPickAgentAgentVersion_](docs/TsoaPickAgentAgentVersion_.md)
 - [TsoaPickAgentConnectionGroupAgentConnectionGroupId_](docs/TsoaPickAgentConnectionGroupAgentConnectionGroupId_.md)
 - [TsoaPickAgentConnectionGroupOrAgentConnectionGroupIdOrAgentConnectionGroupUpdatedAtOrAgentConnectionGroupSdnEnabledOrAgentConnectionGroupCreatedBy_](docs/TsoaPickAgentConnectionGroupOrAgentConnectionGroupIdOrAgentConnectionGroupUpdatedAtOrAgentConnectionGroupSdnEnabledOrAgentConnectionGroupCreatedBy_.md)
 - [TsoaPickAgentConnectionOrAgentConnectionIdOrAgentConnectionUpdatedAtOrAgentConnectionLinkTagOrAgentConnectionStatusOrAgentConnectionStatusReason_](docs/TsoaPickAgentConnectionOrAgentConnectionIdOrAgentConnectionUpdatedAtOrAgentConnectionLinkTagOrAgentConnectionStatusOrAgentConnectionStatusReason_.md)
 - [TsoaPickAgentConnectionSubnetOrAgentConnectionSubnetIdOrAgentServiceSubnetIdOrAgentConnectionSubnetIsEnabledOrAgentConnectionSubnetErrorOrAgentConnectionSubnetStatus_](docs/TsoaPickAgentConnectionSubnetOrAgentConnectionSubnetIdOrAgentServiceSubnetIdOrAgentConnectionSubnetIsEnabledOrAgentConnectionSubnetErrorOrAgentConnectionSubnetStatus_.md)
 - [TsoaPickAgentInterfaceExcludeKeyofAgentInterfaceAgent_](docs/TsoaPickAgentInterfaceExcludeKeyofAgentInterfaceAgent_.md)
 - [TsoaPickAgentOrAgentIdOrAgentPublicIpv4OrAgentLocationCityOrAgentLockedFieldsOrAgentNameOrAgentTypeOrAgentVersionOrAgentModifiedAtOrAgentStatusOrAgentIsOnlineOrAgentIsVirtual_](docs/TsoaPickAgentOrAgentIdOrAgentPublicIpv4OrAgentLocationCityOrAgentLockedFieldsOrAgentNameOrAgentTypeOrAgentVersionOrAgentModifiedAtOrAgentStatusOrAgentIsOnlineOrAgentIsVirtual_.md)
 - [TsoaPickAgentProviderAgentProviderNameOrAgentProviderId_](docs/TsoaPickAgentProviderAgentProviderNameOrAgentProviderId_.md)
 - [TsoaPickAgentServiceModelExcludeKeyofAgentServiceModelAgentOrAgentServiceSubnets_](docs/TsoaPickAgentServiceModelExcludeKeyofAgentServiceModelAgentOrAgentServiceSubnets_.md)
 - [TsoaPickAgentServiceSubnetExcludeKeyofAgentServiceSubnetAgentServiceOrAgentNetworkOrAgentOrAgentConnectionSubnets_](docs/TsoaPickAgentServiceSubnetExcludeKeyofAgentServiceSubnetAgentServiceOrAgentNetworkOrAgentOrAgentConnectionSubnets_.md)
 - [TsoaPickAgentTagAgentTagIdOrAgentTagName_](docs/TsoaPickAgentTagAgentTagIdOrAgentTagName_.md)
 - [TsoaPickAgentTagAgentTagIdOrUserIdOrAgentTagName_](docs/TsoaPickAgentTagAgentTagIdOrUserIdOrAgentTagName_.md)
 - [TsoaPickAgentTagAgentTagNameOrAgentTagId_](docs/TsoaPickAgentTagAgentTagNameOrAgentTagId_.md)
 - [TunnelObject](docs/TunnelObject.md)
 - [UpdateStatusBody](docs/UpdateStatusBody.md)
 - [UpdateStatusBodySubnetsToUpdate](docs/UpdateStatusBodySubnetsToUpdate.md)
 - [UserAdminObject](docs/UserAdminObject.md)
 - [UserAgentCreateObject](docs/UserAgentCreateObject.md)
 - [UserAgentPatchObject](docs/UserAgentPatchObject.md)
 - [UserApiKeyCreateObject](docs/UserApiKeyCreateObject.md)
 - [UserSettings](docs/UserSettings.md)
 - [UserSrDirection](docs/UserSrDirection.md)
 - [UserSrObject](docs/UserSrObject.md)
 - [VersionObject](docs/VersionObject.md)
 - [VersionType](docs/VersionType.md)
 - [VisibilityType](docs/VisibilityType.md)
 - [VpnObject](docs/VpnObject.md)
 - [VppCallableObject](docs/VppCallableObject.md)
 - [VppCallableObjectArgs](docs/VppCallableObjectArgs.md)
 - [VppCallableObjectArgs1](docs/VppCallableObjectArgs1.md)
 - [VppCallableObjectArgs10](docs/VppCallableObjectArgs10.md)
 - [VppCallableObjectArgs11](docs/VppCallableObjectArgs11.md)
 - [VppCallableObjectArgs12](docs/VppCallableObjectArgs12.md)
 - [VppCallableObjectArgs13](docs/VppCallableObjectArgs13.md)
 - [VppCallableObjectArgs14](docs/VppCallableObjectArgs14.md)
 - [VppCallableObjectArgs15](docs/VppCallableObjectArgs15.md)
 - [VppCallableObjectArgs16](docs/VppCallableObjectArgs16.md)
 - [VppCallableObjectArgs2](docs/VppCallableObjectArgs2.md)
 - [VppCallableObjectArgs3](docs/VppCallableObjectArgs3.md)
 - [VppCallableObjectArgs4](docs/VppCallableObjectArgs4.md)
 - [VppCallableObjectArgs5](docs/VppCallableObjectArgs5.md)
 - [VppCallableObjectArgs6](docs/VppCallableObjectArgs6.md)
 - [VppCallableObjectArgs7](docs/VppCallableObjectArgs7.md)
 - [VppCallableObjectArgs8](docs/VppCallableObjectArgs8.md)
 - [VppCallableObjectArgs9](docs/VppCallableObjectArgs9.md)
 - [WgAddPeer](docs/WgAddPeer.md)
 - [WgAddPeerArgs](docs/WgAddPeerArgs.md)
 - [WgAddPeerMetadata](docs/WgAddPeerMetadata.md)
 - [WgAddPeerMetadataAllowedIpsInfo](docs/WgAddPeerMetadataAllowedIpsInfo.md)
 - [WgCallableObject](docs/WgCallableObject.md)
 - [WgCreateInterface](docs/WgCreateInterface.md)
 - [WgCreateInterfaceArgs](docs/WgCreateInterfaceArgs.md)
 - [WgCreateInterfaceMetadata](docs/WgCreateInterfaceMetadata.md)
 - [WgKeypairObject](docs/WgKeypairObject.md)
 - [WgPublicKey](docs/WgPublicKey.md)
 - [WgRemoveInterface](docs/WgRemoveInterface.md)
 - [WgRemoveInterfaceArgs](docs/WgRemoveInterfaceArgs.md)
 - [WgRemovePeer](docs/WgRemovePeer.md)
 - [WgRemovePeerArgs](docs/WgRemovePeerArgs.md)
 - [WhereString](docs/WhereString.md)
 - [ConnectionsPointtotagBody](docs/ConnectionsPointtotagBody.md)
 - [PointtotagPointToTag](docs/PointtotagPointToTag.md)
 - [PointtotagResponse](docs/PointtotagResponse.md)
 - [PointtotagSearchFilter](docs/PointtotagSearchFilter.md)
 - [PointtotagSearchRequest](docs/PointtotagSearchRequest.md)
 - [PointtotagSearchResponse](docs/PointtotagSearchResponse.md)
 - [RulesRequest](docs/RulesRequest.md)
 - [RulesRequestFilter](docs/RulesRequestFilter.md)
 - [RulesResponse](docs/RulesResponse.md)
 - [RulesSimpleRuleLine](docs/RulesSimpleRuleLine.md)
 - [TypesErrorMsg](docs/TypesErrorMsg.md)
 - [TypesErrorResponse](docs/TypesErrorResponse.md)

## Documentation For Authorization
In order to use this SDK you must have a valid API Authorization token.
This token can be obtained either by using `AuthApi.local` method or using the UI.
This token should be passed to the configuration object like so:

```Python
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
```

## jwt

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author


