"""This module implements the Json Web Algorithms as defined in [RFC7518].

Each algorithm is represented as a wrapper around a symmetric or asymmetric key, and exposes the
cryptographic operations as methods. The cryptographic operations themselves are delegated to
`cryptography`.

[RFC7518]: https://www.rfc-editor.org/rfc/rfc7518
"""

from .base import (
    BaseAESEncryptionAlg,
    BaseAlg,
    BaseAsymmetricAlg,
    BaseKeyManagementAlg,
    BaseSignatureAlg,
    BaseSymmetricAlg,
    MismatchingAuthTag,
    PrivateKeyRequired,
    PublicKeyRequired,
)
from .ec import P_256, P_384, P_521, EllipticCurve, secp256k1
from .encryption import (
    A128CBC_HS256,
    A128GCM,
    A192CBC_HS384,
    A192GCM,
    A256CBC_HS512,
    A256GCM,
)
from .key_mgmt import (
    A128GCMKW,
    A128KW,
    A192GCMKW,
    A192KW,
    A256GCMKW,
    A256KW,
    BaseAesGcmKeyWrap,
    BaseAesKeyWrap,
    BaseEcdhEs_AesKw,
    BasePbes2,
    BaseRsaKeyWrap,
    DirectKeyUse,
    EcdhEs,
    EcdhEs_A128KW,
    EcdhEs_A192KW,
    EcdhEs_A256KW,
    Pbes2_HS256_A128KW,
    Pbes2_HS384_A192KW,
    Pbes2_HS512_A256KW,
    RsaEsOaep,
    RsaEsOaepSha256,
    RsaEsOaepSha384,
    RsaEsOaepSha512,
    RsaEsPcks1v1_5,
)
from .okp import X448, X25519, Ed448, Ed25519, OKPCurve
from .signature import (
    ES256,
    ES256K,
    ES384,
    ES512,
    HS256,
    HS384,
    HS512,
    PS256,
    PS384,
    PS512,
    RS256,
    RS384,
    RS512,
    BaseECSignatureAlg,
    BaseHMACSigAlg,
    BaseRSASigAlg,
    EdDsa,
)

__all__ = [
    "A128CBC_HS256",
    "A128GCM",
    "A128GCMKW",
    "A128KW",
    "A192CBC_HS384",
    "A192GCM",
    "A192GCMKW",
    "A192KW",
    "A256CBC_HS512",
    "A256GCM",
    "A256GCMKW",
    "A256KW",
    "BaseAESEncryptionAlg",
    "BaseAesGcmKeyWrap",
    "BaseAesKeyWrap",
    "BaseAlg",
    "BaseAsymmetricAlg",
    "BaseEcdhEs_AesKw",
    "BaseECSignatureAlg",
    "BaseHMACSigAlg",
    "BaseKeyManagementAlg",
    "BasePbes2",
    "BaseRsaKeyWrap",
    "BaseRSASigAlg",
    "BaseSignatureAlg",
    "BaseSymmetricAlg",
    "DirectKeyUse",
    "ES256",
    "ES256K",
    "ES384",
    "ES512",
    "EcdhEs",
    "EcdhEs_A128KW",
    "EcdhEs_A192KW",
    "EcdhEs_A256KW",
    "Ed25519",
    "Ed448",
    "EdDsa",
    "EllipticCurve",
    "HS256",
    "HS384",
    "HS512",
    "MismatchingAuthTag",
    "OKPCurve",
    "PS256",
    "PS384",
    "PS512",
    "P_256",
    "P_384",
    "P_521",
    "Pbes2_HS256_A128KW",
    "Pbes2_HS384_A192KW",
    "Pbes2_HS512_A256KW",
    "PrivateKeyRequired",
    "PublicKeyRequired",
    "RS256",
    "RS384",
    "RS512",
    "RsaEsOaep",
    "RsaEsOaepSha256",
    "RsaEsOaepSha384",
    "RsaEsOaepSha512",
    "RsaEsPcks1v1_5",
    "X25519",
    "X448",
    "secp256k1",
]
