"""Main module for `jwskate`.

The `jwskate` module implements the various Json Web Crypto-related
standards: JWA, JWK, JWKS, JWE, JWT. Each standard has its own submodule, but
for convenience, you can import any class or component directly from the root
`jwskate` module.

`jwskate` doesn't implement any actual cryptographic operation, it just
provides a set of convenient wrappers around the `cryptography` module.
"""

__author__ = """Guillaume Pujol"""
__email__ = "guill.p.linux@gmail.com"

from .enums import EncryptionAlgs, KeyManagementAlgs, SignatureAlgs
from .jwa import (
    A128CBC_HS256,
    A128GCM,
    A128GCMKW,
    A128KW,
    A192CBC_HS384,
    A192GCM,
    A192GCMKW,
    A192KW,
    A256CBC_HS512,
    A256GCM,
    A256GCMKW,
    A256KW,
    ES256,
    ES256K,
    ES384,
    ES512,
    HS256,
    HS384,
    HS512,
    P_256,
    P_384,
    P_521,
    PS256,
    PS384,
    PS512,
    RS256,
    RS384,
    RS512,
    X448,
    X25519,
    BaseAESEncryptionAlg,
    BaseAlg,
    BaseAsymmetricAlg,
    BaseEcdhEs_AesKw,
    BaseKeyManagementAlg,
    BasePbes2,
    BaseRsaKeyWrap,
    BaseSignatureAlg,
    BaseSymmetricAlg,
    DirectKeyUse,
    EcdhEs,
    EcdhEs_A128KW,
    EcdhEs_A192KW,
    EcdhEs_A256KW,
    Ed448,
    Ed25519,
    EdDsa,
    EllipticCurve,
    MismatchingAuthTag,
    OKPCurve,
    Pbes2_HS256_A128KW,
    Pbes2_HS384_A192KW,
    Pbes2_HS512_A256KW,
    PrivateKeyRequired,
    PublicKeyRequired,
    RsaEsOaep,
    RsaEsOaepSha256,
    RsaEsOaepSha384,
    RsaEsOaepSha512,
    RsaEsPcks1v1_5,
    secp256k1,
)
from .jwe import InvalidJwe, JweCompact
from .jwk import (
    ECJwk,
    ExpectedAlgRequired,
    InvalidJwk,
    Jwk,
    JwkSet,
    OKPJwk,
    RSAJwk,
    SymmetricJwk,
    UnsupportedAlg,
    UnsupportedEllipticCurve,
    UnsupportedKeyType,
    UnsupportedOKPCurve,
    select_alg_class,
    select_alg_classes,
    to_jwk,
)
from .jws import InvalidJws, JwsCompact, JwsJsonFlat, JwsJsonGeneral
from .jwt import (
    ExpiredJwt,
    InvalidClaim,
    InvalidJwt,
    InvalidSignature,
    Jwt,
    JwtSigner,
    SignedJwt,
)

__all__ = [
    "A128CBC_HS256",
    "A128GCM",
    "A128GCMKW",
    "A128KW",
    "A192CBC_HS384",
    "A192GCM",
    "A192GCMKW",
    "A192KW",
    "A256CBC_HS512",
    "A256GCM",
    "A256GCMKW",
    "A256KW",
    "BaseAESEncryptionAlg",
    "BaseAlg",
    "BaseAsymmetricAlg",
    "BaseEcdhEs_AesKw",
    "BaseKeyManagementAlg",
    "BasePbes2",
    "BaseRsaKeyWrap",
    "BaseSignatureAlg",
    "BaseSymmetricAlg",
    "DirectKeyUse",
    "ECJwk",
    "ES256",
    "ES256K",
    "ES384",
    "ES512",
    "EcdhEs",
    "EcdhEs_A128KW",
    "EcdhEs_A192KW",
    "EcdhEs_A256KW",
    "Ed25519",
    "Ed448",
    "EdDsa",
    "EllipticCurve",
    "EncryptionAlgs",
    "ExpectedAlgRequired",
    "ExpiredJwt",
    "HS256",
    "HS384",
    "HS512",
    "InvalidClaim",
    "InvalidJwe",
    "InvalidJwk",
    "InvalidJws",
    "InvalidJwt",
    "InvalidSignature",
    "JweCompact",
    "Jwk",
    "JwkSet",
    "JwsCompact",
    "JwsJsonFlat",
    "JwsJsonGeneral",
    "Jwt",
    "JwtSigner",
    "KeyManagementAlgs",
    "MismatchingAuthTag",
    "OKPCurve",
    "OKPJwk",
    "PS256",
    "PS384",
    "PS512",
    "P_256",
    "P_384",
    "P_521",
    "Pbes2_HS256_A128KW",
    "Pbes2_HS384_A192KW",
    "Pbes2_HS512_A256KW",
    "PrivateKeyRequired",
    "PublicKeyRequired",
    "RS256",
    "RS384",
    "RS512",
    "RSAJwk",
    "RsaEsOaep",
    "RsaEsOaepSha256",
    "RsaEsOaepSha384",
    "RsaEsOaepSha512",
    "RsaEsPcks1v1_5",
    "SignatureAlgs",
    "SignedJwt",
    "SymmetricJwk",
    "UnsupportedAlg",
    "UnsupportedEllipticCurve",
    "UnsupportedKeyType",
    "UnsupportedOKPCurve",
    "X25519",
    "X448",
    "secp256k1",
    "select_alg_class",
    "select_alg_classes",
    "to_jwk",
]
