"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Execution = exports.ExecutionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const oos_generated_1 = require("./oos.generated");
Object.defineProperty(exports, "ExecutionProperty", { enumerable: true, get: function () { return oos_generated_1.RosExecution; } });
/**
 * A ROS resource type:  `ALIYUN::OOS::Execution`
 */
class Execution extends ros.Resource {
    /**
     * Create a new `ALIYUN::OOS::Execution`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosExecution = new oos_generated_1.RosExecution(this, id, {
            parentExecutionId: props.parentExecutionId,
            resourceOptions: props.resourceOptions,
            parameters: props.parameters,
            safetyCheck: props.safetyCheck === undefined || props.safetyCheck === null ? 'ConfirmEveryHighRiskAction' : props.safetyCheck,
            mode: props.mode === undefined || props.mode === null ? 'Automatic' : props.mode,
            templateName: props.templateName,
            templateVersion: props.templateVersion,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosExecution;
        this.attrCounters = rosExecution.attrCounters;
        this.attrCurlCli = rosExecution.attrCurlCli;
        this.attrExecutionId = rosExecution.attrExecutionId;
        this.attrOutputs = rosExecution.attrOutputs;
        this.attrPowerShellCurlCli = rosExecution.attrPowerShellCurlCli;
        this.attrStatus = rosExecution.attrStatus;
        this.attrStatusMessage = rosExecution.attrStatusMessage;
        this.attrWindowsCurlCli = rosExecution.attrWindowsCurlCli;
    }
}
exports.Execution = Execution;
//# sourceMappingURL=data:application/json;base64,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