import sys

from aiokeydb.client import KeyDB, StrictKeyDB
from aiokeydb.cluster import KeyDBCluster
from aiokeydb.connection import (
    BlockingConnectionPool,
    Connection,
    ConnectionPool,
    SSLConnection,
    UnixDomainSocketConnection,
)
from aiokeydb.exceptions import (
    AuthenticationError,
    AuthenticationWrongNumberOfArgsError,
    BusyLoadingError,
    ChildDeadlockedError,
    ConnectionError,
    DataError,
    InvalidResponse,
    PubSubError,
    ReadOnlyError,
    KeyDBError,
    ResponseError,
    TimeoutError,
    WatchError,
)
from aiokeydb.sentinel import (
    Sentinel,
    SentinelConnectionPool,
    SentinelManagedConnection,
    SentinelManagedSSLConnection,
)
from aiokeydb.utils import from_url

# Handle Async

from aiokeydb.asyncio import (
    AsyncKeyDB, 
    StrictAsyncKeyDB,
    AsyncBlockingConnectionPool,
    AsyncConnection,
    AsyncConnectionPool,
    AsyncSSLConnection,
    AsyncUnixDomainSocketConnection,
    AsyncSentinel,
    AsyncSentinelConnectionPool,
    AsyncSentinelManagedConnection,
    AsyncSentinelManagedSSLConnection,
    async_from_url
)


if sys.version_info >= (3, 8):
    from importlib import metadata
else:
    import importlib_metadata as metadata


def int_or_str(value):
    try:
        return int(value)
    except ValueError:
        return value


try:
    __version__ = metadata.version("redis")
except metadata.PackageNotFoundError:
    __version__ = "99.99.99"


VERSION = tuple(map(int_or_str, __version__.split(".")))

__all__ = [
    "AuthenticationError",
    "AuthenticationWrongNumberOfArgsError",
    "BlockingConnectionPool",
    "BusyLoadingError",
    "ChildDeadlockedError",
    "Connection",
    "ConnectionError",
    "ConnectionPool",
    "DataError",
    "from_url",
    "InvalidResponse",
    "PubSubError",
    "ReadOnlyError",
    "KeyDB",
    "KeyDBCluster",
    "KeyDBError",
    "ResponseError",
    "Sentinel",
    "SentinelConnectionPool",
    "SentinelManagedConnection",
    "SentinelManagedSSLConnection",
    "SSLConnection",
    "StrictKeyDB",
    "TimeoutError",
    "UnixDomainSocketConnection",
    "WatchError",
    # Async
    "AsyncKeyDB", 
    "StrictAsyncKeyDB",
    "AsyncBlockingConnectionPool",
    "AsyncConnection",
    "AsyncConnectionPool",
    "AsyncSSLConnection",
    "AsyncUnixDomainSocketConnection",
    "AsyncSentinel",
    "AsyncSentinelConnectionPool",
    "AsyncSentinelManagedConnection",
    "AsyncSentinelManagedSSLConnection",
    "async_from_url"
]
