/*
 * Decompiled with CFR 0.152.
 */
package Metrics;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class SourceCodeLineCounter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumberOfLines(String method) throws IOException {
        BufferedReader reader = null;
        try {
            StringReader inputString = new StringReader(method);
            reader = new BufferedReader(inputString);
            int count = 0;
            boolean commentBegan = false;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ("".equals(line = line.trim()) || line.startsWith("//")) continue;
                if (commentBegan) {
                    if (!SourceCodeLineCounter.commentEnded(line)) continue;
                    line = line.substring(line.indexOf("*/") + 2).trim();
                    commentBegan = false;
                    if ("".equals(line) || line.startsWith("//")) continue;
                }
                if (SourceCodeLineCounter.isSourceCodeLine(line)) {
                    ++count;
                }
                if (!SourceCodeLineCounter.commentBegan(line)) continue;
                commentBegan = true;
            }
            int n = count;
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    private static boolean commentBegan(String line) {
        int index = line.indexOf("/*");
        if (index < 0) {
            return false;
        }
        int quoteStartIndex = line.indexOf("\"");
        if (quoteStartIndex != -1 && quoteStartIndex < index) {
            while (quoteStartIndex > -1) {
                line = line.substring(quoteStartIndex + 1);
                int quoteEndIndex = line.indexOf("\"");
                line = line.substring(quoteEndIndex + 1);
                quoteStartIndex = line.indexOf("\"");
            }
            return SourceCodeLineCounter.commentBegan(line);
        }
        return !SourceCodeLineCounter.commentEnded(line.substring(index + 2));
    }

    private static boolean commentEnded(String line) {
        int index = line.indexOf("*/");
        if (index < 0) {
            return false;
        }
        String subString = line.substring(index + 2).trim();
        if ("".equals(subString) || subString.startsWith("//")) {
            return true;
        }
        return !SourceCodeLineCounter.commentBegan(subString);
    }

    private static boolean isSourceCodeLine(String line) {
        boolean isSourceCodeLine = false;
        if ("".equals(line = line.trim()) || line.startsWith("//")) {
            return isSourceCodeLine;
        }
        if (line.length() == 1) {
            return true;
        }
        int index = line.indexOf("/*");
        if (index != 0) {
            return true;
        }
        while (line.length() > 0) {
            int endCommentPosition = (line = line.substring(index + 2)).indexOf("*/");
            if (endCommentPosition < 0) {
                return false;
            }
            if (endCommentPosition == line.length() - 2) {
                return false;
            }
            String subString = line.substring(endCommentPosition + 2).trim();
            if ("".equals(subString) || subString.indexOf("//") == 0) {
                return false;
            }
            if (subString.startsWith("/*")) {
                line = subString;
                continue;
            }
            return true;
        }
        return isSourceCodeLine;
    }
}

