/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.KotlinToJvmSignatureMapper;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.KotlinToJvmSignatureMapperKt;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturePropagationUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class SignaturesPropagationData {
    private static final KotlinToJvmSignatureMapper SIGNATURE_MAPPER = ServiceLoader.load(KotlinToJvmSignatureMapper.class, KotlinToJvmSignatureMapper.class.getClassLoader()).iterator().next();
    private final ValueParameters modifiedValueParameters;
    private final List<String> signatureErrors = new ArrayList<String>(0);
    private final List<FunctionDescriptor> superFunctions;

    public SignaturesPropagationData(@NotNull ClassDescriptor containingClass, @NotNull KotlinType autoReturnType, @Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> autoValueParameters, @NotNull List<TypeParameterDescriptor> autoTypeParameters, @NotNull JavaMethod method) {
        assert (receiverType == null) : "Parameters before propagation have receiver type, but propagation should be disabled for functions compiled from Kotlin in class: " + DescriptorUtils.getFqName(containingClass);
        JavaMethodDescriptor autoMethodDescriptor = SignaturesPropagationData.createAutoMethodDescriptor(containingClass, method, autoReturnType, autoValueParameters, autoTypeParameters);
        boolean hasStableParameterNames = autoValueParameters.stream().allMatch(it -> UtilKt.getParameterNameAnnotation(it) != null);
        this.superFunctions = SignaturesPropagationData.getSuperFunctionsForMethod(method, autoMethodDescriptor, containingClass);
        this.modifiedValueParameters = this.superFunctions.isEmpty() ? new ValueParameters(null, autoValueParameters, hasStableParameterNames) : this.modifyValueParametersAccordingToSuperMethods(autoValueParameters, hasStableParameterNames);
    }

    @NotNull
    private static JavaMethodDescriptor createAutoMethodDescriptor(@NotNull ClassDescriptor containingClass, @NotNull JavaMethod method, KotlinType autoReturnType, @NotNull List<ValueParameterDescriptor> autoValueParameters, @NotNull List<TypeParameterDescriptor> autoTypeParameters) {
        JavaMethodDescriptor autoMethodDescriptor = JavaMethodDescriptor.createJavaMethod(containingClass, Annotations.Companion.getEMPTY(), method.getName(), SourceElement.NO_SOURCE);
        autoMethodDescriptor.initialize((ReceiverParameterDescriptor)null, containingClass.getThisAsReceiverParameter(), autoTypeParameters, (List)autoValueParameters, autoReturnType, Modality.OPEN, Visibilities.PUBLIC);
        return autoMethodDescriptor;
    }

    public KotlinType getModifiedReceiverType() {
        return this.modifiedValueParameters.receiverType;
    }

    public List<ValueParameterDescriptor> getModifiedValueParameters() {
        return this.modifiedValueParameters.descriptors;
    }

    public boolean getModifiedHasStableParameterNames() {
        return this.modifiedValueParameters.hasStableParameterNames;
    }

    public List<String> getSignatureErrors() {
        return this.signatureErrors;
    }

    void reportError(String error) {
        this.signatureErrors.add(error);
    }

    private ValueParameters modifyValueParametersAccordingToSuperMethods(@NotNull List<ValueParameterDescriptor> parameters2, boolean annotatedWithParameterName) {
        KotlinType resultReceiverType = null;
        ArrayList<ValueParameterDescriptor> resultParameters = new ArrayList<ValueParameterDescriptor>(parameters2.size());
        boolean shouldBeExtension = this.checkIfShouldBeExtension();
        for (ValueParameterDescriptor originalParam : parameters2) {
            AnnotationDescriptor currentName;
            int originalIndex = originalParam.getIndex();
            List<TypeAndName> typesFromSuperMethods = CollectionsKt.map(this.superFunctions, superFunction -> {
                int index2;
                ReceiverParameterDescriptor receiver2 = superFunction.getExtensionReceiverParameter();
                int n = index2 = receiver2 != null ? originalIndex - 1 : originalIndex;
                if (index2 == -1) {
                    assert (receiver2 != null) : "can't happen: index is -1, while function is not extension";
                    return new TypeAndName(receiver2.getType(), originalParam.getName());
                }
                ValueParameterDescriptor parameter = superFunction.getValueParameters().get(index2);
                return new TypeAndName(parameter.getType(), parameter.getName());
            });
            VarargCheckResult varargCheckResult = this.checkVarargInSuperFunctions(originalParam);
            KotlinType altType = varargCheckResult.parameterType;
            if (shouldBeExtension && originalIndex == 0) {
                resultReceiverType = altType;
                continue;
            }
            Name stableName = null;
            for (int i = 0; i < this.superFunctions.size(); ++i) {
                if (!this.superFunctions.get(i).hasStableParameterNames()) continue;
                stableName = typesFromSuperMethods.get((int)i).name;
                break;
            }
            boolean shouldTakeOldName = (currentName = UtilKt.getParameterNameAnnotation(originalParam)) == null && stableName != null;
            resultParameters.add(new ValueParameterDescriptorImpl(originalParam.getContainingDeclaration(), null, shouldBeExtension ? originalIndex - 1 : originalIndex, originalParam.getAnnotations(), shouldTakeOldName ? stableName : originalParam.getName(), altType, originalParam.declaresDefaultValue(), originalParam.isCrossinline(), originalParam.isNoinline(), varargCheckResult.isVararg ? DescriptorUtilsKt.getBuiltIns(originalParam).getArrayElementType(altType) : null, SourceElement.NO_SOURCE));
        }
        boolean hasStableParameterNames = annotatedWithParameterName || CollectionsKt.any(this.superFunctions, CallableDescriptor::hasStableParameterNames);
        return new ValueParameters(resultReceiverType, resultParameters, hasStableParameterNames);
    }

    private static List<FunctionDescriptor> getSuperFunctionsForMethod(@NotNull JavaMethod method, @NotNull JavaMethodDescriptor autoMethodDescriptor, @NotNull ClassDescriptor containingClass) {
        ArrayList<FunctionDescriptor> superFunctions = Lists.newArrayList();
        Name name = method.getName();
        Method autoSignature = null;
        boolean autoMethodContainsVararg = SignaturePropagationUtilKt.containsVarargs(autoMethodDescriptor);
        for (KotlinType supertype : containingClass.getTypeConstructor().getSupertypes()) {
            Collection<? extends SimpleFunctionDescriptor> superFunctionCandidates = supertype.getMemberScope().getContributedFunctions(name, NoLookupLocation.WHEN_GET_SUPER_MEMBERS);
            if (!autoMethodContainsVararg && !SignaturePropagationUtilKt.containsAnyNotTrivialSignature(superFunctionCandidates)) continue;
            if (autoSignature == null) {
                autoSignature = SIGNATURE_MAPPER.mapToJvmMethodSignature(autoMethodDescriptor);
            }
            for (FunctionDescriptor functionDescriptor : superFunctionCandidates) {
                Method candidateSignature;
                if (functionDescriptor.isSuspend() || !KotlinToJvmSignatureMapperKt.erasedSignaturesEqualIgnoringReturnTypes(autoSignature, candidateSignature = SIGNATURE_MAPPER.mapToJvmMethodSignature(functionDescriptor))) continue;
                superFunctions.add(functionDescriptor);
            }
        }
        superFunctions.sort(Comparator.comparing(fun -> DescriptorUtils.getFqName(fun.getContainingDeclaration()).asString()));
        return superFunctions;
    }

    private boolean checkIfShouldBeExtension() {
        boolean someSupersExtension = false;
        boolean someSupersNotExtension = false;
        for (FunctionDescriptor superFunction : this.superFunctions) {
            if (superFunction.getExtensionReceiverParameter() != null) {
                someSupersExtension = true;
                continue;
            }
            someSupersNotExtension = true;
        }
        if (someSupersExtension) {
            if (someSupersNotExtension) {
                this.reportError("Incompatible super methods: some are extension functions, some are not");
            } else {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private VarargCheckResult checkVarargInSuperFunctions(@NotNull ValueParameterDescriptor originalParam) {
        boolean someSupersVararg = false;
        boolean someSupersNotVararg = false;
        for (FunctionDescriptor superFunction : this.superFunctions) {
            int index2;
            int originalIndex = originalParam.getIndex();
            int n = index2 = superFunction.getExtensionReceiverParameter() != null ? originalIndex - 1 : originalIndex;
            if (index2 != -1 && superFunction.getValueParameters().get(index2).getVarargElementType() != null) {
                someSupersVararg = true;
                continue;
            }
            someSupersNotVararg = true;
        }
        KotlinType originalVarargElementType = originalParam.getVarargElementType();
        KotlinType originalType = originalParam.getType();
        if (someSupersVararg && someSupersNotVararg) {
            this.reportError("Incompatible super methods: some have vararg parameter, some have not");
            return new VarargCheckResult(originalType, originalVarargElementType != null);
        }
        if (someSupersVararg && originalVarargElementType == null) {
            assert (SignaturesPropagationData.isArrayType(originalType));
            return new VarargCheckResult(TypeUtils.makeNotNullable(originalType), true);
        }
        if (someSupersNotVararg && originalVarargElementType != null) {
            assert (SignaturesPropagationData.isArrayType(originalType));
            return new VarargCheckResult(TypeUtils.makeNullable(originalType), false);
        }
        return new VarargCheckResult(originalType, originalVarargElementType != null);
    }

    private static boolean isArrayType(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2);
    }

    private static class ValueParameters {
        private final KotlinType receiverType;
        private final List<ValueParameterDescriptor> descriptors;
        private final boolean hasStableParameterNames;

        public ValueParameters(@Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> descriptors, boolean hasStableParameterNames) {
            this.receiverType = receiverType;
            this.descriptors = descriptors;
            this.hasStableParameterNames = hasStableParameterNames;
        }
    }

    private static class TypeAndName {
        public final KotlinType type;
        public final Name name;

        public TypeAndName(KotlinType type2, Name name) {
            this.type = type2;
            this.name = name;
        }
    }

    private static class VarargCheckResult {
        public final KotlinType parameterType;
        public final boolean isVararg;

        public VarargCheckResult(KotlinType parameterType, boolean isVararg) {
            this.parameterType = parameterType;
            this.isVararg = isVararg;
        }
    }
}

