/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtEnumEntry
extends KtClass {
    public KtEnumEntry(@NotNull ASTNode node) {
        super(node);
    }

    public KtEnumEntry(@NotNull KotlinClassStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public List<KtSuperTypeListEntry> getSuperTypeListEntries() {
        KtInitializerList initializerList = this.getInitializerList();
        if (initializerList == null) {
            return Collections.emptyList();
        }
        return initializerList.getInitializers();
    }

    public boolean hasInitializer() {
        return !this.getSuperTypeListEntries().isEmpty();
    }

    @Nullable
    public KtInitializerList getInitializerList() {
        return (KtInitializerList)this.getStubOrPsiChild(KtStubElementTypes.INITIALIZER_LIST);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        return visitor2.visitEnumEntry(this, data2);
    }

    @Override
    public boolean isEquivalentTo(@Nullable PsiElement another) {
        String theirFQName;
        String containingClassQName;
        PsiEnumConstant enumConstant;
        PsiClass containingClass;
        if (another instanceof PsiEnumConstant && (containingClass = (enumConstant = (PsiEnumConstant)another).getContainingClass()) != null && (containingClassQName = containingClass.getQualifiedName()) != null && enumConstant.getName() != null && (theirFQName = containingClassQName + "." + enumConstant.getName()).equals(this.getQualifiedName())) {
            return true;
        }
        return super.isEquivalentTo(another);
    }
}

