/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import gnu.trove.TIntObjectHashMap;
import javax.swing.Icon;
import org.jetbrains.kotlin.com.intellij.codeInsight.CodeInsightBundle;
import org.jetbrains.kotlin.com.intellij.codeInsight.TestFrameworks;
import org.jetbrains.kotlin.com.intellij.icons.AllIcons;
import org.jetbrains.kotlin.com.intellij.ide.IconLayerProvider;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiBundle;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementBase;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiClassUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiMethodUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.ui.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;
import org.jetbrains.kotlin.com.intellij.util.VisibilityIcons;

public class ElementPresentationUtil
implements PlatformIcons {
    public static final int CLASS_KIND_CLASS = 30;
    public static final int CLASS_KIND_JSP = 70;
    public static final int CLASS_KIND_EXCEPTION = 80;
    public static final int FLAGS_RUNNABLE = 16384;
    private static final Key<CachedValue<Integer>> CLASS_KIND_KEY = new Key("CLASS_KIND_KEY");
    private static final TIntObjectHashMap<Icon> BASE_ICON = new TIntObjectHashMap(20);

    private ElementPresentationUtil() {
    }

    public static int getFlags(PsiModifierListOwner element, boolean isLocked) {
        boolean isEnum = element instanceof PsiClass && ((PsiClass)element).isEnum();
        int flags = (element.hasModifierProperty("final") && !isEnum ? 1024 : 0) | (element.hasModifierProperty("static") && !isEnum ? 512 : 0) | (isLocked ? 2048 : 0);
        if (element instanceof PsiClass) {
            int kind;
            PsiClass aClass2 = (PsiClass)element;
            if (element.hasModifierProperty("abstract") && !((PsiClass)element).isInterface()) {
                flags |= 0x100;
            }
            if ((kind = ElementPresentationUtil.getClassKind(aClass2)) == 90) {
                flags |= 0x2000;
            } else if (kind == 100) {
                flags |= 0x4000;
            }
        }
        return flags;
    }

    public static RowIcon createLayeredIcon(Icon baseIcon, PsiModifierListOwner element, boolean isLocked) {
        return ElementBase.createLayeredIcon(element, baseIcon, ElementPresentationUtil.getFlags(element, isLocked));
    }

    public static int getBasicClassKind(PsiClass aClass2) {
        if (!aClass2.isValid()) {
            return 30;
        }
        if (aClass2.isAnnotationType()) {
            return 20;
        }
        if (aClass2.isEnum()) {
            return 50;
        }
        if (aClass2.isInterface()) {
            return 10;
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            return 40;
        }
        return 30;
    }

    public static int getClassKind(PsiClass aClass2) {
        if (!aClass2.isValid()) {
            aClass2.putUserData(CLASS_KIND_KEY, null);
            return 30;
        }
        CachedValue<Integer> value = aClass2.getUserData(CLASS_KIND_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager(aClass2.getProject()).createCachedValue(() -> CachedValueProvider.Result.createSingleDependency(ElementPresentationUtil.getClassKindImpl(aClass2), aClass2), false);
            aClass2.putUserData(CLASS_KIND_KEY, value);
        }
        return value.getValue();
    }

    private static int getClassKindImpl(PsiClass aClass2) {
        if (!aClass2.isValid()) {
            return 30;
        }
        if (aClass2.isAnnotationType()) {
            return 20;
        }
        if (aClass2.isEnum()) {
            return 50;
        }
        if (aClass2.isInterface()) {
            return 10;
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            return 40;
        }
        if (!DumbService.getInstance(aClass2.getProject()).isDumb()) {
            boolean isException;
            PsiManager manager = aClass2.getManager();
            PsiClass javaLangTrowable = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Throwable", aClass2.getResolveScope());
            boolean bl = isException = javaLangTrowable != null && InheritanceUtil.isInheritorOrSelf(aClass2, javaLangTrowable, true);
            if (isException) {
                return 80;
            }
            if (TestFrameworks.getInstance().isTestClass(aClass2)) {
                return 90;
            }
            if (PsiClassUtil.isRunnableClass(aClass2, false) && PsiMethodUtil.findMainMethod(aClass2) != null) {
                return 100;
            }
        }
        return 30;
    }

    public static Icon getClassIconOfKind(PsiClass aClass2, int classKind) {
        boolean isAbstract = aClass2.hasModifierProperty("abstract");
        return BASE_ICON.get(classKind | (isAbstract ? 256 : 0));
    }

    public static String getDescription(PsiModifierListOwner member) {
        String noun;
        if (member instanceof PsiClass) {
            noun = ElementPresentationUtil.getClassNoun((PsiClass)member);
        } else if (member instanceof PsiMethod) {
            noun = CodeInsightBundle.message("node.method.tooltip", new Object[0]);
        } else if (member instanceof PsiField) {
            noun = CodeInsightBundle.message("node.field.tooltip", new Object[0]);
        } else {
            return null;
        }
        String adj = ElementPresentationUtil.getFlagsDescription(member);
        return (adj + " " + noun).trim();
    }

    private static String getClassNoun(PsiClass aClass2) {
        String noun;
        int kind = ElementPresentationUtil.getClassKind(aClass2);
        switch (kind) {
            case 20: {
                noun = CodeInsightBundle.message("node.annotation.tooltip", new Object[0]);
                break;
            }
            case 40: {
                noun = CodeInsightBundle.message("node.anonymous.class.tooltip", new Object[0]);
                break;
            }
            case 50: {
                noun = CodeInsightBundle.message("node.enum.tooltip", new Object[0]);
                break;
            }
            case 80: {
                noun = CodeInsightBundle.message("node.exception.tooltip", new Object[0]);
                break;
            }
            case 10: {
                noun = CodeInsightBundle.message("node.interface.tooltip", new Object[0]);
                break;
            }
            case 90: {
                noun = CodeInsightBundle.message("node.junit.test.tooltip", new Object[0]);
                break;
            }
            case 100: {
                noun = CodeInsightBundle.message("node.runnable.class.tooltip", new Object[0]);
                break;
            }
            default: {
                noun = CodeInsightBundle.message("node.class.tooltip", new Object[0]);
            }
        }
        return noun;
    }

    private static String getFlagsDescription(PsiModifierListOwner aClass2) {
        int level;
        PsiModifierList list2;
        int flags = ElementPresentationUtil.getFlags(aClass2, false);
        String adj = "";
        for (IconLayerProvider provider : IconLayerProvider.EP_NAME.getExtensionList()) {
            if (provider.getLayerIcon(aClass2, false) == null) continue;
            adj = adj + " " + provider.getLayerDescription();
        }
        if (BitUtil.isSet(flags, 256)) {
            adj = adj + " " + CodeInsightBundle.message("node.abstract.flag.tooltip", new Object[0]);
        }
        if (BitUtil.isSet(flags, 1024)) {
            adj = adj + " " + CodeInsightBundle.message("node.final.flag.tooltip", new Object[0]);
        }
        if (BitUtil.isSet(flags, 512)) {
            adj = adj + " " + CodeInsightBundle.message("node.static.flag.tooltip", new Object[0]);
        }
        if ((list2 = aClass2.getModifierList()) != null && (level = PsiUtil.getAccessLevel(list2)) != 4) {
            adj = adj + " " + StringUtil.capitalize(PsiBundle.visibilityPresentation(PsiUtil.getAccessModifier(level)));
        }
        return adj;
    }

    public static Icon addVisibilityIcon(PsiModifierListOwner element, int flags, RowIcon baseIcon) {
        if (BitUtil.isSet(flags, 1)) {
            VisibilityIcons.setVisibilityIcon(element.getModifierList(), baseIcon);
        }
        return baseIcon;
    }

    static {
        BASE_ICON.put(30, CLASS_ICON);
        BASE_ICON.put(286, ABSTRACT_CLASS_ICON);
        BASE_ICON.put(20, ANNOTATION_TYPE_ICON);
        BASE_ICON.put(276, ANNOTATION_TYPE_ICON);
        BASE_ICON.put(40, ANONYMOUS_CLASS_ICON);
        BASE_ICON.put(296, ANONYMOUS_CLASS_ICON);
        BASE_ICON.put(60, ASPECT_ICON);
        BASE_ICON.put(316, ASPECT_ICON);
        BASE_ICON.put(50, ENUM_ICON);
        BASE_ICON.put(306, ENUM_ICON);
        BASE_ICON.put(80, EXCEPTION_CLASS_ICON);
        BASE_ICON.put(336, AllIcons.Nodes.AbstractException);
        BASE_ICON.put(10, INTERFACE_ICON);
        BASE_ICON.put(266, INTERFACE_ICON);
        BASE_ICON.put(90, CLASS_ICON);
        BASE_ICON.put(346, ABSTRACT_CLASS_ICON);
        BASE_ICON.put(100, CLASS_ICON);
        ElementBase.registerIconLayer(512, AllIcons.Nodes.StaticMark);
        ElementBase.registerIconLayer(1024, AllIcons.Nodes.FinalMark);
        ElementBase.registerIconLayer(8192, AllIcons.Nodes.JunitTestMark);
        ElementBase.registerIconLayer(16384, AllIcons.Nodes.RunnableMark);
    }
}

