/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.io.URLUtil;

public class PathManager {
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");
    private static String ourHomePath;
    private static String[] ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourPluginsPath;

    @NotNull
    public static String getHomePath() {
        String string = PathManager.getHomePath(true);
        if (string == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        if (ourHomePath != null) {
            return ourHomePath;
        }
        String fromProperty = System.getProperty("idea.home.path", System.getProperty("idea.home"));
        if (fromProperty != null) {
            ourHomePath = PathManager.getAbsolutePath(fromProperty);
            if (!new File(ourHomePath).isDirectory()) {
                throw new RuntimeException("Invalid home path '" + ourHomePath + "'");
            }
        } else if (insideIde && (ourHomePath = PathManager.getHomePathFor(PathManager.class)) == null) {
            String advice = SystemInfo.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
            throw new RuntimeException("Could not find installation home path. Please " + advice);
        }
        if (ourHomePath != null && SystemInfo.isWindows) {
            ourHomePath = PathManager.canonicalPath(ourHomePath);
        }
        ourBinDirectories = ourHomePath != null ? PathManager.getBinDirectories(new File(ourHomePath)) : ArrayUtil.EMPTY_STRING_ARRAY;
        return ourHomePath;
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class aClass2) {
        String rootPath;
        if (aClass2 == null) {
            PathManager.$$$reportNull$$$0(2);
        }
        if ((rootPath = PathManager.getResourceRoot(aClass2, "/" + aClass2.getName().replace('.', '/') + ".class")) == null) {
            return null;
        }
        File root2 = new File(rootPath).getAbsoluteFile();
        while ((root2 = root2.getParentFile()) != null && !PathManager.isIdeaHome(root2)) {
        }
        return root2 != null ? root2.getPath() : null;
    }

    private static boolean isIdeaHome(File root2) {
        for (String binDir : PathManager.getBinDirectories(root2)) {
            if (!new File(binDir, "idea.properties").isFile()) continue;
            return true;
        }
        return false;
    }

    private static String[] getBinDirectories(File root2) {
        List<String> binDirs = ContainerUtil.newSmartList();
        String[] subDirs = new String[]{"bin", "community/bin", "ultimate/community/bin"};
        String osSuffix = SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux");
        for (String subDir : subDirs) {
            File dir = new File(root2, subDir);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
            dir = new File(dir, osSuffix);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
        }
        return ArrayUtil.toStringArray(binDirs);
    }

    @NotNull
    public static String getBinPath() {
        String string = PathManager.getHomePath() + File.separator + "bin";
        if (string == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static File findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        PathManager.getHomePath();
        for (String binDir : ourBinDirectories) {
            File file2 = new File(binDir, fileName);
            if (!file2.isFile()) continue;
            return file2;
        }
        return null;
    }

    @NotNull
    public static File findBinFileWithException(@NotNull String fileName) throws FileNotFoundException {
        File file2;
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        if ((file2 = PathManager.findBinFile(fileName)) != null) {
            File file3 = file2;
            if (file3 == null) {
                PathManager.$$$reportNull$$$0(6);
            }
            return file3;
        }
        String paths = StringUtil.join(ourBinDirectories, "\n");
        throw new FileNotFoundException(String.format("'%s' not found in directories:\n%s", fileName, paths));
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string = PathManager.getHomePath() + File.separatorChar + "plugins";
        if (string == null) {
            PathManager.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string = ourConfigPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(9);
            }
            return string;
        }
        ourConfigPath = System.getProperty("idea.config.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.config.path"))) : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + File.separator + "config");
        String string = ourConfigPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(13);
        }
        String string = PathManager.platformPath(selector, "Library/Preferences", "config");
        if (string == null) {
            PathManager.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            String string = ourPluginsPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(18);
            }
            return string;
        }
        ourPluginsPath = System.getProperty("idea.plugins.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.plugins.path"))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? PathManager.platformPath(PATHS_SELECTOR, "Library/Application Support", "") : PathManager.getConfigPath() + File.separatorChar + "plugins");
        String string = ourPluginsPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string = ourSystemPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(23);
            }
            return string;
        }
        ourSystemPath = System.getProperty("idea.system.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.system.path"))) : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + File.separator + "system");
        FileUtil.createDirectory(new File(ourSystemPath));
        String string = ourSystemPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(25);
        }
        String string = PathManager.platformPath(selector, "Library/Caches", "system");
        if (string == null) {
            PathManager.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static File getIndexRoot() {
        File indexRoot = new File(System.getProperty("index_root_path", PathManager.getSystemPath() + "/index"));
        FileUtil.createDirectory(indexRoot);
        File file2 = indexRoot;
        if (file2 == null) {
            PathManager.$$$reportNull$$$0(28);
        }
        return file2;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class context, String path2) {
        URL url;
        if (context == null) {
            PathManager.$$$reportNull$$$0(32);
        }
        if ((url = context.getResource(path2)) == null) {
            url = ClassLoader.getSystemResource(path2.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path2) : null;
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path2 = URLUtil.urlToFile(resourceURL).getPath();
            String testPath = path2.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path2.substring(0, path2.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            Pair<String, String> paths = URLUtil.splitJarUrl(resourceURL.getFile());
            if (paths != null && paths.first != null) {
                resultPath = FileUtil.toSystemDependentName((String)paths.first);
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return StringUtil.trimEnd(resultPath, File.separator);
    }

    @NotNull
    public static String getCommunityHomePath() {
        String path2 = PathManager.getHomePath();
        if (new File(path2, "community/.idea").isDirectory()) {
            String string = path2 + File.separator + "community";
            if (string == null) {
                PathManager.$$$reportNull$$$0(36);
            }
            return string;
        }
        if (new File(path2, "ultimate/community/.idea").isDirectory()) {
            String string = path2 + File.separator + "ultimate" + File.separator + "community";
            if (string == null) {
                PathManager.$$$reportNull$$$0(37);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            PathManager.$$$reportNull$$$0(38);
        }
        return string;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class aClass2) {
        String resourceRoot;
        if (aClass2 == null) {
            PathManager.$$$reportNull$$$0(39);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass2, "/" + aClass2.getName().replace('.', '/') + ".class")) != null ? new File(resourceRoot).getAbsolutePath() : null;
    }

    private static void log(String x) {
        System.err.println(x);
    }

    public static String getAbsolutePath(String path2) {
        path2 = FileUtil.expandUserHome(path2);
        return FileUtil.toCanonicalPath(new File(path2).getAbsolutePath());
    }

    private static String trimPathQuotes(String path2) {
        if (path2 != null && path2.length() >= 3 && StringUtil.startsWithChar(path2, '\"') && StringUtil.endsWithChar(path2, '\"')) {
            path2 = path2.substring(1, path2.length() - 1);
        }
        return path2;
    }

    private static String platformPath(@NotNull String selector, @Nullable String macPart, @NotNull String fallback) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(41);
        }
        if (fallback == null) {
            PathManager.$$$reportNull$$$0(42);
        }
        return PathManager.platformPath(selector, macPart, null, null, null, fallback);
    }

    private static String platformPath(@NotNull String selector, @Nullable String macPart, @Nullable String winVar, @Nullable String xdgVar, @Nullable String xdgDir, @NotNull String fallback) {
        String dir;
        if (selector == null) {
            PathManager.$$$reportNull$$$0(43);
        }
        if (fallback == null) {
            PathManager.$$$reportNull$$$0(44);
        }
        String userHome = SystemProperties.getUserHome();
        if (macPart != null && SystemInfo.isMac) {
            return userHome + File.separator + macPart + File.separator + selector;
        }
        if (winVar != null && SystemInfo.isWindows && (dir = System.getenv(winVar)) != null) {
            return dir + File.separator + selector;
        }
        if (xdgVar != null && xdgDir != null && SystemInfo.hasXdgOpen()) {
            dir = System.getenv(xdgVar);
            if (dir == null) {
                dir = userHome + File.separator + xdgDir;
            }
            return dir + File.separator + selector;
        }
        return userHome + File.separator + "." + selector + (!fallback.isEmpty() ? File.separator + fallback : "");
    }

    private static String canonicalPath(String path2) {
        try {
            return new File(path2).getCanonicalPath();
        }
        catch (IOException e) {
            return path2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 16: 
            case 20: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 16: 
            case 20: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 13: 
            case 20: 
            case 25: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 16: 
            case 20: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/PathManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtilClassPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "platformPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 16: 
            case 20: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

