/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.impl;

import gnu.trove.TIntObjectHashMap;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.ForeignLeafType;
import org.jetbrains.kotlin.com.intellij.lang.ITokenTypeRemapper;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTTokenNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterLazyParseableNode;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.TokenWrapper;
import org.jetbrains.kotlin.com.intellij.lang.WhitespaceSkippedCallback;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesAndCommentsBinder;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesBinders;
import org.jetbrains.kotlin.com.intellij.lang.impl.MarkerOptionalData;
import org.jetbrains.kotlin.com.intellij.lang.impl.MarkerPool;
import org.jetbrains.kotlin.com.intellij.lang.impl.MarkerProduction;
import org.jetbrains.kotlin.com.intellij.lang.impl.TokenSequence;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.EmptyProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.UnprotectedUserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.BlockSupportImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.DiffLog;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.CharTableImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.FileContextUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.text.BlockSupport;
import org.jetbrains.kotlin.com.intellij.psi.tree.CustomLanguageASTComparator;
import org.jetbrains.kotlin.com.intellij.psi.tree.ICustomParsingType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILeafElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILightLazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;
import org.jetbrains.kotlin.com.intellij.util.TripleFunction;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Convertor;
import org.jetbrains.kotlin.com.intellij.util.containers.LimitedPool;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.com.intellij.util.diff.DiffTreeChangeBuilder;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.com.intellij.util.diff.ShallowNodeComparator;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;

public class PsiBuilderImpl
extends UnprotectedUserDataHolder
implements PsiBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.lang.impl.PsiBuilderImpl");
    public static final Key<TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState>> CUSTOM_COMPARATOR = Key.create("CUSTOM_COMPARATOR");
    private static final Key<TokenSequence> LAZY_PARSEABLE_TOKENS = Key.create("LAZY_PARSEABLE_TOKENS");
    private static TokenSet ourAnyLanguageWhitespaceTokens = TokenSet.EMPTY;
    private final Project myProject;
    private PsiFile myFile;
    private final int[] myLexStarts;
    private final IElementType[] myLexTypes;
    private int myCurrentLexeme;
    private final ParserDefinition myParserDefinition;
    private final Lexer myLexer;
    private final TokenSet myWhitespaces;
    private TokenSet myComments;
    private CharTable myCharTable;
    private final CharSequence myText;
    private final CharSequence myLastCommittedText;
    private final char[] myTextArray;
    private boolean myDebugMode;
    private final int myLexemeCount;
    private boolean myTokenTypeChecked;
    private ITokenTypeRemapper myRemapper;
    private WhitespaceSkippedCallback myWhitespaceSkippedCallback;
    private final ASTNode myOriginalTree;
    private final MyTreeStructure myParentLightTree;
    private final int myOffset;
    private IElementType myCachedTokenType;
    private final TIntObjectHashMap<LazyParseableToken> myChameleonCache;
    private final MarkerPool myPool;
    private final MarkerOptionalData myOptionalData;
    private final MarkerProduction myProduction;

    public static void registerWhitespaceToken(@NotNull IElementType type2) {
        if (type2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(0);
        }
        ourAnyLanguageWhitespaceTokens = TokenSet.orSet(ourAnyLanguageWhitespaceTokens, TokenSet.create(type2));
    }

    public PsiBuilderImpl(@Nullable Project project, @Nullable PsiFile containingFile, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @Nullable CharTable charTable, @NotNull CharSequence text2, @Nullable ASTNode originalTree, @Nullable MyTreeStructure parentLightTree) {
        if (parserDefinition == null) {
            PsiBuilderImpl.$$$reportNull$$$0(1);
        }
        if (lexer == null) {
            PsiBuilderImpl.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(3);
        }
        this(project, containingFile, parserDefinition, lexer, charTable, text2, originalTree, originalTree == null ? null : originalTree.getText(), parentLightTree, null);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull ASTNode chameleon, @NotNull CharSequence text2) {
        if (project == null) {
            PsiBuilderImpl.$$$reportNull$$$0(4);
        }
        if (parserDefinition == null) {
            PsiBuilderImpl.$$$reportNull$$$0(5);
        }
        if (lexer == null) {
            PsiBuilderImpl.$$$reportNull$$$0(6);
        }
        if (chameleon == null) {
            PsiBuilderImpl.$$$reportNull$$$0(7);
        }
        if (text2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(8);
        }
        this(project, SharedImplUtil.getContainingFile(chameleon), parserDefinition, lexer, SharedImplUtil.findCharTableByTree(chameleon), text2, Pair.getFirst(chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED)), Pair.getSecond(chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED)), null, chameleon);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull LighterLazyParseableNode chameleon, @NotNull CharSequence text2) {
        if (project == null) {
            PsiBuilderImpl.$$$reportNull$$$0(9);
        }
        if (parserDefinition == null) {
            PsiBuilderImpl.$$$reportNull$$$0(10);
        }
        if (lexer == null) {
            PsiBuilderImpl.$$$reportNull$$$0(11);
        }
        if (chameleon == null) {
            PsiBuilderImpl.$$$reportNull$$$0(12);
        }
        if (text2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(13);
        }
        this(project, chameleon.getContainingFile(), parserDefinition, lexer, chameleon.getCharTable(), text2, null, null, ((LazyParseableToken)chameleon).myParentStructure, chameleon);
    }

    private PsiBuilderImpl(@Nullable Project project, @Nullable PsiFile containingFile, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @Nullable CharTable charTable, @NotNull CharSequence text2, @Nullable ASTNode originalTree, @Nullable CharSequence lastCommittedText, @Nullable MyTreeStructure parentLightTree, @Nullable Object parentCachingNode) {
        if (parserDefinition == null) {
            PsiBuilderImpl.$$$reportNull$$$0(14);
        }
        if (lexer == null) {
            PsiBuilderImpl.$$$reportNull$$$0(15);
        }
        if (text2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(16);
        }
        this.myChameleonCache = new TIntObjectHashMap();
        this.myPool = new MarkerPool(this);
        this.myOptionalData = new MarkerOptionalData();
        this.myProduction = new MarkerProduction(this.myPool, this.myOptionalData);
        this.myProject = project;
        this.myFile = containingFile;
        this.myParserDefinition = parserDefinition;
        this.myText = text2;
        this.myTextArray = CharArrayUtil.fromSequenceWithoutCopying(text2);
        this.myLexer = lexer;
        this.myWhitespaces = parserDefinition.getWhitespaceTokens();
        this.myComments = parserDefinition.getCommentTokens();
        this.myCharTable = charTable;
        this.myOriginalTree = originalTree;
        this.myLastCommittedText = lastCommittedText;
        if (originalTree == null != (lastCommittedText == null)) {
            throw new IllegalArgumentException("originalTree and lastCommittedText must be null/notnull together but got: originalTree=" + originalTree + "; lastCommittedText=" + (lastCommittedText == null ? null : "'" + StringUtil.first(lastCommittedText, 80, true) + "'"));
        }
        this.myParentLightTree = parentLightTree;
        this.myOffset = parentCachingNode instanceof LazyParseableToken ? ((LazyParseableToken)parentCachingNode).getStartOffset() : 0;
        TokenSequence tokens = this.performLexing(parentCachingNode);
        this.myLexStarts = tokens.lexStarts;
        this.myLexTypes = tokens.lexTypes;
        this.myLexemeCount = tokens.lexemeCount;
    }

    private TokenSequence performLexing(@Nullable Object parentCachingNode) {
        TokenSequence fromParent = null;
        if (parentCachingNode instanceof LazyParseableToken) {
            fromParent = ((LazyParseableToken)parentCachingNode).getParsedTokenSequence();
            assert (fromParent == null || fromParent.lexStarts[fromParent.lexemeCount] == this.myText.length());
            ProgressIndicatorProvider.checkCanceled();
        } else if (parentCachingNode instanceof LazyParseableElement) {
            LazyParseableElement parentElement = (LazyParseableElement)parentCachingNode;
            fromParent = parentElement.getUserData(LAZY_PARSEABLE_TOKENS);
            parentElement.putUserData(LAZY_PARSEABLE_TOKENS, null);
        }
        if (fromParent != null) {
            if (PsiBuilderImpl.doLexingOptimizationCorrectionCheck()) {
                fromParent.assertMatches(this.myText, this.myLexer);
            }
            return fromParent;
        }
        return new TokenSequence.Builder(this.myText, this.myLexer).performLexing();
    }

    private static boolean doLexingOptimizationCorrectionCheck() {
        return false;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void enforceCommentTokens(@NotNull TokenSet tokens) {
        if (tokens == null) {
            PsiBuilderImpl.$$$reportNull$$$0(17);
        }
        this.myComments = tokens;
    }

    @Override
    @Nullable
    public StartMarker getLatestDoneMarker() {
        for (int index2 = this.myProduction.size() - 1; index2 >= 0; --index2) {
            StartMarker marker = this.myProduction.getDoneMarkerAt(index2);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    @NotNull
    private PsiBuilder.Marker precede(StartMarker marker) {
        assert (marker.myLexemeIndex >= 0) : "Preceding disposed marker";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        StartMarker pre = this.createMarker(marker.myLexemeIndex);
        this.myProduction.addBefore(pre, marker);
        StartMarker startMarker = pre;
        if (startMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(18);
        }
        return startMarker;
    }

    @Override
    @NotNull
    public CharSequence getOriginalText() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            PsiBuilderImpl.$$$reportNull$$$0(19);
        }
        return charSequence;
    }

    @Override
    @Nullable
    public IElementType getTokenType() {
        IElementType cached = this.myCachedTokenType;
        if (cached == null) {
            this.myCachedTokenType = cached = this.calcTokenType();
        }
        return cached;
    }

    private void clearCachedTokenType() {
        this.myCachedTokenType = null;
    }

    private IElementType remapCurrentToken() {
        if (this.myCachedTokenType != null) {
            return this.myCachedTokenType;
        }
        if (this.myRemapper != null) {
            this.remapCurrentToken(this.myRemapper.filter(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1], this.myLexer.getBufferSequence()));
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    private IElementType calcTokenType() {
        if (this.eof()) {
            return null;
        }
        if (this.myRemapper != null) {
            this.skipWhitespace();
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    @Override
    public void setTokenTypeRemapper(ITokenTypeRemapper remapper2) {
        this.myRemapper = remapper2;
        this.myTokenTypeChecked = false;
        this.clearCachedTokenType();
    }

    @Override
    public void remapCurrentToken(IElementType type2) {
        this.myLexTypes[this.myCurrentLexeme] = type2;
        this.clearCachedTokenType();
    }

    @Override
    @Nullable
    public IElementType lookAhead(int steps) {
        if (this.eof()) {
            return null;
        }
        int cur = this.myCurrentLexeme;
        while (steps > 0) {
            ++cur;
            while (cur < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[cur])) {
                ++cur;
            }
            --steps;
        }
        return cur < this.myLexemeCount ? this.myLexTypes[cur] : null;
    }

    @Override
    public IElementType rawLookup(int steps) {
        int cur = this.myCurrentLexeme + steps;
        return cur < this.myLexemeCount && cur >= 0 ? this.myLexTypes[cur] : null;
    }

    @Override
    public int rawTokenTypeStart(int steps) {
        int cur = this.myCurrentLexeme + steps;
        if (cur < 0) {
            return -1;
        }
        if (cur >= this.myLexemeCount) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[cur];
    }

    @Override
    public int rawTokenIndex() {
        return this.myCurrentLexeme;
    }

    @Override
    public void setWhitespaceSkippedCallback(@Nullable WhitespaceSkippedCallback callback) {
        this.myWhitespaceSkippedCallback = callback;
    }

    @Override
    public void advanceLexer() {
        ProgressIndicatorProvider.checkCanceled();
        if (this.eof()) {
            return;
        }
        if (!this.myTokenTypeChecked) {
            LOG.error("Probably a bug: eating token without its type checking");
        }
        this.myTokenTypeChecked = false;
        ++this.myCurrentLexeme;
        this.clearCachedTokenType();
    }

    private void skipWhitespace() {
        while (this.myCurrentLexeme < this.myLexemeCount && this.whitespaceOrComment(this.remapCurrentToken())) {
            this.onSkip(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myCurrentLexeme + 1 < this.myLexemeCount ? this.myLexStarts[this.myCurrentLexeme + 1] : this.myText.length());
            ++this.myCurrentLexeme;
            this.clearCachedTokenType();
        }
    }

    private void onSkip(IElementType type2, int start, int end) {
        if (this.myWhitespaceSkippedCallback != null) {
            this.myWhitespaceSkippedCallback.onSkip(type2, start, end);
        }
    }

    @Override
    public int getCurrentOffset() {
        if (this.eof()) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[this.myCurrentLexeme];
    }

    @Override
    @Nullable
    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        IElementType type2 = this.getTokenType();
        if (type2 instanceof TokenWrapper) {
            return ((TokenWrapper)type2).getValue();
        }
        return this.myText.subSequence(this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1]).toString();
    }

    public boolean whitespaceOrComment(IElementType token) {
        return this.myWhitespaces.contains(token) || this.myComments.contains(token);
    }

    @Override
    @NotNull
    public PsiBuilder.Marker mark() {
        if (!this.myProduction.isEmpty()) {
            this.skipWhitespace();
        }
        StartMarker marker = this.createMarker(this.myCurrentLexeme);
        this.myProduction.addMarker(marker);
        StartMarker startMarker = marker;
        if (startMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(20);
        }
        return startMarker;
    }

    @NotNull
    private StartMarker createMarker(int lexemeIndex) {
        StartMarker marker = this.myPool.allocateStartMarker();
        marker.myLexemeIndex = lexemeIndex;
        if (this.myDebugMode) {
            this.myOptionalData.notifyAllocated(marker.markerId);
        }
        StartMarker startMarker = marker;
        if (startMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(21);
        }
        return startMarker;
    }

    @Override
    public final boolean eof() {
        if (!this.myTokenTypeChecked) {
            this.myTokenTypeChecked = true;
            this.skipWhitespace();
        }
        return this.myCurrentLexeme >= this.myLexemeCount;
    }

    private void rollbackTo(@NotNull StartMarker marker) {
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(22);
        }
        assert (marker.myLexemeIndex >= 0) : "Disposed marker passed to rollbackTo";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        this.myCurrentLexeme = marker.myLexemeIndex;
        this.myTokenTypeChecked = true;
        this.myProduction.rollbackTo(marker);
        this.clearCachedTokenType();
    }

    public boolean hasErrorsAfter(@NotNull PsiBuilder.Marker marker) {
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(23);
        }
        return this.myProduction.hasErrorsAfter((StartMarker)marker);
    }

    private void processDone(@NotNull StartMarker marker, @Nullable String errorMessage, @Nullable StartMarker before) {
        int doneLexeme;
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(24);
        }
        this.doValidityChecks(marker, before);
        if (errorMessage != null) {
            this.myOptionalData.setErrorMessage(marker.markerId, errorMessage);
        }
        int n = doneLexeme = before == null ? this.myCurrentLexeme : before.myLexemeIndex;
        if (marker.myType.isLeftBound() && this.isEmpty(marker.myLexemeIndex, doneLexeme)) {
            marker.setCustomEdgeTokenBinders(WhitespacesBinders.DEFAULT_RIGHT_BINDER, null);
        }
        marker.myDoneLexeme = doneLexeme;
        this.myProduction.addDone(marker, before);
    }

    private boolean isEmpty(int startIdx, int endIdx) {
        for (int i = startIdx; i < endIdx; ++i) {
            IElementType token = this.myLexTypes[i];
            if (this.whitespaceOrComment(token)) continue;
            return false;
        }
        return true;
    }

    private void doValidityChecks(@NotNull StartMarker marker, @Nullable StartMarker before) {
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(25);
        }
        if (marker.isDone()) {
            LOG.error("Marker already done.");
        }
        if (this.myDebugMode) {
            this.myProduction.doHeavyChecksOnMarkerDone(marker, before);
        }
    }

    @Override
    public void error(@NotNull String messageText) {
        ProductionMarker lastMarker;
        if (messageText == null) {
            PsiBuilderImpl.$$$reportNull$$$0(26);
        }
        if ((lastMarker = this.myProduction.getStartingMarkerAt(this.myProduction.size() - 1)) instanceof ErrorItem && lastMarker.myLexemeIndex == this.myCurrentLexeme) {
            return;
        }
        ErrorItem marker = this.myPool.allocateErrorItem();
        marker.myMessage = messageText;
        marker.myLexemeIndex = this.myCurrentLexeme;
        this.myProduction.addMarker(marker);
    }

    @Override
    @NotNull
    public ASTNode getTreeBuilt() {
        ASTNode aSTNode = this.buildTree();
        if (aSTNode == null) {
            PsiBuilderImpl.$$$reportNull$$$0(27);
        }
        return aSTNode;
    }

    @NotNull
    private ASTNode buildTree() {
        boolean isTooDeep;
        StartMarker rootMarker = this.prepareLightTree();
        boolean bl = isTooDeep = this.myFile != null && BlockSupport.isTooDeep(this.myFile.getOriginalFile());
        if (this.myOriginalTree != null && !isTooDeep) {
            DiffLog diffLog = this.merge(this.myOriginalTree, rootMarker, this.myLastCommittedText);
            throw new BlockSupport.ReparsedSuccessfullyException(diffLog);
        }
        TreeElement rootNode = this.createRootAST(rootMarker);
        this.bind(rootMarker, (CompositeElement)rootNode);
        if (isTooDeep && !(rootNode instanceof FileElement)) {
            TreeElement childNode = rootNode.getFirstChildNode();
            childNode.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        assert (rootNode.getTextLength() == this.myText.length()) : rootNode.getElementType();
        TreeElement treeElement = rootNode;
        if (treeElement == null) {
            PsiBuilderImpl.$$$reportNull$$$0(28);
        }
        return treeElement;
    }

    @Override
    @NotNull
    public FlyweightCapableTreeStructure<LighterASTNode> getLightTree() {
        StartMarker rootMarker = this.prepareLightTree();
        MyTreeStructure myTreeStructure = new MyTreeStructure(rootMarker, this.myParentLightTree);
        if (myTreeStructure == null) {
            PsiBuilderImpl.$$$reportNull$$$0(29);
        }
        return myTreeStructure;
    }

    @NotNull
    private TreeElement createRootAST(@NotNull StartMarker rootMarker) {
        IElementType type2;
        CompositeElement rootNode;
        if (rootMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(30);
        }
        CompositeElement compositeElement = rootNode = (type2 = rootMarker.getTokenType()) instanceof ILazyParseableElementType ? PsiBuilderImpl.createLazy((ILazyParseableElementType)type2, null, this.getASTFactory()) : PsiBuilderImpl.createComposite(rootMarker, this.getASTFactory());
        if (this.myCharTable == null) {
            CharTable charTable = this.myCharTable = rootNode instanceof FileElement ? ((FileElement)rootNode).getCharTable() : new CharTableImpl();
        }
        if (!(rootNode instanceof FileElement)) {
            rootNode.putUserData(CharTable.CHAR_TABLE_KEY, this.myCharTable);
        }
        CompositeElement compositeElement2 = rootNode;
        if (compositeElement2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(31);
        }
        return compositeElement2;
    }

    @Nullable
    private ASTFactory getASTFactory() {
        return this.myParserDefinition instanceof ASTFactory ? (ASTFactory)((Object)this.myParserDefinition) : null;
    }

    @NotNull
    private DiffLog merge(@NotNull ASTNode oldRoot, @NotNull StartMarker newRoot, @NotNull CharSequence lastCommittedText) {
        if (oldRoot == null) {
            PsiBuilderImpl.$$$reportNull$$$0(32);
        }
        if (newRoot == null) {
            PsiBuilderImpl.$$$reportNull$$$0(33);
        }
        if (lastCommittedText == null) {
            PsiBuilderImpl.$$$reportNull$$$0(34);
        }
        DiffLog diffLog = new DiffLog();
        ConvertFromTokensToASTBuilder builder = new ConvertFromTokensToASTBuilder(newRoot, diffLog, this.getASTFactory());
        MyTreeStructure treeStructure = new MyTreeStructure(newRoot, null);
        List<CustomLanguageASTComparator> customLanguageASTComparators = CustomLanguageASTComparator.getMatchingComparators(this.myFile);
        MyComparator comparator = new MyComparator(this.getUserData(CUSTOM_COMPARATOR), customLanguageASTComparators, treeStructure);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        BlockSupportImpl.diffTrees(oldRoot, builder, comparator, treeStructure, indicator == null ? new EmptyProgressIndicator() : indicator, lastCommittedText);
        DiffLog diffLog2 = diffLog;
        if (diffLog2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(35);
        }
        return diffLog2;
    }

    @NotNull
    private StartMarker prepareLightTree() {
        StartMarker rootMarker;
        if (this.myProduction.isEmpty()) {
            LOG.error("Parser produced no markers. Text:\n" + this.myText);
        }
        if ((rootMarker = (StartMarker)Objects.requireNonNull(this.myProduction.getStartingMarkerAt(0))).myFirstChild != null) {
            StartMarker startMarker = rootMarker;
            if (startMarker == null) {
                PsiBuilderImpl.$$$reportNull$$$0(36);
            }
            return startMarker;
        }
        this.myOptionalData.compact();
        this.myTokenTypeChecked = true;
        this.balanceWhiteSpaces();
        rootMarker.myNext = null;
        rootMarker.myParent = rootMarker.myFirstChild = (rootMarker.myLastChild = null);
        StartMarker curNode = rootMarker;
        Stack<StartMarker> nodes = ContainerUtil.newStack();
        nodes.push(rootMarker);
        int lastErrorIndex = -1;
        int maxDepth = 0;
        int curDepth = 0;
        for (int i = 1; i < this.myProduction.size(); ++i) {
            ProductionMarker item = this.myProduction.getStartingMarkerAt(i);
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                marker.myParent = curNode;
                marker.myNext = null;
                marker.myFirstChild = (marker.myLastChild = null);
                curNode.addChild(marker);
                nodes.push(curNode);
                curNode = marker;
                if (++curDepth <= maxDepth) continue;
                maxDepth = curDepth;
                continue;
            }
            if (item instanceof ErrorItem) {
                ((ErrorItem)item).myParent = curNode;
                int curToken = item.myLexemeIndex;
                if (curToken == lastErrorIndex) continue;
                lastErrorIndex = curToken;
                curNode.addChild(item);
                continue;
            }
            this.assertMarkersBalanced(this.myProduction.getDoneMarkerAt(i) == curNode, item);
            curNode = (StartMarker)nodes.pop();
            --curDepth;
        }
        if (this.myCurrentLexeme < this.myLexemeCount) {
            List<IElementType> missed = ContainerUtil.newArrayList(this.myLexTypes, this.myCurrentLexeme, this.myLexemeCount);
            LOG.error("Tokens " + missed + " were not inserted into the tree. " + (this.myFile != null ? this.myFile.getLanguage() + ", " : "") + "Text:\n" + this.myText);
        }
        if (rootMarker.getEndIndex() < this.myLexemeCount) {
            List<IElementType> missed = ContainerUtil.newArrayList(this.myLexTypes, rootMarker.getEndIndex(), this.myLexemeCount);
            LOG.error("Tokens " + missed + " are outside of root element \"" + rootMarker.myType + "\". Text:\n" + this.myText);
        }
        this.assertMarkersBalanced(curNode == rootMarker, curNode);
        this.checkTreeDepth(maxDepth, rootMarker.getTokenType() instanceof IFileElementType);
        this.clearCachedTokenType();
        StartMarker startMarker = rootMarker;
        if (startMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(37);
        }
        return startMarker;
    }

    private void assertMarkersBalanced(boolean condition, @Nullable ProductionMarker marker) {
        if (condition) {
            return;
        }
        this.reportUnbalancedMarkers(marker);
    }

    private void reportUnbalancedMarkers(@Nullable ProductionMarker marker) {
        int index2 = marker != null ? marker.getStartIndex() + 1 : this.myLexStarts.length;
        String context = index2 < this.myLexStarts.length ? this.myText.subSequence(Math.max(0, this.myLexStarts[index2] - 1000), this.myLexStarts[index2]) : "<none>";
        String language = this.myFile != null ? this.myFile.getLanguage() + ", " : "";
        LOG.error("Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem\nlanguage: " + language + "\ncontext: '" + context + "'");
    }

    private void balanceWhiteSpaces() {
        RelativeTokenTypesView wsTokens = new RelativeTokenTypesView();
        RelativeTokenTextView tokenTextGetter = new RelativeTokenTextView();
        int lastIndex = 0;
        int size = this.myProduction.size() - 1;
        for (int i = 1; i < size; ++i) {
            int wsEndIndex;
            int wsStartIndex;
            ProductionMarker starting = this.myProduction.getStartingMarkerAt(i);
            if (starting instanceof StartMarker) {
                this.assertMarkersBalanced(((StartMarker)starting).isDone(), starting);
            }
            boolean done2 = starting == null;
            ProductionMarker item = starting != null ? starting : (ProductionMarker)Objects.requireNonNull(this.myProduction.getDoneMarkerAt(i));
            WhitespacesAndCommentsBinder binder = item.getBinder(done2);
            int lexemeIndex = item.getLexemeIndex(done2);
            boolean recursive = binder instanceof WhitespacesAndCommentsBinder.RecursiveBinder;
            int prevProductionLexIndex = recursive ? 0 : this.myProduction.getLexemeIndexAt(i - 1);
            for (wsStartIndex = Math.max(lexemeIndex, lastIndex); wsStartIndex > prevProductionLexIndex && this.whitespaceOrComment(this.myLexTypes[wsStartIndex - 1]); --wsStartIndex) {
            }
            for (wsEndIndex = lexemeIndex; wsEndIndex < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[wsEndIndex]); ++wsEndIndex) {
            }
            if (wsStartIndex != wsEndIndex) {
                wsTokens.configure(wsStartIndex, wsEndIndex);
                tokenTextGetter.configure(wsStartIndex);
                boolean atEnd = wsStartIndex == 0 || wsEndIndex == this.myLexemeCount;
                lexemeIndex = wsStartIndex + binder.getEdgePosition(wsTokens, atEnd, tokenTextGetter);
                item.setLexemeIndex(lexemeIndex, done2);
                if (recursive) {
                    this.myProduction.confineMarkersToMaxLexeme(i, lexemeIndex);
                }
            } else if (lexemeIndex < wsStartIndex) {
                lexemeIndex = wsStartIndex;
                item.setLexemeIndex(wsStartIndex, done2);
            }
            lastIndex = lexemeIndex;
        }
    }

    private void checkTreeDepth(int maxDepth, boolean isFileRoot) {
        if (this.myFile == null) {
            return;
        }
        PsiFile file2 = this.myFile.getOriginalFile();
        Boolean flag = file2.getUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED);
        if (maxDepth > BlockSupport.INCREMENTAL_REPARSE_DEPTH_LIMIT) {
            if (!Boolean.TRUE.equals(flag)) {
                file2.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
            }
        } else if (isFileRoot && flag != null) {
            file2.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, null);
        }
    }

    private void bind(@NotNull StartMarker rootMarker, @NotNull CompositeElement rootNode) {
        if (rootMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(38);
        }
        if (rootNode == null) {
            PsiBuilderImpl.$$$reportNull$$$0(39);
        }
        ASTFactory astFactory = this.getASTFactory();
        StartMarker curMarker = rootMarker;
        CompositeElement curNode = rootNode;
        int lexIndex = rootMarker.myLexemeIndex;
        ProductionMarker item = rootMarker.myFirstChild != null ? rootMarker.myFirstChild : rootMarker;
        boolean itemDone = rootMarker.myFirstChild == null;
        while (true) {
            lexIndex = this.insertLeaves(lexIndex, item.getLexemeIndex(itemDone), curNode);
            if (item == rootMarker && itemDone) break;
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                if (itemDone) {
                    curMarker = (StartMarker)marker.myParent;
                    curNode = curNode.getTreeParent();
                    item = marker.myNext;
                    itemDone = false;
                } else {
                    if (!this.myOptionalData.isCollapsed(marker.markerId)) {
                        curMarker = marker;
                        CompositeElement childNode = PsiBuilderImpl.createComposite(marker, astFactory);
                        curNode.rawAddChildrenWithoutNotifications(childNode);
                        curNode = childNode;
                        item = marker.myFirstChild != null ? marker.myFirstChild : marker;
                        itemDone = marker.myFirstChild == null;
                        continue;
                    }
                    lexIndex = this.collapseLeaves(curNode, marker);
                    item = marker.myNext;
                    itemDone = false;
                }
            } else if (item instanceof ErrorItem) {
                CompositeElement errorElement = Factory.createErrorElement(((ErrorItem)item).myMessage);
                curNode.rawAddChildrenWithoutNotifications(errorElement);
                item = ((ErrorItem)item).myNext;
                itemDone = false;
            }
            if (item != null) continue;
            item = curMarker;
            itemDone = true;
        }
    }

    private int insertLeaves(int curToken, int lastIdx, CompositeElement curNode) {
        lastIdx = Math.min(lastIdx, this.myLexemeCount);
        while (curToken < lastIdx) {
            ProgressIndicatorProvider.checkCanceled();
            int start = this.myLexStarts[curToken];
            int end = this.myLexStarts[curToken + 1];
            if (start < end || this.myLexTypes[curToken] instanceof ILeafElementType) {
                IElementType type2 = this.myLexTypes[curToken];
                TreeElement leaf = this.createLeaf(type2, start, end);
                curNode.rawAddChildrenWithoutNotifications(leaf);
            }
            ++curToken;
        }
        return curToken;
    }

    private int collapseLeaves(@NotNull CompositeElement ast, @NotNull StartMarker startMarker) {
        if (ast == null) {
            PsiBuilderImpl.$$$reportNull$$$0(40);
        }
        if (startMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(41);
        }
        int start = this.myLexStarts[startMarker.myLexemeIndex];
        int end = this.myLexStarts[startMarker.getEndIndex()];
        IElementType markerType = startMarker.myType;
        TreeElement leaf = this.createLeaf(markerType, start, end);
        if (markerType instanceof ILazyParseableElementType && ((ILazyParseableElementType)markerType).reuseCollapsedTokens() && startMarker.myLexemeIndex < startMarker.getEndIndex()) {
            int length = startMarker.getEndIndex() - startMarker.myLexemeIndex;
            int[] relativeStarts = new int[length + 1];
            IElementType[] types = new IElementType[length + 1];
            for (int i = startMarker.myLexemeIndex; i < startMarker.getEndIndex(); ++i) {
                relativeStarts[i - startMarker.myLexemeIndex] = this.myLexStarts[i] - start;
                types[i - startMarker.myLexemeIndex] = this.myLexTypes[i];
            }
            relativeStarts[length] = end - start;
            leaf.putUserData(LAZY_PARSEABLE_TOKENS, new TokenSequence(relativeStarts, types, length));
        }
        ast.rawAddChildrenWithoutNotifications(leaf);
        return startMarker.getEndIndex();
    }

    @NotNull
    private static CompositeElement createComposite(@NotNull StartMarker marker, @Nullable ASTFactory astFactory) {
        CompositeElement composite;
        IElementType type2;
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(42);
        }
        if ((type2 = marker.myType) == TokenType.ERROR_ELEMENT) {
            String error = marker.myBuilder.myOptionalData.getDoneError(marker.markerId);
            CompositeElement compositeElement = Factory.createErrorElement(error);
            if (compositeElement == null) {
                PsiBuilderImpl.$$$reportNull$$$0(43);
            }
            return compositeElement;
        }
        if (type2 == null) {
            throw new RuntimeException("Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem");
        }
        if (astFactory != null && (composite = astFactory.createComposite(marker.getTokenType())) != null) {
            CompositeElement compositeElement = composite;
            if (compositeElement == null) {
                PsiBuilderImpl.$$$reportNull$$$0(44);
            }
            return compositeElement;
        }
        CompositeElement compositeElement = ASTFactory.composite(type2);
        if (compositeElement == null) {
            PsiBuilderImpl.$$$reportNull$$$0(45);
        }
        return compositeElement;
    }

    @NotNull
    private static LazyParseableElement createLazy(@NotNull ILazyParseableElementType type2, @Nullable CharSequence text2, @Nullable ASTFactory astFactory) {
        LazyParseableElement element;
        if (type2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(46);
        }
        if (astFactory != null && (element = astFactory.createLazy(type2, text2)) != null) {
            LazyParseableElement lazyParseableElement = element;
            if (lazyParseableElement == null) {
                PsiBuilderImpl.$$$reportNull$$$0(47);
            }
            return lazyParseableElement;
        }
        LazyParseableElement lazyParseableElement = ASTFactory.lazy(type2, text2);
        if (lazyParseableElement == null) {
            PsiBuilderImpl.$$$reportNull$$$0(48);
        }
        return lazyParseableElement;
    }

    @Nullable
    public static String getErrorMessage(@NotNull LighterASTNode node) {
        StartMarker marker;
        if (node == null) {
            PsiBuilderImpl.$$$reportNull$$$0(49);
        }
        if (node instanceof ErrorItem) {
            return ((ErrorItem)node).myMessage;
        }
        if (node instanceof StartMarker && (marker = (StartMarker)node).myType == TokenType.ERROR_ELEMENT) {
            return marker.myBuilder.myOptionalData.getDoneError(marker.markerId);
        }
        return null;
    }

    @Override
    public void setDebugMode(boolean dbgMode) {
        this.myDebugMode = dbgMode;
    }

    public int getLexemeCount() {
        return this.myLexemeCount;
    }

    @NotNull
    public Lexer getLexer() {
        Lexer lexer = this.myLexer;
        if (lexer == null) {
            PsiBuilderImpl.$$$reportNull$$$0(50);
        }
        return lexer;
    }

    @NotNull
    protected TreeElement createLeaf(@NotNull IElementType type2, int start, int end) {
        LeafElement element;
        if (type2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(51);
        }
        CharSequence text2 = this.myCharTable.intern(this.myText, start, end);
        if (this.myWhitespaces.contains(type2)) {
            PsiWhiteSpaceImpl psiWhiteSpaceImpl = new PsiWhiteSpaceImpl(text2);
            if (psiWhiteSpaceImpl == null) {
                PsiBuilderImpl.$$$reportNull$$$0(52);
            }
            return psiWhiteSpaceImpl;
        }
        if (type2 instanceof ICustomParsingType) {
            TreeElement treeElement = (TreeElement)((ICustomParsingType)((Object)type2)).parse(text2, this.myCharTable);
            if (treeElement == null) {
                PsiBuilderImpl.$$$reportNull$$$0(53);
            }
            return treeElement;
        }
        ASTFactory astFactory = this.getASTFactory();
        if (type2 instanceof ILazyParseableElementType) {
            LazyParseableElement lazyParseableElement = PsiBuilderImpl.createLazy((ILazyParseableElementType)type2, text2, astFactory);
            if (lazyParseableElement == null) {
                PsiBuilderImpl.$$$reportNull$$$0(54);
            }
            return lazyParseableElement;
        }
        if (astFactory != null && (element = astFactory.createLeaf(type2, text2)) != null) {
            LeafElement leafElement = element;
            if (leafElement == null) {
                PsiBuilderImpl.$$$reportNull$$$0(55);
            }
            return leafElement;
        }
        LeafElement leafElement = ASTFactory.leaf(type2, text2);
        if (leafElement == null) {
            PsiBuilderImpl.$$$reportNull$$$0(56);
        }
        return leafElement;
    }

    @Override
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            PsiBuilderImpl.$$$reportNull$$$0(57);
        }
        if (key == FileContextUtil.CONTAINING_FILE_KEY) {
            return (T)this.myFile;
        }
        return super.getUserData(key);
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            PsiBuilderImpl.$$$reportNull$$$0(58);
        }
        if (key == FileContextUtil.CONTAINING_FILE_KEY) {
            this.myFile = (PsiFile)value;
            return;
        }
        super.putUserData(key, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageText";
                break;
            }
            case 30: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootMarker";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastCommittedText";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ast";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startMarker";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "precede";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "mark";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createMarker";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeBuilt";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTree";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightTree";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootAST";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareLightTree";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createComposite";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createLazy";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexer";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeaf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerWhitespaceToken";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "enforceCommentTokens";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "rollbackTo";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasErrorsAfter";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processDone";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doValidityChecks";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createRootAST";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "bind";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "collapseLeaves";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createComposite";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createLazy";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createLeaf";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ASTConverter
    implements Convertor<Node, ASTNode> {
        private final StartMarker myRoot;
        private final ASTFactory myASTFactory;

        private ASTConverter(@NotNull StartMarker root2, @Nullable ASTFactory astFactory) {
            if (root2 == null) {
                ASTConverter.$$$reportNull$$$0(0);
            }
            this.myRoot = root2;
            this.myASTFactory = astFactory;
        }

        @Override
        public ASTNode convert(Node n) {
            if (n instanceof Token) {
                Token token = (Token)n;
                return token.myBuilder.createLeaf(token.getTokenType(), token.myTokenStart, token.myTokenEnd);
            }
            if (n instanceof ErrorItem) {
                return Factory.createErrorElement(((ErrorItem)n).myMessage);
            }
            StartMarker startMarker = (StartMarker)n;
            CompositeElement composite = n == this.myRoot ? (CompositeElement)this.myRoot.myBuilder.createRootAST(this.myRoot) : PsiBuilderImpl.createComposite(startMarker, this.myASTFactory);
            startMarker.myBuilder.bind(startMarker, composite);
            return composite;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ASTConverter", "<init>"));
        }
    }

    private static class MyTreeStructure
    implements FlyweightCapableTreeStructure<LighterASTNode> {
        private final LimitedPool<Token> myPool;
        private final LimitedPool<LazyParseableToken> myLazyPool;
        private final StartMarker myRoot;
        private int count;
        private LighterASTNode[] nodes;

        MyTreeStructure(@NotNull StartMarker root2, @Nullable MyTreeStructure parentTree) {
            if (root2 == null) {
                MyTreeStructure.$$$reportNull$$$0(0);
            }
            if (parentTree == null) {
                this.myPool = new LimitedPool<Token>(1000, new LimitedPool.ObjectFactory<Token>(){

                    @Override
                    public void cleanup(@NotNull Token token) {
                        if (token == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        token.clean();
                    }

                    @Override
                    @NotNull
                    public Token create() {
                        TokenNode tokenNode = new TokenNode();
                        if (tokenNode == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return tokenNode;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "token";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "create";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "cleanup";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
                this.myLazyPool = new LimitedPool<LazyParseableToken>(200, new LimitedPool.ObjectFactory<LazyParseableToken>(){

                    @Override
                    public void cleanup(@NotNull LazyParseableToken token) {
                        if (token == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        token.clean();
                    }

                    @Override
                    @NotNull
                    public LazyParseableToken create() {
                        LazyParseableToken lazyParseableToken = new LazyParseableToken();
                        if (lazyParseableToken == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return lazyParseableToken;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "token";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$2";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "create";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "cleanup";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
            } else {
                this.myPool = parentTree.myPool;
                this.myLazyPool = parentTree.myLazyPool;
            }
            this.myRoot = root2;
        }

        @Override
        @NotNull
        public LighterASTNode getRoot() {
            StartMarker startMarker = this.myRoot;
            if (startMarker == null) {
                MyTreeStructure.$$$reportNull$$$0(1);
            }
            return startMarker;
        }

        @Override
        public LighterASTNode getParent(@NotNull LighterASTNode node) {
            if (node == null) {
                MyTreeStructure.$$$reportNull$$$0(2);
            }
            if (node instanceof ProductionMarker) {
                return ((ProductionMarker)node).myParent;
            }
            if (node instanceof Token) {
                return ((Token)node).myParentNode;
            }
            throw new UnsupportedOperationException("Unknown node type: " + node);
        }

        @Override
        public int getChildren(@NotNull LighterASTNode item, @NotNull Ref<LighterASTNode[]> into) {
            if (item == null) {
                MyTreeStructure.$$$reportNull$$$0(3);
            }
            if (into == null) {
                MyTreeStructure.$$$reportNull$$$0(4);
            }
            if (item instanceof LazyParseableToken) {
                FlyweightCapableTreeStructure<LighterASTNode> tree = ((LazyParseableToken)item).parseContents();
                LighterASTNode root2 = tree.getRoot();
                if (root2 instanceof ProductionMarker) {
                    ((ProductionMarker)root2).myParent = ((Token)item).myParentNode;
                }
                return tree.getChildren(root2, into);
            }
            if (item instanceof Token || item instanceof ErrorItem) {
                return 0;
            }
            StartMarker marker = (StartMarker)item;
            this.count = 0;
            ProductionMarker child = marker.myFirstChild;
            int lexIndex = marker.myLexemeIndex;
            while (child != null) {
                lexIndex = this.insertLeaves(lexIndex, child.myLexemeIndex, marker.myBuilder, marker);
                if (child instanceof StartMarker && child.myBuilder.myOptionalData.isCollapsed(child.markerId)) {
                    int lastIndex = child.getEndIndex();
                    this.insertLeaf(child.getTokenType(), marker.myBuilder, child.myLexemeIndex, lastIndex, true, marker);
                } else {
                    this.ensureCapacity();
                    this.nodes[this.count++] = child;
                }
                if (child instanceof StartMarker) {
                    lexIndex = child.getEndIndex();
                }
                child = child.myNext;
            }
            this.insertLeaves(lexIndex, marker.getEndIndex(), marker.myBuilder, marker);
            into.set(this.nodes == null ? LighterASTNode.EMPTY_ARRAY : this.nodes);
            this.nodes = null;
            return this.count;
        }

        public void disposeChildren(LighterASTNode[] nodes, int count2) {
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < count2; ++i) {
                LighterASTNode node = nodes[i];
                if (node instanceof LazyParseableToken) {
                    this.myLazyPool.recycle((LazyParseableToken)node);
                    continue;
                }
                if (!(node instanceof Token)) continue;
                this.myPool.recycle((Token)node);
            }
        }

        private void ensureCapacity() {
            LighterASTNode[] old = this.nodes;
            if (old == null) {
                this.nodes = old = new LighterASTNode[10];
            } else if (this.count >= old.length) {
                LighterASTNode[] newStore = new LighterASTNode[this.count * 3 / 2];
                System.arraycopy(old, 0, newStore, 0, this.count);
                this.nodes = newStore;
            }
        }

        private int insertLeaves(int curToken, int lastIdx, PsiBuilderImpl builder, StartMarker parent2) {
            lastIdx = Math.min(lastIdx, builder.myLexemeCount);
            while (curToken < lastIdx) {
                this.insertLeaf(builder.myLexTypes[curToken], builder, curToken, curToken + 1, false, parent2);
                ++curToken;
            }
            return curToken;
        }

        private void insertLeaf(@NotNull IElementType type2, @NotNull PsiBuilderImpl builder, int startLexemeIndex, int endLexemeIndex, boolean forceInsertion, StartMarker parent2) {
            int end;
            int start;
            if (type2 == null) {
                MyTreeStructure.$$$reportNull$$$0(5);
            }
            if (builder == null) {
                MyTreeStructure.$$$reportNull$$$0(6);
            }
            if ((start = builder.myLexStarts[startLexemeIndex]) > (end = builder.myLexStarts[endLexemeIndex]) || !forceInsertion && start == end && !(type2 instanceof ILeafElementType)) {
                return;
            }
            Token lexeme = this.obtainToken(type2, builder, startLexemeIndex, endLexemeIndex, parent2, start, end);
            this.ensureCapacity();
            this.nodes[this.count++] = lexeme;
        }

        @NotNull
        private Token obtainToken(@NotNull IElementType type2, @NotNull PsiBuilderImpl builder, int startLexemeIndex, int endLexemeIndex, StartMarker parent2, int start, int end) {
            if (type2 == null) {
                MyTreeStructure.$$$reportNull$$$0(7);
            }
            if (builder == null) {
                MyTreeStructure.$$$reportNull$$$0(8);
            }
            if (type2 instanceof ILightLazyParseableElementType) {
                Token token = this.obtainLazyToken(type2, builder, startLexemeIndex, endLexemeIndex, parent2, start, end);
                if (token == null) {
                    MyTreeStructure.$$$reportNull$$$0(9);
                }
                return token;
            }
            Token lexeme = this.myPool.alloc();
            lexeme.initToken(type2, builder, parent2, start, end);
            Token token = lexeme;
            if (token == null) {
                MyTreeStructure.$$$reportNull$$$0(10);
            }
            return token;
        }

        @NotNull
        private Token obtainLazyToken(@NotNull IElementType type2, @NotNull PsiBuilderImpl builder, int startLexemeIndex, int endLexemeIndex, StartMarker parent2, int start, int end) {
            if (type2 == null) {
                MyTreeStructure.$$$reportNull$$$0(11);
            }
            if (builder == null) {
                MyTreeStructure.$$$reportNull$$$0(12);
            }
            int startInFile = start + builder.myOffset;
            LazyParseableToken token = (LazyParseableToken)builder.myChameleonCache.get(startInFile);
            if (token == null) {
                token = this.myLazyPool.alloc();
                token.myStartIndex = startLexemeIndex;
                token.myEndIndex = endLexemeIndex;
                token.initToken(type2, builder, parent2, start, end);
                builder.myChameleonCache.put(startInFile, token);
            } else if (token.myBuilder != builder || token.myStartIndex != startLexemeIndex || token.myEndIndex != endLexemeIndex) {
                throw new AssertionError((Object)"Wrong chameleon cached");
            }
            token.myParentStructure = this;
            LazyParseableToken lazyParseableToken = token;
            if (lazyParseableToken == null) {
                MyTreeStructure.$$$reportNull$$$0(13);
            }
            return lazyParseableToken;
        }

        @Override
        @NotNull
        public CharSequence toString(@NotNull LighterASTNode node) {
            if (node == null) {
                MyTreeStructure.$$$reportNull$$$0(14);
            }
            CharSequence charSequence = this.myRoot.myBuilder.myText.subSequence(node.getStartOffset(), node.getEndOffset());
            if (charSequence == null) {
                MyTreeStructure.$$$reportNull$$$0(15);
            }
            return charSequence;
        }

        @Override
        public int getStartOffset(@NotNull LighterASTNode node) {
            if (node == null) {
                MyTreeStructure.$$$reportNull$$$0(16);
            }
            return node.getStartOffset();
        }

        @Override
        public int getEndOffset(@NotNull LighterASTNode node) {
            if (node == null) {
                MyTreeStructure.$$$reportNull$$$0(17);
            }
            return node.getEndOffset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 9: 
                case 10: 
                case 13: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 9: 
                case 10: 
                case 13: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 9: 
                case 10: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure";
                    break;
                }
                case 2: 
                case 14: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "into";
                    break;
                }
                case 5: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 6: 
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "obtainToken";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "obtainLazyToken";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 9: 
                case 10: 
                case 13: 
                case 15: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getParent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "insertLeaf";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "obtainToken";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "obtainLazyToken";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartOffset";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getEndOffset";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 9: 
                case 10: 
                case 13: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyComparator
    implements ShallowNodeComparator<ASTNode, LighterASTNode> {
        private final TripleFunction<? super ASTNode, ? super LighterASTNode, ? super FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom;
        @NotNull
        private final List<? extends CustomLanguageASTComparator> myCustomLanguageASTComparators;
        private final MyTreeStructure myTreeStructure;

        private MyComparator(TripleFunction<? super ASTNode, ? super LighterASTNode, ? super FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom, @NotNull List<? extends CustomLanguageASTComparator> customLanguageASTComparators, @NotNull MyTreeStructure treeStructure) {
            if (customLanguageASTComparators == null) {
                MyComparator.$$$reportNull$$$0(0);
            }
            if (treeStructure == null) {
                MyComparator.$$$reportNull$$$0(1);
            }
            this.custom = custom;
            this.myCustomLanguageASTComparators = customLanguageASTComparators;
            this.myTreeStructure = treeStructure;
        }

        @Override
        @NotNull
        public ThreeState deepEqual(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
            boolean newIsErrorElement;
            if (oldNode == null) {
                MyComparator.$$$reportNull$$$0(2);
            }
            if (newNode == null) {
                MyComparator.$$$reportNull$$$0(3);
            }
            ProgressIndicatorProvider.checkCanceled();
            boolean oldIsErrorElement = oldNode instanceof PsiErrorElement;
            boolean bl = newIsErrorElement = newNode.getTokenType() == TokenType.ERROR_ELEMENT;
            if (oldIsErrorElement != newIsErrorElement) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    MyComparator.$$$reportNull$$$0(4);
                }
                return threeState;
            }
            if (oldIsErrorElement) {
                PsiErrorElement e1 = (PsiErrorElement)((Object)oldNode);
                ThreeState threeState = Comparing.equal(e1.getErrorDescription(), PsiBuilderImpl.getErrorMessage(newNode)) ? ThreeState.UNSURE : ThreeState.NO;
                if (threeState == null) {
                    MyComparator.$$$reportNull$$$0(5);
                }
                return threeState;
            }
            ThreeState customResult = this.customCompare(oldNode, newNode);
            if (customResult != ThreeState.UNSURE) {
                ThreeState threeState = customResult;
                if (threeState == null) {
                    MyComparator.$$$reportNull$$$0(6);
                }
                return threeState;
            }
            if (newNode instanceof Token) {
                IElementType type2 = newNode.getTokenType();
                Token token = (Token)newNode;
                if (oldNode instanceof ForeignLeafPsiElement) {
                    ThreeState threeState = type2 instanceof ForeignLeafType && ((ForeignLeafType)type2).getValue().equals(oldNode.getText()) ? ThreeState.YES : ThreeState.NO;
                    if (threeState == null) {
                        MyComparator.$$$reportNull$$$0(7);
                    }
                    return threeState;
                }
                if (oldNode instanceof LeafElement) {
                    if (type2 instanceof ForeignLeafType) {
                        ThreeState threeState = ThreeState.NO;
                        if (threeState == null) {
                            MyComparator.$$$reportNull$$$0(8);
                        }
                        return threeState;
                    }
                    ThreeState threeState = ((LeafElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                    if (threeState == null) {
                        MyComparator.$$$reportNull$$$0(9);
                    }
                    return threeState;
                }
                if (type2 instanceof ILightLazyParseableElementType) {
                    if (((TreeElement)oldNode).textMatches(token.getText())) {
                        ThreeState threeState = PsiDocumentManagerBase.isFullReparseInProgress() ? ThreeState.UNSURE : ThreeState.YES;
                        if (threeState == null) {
                            MyComparator.$$$reportNull$$$0(10);
                        }
                        return threeState;
                    }
                    ThreeState threeState = TreeUtil.isCollapsedChameleon(oldNode) ? ThreeState.NO : ThreeState.UNSURE;
                    if (threeState == null) {
                        MyComparator.$$$reportNull$$$0(11);
                    }
                    return threeState;
                }
                if (oldNode.getElementType() instanceof ILazyParseableElementType && type2 instanceof ILazyParseableElementType || oldNode.getElementType() instanceof ICustomParsingType && type2 instanceof ICustomParsingType) {
                    ThreeState threeState = ((TreeElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                    if (threeState == null) {
                        MyComparator.$$$reportNull$$$0(12);
                    }
                    return threeState;
                }
            }
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                MyComparator.$$$reportNull$$$0(13);
            }
            return threeState;
        }

        @NotNull
        private ThreeState customCompare(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
            ThreeState customResult;
            if (oldNode == null) {
                MyComparator.$$$reportNull$$$0(14);
            }
            if (newNode == null) {
                MyComparator.$$$reportNull$$$0(15);
            }
            for (CustomLanguageASTComparator customLanguageASTComparator : this.myCustomLanguageASTComparators) {
                ThreeState customComparatorResult = customLanguageASTComparator.compareAST(oldNode, newNode, this.myTreeStructure);
                if (customComparatorResult == ThreeState.UNSURE) continue;
                ThreeState threeState = customComparatorResult;
                if (threeState == null) {
                    MyComparator.$$$reportNull$$$0(16);
                }
                return threeState;
            }
            if (this.custom != null && (customResult = this.custom.fun(oldNode, newNode, this.myTreeStructure)) != ThreeState.UNSURE) {
                ThreeState threeState = customResult;
                if (threeState == null) {
                    MyComparator.$$$reportNull$$$0(17);
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                MyComparator.$$$reportNull$$$0(18);
            }
            return threeState;
        }

        @Override
        public boolean typesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
            IElementType n2t;
            IElementType n1t;
            if (n1 == null) {
                MyComparator.$$$reportNull$$$0(19);
            }
            if (n2 == null) {
                MyComparator.$$$reportNull$$$0(20);
            }
            if (n1 instanceof PsiWhiteSpaceImpl) {
                return ourAnyLanguageWhitespaceTokens.contains(n2.getTokenType()) || n2 instanceof Token && ((Token)n2).myBuilder.myWhitespaces.contains(n2.getTokenType());
            }
            if (n1 instanceof ForeignLeafPsiElement) {
                n1t = ((ForeignLeafPsiElement)n1).getForeignType();
                n2t = n2.getTokenType();
            } else {
                n1t = MyComparator.dereferenceToken(n1.getElementType());
                n2t = MyComparator.dereferenceToken(n2.getTokenType());
            }
            return Comparing.equal(n1t, n2t);
        }

        private static IElementType dereferenceToken(IElementType probablyWrapper) {
            if (probablyWrapper instanceof TokenWrapper) {
                return MyComparator.dereferenceToken(((TokenWrapper)probablyWrapper).getDelegate());
            }
            return probablyWrapper;
        }

        @Override
        public boolean hashCodesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
            PsiErrorElement e1;
            if (n1 == null) {
                MyComparator.$$$reportNull$$$0(21);
            }
            if (n2 == null) {
                MyComparator.$$$reportNull$$$0(22);
            }
            if (n1 instanceof LeafElement && n2 instanceof Token) {
                boolean isForeign1 = n1 instanceof ForeignLeafPsiElement;
                boolean isForeign2 = n2.getTokenType() instanceof ForeignLeafType;
                if (isForeign1 != isForeign2) {
                    return false;
                }
                if (isForeign1) {
                    return n1.getText().equals(((ForeignLeafType)n2.getTokenType()).getValue());
                }
                return ((LeafElement)n1).textMatches(((Token)n2).getText());
            }
            if (n1 instanceof PsiErrorElement && n2.getTokenType() == TokenType.ERROR_ELEMENT && !Comparing.equal((e1 = (PsiErrorElement)((Object)n1)).getErrorDescription(), PsiBuilderImpl.getErrorMessage(n2))) {
                return false;
            }
            return ((TreeElement)n1).hc() == ((Node)n2).hc();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "customLanguageASTComparators";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeStructure";
                    break;
                }
                case 2: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNode";
                    break;
                }
                case 3: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNode";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator";
                    break;
                }
                case 19: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "n1";
                    break;
                }
                case 20: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "n2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deepEqual";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "customCompare";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "deepEqual";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "customCompare";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "typesEqual";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "hashCodesEqual";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class RelativeTokenTextView
    implements WhitespacesAndCommentsBinder.TokenTextGetter {
        private int myStart;

        private RelativeTokenTextView() {
        }

        private void configure(int start) {
            this.myStart = start;
        }

        @Override
        @NotNull
        public CharSequence get(int i) {
            CharSequence charSequence = PsiBuilderImpl.this.myText.subSequence(PsiBuilderImpl.this.myLexStarts[this.myStart + i], PsiBuilderImpl.this.myLexStarts[this.myStart + i + 1]);
            if (charSequence == null) {
                RelativeTokenTextView.$$$reportNull$$$0(0);
            }
            return charSequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$RelativeTokenTextView", "get"));
        }
    }

    private final class RelativeTokenTypesView
    extends AbstractList<IElementType> {
        private int myStart;
        private int mySize;

        private RelativeTokenTypesView() {
        }

        private void configure(int start, int end) {
            this.myStart = start;
            this.mySize = end - start;
        }

        @Override
        public IElementType get(int index2) {
            return PsiBuilderImpl.this.myLexTypes[this.myStart + index2];
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }

    private static class ConvertFromTokensToASTBuilder
    implements DiffTreeChangeBuilder<ASTNode, LighterASTNode> {
        private final DiffTreeChangeBuilder<? super ASTNode, ? super ASTNode> myDelegate;
        private final ASTConverter myConverter;

        private ConvertFromTokensToASTBuilder(@NotNull StartMarker rootNode, @NotNull DiffTreeChangeBuilder<? super ASTNode, ? super ASTNode> delegate, @Nullable ASTFactory astFactory) {
            if (rootNode == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(1);
            }
            this.myDelegate = delegate;
            this.myConverter = new ASTConverter(rootNode, astFactory);
        }

        @Override
        public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            if (oldParent == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(2);
            }
            if (oldNode == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(3);
            }
            this.myDelegate.nodeDeleted(oldParent, oldNode);
        }

        @Override
        public void nodeInserted(@NotNull ASTNode oldParent, @NotNull LighterASTNode newNode, int pos) {
            if (oldParent == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(4);
            }
            if (newNode == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(5);
            }
            this.myDelegate.nodeInserted(oldParent, this.myConverter.convert((Node)newNode), pos);
        }

        @Override
        public void nodeReplaced(@NotNull ASTNode oldChild, @NotNull LighterASTNode newChild) {
            if (oldChild == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(6);
            }
            if (newChild == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(7);
            }
            ASTNode converted = this.myConverter.convert((Node)newChild);
            this.myDelegate.nodeReplaced(oldChild, converted);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNode";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNode";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldChild";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newChild";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeDeleted";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeInserted";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeReplaced";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ErrorItem
    extends ProductionMarker {
        private String myMessage;

        ErrorItem(int markerId, PsiBuilderImpl builder) {
            super(markerId, builder);
        }

        @Override
        void clean() {
            super.clean();
            this.myMessage = null;
        }

        @Override
        @NotNull
        public WhitespacesAndCommentsBinder getBinder(boolean done2) {
            assert (!done2);
            WhitespacesAndCommentsBinder whitespacesAndCommentsBinder = WhitespacesBinders.DEFAULT_RIGHT_BINDER;
            if (whitespacesAndCommentsBinder == null) {
                ErrorItem.$$$reportNull$$$0(0);
            }
            return whitespacesAndCommentsBinder;
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done2) {
            assert (!done2);
            this.myLexemeIndex = lexemeIndex;
        }

        @Override
        int getLexemeIndex(boolean done2) {
            assert (!done2);
            return this.myLexemeIndex;
        }

        @Override
        public int hc() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex] + this.myBuilder.myOffset;
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            IElementType iElementType = TokenType.ERROR_ELEMENT;
            if (iElementType == null) {
                ErrorItem.$$$reportNull$$$0(1);
            }
            return iElementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ErrorItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBinder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class LazyParseableToken
    extends Token
    implements LighterLazyParseableNode {
        private MyTreeStructure myParentStructure;
        private FlyweightCapableTreeStructure<LighterASTNode> myParsed;
        private int myStartIndex;
        private int myEndIndex;

        private LazyParseableToken() {
        }

        @Override
        public void clean() {
            this.myBuilder.myChameleonCache.remove(this.getStartOffset());
            super.clean();
            this.myParentStructure = null;
            this.myParsed = null;
        }

        @Override
        public PsiFile getContainingFile() {
            return this.myBuilder.myFile;
        }

        @Override
        public CharTable getCharTable() {
            return this.myBuilder.myCharTable;
        }

        public FlyweightCapableTreeStructure<LighterASTNode> parseContents() {
            if (this.myParsed == null) {
                this.myParsed = ((ILightLazyParseableElementType)((Object)this.getTokenType())).parseContents(this);
            }
            return this.myParsed;
        }

        @Override
        public boolean accept(@NotNull LighterLazyParseableNode.Visitor visitor2) {
            if (visitor2 == null) {
                LazyParseableToken.$$$reportNull$$$0(0);
            }
            for (int i = this.myStartIndex; i < this.myEndIndex; ++i) {
                IElementType type2 = this.myBuilder.myLexTypes[i];
                if (visitor2.visit(type2)) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private TokenSequence getParsedTokenSequence() {
            int tokenCount = this.myEndIndex - this.myStartIndex;
            if (tokenCount == 1) {
                return null;
            }
            int[] lexStarts = new int[tokenCount + 1];
            System.arraycopy(this.myBuilder.myLexStarts, this.myStartIndex, lexStarts, 0, tokenCount);
            int diff = this.myBuilder.myLexStarts[this.myStartIndex];
            int i = 0;
            while (i < tokenCount) {
                int n = i++;
                lexStarts[n] = lexStarts[n] - diff;
            }
            lexStarts[tokenCount] = this.getEndOffset() - this.getStartOffset();
            IElementType[] lexTypes = new IElementType[tokenCount + 1];
            System.arraycopy(this.myBuilder.myLexTypes, this.myStartIndex, lexTypes, 0, tokenCount);
            return new TokenSequence(lexStarts, lexTypes, tokenCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$LazyParseableToken", "accept"));
        }
    }

    private static class TokenNode
    extends Token
    implements LighterASTTokenNode {
        private TokenNode() {
        }

        public String toString() {
            return this.getText().toString();
        }
    }

    private static abstract class Token
    implements Node {
        protected PsiBuilderImpl myBuilder;
        private IElementType myTokenType;
        private int myTokenStart;
        private int myTokenEnd;
        private int myHC = -1;
        private StartMarker myParentNode;

        private Token() {
        }

        public void clean() {
            this.myBuilder = null;
            this.myHC = -1;
            this.myParentNode = null;
        }

        @Override
        public int hc() {
            if (this.myHC == -1) {
                int hc = 0;
                if (this.myTokenType instanceof TokenWrapper) {
                    String value = ((TokenWrapper)this.myTokenType).getValue();
                    for (int i = 0; i < value.length(); ++i) {
                        hc += value.charAt(i);
                    }
                } else {
                    int start = this.myTokenStart;
                    int end = this.myTokenEnd;
                    CharSequence buf = this.myBuilder.myText;
                    char[] bufArray = this.myBuilder.myTextArray;
                    for (int i = start; i < end; ++i) {
                        hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                    }
                }
                this.myHC = hc;
            }
            return this.myHC;
        }

        @Override
        public int getEndOffset() {
            return this.myTokenEnd + this.myBuilder.myOffset;
        }

        @Override
        public int getStartOffset() {
            return this.myTokenStart + this.myBuilder.myOffset;
        }

        @NotNull
        public CharSequence getText() {
            if (this.myTokenType instanceof TokenWrapper) {
                String string = ((TokenWrapper)this.myTokenType).getValue();
                if (string == null) {
                    Token.$$$reportNull$$$0(0);
                }
                return string;
            }
            CharSequence charSequence = this.myBuilder.myText.subSequence(this.myTokenStart, this.myTokenEnd);
            if (charSequence == null) {
                Token.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            IElementType iElementType = this.myTokenType;
            if (iElementType == null) {
                Token.$$$reportNull$$$0(2);
            }
            return iElementType;
        }

        void initToken(@NotNull IElementType type2, @NotNull PsiBuilderImpl builder, StartMarker parent2, int start, int end) {
            if (type2 == null) {
                Token.$$$reportNull$$$0(3);
            }
            if (builder == null) {
                Token.$$$reportNull$$$0(4);
            }
            this.myParentNode = parent2;
            this.myBuilder = builder;
            this.myTokenType = type2;
            this.myTokenStart = start;
            this.myTokenEnd = end;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$Token";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenType";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$Token";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "initToken";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class StartMarker
    extends ProductionMarker
    implements PsiBuilder.Marker {
        private IElementType myType;
        private int myDoneLexeme = -1;
        private ProductionMarker myFirstChild;
        private ProductionMarker myLastChild;
        private int myHC = -1;

        StartMarker(int markerId, PsiBuilderImpl builder) {
            super(markerId, builder);
        }

        @Override
        void clean() {
            super.clean();
            this.myBuilder.myOptionalData.clean(this.markerId);
            this.myType = null;
            this.myDoneLexeme = -1;
            this.myLastChild = null;
            this.myFirstChild = null;
            this.myHC = -1;
        }

        @Override
        public int hc() {
            if (this.myHC == -1) {
                PsiBuilderImpl builder = this.myBuilder;
                int hc = 0;
                CharSequence buf = builder.myText;
                char[] bufArray = builder.myTextArray;
                ProductionMarker child = this.myFirstChild;
                int lexIdx = this.myLexemeIndex;
                while (child != null) {
                    int lastLeaf = child.myLexemeIndex;
                    for (int i = builder.myLexStarts[lexIdx]; i < builder.myLexStarts[lastLeaf]; ++i) {
                        hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                    }
                    lexIdx = lastLeaf;
                    hc += child.hc();
                    if (child instanceof StartMarker) {
                        lexIdx = child.getEndIndex();
                    }
                    child = child.myNext;
                }
                for (int i = builder.myLexStarts[lexIdx]; i < builder.myLexStarts[this.getEndIndex()]; ++i) {
                    hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                }
                this.myHC = hc;
            }
            return this.myHC;
        }

        @Override
        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.getEndIndex()] + this.myBuilder.myOffset;
        }

        @Override
        public int getEndIndex() {
            return this.myDoneLexeme;
        }

        @Override
        @NotNull
        WhitespacesAndCommentsBinder getBinder(boolean done2) {
            WhitespacesAndCommentsBinder whitespacesAndCommentsBinder = this.myBuilder.myOptionalData.getBinder(this.markerId, done2);
            if (whitespacesAndCommentsBinder == null) {
                StartMarker.$$$reportNull$$$0(0);
            }
            return whitespacesAndCommentsBinder;
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done2) {
            if (done2) {
                this.myDoneLexeme = lexemeIndex;
            } else {
                this.myLexemeIndex = lexemeIndex;
            }
        }

        @Override
        int getLexemeIndex(boolean done2) {
            return done2 ? this.myDoneLexeme : this.myLexemeIndex;
        }

        public void addChild(@NotNull ProductionMarker node) {
            if (node == null) {
                StartMarker.$$$reportNull$$$0(1);
            }
            if (this.myFirstChild == null) {
                this.myFirstChild = node;
                this.myLastChild = node;
            } else {
                this.myLastChild.myNext = node;
                this.myLastChild = node;
            }
        }

        @Override
        @NotNull
        public PsiBuilder.Marker precede() {
            PsiBuilder.Marker marker = this.myBuilder.precede(this);
            if (marker == null) {
                StartMarker.$$$reportNull$$$0(2);
            }
            return marker;
        }

        @Override
        public void drop() {
            this.myBuilder.myProduction.dropMarker(this);
        }

        @Override
        public void rollbackTo() {
            this.myBuilder.rollbackTo(this);
        }

        @Override
        public void done(@NotNull IElementType type2) {
            if (type2 == null) {
                StartMarker.$$$reportNull$$$0(3);
            }
            this.myType = type2;
            this.myBuilder.processDone(this, null, null);
        }

        @Override
        public void collapse(@NotNull IElementType type2) {
            if (type2 == null) {
                StartMarker.$$$reportNull$$$0(4);
            }
            this.done(type2);
            this.myBuilder.myOptionalData.markCollapsed(this.markerId);
        }

        @Override
        public void doneBefore(@NotNull IElementType type2, @NotNull PsiBuilder.Marker before) {
            if (type2 == null) {
                StartMarker.$$$reportNull$$$0(5);
            }
            if (before == null) {
                StartMarker.$$$reportNull$$$0(6);
            }
            this.myType = type2;
            this.myBuilder.processDone(this, null, (StartMarker)before);
        }

        public void doneBefore(@NotNull IElementType type2, @NotNull PsiBuilder.Marker before, @NotNull String errorMessage) {
            if (type2 == null) {
                StartMarker.$$$reportNull$$$0(7);
            }
            if (before == null) {
                StartMarker.$$$reportNull$$$0(8);
            }
            if (errorMessage == null) {
                StartMarker.$$$reportNull$$$0(9);
            }
            StartMarker marker = (StartMarker)before;
            ErrorItem errorItem = this.myBuilder.myPool.allocateErrorItem();
            errorItem.myMessage = errorMessage;
            errorItem.myLexemeIndex = marker.myLexemeIndex;
            this.myBuilder.myProduction.addBefore(errorItem, marker);
            this.doneBefore(type2, before);
        }

        @Override
        public void error(@NotNull String message) {
            if (message == null) {
                StartMarker.$$$reportNull$$$0(10);
            }
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, null);
        }

        @Override
        public void errorBefore(@NotNull String message, @NotNull PsiBuilder.Marker before) {
            if (message == null) {
                StartMarker.$$$reportNull$$$0(11);
            }
            if (before == null) {
                StartMarker.$$$reportNull$$$0(12);
            }
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, (StartMarker)before);
        }

        @Override
        public IElementType getTokenType() {
            return this.myType;
        }

        @Override
        public void remapTokenType(@NotNull IElementType type2) {
            if (type2 == null) {
                StartMarker.$$$reportNull$$$0(13);
            }
            this.myType = type2;
        }

        @Override
        public void setCustomEdgeTokenBinders(WhitespacesAndCommentsBinder left, WhitespacesAndCommentsBinder right) {
            if (left != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, left, false);
            }
            if (right != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, right, true);
            }
        }

        public String toString() {
            if (this.myLexemeIndex < 0) {
                return "<dropped>";
            }
            boolean isDone = this.isDone();
            CharSequence originalText = this.myBuilder.getOriginalText();
            int startOffset = this.getStartOffset() - this.myBuilder.myOffset;
            int endOffset = isDone ? this.getEndOffset() - this.myBuilder.myOffset : this.myBuilder.getCurrentOffset();
            CharSequence text2 = originalText.subSequence(startOffset, endOffset);
            return isDone ? text2.toString() : text2 + "\u2026";
        }

        boolean isDone() {
            return this.myDoneLexeme != -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 6: 
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "before";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBinder";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "precede";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addChild";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "done";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "collapse";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "doneBefore";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "errorBefore";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "remapTokenType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class ProductionMarker
    implements Node {
        final int markerId;
        protected final PsiBuilderImpl myBuilder;
        protected int myLexemeIndex;
        protected ProductionMarker myParent;
        protected ProductionMarker myNext;

        ProductionMarker(int markerId, @NotNull PsiBuilderImpl builder) {
            if (builder == null) {
                ProductionMarker.$$$reportNull$$$0(0);
            }
            this.myLexemeIndex = -1;
            this.markerId = markerId;
            this.myBuilder = builder;
        }

        void clean() {
            this.myLexemeIndex = -1;
            this.myNext = null;
            this.myParent = null;
        }

        @Override
        public int getStartOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex] + this.myBuilder.myOffset;
        }

        public void remapTokenType(@NotNull IElementType type2) {
            if (type2 == null) {
                ProductionMarker.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        public int getStartIndex() {
            return this.myLexemeIndex;
        }

        public int getEndIndex() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @NotNull
        abstract WhitespacesAndCommentsBinder getBinder(boolean var1);

        abstract void setLexemeIndex(int var1, boolean var2);

        abstract int getLexemeIndex(boolean var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ProductionMarker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remapTokenType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface Node
    extends LighterASTNode {
        public int hc();
    }
}

