/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmDescriptorTypeWriter;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfiguration;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.FunctionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeSignatureMappingKt {
    private static final <T> T boxTypeIfNeeded(@NotNull JvmTypeFactory<T> $receiver, T possiblyPrimitiveType, boolean needBoxedType) {
        return needBoxedType ? $receiver.boxType(possiblyPrimitiveType) : possiblyPrimitiveType;
    }

    @NotNull
    public static final <T> T mapType(@NotNull KotlinType kotlinType2, @NotNull JvmTypeFactory<T> factory2, @NotNull TypeMappingMode mode, @NotNull TypeMappingConfiguration<? extends T> typeMappingConfiguration, @Nullable JvmDescriptorTypeWriter<T> descriptorTypeWriter, @NotNull Function3<? super KotlinType, ? super T, ? super TypeMappingMode, Unit> writeGenericType, boolean isIrBackend) {
        Intrinsics.checkParameterIsNotNull(kotlinType2, "kotlinType");
        Intrinsics.checkParameterIsNotNull(factory2, "factory");
        Intrinsics.checkParameterIsNotNull(mode, "mode");
        Intrinsics.checkParameterIsNotNull(typeMappingConfiguration, "typeMappingConfiguration");
        Intrinsics.checkParameterIsNotNull(writeGenericType, "writeGenericType");
        KotlinType kotlinType3 = typeMappingConfiguration.preprocessType(kotlinType2);
        if (kotlinType3 != null) {
            KotlinType kotlinType4;
            KotlinType newType = kotlinType4 = kotlinType3;
            return TypeSignatureMappingKt.mapType(newType, factory2, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType, isIrBackend);
        }
        if (FunctionTypesKt.isSuspendFunctionType(kotlinType2)) {
            return TypeSignatureMappingKt.mapType(SuspendFunctionTypesKt.transformSuspendFunctionToRuntimeFunctionType(kotlinType2, typeMappingConfiguration.releaseCoroutines()), factory2, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType, isIrBackend);
        }
        T t = TypeSignatureMappingKt.mapBuiltInType(kotlinType2, factory2, mode);
        if (t != null) {
            T t2;
            T builtInType = t2 = t;
            T jvmType = TypeSignatureMappingKt.boxTypeIfNeeded(factory2, builtInType, mode.getNeedPrimitiveBoxing());
            writeGenericType.invoke(kotlinType2, jvmType, mode);
            return jvmType;
        }
        TypeConstructor constructor = kotlinType2.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            KotlinType commonSupertype = typeMappingConfiguration.commonSupertype(((IntersectionTypeConstructor)constructor).getSupertypes());
            return TypeSignatureMappingKt.mapType(TypeUtilsKt.replaceArgumentsWithStarProjections(commonSupertype), factory2, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType, isIrBackend);
        }
        ClassifierDescriptor classifierDescriptor = constructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw (Throwable)new UnsupportedOperationException("no descriptor for type constructor of " + kotlinType2);
        }
        Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "constructor.declarationD\u2026structor of $kotlinType\")");
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        if (ErrorUtils.isError(descriptor2)) {
            T jvmType = factory2.createObjectType("error/NonExistentClass");
            ClassifierDescriptor classifierDescriptor2 = descriptor2;
            if (classifierDescriptor2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            typeMappingConfiguration.processErrorType(kotlinType2, (ClassDescriptor)classifierDescriptor2);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter != null) {
                jvmDescriptorTypeWriter.writeClass(jvmType);
            }
            return jvmType;
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(kotlinType2)) {
            T arrayElementType;
            if (kotlinType2.getArguments().size() != 1) {
                throw (Throwable)new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = kotlinType2.getArguments().get(0);
            KotlinType kotlinType5 = memberProjection.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType5, "memberProjection.type");
            KotlinType memberType = kotlinType5;
            if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                arrayElementType = factory2.createObjectType("java/lang/Object");
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter != null) {
                    JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter2;
                    JvmDescriptorTypeWriter<Object> $receiver = jvmDescriptorTypeWriter2 = jvmDescriptorTypeWriter;
                    $receiver.writeArrayType();
                    $receiver.writeClass(arrayElementType);
                    $receiver.writeArrayEnd();
                }
            } else {
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter != null) {
                    jvmDescriptorTypeWriter.writeArrayType();
                }
                Variance variance = memberProjection.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)variance, "memberProjection.projectionKind");
                arrayElementType = TypeSignatureMappingKt.mapType(memberType, factory2, mode.toGenericArgumentMode(variance), typeMappingConfiguration, descriptorTypeWriter, writeGenericType, isIrBackend);
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter3 = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter3 != null) {
                    jvmDescriptorTypeWriter3.writeArrayEnd();
                }
            }
            return factory2.createFromString("[" + factory2.toString(arrayElementType));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            T t3;
            KotlinType expandedType;
            if (((ClassDescriptor)descriptor2).isInline() && !mode.getNeedInlineClassWrapping() && (expandedType = TypeSignatureMappingKt.computeExpandedTypeForInlineClass(kotlinType2)) != null) {
                return TypeSignatureMappingKt.mapType(expandedType, factory2, mode.wrapInlineClassesMode(), typeMappingConfiguration, descriptorTypeWriter, writeGenericType, isIrBackend);
            }
            if (mode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
                t3 = factory2.getJavaLangClassType();
            } else {
                ClassDescriptor classDescriptor2 = ((ClassDescriptor)descriptor2).getOriginal();
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "descriptor.original");
                t3 = typeMappingConfiguration.getPredefinedTypeForClass(classDescriptor2);
                if (t3 == null) {
                    ClassDescriptor classDescriptor3;
                    if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                        DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)descriptor2).getContainingDeclaration();
                        if (declarationDescriptor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        }
                        classDescriptor3 = (ClassDescriptor)declarationDescriptor;
                    } else {
                        classDescriptor3 = (ClassDescriptor)descriptor2;
                    }
                    ClassDescriptor enumClassIfEnumEntry = classDescriptor3;
                    ClassDescriptor classDescriptor4 = enumClassIfEnumEntry.getOriginal();
                    Intrinsics.checkExpressionValueIsNotNull(classDescriptor4, "enumClassIfEnumEntry.original");
                    t3 = factory2.createObjectType(TypeSignatureMappingKt.computeInternalName(classDescriptor4, typeMappingConfiguration, isIrBackend));
                }
            }
            T jvmType = t3;
            writeGenericType.invoke(kotlinType2, jvmType, mode);
            return jvmType;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            boolean bl = isIrBackend;
            JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter = null;
            Function3<Object, Object, Object, Unit> function3 = FunctionsKt.getDO_NOTHING_3();
            Object type2 = TypeSignatureMappingKt.mapType(TypeSignatureMappingKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2), factory2, mode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3, bl);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter4 = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter4 != null) {
                Name name = descriptor2.getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.getName()");
                jvmDescriptorTypeWriter4.writeTypeVariable(name, type2);
            }
            return (T)type2;
        }
        throw (Throwable)new UnsupportedOperationException("Unknown type " + kotlinType2);
    }

    @NotNull
    public static /* synthetic */ Object mapType$default(KotlinType kotlinType2, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return TypeSignatureMappingKt.mapType(kotlinType2, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasVoidReturnType(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (descriptor2 instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType2 = descriptor2.getReturnType();
        if (kotlinType2 == null) {
            Intrinsics.throwNpe();
        }
        if (!KotlinBuiltIns.isUnit(kotlinType2)) return false;
        KotlinType kotlinType3 = descriptor2.getReturnType();
        if (kotlinType3 == null) {
            Intrinsics.throwNpe();
        }
        if (TypeUtils.isNullableType(kotlinType3)) return false;
        if (descriptor2 instanceof PropertyGetterDescriptor) return false;
        return true;
    }

    private static final String continuationInternalName(boolean releaseCoroutines) {
        FqName fqName2 = releaseCoroutines ? DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME_RELEASE : DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL;
        JvmClassName jvmClassName = JvmClassName.byClassId(ClassId.topLevel(fqName2));
        Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byClassId(ClassId.topLevel(fqName))");
        String string = jvmClassName.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "JvmClassName.byClassId(C\u2026vel(fqName)).internalName");
        return string;
    }

    private static final <T> T mapBuiltInType(KotlinType type2, JvmTypeFactory<T> typeFactory, TypeMappingMode mode) {
        ClassId classId;
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor descriptor2 = classDescriptor2;
        if (descriptor2 == SuspendFunctionTypesKt.getFAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL()) {
            return typeFactory.createObjectType(TypeSignatureMappingKt.continuationInternalName(false));
        }
        if (Intrinsics.areEqual(descriptor2, SuspendFunctionTypesKt.getFAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE())) {
            return typeFactory.createObjectType(TypeSignatureMappingKt.continuationInternalName(true));
        }
        PrimitiveType primitiveType = KotlinBuiltIns.getPrimitiveType(descriptor2);
        if (primitiveType != null) {
            JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.get(primitiveType);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmPrimitiveType, "JvmPrimitiveType.get(primitiveType)");
            String string = jvmPrimitiveType.getDesc();
            Intrinsics.checkExpressionValueIsNotNull(string, "JvmPrimitiveType.get(primitiveType).desc");
            T jvmType = typeFactory.createFromString(string);
            boolean isNullableInJava = TypeUtils.isNullableType(type2) || TypeEnhancementKt.hasEnhancedNullability(type2);
            return TypeSignatureMappingKt.boxTypeIfNeeded(typeFactory, jvmType, isNullableInJava);
        }
        PrimitiveType arrayElementType = KotlinBuiltIns.getPrimitiveArrayType(descriptor2);
        if (arrayElementType != null) {
            StringBuilder stringBuilder = new StringBuilder().append("[");
            JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.get(arrayElementType);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmPrimitiveType, "JvmPrimitiveType.get(arrayElementType)");
            return typeFactory.createFromString(stringBuilder.append(jvmPrimitiveType.getDesc()).toString());
        }
        if (KotlinBuiltIns.isUnderKotlinPackage(descriptor2) && (classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtilsKt.getFqNameUnsafe(descriptor2))) != null) {
            if (!mode.getKotlinCollectionsToJavaCollections()) {
                boolean bl;
                block12: {
                    Iterable $receiver$iv = JavaToKotlinClassMap.INSTANCE.getMutabilityMappings();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            JavaToKotlinClassMap.PlatformMutabilityMapping it = (JavaToKotlinClassMap.PlatformMutabilityMapping)element$iv;
                            if (!Intrinsics.areEqual(it.getJavaClass(), classId)) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return null;
                }
            }
            JvmClassName jvmClassName = JvmClassName.byClassId(classId);
            Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byClassId(classId)");
            String string = jvmClassName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "JvmClassName.byClassId(classId).internalName");
            return typeFactory.createObjectType(string);
        }
        return null;
    }

    @Nullable
    public static final KotlinType computeExpandedTypeForInlineClass(@NotNull KotlinType inlineClassType) {
        Intrinsics.checkParameterIsNotNull(inlineClassType, "inlineClassType");
        KotlinType kotlinType2 = inlineClassType;
        HashSet<ClassifierDescriptor> hashSet = new HashSet<ClassifierDescriptor>();
        return TypeSignatureMappingKt.computeExpandedTypeInner(kotlinType2, hashSet);
    }

    @Nullable
    public static final KotlinType computeExpandedTypeInner(@NotNull KotlinType kotlinType2, @NotNull HashSet<ClassifierDescriptor> visitedClassifiers) {
        KotlinType kotlinType3;
        Intrinsics.checkParameterIsNotNull(kotlinType2, "kotlinType");
        Intrinsics.checkParameterIsNotNull(visitedClassifiers, "visitedClassifiers");
        ClassifierDescriptor classifierDescriptor = kotlinType2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Type with a declaration expected: " + kotlinType2)));
        }
        Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "kotlinType.constructor.d\u2026n expected: $kotlinType\")");
        ClassifierDescriptor classifier2 = classifierDescriptor;
        if (!visitedClassifiers.add(classifier2)) {
            return null;
        }
        if (classifier2 instanceof TypeParameterDescriptor) {
            KotlinType kotlinType4;
            KotlinType expandedUpperBound;
            KotlinType kotlinType5 = TypeSignatureMappingKt.computeExpandedTypeInner(TypeSignatureMappingKt.getRepresentativeUpperBound((TypeParameterDescriptor)classifier2), visitedClassifiers);
            kotlinType3 = kotlinType5 != null ? (KotlinTypeKt.isNullable(expandedUpperBound = (kotlinType4 = kotlinType5)) || !kotlinType2.isMarkedNullable() ? expandedUpperBound : TypeUtilsKt.makeNullable(expandedUpperBound)) : null;
        } else if (classifier2 instanceof ClassDescriptor && ((ClassDescriptor)classifier2).isInline()) {
            KotlinType inlineClassBoxType = kotlinType2;
            KotlinType kotlinType6 = InlineClassesUtilsKt.substitutedUnderlyingType(kotlinType2);
            if (kotlinType6 == null) {
                return null;
            }
            KotlinType underlyingType = kotlinType6;
            KotlinType kotlinType7 = TypeSignatureMappingKt.computeExpandedTypeInner(underlyingType, visitedClassifiers);
            if (kotlinType7 == null) {
                return null;
            }
            KotlinType expandedUnderlyingType = kotlinType7;
            kotlinType3 = !KotlinTypeKt.isNullable(kotlinType2) ? expandedUnderlyingType : (KotlinTypeKt.isNullable(expandedUnderlyingType) ? inlineClassBoxType : (KotlinBuiltIns.isPrimitiveType(expandedUnderlyingType) ? inlineClassBoxType : TypeUtilsKt.makeNullable(expandedUnderlyingType)));
        } else {
            kotlinType3 = kotlinType2;
        }
        return kotlinType3;
    }

    @NotNull
    public static final String computeInternalName(@NotNull ClassDescriptor klass2, @NotNull TypeMappingConfiguration<?> typeMappingConfiguration, boolean isIrBackend) {
        Intrinsics.checkParameterIsNotNull(klass2, "klass");
        Intrinsics.checkParameterIsNotNull(typeMappingConfiguration, "typeMappingConfiguration");
        DeclarationDescriptor container2 = isIrBackend ? TypeSignatureMappingKt.getContainer(klass2.getContainingDeclaration()) : klass2.getContainingDeclaration();
        Name name = SpecialNames.safeIdentifier(klass2.getName());
        Intrinsics.checkExpressionValueIsNotNull(name, "SpecialNames.safeIdentifier(klass.name)");
        String string = name.getIdentifier();
        Intrinsics.checkExpressionValueIsNotNull(string, "SpecialNames.safeIdentifier(klass.name).identifier");
        String name2 = string;
        if (container2 instanceof PackageFragmentDescriptor) {
            String string2;
            FqName fqName2 = ((PackageFragmentDescriptor)container2).getFqName();
            if (fqName2.isRoot()) {
                string2 = name2;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = fqName2.asString();
                Intrinsics.checkExpressionValueIsNotNull(string3, "fqName.asString()");
                string2 = stringBuilder.append(StringsKt.replace$default(string3, '.', '/', false, 4, null)).append('/').append(name2).toString();
            }
            return string2;
        }
        DeclarationDescriptor declarationDescriptor = container2;
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor2 == null) {
            throw (Throwable)new IllegalArgumentException("Unexpected container: " + container2 + " for " + klass2);
        }
        ClassDescriptor containerClass = classDescriptor2;
        String string4 = typeMappingConfiguration.getPredefinedInternalNameForClass(containerClass);
        if (string4 == null) {
            string4 = TypeSignatureMappingKt.computeInternalName(containerClass, typeMappingConfiguration, isIrBackend);
        }
        String containerInternalName = string4;
        return containerInternalName + '$' + name2;
    }

    @NotNull
    public static /* synthetic */ String computeInternalName$default(ClassDescriptor classDescriptor2, TypeMappingConfiguration typeMappingConfiguration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            typeMappingConfiguration = TypeMappingConfigurationImpl.INSTANCE;
        }
        return TypeSignatureMappingKt.computeInternalName(classDescriptor2, typeMappingConfiguration, bl);
    }

    private static final DeclarationDescriptor getContainer(DeclarationDescriptor container2) {
        DeclarationDescriptor declarationDescriptor;
        DeclarationDescriptor declarationDescriptor2;
        DeclarationDescriptor declarationDescriptor3 = container2;
        if (!(declarationDescriptor3 instanceof ClassDescriptor)) {
            declarationDescriptor3 = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor3;
        if (classDescriptor2 != null) {
            declarationDescriptor2 = classDescriptor2;
        } else {
            DeclarationDescriptor declarationDescriptor4 = container2;
            if (!(declarationDescriptor4 instanceof PackageFragmentDescriptor)) {
                declarationDescriptor4 = null;
            }
            declarationDescriptor2 = declarationDescriptor = (DeclarationDescriptor)((PackageFragmentDescriptor)declarationDescriptor4);
        }
        if (declarationDescriptor2 == null) {
            DeclarationDescriptor declarationDescriptor5 = container2;
            if (declarationDescriptor5 != null) {
                DeclarationDescriptor declarationDescriptor6;
                DeclarationDescriptor it = declarationDescriptor6 = declarationDescriptor5;
                declarationDescriptor = TypeSignatureMappingKt.getContainer(it.getContainingDeclaration());
            } else {
                declarationDescriptor = null;
            }
        }
        return declarationDescriptor;
    }

    @NotNull
    public static final KotlinType getRepresentativeUpperBound(@NotNull TypeParameterDescriptor descriptor2) {
        KotlinType kotlinType2;
        Object v4;
        List<KotlinType> upperBounds2;
        block4: {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            List<KotlinType> list2 = descriptor2.getUpperBounds();
            Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.upperBounds");
            upperBounds2 = list2;
            boolean bl2 = bl = !upperBounds2.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Upper bounds should not be empty: " + descriptor2;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable $receiver$iv = upperBounds2;
            for (Object element$iv : $receiver$iv) {
                ClassDescriptor classDescriptor2;
                KotlinType it = (KotlinType)element$iv;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                boolean bl3 = (ClassDescriptor)classifierDescriptor == null ? false : classDescriptor2.getKind() != ClassKind.INTERFACE && classDescriptor2.getKind() != ClassKind.ANNOTATION_CLASS;
                if (!bl3) continue;
                v4 = element$iv;
                break block4;
            }
            v4 = null;
        }
        if ((kotlinType2 = (KotlinType)v4) == null) {
            KotlinType kotlinType3 = CollectionsKt.first(upperBounds2);
            Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "upperBounds.first()");
            kotlinType2 = kotlinType3;
        }
        return kotlinType2;
    }
}

