/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MethodSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import org.jetbrains.annotations.NotNull;

public final class SignatureBuildingComponents {
    public static final SignatureBuildingComponents INSTANCE;

    @NotNull
    public final String javaLang(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return "java/lang/" + name;
    }

    @NotNull
    public final String javaUtil(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return "java/util/" + name;
    }

    @NotNull
    public final String javaFunction(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return "java/util/function/" + name;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] constructors(String ... signatures) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(signatures, "signatures");
        Object $receiver$iv = signatures;
        String[] stringArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((String[])$receiver$iv).length);
        void var5_5 = $receiver$iv$iv;
        int n = ((void)var5_5).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = var5_5[i];
            Collection collection = destination$iv$iv;
            String string = "<init>(" + (String)it + ")V";
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        Object thisCollection$iv = $receiver$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray2;
    }

    @NotNull
    public final LinkedHashSet<String> inJavaLang(@NotNull String name, String ... signatures) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(signatures, "signatures");
        return this.inClass(this.javaLang(name), Arrays.copyOf(signatures, signatures.length));
    }

    @NotNull
    public final LinkedHashSet<String> inJavaUtil(@NotNull String name, String ... signatures) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(signatures, "signatures");
        return this.inClass(this.javaUtil(name), Arrays.copyOf(signatures, signatures.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LinkedHashSet<String> inClass(@NotNull String internalName, String ... signatures) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(internalName, "internalName");
        Intrinsics.checkParameterIsNotNull(signatures, "signatures");
        String[] stringArray = signatures;
        Collection destination$iv = new LinkedHashSet();
        void var5_5 = $receiver$iv;
        int n = ((void)var5_5).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv;
            void var9_9 = item$iv = var5_5[i];
            Collection collection = destination$iv;
            String string = internalName + "." + (String)it;
            collection.add(string);
        }
        return (LinkedHashSet)destination$iv;
    }

    @NotNull
    public final String signature(@NotNull ClassDescriptor classDescriptor2, @NotNull String jvmDescriptor2) {
        Intrinsics.checkParameterIsNotNull(classDescriptor2, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(jvmDescriptor2, "jvmDescriptor");
        return this.signature(MethodSignatureMappingKt.getInternalName(classDescriptor2), jvmDescriptor2);
    }

    @NotNull
    public final String signature(@NotNull String internalName, @NotNull String jvmDescriptor2) {
        Intrinsics.checkParameterIsNotNull(internalName, "internalName");
        Intrinsics.checkParameterIsNotNull(jvmDescriptor2, "jvmDescriptor");
        return internalName + "." + jvmDescriptor2;
    }

    @NotNull
    public final String jvmDescriptor(@NotNull String name, @NotNull List<String> parameters2, @NotNull String ret) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        Intrinsics.checkParameterIsNotNull(ret, "ret");
        return name + '(' + CollectionsKt.joinToString$default(parameters2, "", null, null, 0, null, jvmDescriptor.1.INSTANCE, 30, null) + ')' + this.escapeClassName(ret);
    }

    private final String escapeClassName(String internalName) {
        return internalName.length() > 1 ? 'L' + internalName + ';' : internalName;
    }

    private SignatureBuildingComponents() {
    }

    static {
        SignatureBuildingComponents signatureBuildingComponents;
        INSTANCE = signatureBuildingComponents = new SignatureBuildingComponents();
    }

    public static final /* synthetic */ String access$escapeClassName(SignatureBuildingComponents $this, String internalName) {
        return $this.escapeClassName(internalName);
    }
}

