/*
 * Decompiled with CFR 0.152.
 */
package greenlab.org.ebugslocator.detectors;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import greenlab.org.ebugslocator.utils.Reporter;
import greenlab.org.ebugslocator.utils.StringUtils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MemoizationChanceDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Class<? extends Detector> DETECTOR_CLASS = MemoizationChanceDetector.class;
    private static final EnumSet<Scope> DETECTOR_SCOPE = Scope.JAVA_FILE_SCOPE;
    private static final Implementation IMPLEMENTATION = new Implementation(DETECTOR_CLASS, DETECTOR_SCOPE);
    private static final String ISSUE_ID = "MemoizationChance";
    private static final String ISSUE_DESCRIPTION = "The method is memoizable";
    private static final String ISSUE_EXPLANATION = "Methods that work as simples functions are good targets to exploit memoization for performance enhancement.";
    private static final Category ISSUE_CATEGORY = Category.PERFORMANCE;
    private static final int ISSUE_PRIORITY = 5;
    private static final Severity ISSUE_SEVERITY = Severity.WARNING;
    public static final Issue ISSUE = Issue.create((String)"MemoizationChance", (String)"The method is memoizable", (String)"Methods that work as simples functions are good targets to exploit memoization for performance enhancement.", (Category)ISSUE_CATEGORY, (int)5, (Severity)ISSUE_SEVERITY, (Implementation)IMPLEMENTATION);
    private HashMap<String, Boolean> classVars = new HashMap();
    private HashMap<String, Boolean> classMethods = new HashMap();
    private HashMap<String, Set<String>> methodCalls = new HashMap();
    private HashMap<String, HashSet<String>> methodLocalVars = new HashMap();
    public static HashSet<String> nativeTypes = new HashSet();

    public MemoizationChanceDetector() {
        nativeTypes.add("boolean");
        nativeTypes.add("int");
        nativeTypes.add("short");
        nativeTypes.add("long");
        nativeTypes.add("float");
        nativeTypes.add("double");
        nativeTypes.add("byte");
        nativeTypes.add("char");
        nativeTypes.add("java.lang.Boolean");
        nativeTypes.add("java.lang.Integer");
        nativeTypes.add("java.lang.Short");
        nativeTypes.add("java.lang.Long");
        nativeTypes.add("java.lang.Float");
        nativeTypes.add("java.lang.Double");
        nativeTypes.add("java.lang.Byte");
        nativeTypes.add("java.lang.Character");
        nativeTypes.add("java.lang.String");
    }

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Arrays.asList(PsiMethod.class, PsiMethodCallExpression.class, PsiReferenceExpression.class, PsiField.class, PsiLocalVariable.class, PsiParameter.class);
    }

    public void afterCheckProject(Context context) {
        if (context.getDriver().getPhase() < 3) {
            context.getDriver().requestRepeat((Detector)this, DETECTOR_SCOPE);
        }
        super.afterCheckProject(context);
    }

    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        int phase = context.getDriver().getPhase();
        if (phase == 1) {
            return new ClassVarsChecker(context, phase);
        }
        if (phase == 2) {
            return new MemoizationChecker(context, phase);
        }
        this.checkInnerCalls();
        return new ReportChecker(context, phase);
    }

    private void checkInnerCalls() {
        for (String m : this.methodCalls.keySet()) {
            Boolean check = this.classMethods.get(m);
            if (check == null || !check.booleanValue()) continue;
            boolean allCallsMemoizable = true;
            for (String call : this.methodCalls.get(m)) {
                if (!allCallsMemoizable) break;
                if (this.classMethods.containsKey(call)) {
                    allCallsMemoizable = this.classMethods.get(call);
                    continue;
                }
                if (this.methodLocalVars.get(m) != null && this.methodLocalVars.get(m).contains(call)) {
                    allCallsMemoizable = true;
                    continue;
                }
                allCallsMemoizable = false;
            }
            this.classMethods.put(m, allCallsMemoizable);
        }
    }

    public PsiMethod getParentMethod(PsiElement elem) {
        if (elem == null) {
            return null;
        }
        if (elem instanceof PsiMethod) {
            return (PsiMethod)elem;
        }
        PsiElement p = elem.getParent();
        return this.getParentMethod(p);
    }

    public String getParentMethodName(PsiElement elem, JavaContext context) {
        PsiMethod method = this.getParentMethod(elem);
        if (method == null) {
            return "";
        }
        String filename = StringUtils.getShortFileName(context.getJavaFile());
        String packageName = context.getJavaFile().getPackageName();
        return packageName + "." + filename + "." + method.getName();
    }

    private class ReportChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;
        private int phase;
        private String filename;

        public ReportChecker(JavaContext context, int phase) {
            this.mContext = context;
            this.phase = phase;
            this.filename = StringUtils.getShortFileName(this.mContext.getJavaFile());
        }

        public void visitMethod(PsiMethod method) {
            String name = MemoizationChanceDetector.this.getParentMethodName((PsiElement)method, this.mContext);
            Boolean containsBody = method.getBody() != null && method.getBody().getStatements() != null && method.getBody().getStatements().length > 1;
            Boolean check = MemoizationChanceDetector.this.classMethods.containsKey(name) && (Boolean)MemoizationChanceDetector.this.classMethods.get(name) != false;
            if (!name.equals("") && containsBody.booleanValue() && check.booleanValue()) {
                Reporter.reportIssue(this.mContext, ISSUE, method);
            }
            super.visitMethod(method);
        }
    }

    private class MemoizationChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;
        private int phase;
        private String filename;

        public MemoizationChecker(JavaContext context, int phase) {
            this.mContext = context;
            this.phase = phase;
            this.filename = StringUtils.getShortFileName(this.mContext.getJavaFile());
        }

        private boolean areParametersNative(PsiParameterList parameterList) {
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length == 0) {
                return false;
            }
            for (int i = 0; i < parameterList.getParametersCount(); ++i) {
                PsiParameter param = parameters[i];
                String typeName = param.getType().getCanonicalText();
                if (nativeTypes.contains(typeName)) continue;
                return false;
            }
            return true;
        }

        private boolean isReturnTypeNative(PsiType returnType) {
            return nativeTypes.contains(returnType.getCanonicalText());
        }

        private void addMethodCall(String calleeMethod, String call) {
            if (MemoizationChanceDetector.this.methodCalls.containsKey(calleeMethod)) {
                ((Set)MemoizationChanceDetector.this.methodCalls.get(calleeMethod)).add(call);
            } else {
                HashSet<String> calls = new HashSet<String>();
                calls.add(call);
                MemoizationChanceDetector.this.methodCalls.put(calleeMethod, calls);
            }
        }

        public void visitMethod(PsiMethod method) {
            String visitingMethod = MemoizationChanceDetector.this.getParentMethodName((PsiElement)method, this.mContext);
            if (!method.isConstructor() && !visitingMethod.equals("")) {
                boolean goFurther = this.isReturnTypeNative(method.getReturnType()) && this.areParametersNative(method.getParameterList());
                MemoizationChanceDetector.this.classMethods.put(visitingMethod, goFurther);
            }
            super.visitMethod(method);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            String visitingMethod = MemoizationChanceDetector.this.getParentMethodName((PsiElement)expression, this.mContext);
            Boolean check = (Boolean)MemoizationChanceDetector.this.classMethods.get(visitingMethod);
            if (!visitingMethod.equals("") && check != null && check.booleanValue()) {
                String qualifiedVarName = expression.getQualifiedName().replace("this.", "");
                String exprVarName = expression.getText().replace("this.", "").replaceAll("\\..+", "");
                Set methodVars = (Set)MemoizationChanceDetector.this.methodLocalVars.get(visitingMethod);
                boolean isLocalVar = methodVars != null && (methodVars.contains(qualifiedVarName) || methodVars.contains(exprVarName));
                boolean isFinalVar = MemoizationChanceDetector.this.classVars.keySet().contains(qualifiedVarName) && (Boolean)MemoizationChanceDetector.this.classVars.get(qualifiedVarName) != false;
                boolean isMethodCall = MemoizationChanceDetector.this.classMethods.containsKey(qualifiedVarName);
                if (!(isLocalVar || isFinalVar || isMethodCall)) {
                    MemoizationChanceDetector.this.classMethods.put(visitingMethod, false);
                }
            }
            super.visitReferenceExpression(expression);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            String visitingMethod = MemoizationChanceDetector.this.getParentMethodName((PsiElement)expression, this.mContext);
            if (!visitingMethod.equals("")) {
                PsiExpression callVarExp = expression.getMethodExpression().getQualifierExpression();
                String callVariable = "";
                if (callVarExp != null) {
                    callVariable = callVarExp.getText().replace("this.", "");
                }
                String call = expression.getMethodExpression().getQualifiedName();
                if (!callVariable.equals("")) {
                    call = callVariable;
                }
                this.addMethodCall(visitingMethod, call);
            }
            super.visitMethodCallExpression(expression);
        }
    }

    private class ClassVarsChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;
        private int phase;
        private String filename;

        public ClassVarsChecker(JavaContext context, int phase) {
            this.mContext = context;
            this.phase = phase;
            this.filename = StringUtils.getShortFileName(this.mContext.getJavaFile());
        }

        private void addLocalVar(String methodName, String varName) {
            if (MemoizationChanceDetector.this.methodLocalVars.containsKey(methodName)) {
                ((HashSet)MemoizationChanceDetector.this.methodLocalVars.get(methodName)).add(varName);
            } else {
                HashSet<String> calls = new HashSet<String>();
                calls.add(varName);
                MemoizationChanceDetector.this.methodLocalVars.put(methodName, calls);
            }
        }

        private Set<String> getMethodArgs(PsiMethod method) {
            PsiParameter[] params;
            HashSet<String> args = new HashSet<String>();
            for (PsiParameter p : params = method.getParameterList().getParameters()) {
                args.add(p.getName());
            }
            return args;
        }

        public void visitField(PsiField field) {
            String className = this.mContext.getJavaFile().getPackageName() + "." + this.filename;
            MemoizationChanceDetector.this.classVars.put(className + "." + field.getName(), field.getModifierList().hasModifierProperty("final"));
            super.visitVariable((PsiVariable)field);
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            String parentMethod = MemoizationChanceDetector.this.getParentMethodName((PsiElement)variable, this.mContext);
            if (!parentMethod.equals("")) {
                this.addLocalVar(parentMethod, variable.getName());
            }
            super.visitLocalVariable(variable);
        }

        public void visitParameter(PsiParameter parameter) {
            String visitingMethod = MemoizationChanceDetector.this.getParentMethodName((PsiElement)parameter, this.mContext);
            if (!visitingMethod.equals("")) {
                this.addLocalVar(visitingMethod, parameter.getName());
            }
            super.visitParameter(parameter);
        }

        public void visitMethod(PsiMethod method) {
            String visitingMethod = MemoizationChanceDetector.this.getParentMethodName((PsiElement)method, this.mContext);
            if (!method.isConstructor() && !visitingMethod.equals("")) {
                MemoizationChanceDetector.this.classMethods.put(visitingMethod, true);
            }
            super.visitMethod(method);
        }
    }
}

