/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.List;
import soot.Body;
import soot.Unit;
import soot.ValueBox;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public class ValueBoxesValidator
implements BodyValidator {
    public static ValueBoxesValidator INSTANCE;

    public static ValueBoxesValidator v() {
        if (INSTANCE == null) {
            INSTANCE = new ValueBoxesValidator();
        }
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        List<ValueBox> l = body.getUseAndDefBoxes();
        for (int i = 0; i < l.size(); ++i) {
            for (int j = 0; j < l.size(); ++j) {
                if (i == j || l.get(i) != l.get(j)) continue;
                System.err.println("Aliased value box : " + l.get(i) + " in " + body.getMethod());
                for (Unit u : body.getUnits()) {
                    System.err.println("" + u);
                }
                exception.add(new ValidationException(l.get(i), "Aliased value box : " + l.get(i) + " in " + body.getMethod()));
            }
        }
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }
}

