/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.List;
import soot.Body;
import soot.UnitBox;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public class UnitBoxesValidator
implements BodyValidator {
    public static UnitBoxesValidator INSTANCE;

    public static UnitBoxesValidator v() {
        if (INSTANCE == null) {
            INSTANCE = new UnitBoxesValidator();
        }
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        for (UnitBox ub : body.getAllUnitBoxes()) {
            if (body.getUnits().contains(ub.getUnit())) continue;
            throw new RuntimeException("Unitbox points outside unitChain! to unit : " + ub.getUnit() + " in " + body.getMethod());
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

