/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import java.util.LinkedList;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Unit;
import soot.baf.BafBody;
import soot.tagkit.CodeAttribute;
import soot.tagkit.Tag;

public abstract class TagAggregator
extends BodyTransformer {
    protected LinkedList<Tag> tags = new LinkedList();
    protected LinkedList<Unit> units = new LinkedList();

    public abstract boolean wantTag(Tag var1);

    public abstract void considerTag(Tag var1, Unit var2);

    public abstract String aggregatedName();

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        BafBody body = (BafBody)b;
        this.tags.clear();
        this.units.clear();
        for (Unit unit : body.getUnits()) {
            for (Tag tag : unit.getTags()) {
                if (!this.wantTag(tag)) continue;
                this.considerTag(tag, unit);
            }
        }
        if (this.units.size() > 0) {
            b.addTag(new CodeAttribute(this.aggregatedName(), new LinkedList<Unit>(this.units), new LinkedList<Tag>(this.tags)));
        }
        this.fini();
    }

    public void fini() {
    }
}

