/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.List;
import soot.Body;
import soot.Unit;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public class InvokeArgumentValidator
implements BodyValidator {
    private static InvokeArgumentValidator INSTANCE;

    public static InvokeArgumentValidator v() {
        if (INSTANCE == null) {
            INSTANCE = new InvokeArgumentValidator();
        }
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exceptions) {
        for (Unit u : body.getUnits()) {
            InvokeExpr iinvExpr;
            Stmt s = (Stmt)u;
            if (!s.containsInvokeExpr() || (iinvExpr = s.getInvokeExpr()).getArgCount() == iinvExpr.getMethod().getParameterCount()) continue;
            exceptions.add(new ValidationException(s, "Invalid number of arguments"));
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

