/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import soot.SideEffectTester;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Expr;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.toolkits.scalar.ToppedSet;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;

public class FastAvailableExpressionsAnalysis
extends ForwardFlowAnalysis {
    SideEffectTester st;
    Map<Unit, FlowSet> unitToGenerateSet;
    Map unitToPreserveSet;
    Map<Value, Unit> rhsToContainingStmt;
    FlowSet emptySet;

    public FastAvailableExpressionsAnalysis(DirectedGraph dg, SootMethod m, SideEffectTester st) {
        super(dg);
        this.st = st;
        ExceptionalUnitGraph g = (ExceptionalUnitGraph)dg;
        SmartLocalDefs ld = new SmartLocalDefs(g, new SimpleLiveLocals(g));
        this.rhsToContainingStmt = new HashMap<Value, Unit>();
        this.emptySet = new ToppedSet(new ArraySparseSet());
        this.unitToGenerateSet = new HashMap<Unit, FlowSet>(g.size() * 2 + 1, 0.7f);
        for (Unit s : g) {
            AssignStmt as;
            FlowSet<Value> genSet = this.emptySet.clone();
            if (s instanceof AssignStmt && ((as = (AssignStmt)s).getRightOp() instanceof Expr || as.getRightOp() instanceof FieldRef)) {
                Value gen = as.getRightOp();
                this.rhsToContainingStmt.put(gen, s);
                boolean cantAdd = false;
                if (gen instanceof NewExpr || gen instanceof NewArrayExpr || gen instanceof NewMultiArrayExpr) {
                    cantAdd = true;
                }
                if (gen instanceof InvokeExpr) {
                    cantAdd = true;
                }
                if (!cantAdd) {
                    genSet.add(gen, genSet);
                }
            }
            this.unitToGenerateSet.put(s, genSet);
        }
        this.doAnalysis();
    }

    @Override
    protected Object newInitialFlow() {
        FlowSet newSet = this.emptySet.clone();
        ((ToppedSet)newSet).setTop(true);
        return newSet;
    }

    @Override
    protected Object entryInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        in.copy(out);
        if (((ToppedSet)in).isTop()) {
            return;
        }
        out.union(this.unitToGenerateSet.get(unit), out);
        Unit u = (Unit)unit;
        ArrayList toRemove = new ArrayList();
        if (((ToppedSet)out).isTop()) {
            throw new RuntimeException("trying to kill on topped set!");
        }
        LinkedList l = new LinkedList();
        l.addAll(out.toList());
        for (Value avail : l) {
            if (avail instanceof FieldRef) {
                if (!this.st.unitCanWriteTo(u, avail)) continue;
                out.remove(avail, out);
                continue;
            }
            Iterator<ValueBox> usesIt = avail.getUseBoxes().iterator();
            while (usesIt.hasNext()) {
                Value use = usesIt.next().getValue();
                if (!this.st.unitCanWriteTo(u, use)) continue;
                out.remove(avail, out);
            }
        }
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    @Override
    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

