/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.parity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AddExpr;
import soot.jimple.ArithmeticConstant;
import soot.jimple.BinopExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.MulExpr;
import soot.jimple.SubExpr;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.LiveLocals;
import soot.util.Chain;

public class ParityAnalysis
extends ForwardFlowAnalysis<Unit, Map<Value, String>> {
    private UnitGraph g;
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private static final String EVEN = "even";
    private static final String ODD = "odd";
    private LiveLocals filter;

    public ParityAnalysis(UnitGraph g, LiveLocals filter) {
        super(g);
        this.g = g;
        this.filter = filter;
        this.filterUnitToBeforeFlow = new HashMap();
        this.buildBeforeFilterMap();
        this.filterUnitToAfterFlow = new HashMap();
        this.doAnalysis();
    }

    public ParityAnalysis(UnitGraph g) {
        super(g);
        this.g = g;
        this.doAnalysis();
    }

    private void buildBeforeFilterMap() {
        for (Unit s : this.g.getBody().getUnits()) {
            HashMap<Local, String> map = new HashMap<Local, String>();
            for (Local l : this.filter.getLiveLocalsBefore(s)) {
                map.put(l, BOTTOM);
            }
            this.filterUnitToBeforeFlow.put(s, map);
        }
    }

    @Override
    protected void merge(Map<Value, String> inMap1, Map<Value, String> inMap2, Map<Value, String> outMap) {
        Set<Value> keys = inMap1.keySet();
        for (Value var1 : keys) {
            String inVal1 = inMap1.get(var1);
            String inVal2 = inMap2.get(var1);
            if (inVal2 == null) {
                outMap.put(var1, inVal1);
                continue;
            }
            if (inVal1.equals(BOTTOM)) {
                outMap.put(var1, inVal2);
                continue;
            }
            if (inVal2.equals(BOTTOM)) {
                outMap.put(var1, inVal1);
                continue;
            }
            if (inVal1.equals(EVEN) && inVal2.equals(EVEN)) {
                outMap.put(var1, EVEN);
                continue;
            }
            if (inVal1.equals(ODD) && inVal2.equals(ODD)) {
                outMap.put(var1, ODD);
                continue;
            }
            outMap.put(var1, TOP);
        }
    }

    @Override
    protected void copy(Map<Value, String> sourceIn, Map<Value, String> destOut) {
        destOut.clear();
        destOut.putAll(sourceIn);
    }

    private String getParity(Map<Value, String> in, Value val) {
        if (val instanceof AddExpr | val instanceof SubExpr) {
            String resVal1 = this.getParity(in, ((BinopExpr)val).getOp1());
            String resVal2 = this.getParity(in, ((BinopExpr)val).getOp2());
            if (resVal1.equals(TOP) | resVal2.equals(TOP)) {
                return TOP;
            }
            if (resVal1.equals(BOTTOM) | resVal2.equals(BOTTOM)) {
                return BOTTOM;
            }
            if (resVal1.equals(resVal2)) {
                return EVEN;
            }
            return ODD;
        }
        if (val instanceof MulExpr) {
            String resVal1 = this.getParity(in, ((BinopExpr)val).getOp1());
            String resVal2 = this.getParity(in, ((BinopExpr)val).getOp2());
            if (resVal1.equals(TOP) | resVal2.equals(TOP)) {
                return TOP;
            }
            if (resVal1.equals(BOTTOM) | resVal2.equals(BOTTOM)) {
                return BOTTOM;
            }
            if (resVal1.equals(ODD) && resVal2.equals(ODD)) {
                return ODD;
            }
            return EVEN;
        }
        if (val instanceof IntConstant) {
            int value = ((IntConstant)val).value;
            if (value % 2 == 0) {
                return EVEN;
            }
            return ODD;
        }
        if (val instanceof LongConstant) {
            long value = ((LongConstant)val).value;
            if (value % 2L == 0L) {
                return EVEN;
            }
            return ODD;
        }
        if (in.containsKey(val)) {
            return in.get(val);
        }
        return TOP;
    }

    @Override
    protected void flowThrough(Map<Value, String> in, Unit s, Map<Value, String> out) {
        Value left;
        out.putAll(in);
        if (s instanceof DefinitionStmt && (left = ((DefinitionStmt)s).getLeftOp()) instanceof Local && (left.getType() instanceof IntegerType || left.getType() instanceof LongType)) {
            Value right = ((DefinitionStmt)s).getRightOp();
            out.put(left, this.getParity(out, right));
        }
        for (ValueBox next : s.getUseAndDefBoxes()) {
            Value val = next.getValue();
            if (!(val instanceof ArithmeticConstant)) continue;
            out.put(val, this.getParity(out, val));
        }
        if (Options.v().interactive_mode()) {
            this.buildAfterFilterMap(s);
            this.updateAfterFilterMap(s);
        }
    }

    private void buildAfterFilterMap(Unit s) {
        List<Local> list = this.filter.getLiveLocalsAfter(s);
        HashMap<Local, String> map = new HashMap<Local, String>();
        Iterator<Local> listIt = list.iterator();
        while (listIt.hasNext()) {
            map.put(listIt.next(), BOTTOM);
        }
        this.filterUnitToAfterFlow.put(s, map);
    }

    @Override
    protected Map<Value, String> entryInitialFlow() {
        return this.newInitialFlow();
    }

    private void updateBeforeFilterMap() {
        for (Unit s : this.filterUnitToBeforeFlow.keySet()) {
            Map allData = (Map)this.unitToBeforeFlow.get(s);
            Map filterData = (Map)this.filterUnitToBeforeFlow.get(s);
            this.filterUnitToBeforeFlow.put(s, this.updateFilter(allData, filterData));
        }
    }

    private void updateAfterFilterMap(Unit s) {
        Map allData = (Map)this.unitToAfterFlow.get(s);
        Map filterData = (Map)this.filterUnitToAfterFlow.get(s);
        this.filterUnitToAfterFlow.put(s, this.updateFilter(allData, filterData));
    }

    private Map<Value, String> updateFilter(Map<Value, String> allData, Map<Value, String> filterData) {
        if (allData == null) {
            return filterData;
        }
        Iterator<Value> filterVarsIt = filterData.keySet().iterator();
        ArrayList<Value> toRemove = new ArrayList<Value>();
        while (filterVarsIt.hasNext()) {
            Value v = filterVarsIt.next();
            if (allData.get(v) == null) {
                toRemove.add(v);
                continue;
            }
            filterData.put(v, allData.get(v));
        }
        Iterator removeIt = toRemove.iterator();
        while (removeIt.hasNext()) {
            filterData.remove(removeIt.next());
        }
        return filterData;
    }

    @Override
    protected Map<Value, String> newInitialFlow() {
        HashMap<Value, String> initMap = new HashMap<Value, String>();
        Chain<Local> locals = this.g.getBody().getLocals();
        for (Local next : locals) {
            if (!(next.getType() instanceof IntegerType) && !(next.getType() instanceof LongType)) continue;
            initMap.put(next, BOTTOM);
        }
        Iterator<ValueBox> boxIt = this.g.getBody().getUseAndDefBoxes().iterator();
        while (boxIt.hasNext()) {
            Value val = boxIt.next().getValue();
            if (!(val instanceof ArithmeticConstant)) continue;
            initMap.put(val, this.getParity(initMap, val));
        }
        if (Options.v().interactive_mode()) {
            this.updateBeforeFilterMap();
        }
        return initMap;
    }
}

