/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import soot.SootField;
import soot.SootMethod;
import soot.jimple.spark.ondemand.genericutil.Predicate;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;

public class PagToDotDumper {
    public static final int TRACE_MAX_LVL = 99;
    private PAG pag;
    private HashMap<Node, Node[]> vmatches;
    private HashMap<Node, Node[]> invVmatches;
    private static final Predicate<Node> emptyP2SetPred = new Predicate<Node>(){

        @Override
        public boolean test(Node n) {
            return !(n instanceof AllocNode) && n.getP2Set().isEmpty();
        }
    };

    public PagToDotDumper(PAG pag) {
        this.pag = pag;
        this.vmatches = new HashMap();
        this.invVmatches = new HashMap();
    }

    private void buildVmatchEdges() {
        Iterator<FieldRefNode> iter = this.pag.loadSourcesIterator();
        while (iter.hasNext()) {
            FieldRefNode frn1 = iter.next();
            Iterator<FieldRefNode> iter2 = this.pag.storeInvSourcesIterator();
            while (iter2.hasNext()) {
                int i;
                FieldRefNode frn2 = iter2.next();
                VarNode base1 = frn1.getBase();
                VarNode base2 = frn2.getBase();
                if (!frn1.getField().equals(frn2.getField()) || !base1.getP2Set().hasNonEmptyIntersection(base2.getP2Set())) continue;
                Node[] src = this.pag.loadLookup(frn1);
                Node[] dst = this.pag.storeInvLookup(frn2);
                for (i = 0; i < src.length; ++i) {
                    this.vmatches.put(src[i], dst);
                }
                for (i = 0; i < dst.length; ++i) {
                    this.invVmatches.put(dst[i], src);
                }
            }
        }
    }

    private void debug(FieldRefNode frn1, FieldRefNode frn2, VarNode base1, VarNode base2) {
        if (base1 instanceof LocalVarNode && base2 instanceof LocalVarNode) {
            LocalVarNode lvn1 = (LocalVarNode)base1;
            LocalVarNode lvn2 = (LocalVarNode)base2;
            if (lvn1.getMethod().getDeclaringClass().getName().equals("java.util.Hashtable$ValueCollection") && lvn1.getMethod().getName().equals("contains") && lvn2.getMethod().getDeclaringClass().getName().equals("java.util.Hashtable$ValueCollection") && lvn2.getMethod().getName().equals("<init>")) {
                System.err.println("Method: " + lvn1.getMethod().getName());
                System.err.println(PagToDotDumper.makeLabel(frn1));
                System.err.println("Base: " + base1.getVariable());
                System.err.println("Field: " + frn1.getField());
                System.err.println(PagToDotDumper.makeLabel(frn2));
                System.err.println("Base: " + base2.getVariable());
                System.err.println("Field: " + frn2.getField());
                if (frn1.getField().equals(frn2.getField())) {
                    System.err.println("field match");
                    if (base1.getP2Set().hasNonEmptyIntersection(base2.getP2Set())) {
                        System.err.println("non empty");
                    } else {
                        System.err.println("b1: " + base1.getP2Set());
                        System.err.println("b2: " + base2.getP2Set());
                    }
                }
            }
        }
    }

    private static String translateEdge(Node src, Node dest, String label) {
        return PagToDotDumper.makeNodeName(src) + " -> " + PagToDotDumper.makeNodeName(dest) + " [label=\"" + label + "\"];";
    }

    public static String makeDotNodeLabel(Node n, Predicate<Node> p) {
        String color = "";
        if (p.test(n)) {
            color = ", color=red";
        }
        String label = n instanceof LocalVarNode ? PagToDotDumper.makeLabel((LocalVarNode)n) : (n instanceof AllocNode ? PagToDotDumper.makeLabel((AllocNode)n) : (n instanceof FieldRefNode ? PagToDotDumper.makeLabel((FieldRefNode)n) : n.toString()));
        return PagToDotDumper.makeNodeName(n) + "[label=\"" + label + "\"" + color + "];";
    }

    private static String translateLabel(Node n) {
        return PagToDotDumper.makeDotNodeLabel(n, emptyP2SetPred);
    }

    private boolean isDefinedIn(LocalVarNode lvNode, String cName, String mName) {
        return lvNode.getMethod() != null && lvNode.getMethod().getDeclaringClass().getName().equals(cName) && lvNode.getMethod().getName().equals(mName);
    }

    private void printOneNode(VarNode node) {
        int i;
        PrintStream ps = System.err;
        ps.println(PagToDotDumper.makeLabel(node));
        Node[] succs = this.pag.simpleInvLookup(node);
        ps.println("assign");
        ps.println("======");
        for (i = 0; i < succs.length; ++i) {
            ps.println(succs[i]);
        }
        succs = this.pag.allocInvLookup(node);
        ps.println("new");
        ps.println("======");
        for (i = 0; i < succs.length; ++i) {
            ps.println(succs[i]);
        }
        succs = this.pag.loadInvLookup(node);
        ps.println("load");
        ps.println("======");
        for (i = 0; i < succs.length; ++i) {
            ps.println(succs[i]);
        }
        succs = this.pag.storeLookup(node);
        ps.println("store");
        ps.println("======");
        for (i = 0; i < succs.length; ++i) {
            ps.println(succs[i]);
        }
    }

    public void dumpP2SetsForLocals(String fName, String mName) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(new File(fName));
        PrintStream ps = new PrintStream(fos);
        ps.println("digraph G {");
        this.dumpLocalP2Set(mName, ps);
        ps.print("}");
    }

    private void dumpLocalP2Set(String mName, PrintStream ps) {
        for (VarNode vNode : this.pag.getVarNodeNumberer()) {
            LocalVarNode lvNode;
            if (!(vNode instanceof LocalVarNode) || (lvNode = (LocalVarNode)vNode).getMethod() == null || !lvNode.getMethod().getName().equals(mName)) continue;
            ps.println("\t" + PagToDotDumper.makeNodeName(lvNode) + " [label=\"" + PagToDotDumper.makeLabel(lvNode) + "\"];");
            lvNode.getP2Set().forall(new P2SetToDotPrinter(lvNode, ps));
        }
    }

    public void dumpPAGForMethod(String fName, String cName, String mName) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(new File(fName));
        PrintStream ps = new PrintStream(fos);
        ps.println("digraph G {");
        ps.println("\trankdir=LR;");
        this.dumpLocalPAG(cName, mName, ps);
        ps.print("}");
        try {
            fos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        ps.close();
    }

    private void dumpLocalPAG(String cName, String mName, PrintStream ps) {
        for (Node node : this.pag.getVarNodeNumberer()) {
            LocalVarNode lvNode;
            if (!(node instanceof LocalVarNode) || !this.isDefinedIn(lvNode = (LocalVarNode)node, cName, mName)) continue;
            this.dumpForwardReachableNodesFrom(lvNode, ps);
        }
    }

    private void dumpForwardReachableNodesFrom(LocalVarNode lvNode, PrintStream ps) {
        FieldRefNode frNode;
        int i;
        ps.println("\t" + PagToDotDumper.translateLabel(lvNode));
        Node[] succs = this.pag.simpleInvLookup(lvNode);
        for (i = 0; i < succs.length; ++i) {
            ps.println("\t" + PagToDotDumper.translateLabel(succs[i]));
            ps.println("\t" + PagToDotDumper.translateEdge(lvNode, succs[i], "assign"));
        }
        succs = this.pag.allocInvLookup(lvNode);
        for (i = 0; i < succs.length; ++i) {
            ps.println("\t" + PagToDotDumper.translateLabel(succs[i]));
            ps.println("\t" + PagToDotDumper.translateEdge(lvNode, succs[i], "new"));
        }
        succs = this.pag.loadInvLookup(lvNode);
        for (i = 0; i < succs.length; ++i) {
            frNode = (FieldRefNode)succs[i];
            ps.println("\t" + PagToDotDumper.translateLabel(frNode));
            ps.println("\t" + PagToDotDumper.translateLabel(frNode.getBase()));
            ps.println("\t" + PagToDotDumper.translateEdge(lvNode, frNode, "load"));
            ps.println("\t" + PagToDotDumper.translateEdge(frNode, frNode.getBase(), "getBase"));
        }
        succs = this.pag.storeLookup(lvNode);
        for (i = 0; i < succs.length; ++i) {
            frNode = (FieldRefNode)succs[i];
            ps.println("\t" + PagToDotDumper.translateLabel(frNode));
            ps.println("\t" + PagToDotDumper.translateLabel(frNode.getBase()));
            ps.println("\t" + PagToDotDumper.translateEdge(frNode, lvNode, "store"));
            ps.println("\t" + PagToDotDumper.translateEdge(frNode, frNode.getBase(), "getBase"));
        }
    }

    public void traceNode(int id) {
        this.buildVmatchEdges();
        String fName = "trace." + id + ".dot";
        try {
            FileOutputStream fos = new FileOutputStream(new File(fName));
            PrintStream ps = new PrintStream(fos);
            ps.println("digraph G {");
            for (VarNode n : this.pag.getVarNodeNumberer()) {
                if (n.getNumber() != id) continue;
                LocalVarNode lvn = (LocalVarNode)n;
                this.printOneNode(lvn);
                this.trace(lvn, ps, new HashSet<Node>(), 99);
            }
            ps.print("}");
            ps.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void traceNode(String cName, String mName, String varName) {
        String mName2 = mName;
        if (mName.indexOf(60) == 0) {
            mName2 = mName.substring(1, mName.length() - 1);
        }
        this.traceLocalVarNode("trace." + cName + "." + mName2 + "." + varName + ".dot", cName, mName, varName);
    }

    public void traceLocalVarNode(String fName, String cName, String mName, String varName) {
        this.buildVmatchEdges();
        try {
            FileOutputStream fos = new FileOutputStream(new File(fName));
            PrintStream ps = new PrintStream(fos);
            ps.println("digraph G {");
            for (VarNode n : this.pag.getVarNodeNumberer()) {
                LocalVarNode lvn;
                if (!(n instanceof LocalVarNode) || (lvn = (LocalVarNode)n).getMethod() == null || !this.isDefinedIn(lvn, cName, mName) || !lvn.getVariable().toString().equals(varName)) continue;
                this.trace(lvn, ps, new HashSet<Node>(), 10);
            }
            ps.print("}");
            ps.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void trace(VarNode node, PrintStream ps, HashSet<Node> visitedNodes, int level) {
        int i;
        if (level < 1) {
            return;
        }
        ps.println("\t" + PagToDotDumper.translateLabel(node));
        Node[] succs = this.pag.simpleInvLookup(node);
        for (i = 0; i < succs.length; ++i) {
            if (visitedNodes.contains(succs[i])) continue;
            ps.println("\t" + PagToDotDumper.translateLabel(succs[i]));
            ps.println("\t" + PagToDotDumper.translateEdge(node, succs[i], "assign"));
            visitedNodes.add(succs[i]);
            this.trace((VarNode)succs[i], ps, visitedNodes, level - 1);
        }
        succs = this.pag.allocInvLookup(node);
        for (i = 0; i < succs.length; ++i) {
            if (visitedNodes.contains(succs[i])) continue;
            ps.println("\t" + PagToDotDumper.translateLabel(succs[i]));
            ps.println("\t" + PagToDotDumper.translateEdge(node, succs[i], "new"));
        }
        succs = this.vmatches.get(node);
        if (succs != null) {
            for (i = 0; i < succs.length; ++i) {
                if (visitedNodes.contains(succs[i])) continue;
                ps.println("\t" + PagToDotDumper.translateLabel(succs[i]));
                ps.println("\t" + PagToDotDumper.translateEdge(node, succs[i], "vmatch"));
                this.trace((VarNode)succs[i], ps, visitedNodes, level - 1);
            }
        }
    }

    public static String makeNodeName(Node n) {
        return "node_" + n.getNumber();
    }

    public static String makeLabel(AllocNode n) {
        return n.getNewExpr().toString();
    }

    public static String makeLabel(LocalVarNode n) {
        SootMethod sm = n.getMethod();
        return "LV " + n.getVariable().toString() + " " + n.getNumber() + "\\n" + sm.getDeclaringClass() + "\\n" + sm.getName();
    }

    public static String makeLabel(FieldRefNode node) {
        if (node.getField() instanceof SootField) {
            SootField sf = (SootField)node.getField();
            return "FNR " + PagToDotDumper.makeLabel(node.getBase()) + "." + sf.getName();
        }
        return "FNR " + PagToDotDumper.makeLabel(node.getBase()) + "." + node.getField();
    }

    public static String makeLabel(VarNode base) {
        if (base instanceof LocalVarNode) {
            return PagToDotDumper.makeLabel((LocalVarNode)base);
        }
        return base.toString();
    }

    class P2SetToDotPrinter
    extends P2SetVisitor {
        private final Node curNode;
        private final PrintStream ps;

        P2SetToDotPrinter(Node curNode, PrintStream ps) {
            this.curNode = curNode;
            this.ps = ps;
        }

        @Override
        public void visit(Node n) {
            this.ps.println("\t" + PagToDotDumper.makeNodeName(n) + " [label=\"" + PagToDotDumper.makeLabel((AllocNode)n) + "\"];");
            this.ps.print("\t" + PagToDotDumper.makeNodeName(this.curNode) + " -> ");
            this.ps.println(PagToDotDumper.makeNodeName(n) + ";");
        }
    }
}

