/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import java.util.ArrayList;
import java.util.HashMap;
import polyglot.ast.ClassBody;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Formal;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.LocalDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.VarDecl;
import polyglot.util.IdentityKey;
import polyglot.visit.NodeVisitor;
import soot.javaToJimple.LocalUsesChecker;

public class MethodFinalsChecker
extends NodeVisitor {
    private final ArrayList<IdentityKey> inners;
    private final ArrayList<IdentityKey> finalLocals = new ArrayList();
    private final HashMap<IdentityKey, ArrayList<IdentityKey>> typeToLocalsUsed;
    private final ArrayList<Node> ccallList;

    public HashMap<IdentityKey, ArrayList<IdentityKey>> typeToLocalsUsed() {
        return this.typeToLocalsUsed;
    }

    public ArrayList<IdentityKey> finalLocals() {
        return this.finalLocals;
    }

    public ArrayList<IdentityKey> inners() {
        return this.inners;
    }

    public ArrayList<Node> ccallList() {
        return this.ccallList;
    }

    public MethodFinalsChecker() {
        this.inners = new ArrayList();
        this.ccallList = new ArrayList();
        this.typeToLocalsUsed = new HashMap();
    }

    @Override
    public Node override(Node parent, Node n) {
        if (n instanceof LocalClassDecl) {
            this.inners.add(new IdentityKey(((LocalClassDecl)n).decl().type()));
            ClassBody localClassBody = ((LocalClassDecl)n).decl().body();
            LocalUsesChecker luc = new LocalUsesChecker();
            localClassBody.visit(luc);
            this.typeToLocalsUsed.put(new IdentityKey(((LocalClassDecl)n).decl().type()), luc.getLocals());
            return n;
        }
        if (n instanceof New && ((New)n).anonType() != null) {
            this.inners.add(new IdentityKey(((New)n).anonType()));
            ClassBody anonClassBody = ((New)n).body();
            LocalUsesChecker luc = new LocalUsesChecker();
            anonClassBody.visit(luc);
            this.typeToLocalsUsed.put(new IdentityKey(((New)n).anonType()), luc.getLocals());
            return n;
        }
        return null;
    }

    @Override
    public NodeVisitor enter(Node parent, Node n) {
        VarDecl ld;
        if (n instanceof LocalDecl && (ld = (LocalDecl)n).flags().isFinal() && !this.finalLocals.contains(new IdentityKey(ld.localInstance()))) {
            this.finalLocals.add(new IdentityKey(ld.localInstance()));
        }
        if (n instanceof Formal && (ld = (Formal)n).flags().isFinal() && !this.finalLocals.contains(new IdentityKey(ld.localInstance()))) {
            this.finalLocals.add(new IdentityKey(ld.localInstance()));
        }
        if (n instanceof ConstructorCall) {
            this.ccallList.add(n);
        }
        return this.enter(n);
    }
}

