/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.traversals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.SootField;
import soot.Value;
import soot.ValueBox;
import soot.dava.internal.AST.ASTAggregatedCondition;
import soot.dava.internal.AST.ASTBinaryCondition;
import soot.dava.internal.AST.ASTCondition;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTIfElseNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTSynchronizedBlockNode;
import soot.dava.internal.AST.ASTUnaryCondition;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.jimple.ConditionExpr;
import soot.jimple.FieldRef;
import soot.jimple.Stmt;

public class AllVariableUses
extends DepthFirstAdapter {
    ASTMethodNode methodNode;
    HashMap<Local, List> localsToUses;
    HashMap<SootField, List> fieldsToUses;

    public AllVariableUses(ASTMethodNode node) {
        this.methodNode = node;
        this.init();
    }

    public AllVariableUses(boolean verbose, ASTMethodNode node) {
        super(verbose);
        this.methodNode = node;
        this.init();
    }

    public void init() {
        this.localsToUses = new HashMap();
        this.fieldsToUses = new HashMap();
    }

    @Override
    public void inASTSynchronizedBlockNode(ASTSynchronizedBlockNode node) {
        Local local = node.getLocal();
        this.addLocalUse(local, node);
    }

    @Override
    public void inASTSwitchNode(ASTSwitchNode node) {
        Value val = node.get_Key();
        ArrayList<Value> localUses = new ArrayList<Value>();
        ArrayList<Value> fieldUses = new ArrayList<Value>();
        if (val instanceof Local) {
            localUses.add(val);
            System.out.println("Added " + val + " to local uses for switch");
        } else if (val instanceof FieldRef) {
            fieldUses.add(val);
            System.out.println("Added " + val + " to field uses for switch");
        } else {
            List<ValueBox> useBoxes = val.getUseBoxes();
            List<Value> list = this.getUsesFromBoxes(useBoxes);
            for (Value temp : list) {
                if (temp instanceof Local) {
                    localUses.add(temp);
                    System.out.println("Added " + temp + " to local uses for switch");
                    continue;
                }
                if (!(temp instanceof FieldRef)) continue;
                fieldUses.add(temp);
                System.out.println("Added " + temp + " to field uses for switch");
            }
        }
        for (Local local : localUses) {
            this.addLocalUse(local, node);
        }
        for (FieldRef fieldRef : fieldUses) {
            SootField sootField = fieldRef.getField();
            this.addFieldUse(sootField, node);
        }
    }

    @Override
    public void inASTStatementSequenceNode(ASTStatementSequenceNode node) {
        List<Object> statements = node.getStatements();
        for (AugmentedStmt augmentedStmt : statements) {
            Stmt s = augmentedStmt.get_Stmt();
            this.checkStatementUses(s, s);
        }
    }

    @Override
    public void inASTForLoopNode(ASTForLoopNode node) {
        List<Object> init = node.getInit();
        for (AugmentedStmt augmentedStmt : init) {
            Stmt s = augmentedStmt.get_Stmt();
            this.checkStatementUses(s, node);
        }
        ASTCondition aSTCondition = node.get_Condition();
        this.checkConditionalUses(aSTCondition, node);
        List<Object> update = node.getUpdate();
        for (AugmentedStmt augmentedStmt : update) {
            Stmt s = augmentedStmt.get_Stmt();
            this.checkStatementUses(s, node);
        }
    }

    public void checkStatementUses(Stmt s, Object useNodeOrStatement) {
        List<ValueBox> useBoxes = s.getUseBoxes();
        List<Value> uses = this.getUsesFromBoxes(useBoxes);
        for (Value temp : uses) {
            if (temp instanceof Local) {
                this.addLocalUse((Local)temp, useNodeOrStatement);
                continue;
            }
            if (!(temp instanceof FieldRef)) continue;
            FieldRef field = (FieldRef)temp;
            SootField sootField = field.getField();
            this.addFieldUse(sootField, useNodeOrStatement);
        }
    }

    public void checkConditionalUses(ASTCondition cond, ASTNode node) {
        List<Value> useList = this.getUseList(cond);
        for (Value temp : useList) {
            if (temp instanceof Local) {
                this.addLocalUse((Local)temp, node);
                continue;
            }
            if (!(temp instanceof FieldRef)) continue;
            FieldRef field = (FieldRef)temp;
            SootField sootField = field.getField();
            this.addFieldUse(sootField, node);
        }
    }

    @Override
    public void inASTIfNode(ASTIfNode node) {
        ASTCondition cond = node.get_Condition();
        this.checkConditionalUses(cond, node);
    }

    @Override
    public void inASTIfElseNode(ASTIfElseNode node) {
        ASTCondition cond = node.get_Condition();
        this.checkConditionalUses(cond, node);
    }

    @Override
    public void inASTWhileNode(ASTWhileNode node) {
        ASTCondition cond = node.get_Condition();
        this.checkConditionalUses(cond, node);
    }

    @Override
    public void inASTDoWhileNode(ASTDoWhileNode node) {
        ASTCondition cond = node.get_Condition();
        this.checkConditionalUses(cond, node);
    }

    public List<Value> getUseList(ASTCondition cond) {
        ArrayList<Value> useList = new ArrayList<Value>();
        if (cond instanceof ASTAggregatedCondition) {
            useList.addAll(this.getUseList(((ASTAggregatedCondition)cond).getLeftOp()));
            useList.addAll(this.getUseList(((ASTAggregatedCondition)cond).getRightOp()));
            return useList;
        }
        if (cond instanceof ASTUnaryCondition) {
            List<Value> uses = new ArrayList<Value>();
            Value val = ((ASTUnaryCondition)cond).getValue();
            if (val instanceof Local || val instanceof FieldRef) {
                uses.add(val);
            } else {
                List<ValueBox> useBoxes = val.getUseBoxes();
                uses = this.getUsesFromBoxes(useBoxes);
            }
            return uses;
        }
        if (cond instanceof ASTBinaryCondition) {
            ConditionExpr val = ((ASTBinaryCondition)cond).getConditionExpr();
            List<ValueBox> useBoxes = val.getUseBoxes();
            return this.getUsesFromBoxes(useBoxes);
        }
        throw new RuntimeException("Method getUseList in ASTUsesAndDefs encountered unknown condition type");
    }

    private void addLocalUse(Local local, Object obj) {
        List temp = this.localsToUses.get(local);
        ArrayList<Object> uses = temp == null ? new ArrayList<Object>() : (ArrayList<Object>)temp;
        uses.add(obj);
        this.localsToUses.put(local, uses);
    }

    private void addFieldUse(SootField field, Object obj) {
        List temp = this.fieldsToUses.get(field);
        ArrayList<Object> uses = temp == null ? new ArrayList<Object>() : (ArrayList<Object>)temp;
        uses.add(obj);
        this.fieldsToUses.put(field, uses);
    }

    private List<Value> getUsesFromBoxes(List useBoxes) {
        ArrayList<Value> toReturn = new ArrayList<Value>();
        Iterator it = useBoxes.iterator();
        while (it.hasNext()) {
            Value val = ((ValueBox)it.next()).getValue();
            if (!(val instanceof Local) && !(val instanceof FieldRef)) continue;
            toReturn.add(val);
        }
        return toReturn;
    }

    public List getUsesForField(SootField field) {
        List temp = this.fieldsToUses.get(field);
        if (temp == null) {
            return null;
        }
        return temp;
    }

    public List getUsesForLocal(Local local) {
        List temp = this.localsToUses.get(local);
        if (temp == null) {
            return null;
        }
        return temp;
    }
}

