/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.structuredAnalysis;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.Value;
import soot.dava.DecompilationException;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTIfElseNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTLabeledBlockNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTSynchronizedBlockNode;
import soot.dava.internal.AST.ASTTryNode;
import soot.dava.internal.AST.ASTUnaryBinaryCondition;
import soot.dava.internal.AST.ASTUnconditionalLoopNode;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.SET.SETNodeLabel;
import soot.dava.internal.javaRep.DAbruptStmt;
import soot.dava.toolkits.base.AST.structuredAnalysis.DavaFlowSet;
import soot.dava.toolkits.base.AST.structuredAnalysis.StructuredAnalysis;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.toolkits.scalar.FlowSet;

public class UnreachableCodeFinder
extends StructuredAnalysis {
    public static boolean DEBUG = false;

    public UnreachableCodeFinder(Object analyze) {
        DavaFlowSet temp = this.process(analyze, this.newInitialFlow());
    }

    @Override
    public void setMergeType() {
        this.MERGETYPE = 2;
    }

    @Override
    public DavaFlowSet newInitialFlow() {
        DavaFlowSet newSet = this.emptyFlowSet();
        newSet.add(new Boolean(true));
        return newSet;
    }

    @Override
    public DavaFlowSet emptyFlowSet() {
        return new UnreachableCodeFlowSet();
    }

    @Override
    public UnreachableCodeFlowSet cloneFlowSet(DavaFlowSet flowSet) {
        if (flowSet instanceof UnreachableCodeFlowSet) {
            return ((UnreachableCodeFlowSet)flowSet).clone();
        }
        throw new RuntimeException("Clone only implemented for UnreachableCodeFlowSet");
    }

    @Override
    public DavaFlowSet processUnaryBinaryCondition(ASTUnaryBinaryCondition cond, DavaFlowSet input) {
        return input;
    }

    @Override
    public DavaFlowSet processSynchronizedLocal(Local local, DavaFlowSet input) {
        return input;
    }

    @Override
    public DavaFlowSet processSwitchKey(Value key, DavaFlowSet input) {
        return input;
    }

    @Override
    public DavaFlowSet processStatement(Stmt s, DavaFlowSet input) {
        return input;
    }

    @Override
    public DavaFlowSet processAbruptStatements(Stmt s, DavaFlowSet input) {
        if (DEBUG) {
            System.out.println("processing stmt " + s);
        }
        if (s instanceof ReturnStmt || s instanceof RetStmt || s instanceof ReturnVoidStmt) {
            UnreachableCodeFlowSet toReturn = new UnreachableCodeFlowSet();
            toReturn.add(new Boolean(false));
            toReturn.copyInternalDataFrom(input);
            if (DEBUG) {
                System.out.println("\tstmt is a return stmt. Hence sending forward false");
            }
            return toReturn;
        }
        if (s instanceof DAbruptStmt) {
            DAbruptStmt abStmt = (DAbruptStmt)s;
            if (!abStmt.is_Continue() && !abStmt.is_Break()) {
                throw new RuntimeException("Found a DAbruptStmt which is neither break nor continue!!");
            }
            UnreachableCodeFlowSet temp = new UnreachableCodeFlowSet();
            SETNodeLabel nodeLabel = abStmt.getLabel();
            if (abStmt.is_Break()) {
                if (nodeLabel != null && nodeLabel.toString() != null) {
                    temp.addToBreakList(nodeLabel.toString(), input);
                } else {
                    temp.addToImplicitBreaks(abStmt, input);
                }
            }
            temp.add(new Boolean(false));
            temp.copyInternalDataFrom(input);
            if (DEBUG) {
                System.out.println("\tstmt is an abrupt stmt. Hence sending forward false");
            }
            return temp;
        }
        if (DEBUG) {
            System.out.println("\tstmt is not an abrupt stmt.");
        }
        return this.processStatement(s, input);
    }

    @Override
    public DavaFlowSet handleBreak(String label, DavaFlowSet output, ASTNode node) {
        if (DEBUG) {
            System.out.println("Handling break. Output contains" + ((UnreachableCodeFlowSet)output).size());
        }
        if (!(output instanceof UnreachableCodeFlowSet)) {
            throw new RuntimeException("handleBreak is only implemented for UnreachableCodeFlowSet type");
        }
        DavaFlowSet out = output;
        List explicitSet = out.getBreakSet(label);
        if (node == null) {
            throw new RuntimeException("ASTNode sent to handleBreak was null");
        }
        List implicitSet = out.getImplicitlyBrokenSets(node);
        DavaFlowSet toReturn = this.emptyFlowSet();
        toReturn.copyInternalDataFrom(output);
        if (explicitSet != null && explicitSet.size() > 0 || implicitSet != null && implicitSet.size() > 0) {
            if (DEBUG) {
                System.out.println("\tBreak sets (implicit and explicit are nonempty hence forwarding true");
            }
            toReturn.add(new Boolean(true));
            return toReturn;
        }
        toReturn.add(new Boolean(false));
        if (DEBUG) {
            System.out.println("\tBreak sets (implicit and explicit are empty hence forwarding merge of false with inset");
        }
        return this.merge(toReturn, output);
    }

    public boolean isReachable(Object input) {
        if (!(input instanceof UnreachableCodeFlowSet)) {
            throw new DecompilationException("Implemented only for UnreachableCodeFlowSet");
        }
        UnreachableCodeFlowSet checking = (UnreachableCodeFlowSet)input;
        if (checking.size() != 1) {
            throw new DecompilationException("unreachableCodeFlow set size should always be 1");
        }
        if (((Boolean)checking.elements[0]).booleanValue()) {
            if (DEBUG) {
                System.out.println("\t Reachable");
            }
            return true;
        }
        if (DEBUG) {
            System.out.println("\t NOT Reachable");
        }
        return false;
    }

    @Override
    public DavaFlowSet processASTStatementSequenceNode(ASTStatementSequenceNode node, DavaFlowSet input) {
        if (DEBUG) {
            System.out.println("Processing statement sequence node");
        }
        if (!this.isReachable(input)) {
            return input;
        }
        return super.processASTStatementSequenceNode(node, input);
    }

    @Override
    public DavaFlowSet processASTLabeledBlockNode(ASTLabeledBlockNode node, DavaFlowSet input) {
        if (DEBUG) {
            System.out.println("Processing labeled block node node");
        }
        if (!this.isReachable(input)) {
            return input;
        }
        return super.processASTLabeledBlockNode(node, input);
    }

    @Override
    public DavaFlowSet processASTSynchronizedBlockNode(ASTSynchronizedBlockNode node, DavaFlowSet input) {
        if (DEBUG) {
            System.out.println("Processing synchronized block node");
        }
        if (!this.isReachable(input)) {
            return input;
        }
        return super.processASTSynchronizedBlockNode(node, input);
    }

    @Override
    public DavaFlowSet processASTIfElseNode(ASTIfElseNode node, DavaFlowSet input) {
        if (DEBUG) {
            System.out.println("Processing ifelse node");
        }
        if (!this.isReachable(input)) {
            return input;
        }
        return super.processASTIfElseNode(node, input);
    }

    public DavaFlowSet ifNotReachableReturnInputElseProcessBodyAndReturnTrue(ASTNode node, DavaFlowSet input) {
        if (DEBUG) {
            System.out.println("Processing " + node.getClass() + " node");
        }
        if (!this.isReachable(input)) {
            return input;
        }
        DavaFlowSet output = this.processSingleSubBodyNode(node, input);
        UnreachableCodeFlowSet toReturn = new UnreachableCodeFlowSet();
        toReturn.add(new Boolean(true));
        toReturn.copyInternalDataFrom(output);
        return toReturn;
    }

    @Override
    public DavaFlowSet processASTIfNode(ASTIfNode node, DavaFlowSet input) {
        return this.ifNotReachableReturnInputElseProcessBodyAndReturnTrue(node, input);
    }

    @Override
    public DavaFlowSet processASTWhileNode(ASTWhileNode node, DavaFlowSet input) {
        return this.ifNotReachableReturnInputElseProcessBodyAndReturnTrue(node, input);
    }

    @Override
    public DavaFlowSet processASTDoWhileNode(ASTDoWhileNode node, DavaFlowSet input) {
        return this.ifNotReachableReturnInputElseProcessBodyAndReturnTrue(node, input);
    }

    @Override
    public DavaFlowSet processASTUnconditionalLoopNode(ASTUnconditionalLoopNode node, DavaFlowSet input) {
        return this.ifNotReachableReturnInputElseProcessBodyAndReturnTrue(node, input);
    }

    @Override
    public DavaFlowSet processASTForLoopNode(ASTForLoopNode node, DavaFlowSet input) {
        return this.ifNotReachableReturnInputElseProcessBodyAndReturnTrue(node, input);
    }

    @Override
    public DavaFlowSet processASTSwitchNode(ASTSwitchNode node, DavaFlowSet input) {
        if (DEBUG) {
            System.out.println("Processing switch node");
        }
        if (!this.isReachable(input)) {
            return input;
        }
        List<Object> indexList = node.getIndexList();
        Map<Object, List<Object>> index2BodyList = node.getIndex2BodyList();
        UnreachableCodeFlowSet initialIn = this.cloneFlowSet(input);
        DavaFlowSet out = null;
        DavaFlowSet defaultOut = null;
        ArrayList<UnreachableCodeFlowSet> toMergeBreaks = new ArrayList<UnreachableCodeFlowSet>();
        for (Object currentIndex : indexList) {
            List<Object> body = index2BodyList.get(currentIndex);
            if (body == null) continue;
            out = this.process(body, this.cloneFlowSet(initialIn));
            toMergeBreaks.add(this.cloneFlowSet(out));
            if (!(currentIndex instanceof String)) continue;
            defaultOut = out;
        }
        DavaFlowSet output = initialIn;
        if (out != null) {
            output = defaultOut != null ? this.merge(defaultOut, out) : this.merge(initialIn, out);
        }
        String label = this.getLabel(node);
        ArrayList<DavaFlowSet> outList = new ArrayList<DavaFlowSet>();
        for (DavaFlowSet davaFlowSet : toMergeBreaks) {
            outList.add(this.handleBreak(label, davaFlowSet, node));
        }
        DavaFlowSet finalOut = output;
        for (DavaFlowSet fo : outList) {
            finalOut = this.merge(finalOut, fo);
        }
        return finalOut;
    }

    @Override
    public DavaFlowSet processASTTryNode(ASTTryNode node, DavaFlowSet input) {
        if (DEBUG) {
            System.out.println("Processing try node");
        }
        if (!this.isReachable(input)) {
            return input;
        }
        List<Object> tryBody = node.get_TryBody();
        DavaFlowSet tryBodyOutput = this.process(tryBody, input);
        DavaFlowSet inputCatch = this.newInitialFlow();
        List<Object> catchList = node.get_CatchList();
        Iterator<Object> it = catchList.iterator();
        ArrayList<DavaFlowSet> catchOutput = new ArrayList<DavaFlowSet>();
        while (it.hasNext()) {
            ASTTryNode.container catchBody = (ASTTryNode.container)it.next();
            List body = (List)catchBody.o;
            DavaFlowSet tempResult = this.process(body, this.cloneFlowSet(inputCatch));
            catchOutput.add(tempResult);
        }
        String label = this.getLabel(node);
        ArrayList<DavaFlowSet> outList = new ArrayList<DavaFlowSet>();
        outList.add(this.handleBreak(label, tryBodyOutput, node));
        for (DavaFlowSet co : catchOutput) {
            DavaFlowSet temp = this.handleBreak(label, co, node);
            outList.add(temp);
        }
        DavaFlowSet out = tryBodyOutput;
        for (DavaFlowSet oe : outList) {
            out = this.merge(out, oe);
        }
        for (DavaFlowSet ce : catchOutput) {
            out = this.merge(out, ce);
        }
        return out;
    }

    public boolean isConstructReachable(Object construct) {
        DavaFlowSet temp = this.getBeforeSet(construct);
        if (temp == null) {
            return true;
        }
        if (DEBUG) {
            System.out.println("Have before set");
        }
        Boolean reachable = (Boolean)((UnreachableCodeFlowSet)temp).elements[0];
        return reachable;
    }

    public class UnreachableCodeFlowSet
    extends DavaFlowSet {
        @Override
        public UnreachableCodeFlowSet clone() {
            if (this.size() != 1) {
                throw new DecompilationException("unreachableCodeFlow set size should always be 1");
            }
            Boolean temp = (Boolean)this.elements[0];
            UnreachableCodeFlowSet toReturn = new UnreachableCodeFlowSet();
            toReturn.add(new Boolean(temp));
            toReturn.copyInternalDataFrom(this);
            return toReturn;
        }

        @Override
        public void intersection(FlowSet otherFlow, FlowSet destFlow) {
            UnreachableCodeFlowSet workingSet;
            if (DEBUG) {
                System.out.println("In intersection");
            }
            if (!(otherFlow instanceof UnreachableCodeFlowSet) || !(destFlow instanceof UnreachableCodeFlowSet)) {
                super.intersection(otherFlow, destFlow);
                return;
            }
            UnreachableCodeFlowSet dest = (UnreachableCodeFlowSet)destFlow;
            UnreachableCodeFlowSet other = (UnreachableCodeFlowSet)otherFlow;
            if (dest == other || dest == this) {
                workingSet = new UnreachableCodeFlowSet();
            } else {
                workingSet = dest;
                workingSet.clear();
            }
            if (other.size() != 1 || this.size() != 1) {
                System.out.println("Other size = " + other.size());
                System.out.println("This size = " + this.size());
                throw new DecompilationException("UnreachableCodeFlowSet size should always be one");
            }
            Boolean thisPath = (Boolean)this.elements[0];
            Boolean otherPath = (Boolean)other.elements[0];
            if (!thisPath.booleanValue() && !otherPath.booleanValue()) {
                workingSet.add(new Boolean(false));
            } else {
                workingSet.add(new Boolean(true));
            }
            workingSet.copyInternalDataFrom(this);
            if (otherFlow instanceof DavaFlowSet) {
                workingSet.copyInternalDataFrom((DavaFlowSet)otherFlow);
            }
            if (workingSet != dest) {
                workingSet.copy(dest);
            }
            if (DEBUG) {
                System.out.println("destFlow contains size:" + ((UnreachableCodeFlowSet)destFlow).size());
            }
        }
    }
}

