/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.javaRep;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.ArrayType;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.grimp.Grimp;
import soot.jimple.internal.AbstractNewMultiArrayExpr;

public class DNewMultiArrayExpr
extends AbstractNewMultiArrayExpr {
    public DNewMultiArrayExpr(ArrayType type, List sizes) {
        super(type, new ValueBox[sizes.size()]);
        for (int i = 0; i < sizes.size(); ++i) {
            this.sizeBoxes[i] = Grimp.v().newExprBox((Value)sizes.get(i));
        }
    }

    @Override
    public Object clone() {
        ArrayList<Value> clonedSizes = new ArrayList<Value>(this.getSizeCount());
        for (int i = 0; i < this.getSizeCount(); ++i) {
            clonedSizes.add(i, Grimp.cloneIfNecessary(this.getSize(i)));
        }
        return new DNewMultiArrayExpr(this.getBaseType(), clonedSizes);
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("new");
        up.literal(" ");
        up.type(this.getBaseType().baseType);
        for (ValueBox element : this.sizeBoxes) {
            up.literal("[");
            element.toString(up);
            up.literal("]");
        }
        for (int i = this.getSizeCount(); i < this.getBaseType().numDimensions; ++i) {
            up.literal("[]");
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new " + this.getBaseType().baseType);
        List<Value> sizes = this.getSizes();
        Iterator<Value> it = this.getSizes().iterator();
        while (it.hasNext()) {
            buffer.append("[" + it.next().toString() + "]");
        }
        for (int i = this.getSizeCount(); i < this.getBaseType().numDimensions; ++i) {
            buffer.append("[]");
        }
        return buffer.toString();
    }
}

