/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.IntType;
import soot.JastAddJ.NumericLiteral;
import soot.JastAddJ.TypeDecl;
import soot.Value;

public class IntegerLiteral
extends NumericLiteral
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;
    protected boolean constant_computed = false;
    protected Constant constant_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
        this.constant_computed = false;
        this.constant_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public IntegerLiteral clone() throws CloneNotSupportedException {
        IntegerLiteral node = (IntegerLiteral)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.constant_computed = false;
        node.constant_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public IntegerLiteral copy() {
        try {
            IntegerLiteral node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    public IntegerLiteral fullCopy() {
        IntegerLiteral tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public IntegerLiteral(int i) {
        this(Integer.toString(i));
    }

    @Override
    public Value eval(Body b) {
        return IntType.emitConstant(this.constant().intValue());
    }

    public IntegerLiteral() {
    }

    @Override
    public void init$Children() {
    }

    public IntegerLiteral(String p0) {
        this.setLITERAL(p0);
    }

    public IntegerLiteral(Symbol p0) {
        this.setLITERAL(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    @Override
    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    @Override
    public void setLITERAL(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol2.value;
        this.LITERALstart = symbol2.getStart();
        this.LITERALend = symbol2.getEnd();
    }

    @Override
    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    @Override
    public void typeCheck() {
        if (this.constant().error) {
            this.error("The integer literal \"" + this.getLITERAL() + "\" is too large for type int.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPositive() {
        ASTNode$State state = this.state();
        boolean bl = !this.getLITERAL().startsWith("-");
        return bl;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeInt();
    }

    @Override
    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        long l = 0L;
        try {
            l = this.parseLong();
        }
        catch (NumberFormatException e) {
            Constant c = Constant.create(0L);
            c.error = true;
            return c;
        }
        Constant c = Constant.create((int)l);
        if (l != (0xFFFFFFFFL & (long)((int)l)) && l != (long)((int)l)) {
            c.error = true;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needsRewrite() {
        ASTNode$State state = this.state();
        boolean bl = false;
        return bl;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

