/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.Immediate;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.AssignSimpleExpr;
import soot.JastAddJ.Body;
import soot.JastAddJ.Expr;
import soot.JastAddJ.ExprStmt;
import soot.JastAddJ.NameType;
import soot.JastAddJ.Stmt;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.Local;
import soot.Value;

public abstract class AssignExpr
extends Expr
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public AssignExpr clone() throws CloneNotSupportedException {
        AssignExpr node = (AssignExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    protected boolean checkDUeverywhere(Variable v) {
        if (this.getDest().isVariable() && this.getDest().varDecl() == v && !this.getSource().isDAafter(v)) {
            return false;
        }
        return super.checkDUeverywhere(v);
    }

    public static Stmt asStmt(Expr left, Expr right) {
        return new ExprStmt(new AssignSimpleExpr(left, right));
    }

    @Override
    public void toString(StringBuffer s) {
        this.getDest().toString(s);
        s.append(this.printOp());
        this.getSource().toString(s);
    }

    @Override
    public void typeCheck() {
        if (!this.getDest().isVariable()) {
            this.error("left hand side is not a variable");
        } else {
            TypeDecl source = this.sourceType();
            TypeDecl dest = this.getDest().type();
            if (this.getSource().type().isPrimitive() && this.getDest().type().isPrimitive()) {
                return;
            }
            this.error("can not assign " + this.getDest() + " of type " + this.getDest().type().typeName() + " a value of type " + this.sourceType().typeName());
        }
    }

    @Override
    public Value eval(Body b) {
        TypeDecl dest = this.getDest().type();
        TypeDecl source = this.getSource().type();
        TypeDecl type = dest.isNumericType() && source.isNumericType() ? dest.binaryNumericPromotion(source) : dest;
        Value lvalue = this.getDest().eval(b);
        Value v = lvalue instanceof Local ? lvalue : (Value)lvalue.clone();
        Local value = b.newTemp(dest.emitCastTo(b, v, type, this));
        Value rvalue = source.emitCastTo(b, this.getSource(), type);
        Immediate result = this.asImmediate(b, type.emitCastTo(b, this.createAssignOp(b, value, rvalue), dest, this.getDest()));
        this.getDest().emitStore(b, lvalue, result, this);
        return result;
    }

    public Value emitShiftExpr(Body b) {
        TypeDecl dest = this.getDest().type();
        TypeDecl source = this.getSource().type();
        TypeDecl type = dest.unaryNumericPromotion();
        Value lvalue = this.getDest().eval(b);
        Value v = lvalue instanceof Local ? lvalue : (Value)lvalue.clone();
        Local value = b.newTemp(dest.emitCastTo(b, v, type, this.getDest()));
        Value rvalue = source.emitCastTo(b, this.getSource(), this.typeInt());
        Immediate result = this.asImmediate(b, type.emitCastTo(b, this.createAssignOp(b, value, rvalue), dest, this.getDest()));
        this.getDest().emitStore(b, lvalue, result, this);
        return result;
    }

    public Value createAssignOp(Body b, Value fst, Value snd) {
        throw new Error("Operation createAssignOp is not implemented for " + this.getClass().getName());
    }

    public AssignExpr() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
    }

    public AssignExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setDest(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getDest() {
        return (Expr)this.getChild(0);
    }

    public Expr getDestNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setSource(Expr node) {
        this.setChild(node, 1);
    }

    public Expr getSource() {
        return (Expr)this.getChild(1);
    }

    public Expr getSourceNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.getDest().isVariable() && this.getDest().varDecl() == v || this.getSource().isDAafter(v);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDAafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.isDAafter(v) || this.isFalse();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDAafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.isDAafter(v) || this.isTrue();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.getSource().isDUafter(v);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDUafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.isDUafter(v);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDUafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.isDUafter(v);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printOp() {
        ASTNode$State state = this.state();
        String string = " = ";
        return string;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getDest().type();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDecl sourceType() {
        ASTNode$State state = this.state();
        TypeDecl typeDecl = this.getSource().type().isPrimitive() ? this.getSource().type() : this.unknownType();
        return typeDecl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean modifiedInScope(Variable var) {
        ASTNode$State state = this.state();
        boolean bl = this.getDest().isVariable(var);
        return bl;
    }

    @Override
    public boolean Define_boolean_isDest(ASTNode caller, ASTNode child) {
        if (caller == this.getSourceNoTransform()) {
            return false;
        }
        if (caller == this.getDestNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isDest(this, caller);
    }

    @Override
    public boolean Define_boolean_isSource(ASTNode caller, ASTNode child) {
        if (caller == this.getSourceNoTransform()) {
            return true;
        }
        if (caller == this.getDestNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isSource(this, caller);
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getDestNoTransform()) {
            return this.isDAbefore(v);
        }
        if (caller == this.getSourceNoTransform()) {
            return this.getDest().isDAafter(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getDestNoTransform()) {
            return this.isDUbefore(v);
        }
        if (caller == this.getSourceNoTransform()) {
            return this.getDest().isDUafter(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getDestNoTransform()) {
            return NameType.EXPRESSION_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

